/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.itcl;

import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Procedure;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.WrappedCommand;
import tcl.pkg.itcl.EnsembleParser;
import tcl.pkg.itcl.EnsemblePart;
import tcl.pkg.itcl.ItclAccess;
import tcl.pkg.itcl.ItclEnsInvoc;
import tcl.pkg.itcl.Itcl_InterpState;
import tcl.pkg.itcl.Itcl_List;
import tcl.pkg.itcl.Itcl_ListElem;
import tcl.pkg.itcl.Util;

class Ensemble {
    Interp interp;
    EnsemblePart[] parts;
    int numParts;
    int maxParts;
    WrappedCommand wcmd;
    EnsemblePart parent;

    Ensemble() {
    }

    static String[] SplitEnsemble(Interp interp, String ensName) throws TclException {
        TclObject list = TclString.newInstance(ensName);
        TclObject[] objArgv = TclList.getElements(interp, list);
        String[] strArgv = new String[objArgv.length];
        int i = 0;
        while (i < objArgv.length) {
            strArgv[i] = objArgv[i].toString();
            ++i;
        }
        return strArgv;
    }

    static String MergeEnsemble(Interp interp, String[] nameArgv, int nameArgc) throws TclException {
        TclObject list = TclList.newInstance();
        int i = 0;
        while (i < nameArgc) {
            TclList.append(interp, list, TclString.newInstance(nameArgv[i]));
            ++i;
        }
        return list.toString();
    }

    static void EnsembleInit(Interp interp) {
        interp.createCommand("::itcl::ensemble", new EnsembleCmd(null));
    }

    static void CreateEnsemble(Interp interp, String ensName) throws TclException {
        Ensemble parentEnsData = null;
        String[] nameArgv = null;
        try {
            nameArgv = Ensemble.SplitEnsemble(interp, ensName);
        }
        catch (TclException ex) {
            Ensemble.CreateEnsembleFailed(interp, ensName, ex);
        }
        if (nameArgv.length < 1) {
            ex = new TclException(interp, "invalid ensemble name \"" + ensName + "\"");
            Ensemble.CreateEnsembleFailed(interp, ensName, ex);
        }
        parentEnsData = null;
        if (nameArgv.length > 1) {
            try {
                parentEnsData = Ensemble.FindEnsemble(interp, nameArgv, nameArgv.length - 1);
            }
            catch (TclException ex) {
                Ensemble.CreateEnsembleFailed(interp, ensName, ex);
            }
            if (parentEnsData == null) {
                String pname = Ensemble.MergeEnsemble(interp, nameArgv, nameArgv.length - 1);
                TclException ex = new TclException(interp, "invalid ensemble name \"" + pname + "\"");
                Ensemble.CreateEnsembleFailed(interp, ensName, ex);
            }
        }
        try {
            Ensemble.CreateEnsemble(interp, parentEnsData, nameArgv[nameArgv.length - 1]);
        }
        catch (TclException ex) {
            Ensemble.CreateEnsembleFailed(interp, ensName, ex);
        }
    }

    static void CreateEnsembleFailed(Interp interp, String ensName, TclException ex) throws TclException {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("\n    (while creating ensemble \"");
        buffer.append(ensName);
        buffer.append("\")");
        interp.addErrorInfo(buffer.toString());
        throw ex;
    }

    static void AddEnsemblePart(Interp interp, String ensName, String partName, String usageInfo, Command objCmd) throws TclException {
        String[] nameArgv = null;
        Ensemble ensData = null;
        try {
            nameArgv = Ensemble.SplitEnsemble(interp, ensName);
        }
        catch (TclException ex) {
            Ensemble.AddEnsemblePartFailed(interp, ensName, ex);
        }
        try {
            ensData = Ensemble.FindEnsemble(interp, nameArgv, nameArgv.length);
        }
        catch (TclException ex) {
            Ensemble.AddEnsemblePartFailed(interp, ensName, ex);
        }
        if (ensData == null) {
            String pname = Ensemble.MergeEnsemble(interp, nameArgv, nameArgv.length);
            TclException ex = new TclException(interp, "invalid ensemble name \"" + pname + "\"");
            Ensemble.AddEnsemblePartFailed(interp, ensName, ex);
        }
        try {
            Ensemble.AddEnsemblePart(interp, ensData, partName, usageInfo, objCmd);
        }
        catch (TclException ex) {
            Ensemble.AddEnsemblePartFailed(interp, ensName, ex);
        }
    }

    static void AddEnsemblePartFailed(Interp interp, String ensName, TclException ex) throws TclException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n    (while adding to ensemble \"");
        buffer.append(ensName);
        buffer.append("\")");
        interp.addErrorInfo(buffer.toString());
        throw ex;
    }

    static boolean GetEnsembleUsage(Interp interp, String ensName, StringBuffer buffer) {
        Ensemble ensData;
        String[] nameArgv = null;
        Itcl_InterpState state = Util.SaveInterpState(interp, 0);
        try {
            nameArgv = Ensemble.SplitEnsemble(interp, ensName);
        }
        catch (TclException tclException) {
            Util.RestoreInterpState(interp, state);
            return false;
        }
        try {
            ensData = Ensemble.FindEnsemble(interp, nameArgv, nameArgv.length);
        }
        catch (TclException tclException) {
            Util.RestoreInterpState(interp, state);
            return false;
        }
        if (ensData == null) {
            Util.RestoreInterpState(interp, state);
            return false;
        }
        Ensemble.GetEnsembleUsage(ensData, buffer);
        Util.DiscardInterpState(state);
        return true;
    }

    static boolean GetEnsembleUsageForObj(Interp interp, TclObject ensObj, StringBuffer buffer) {
        Command cmd;
        TclObject chainObj = null;
        chainObj = ensObj;
        while (chainObj != null && chainObj.getInternalRep() instanceof ItclEnsInvoc) {
            ItclEnsInvoc t = (ItclEnsInvoc)chainObj.getInternalRep();
            chainObj = t.chainObj;
        }
        if (chainObj != null && (cmd = interp.getCommand(chainObj.toString())) != null && cmd instanceof HandleEnsemble) {
            Ensemble ensData = ((HandleEnsemble)cmd).ensData;
            Ensemble.GetEnsembleUsage(ensData, buffer);
            return true;
        }
        return false;
    }

    static void GetEnsembleUsage(Ensemble ensData, StringBuffer buffer) {
        String spaces = "  ";
        boolean isOpenEnded = false;
        int i = 0;
        while (i < ensData.numParts) {
            EnsemblePart ensPart = ensData.parts[i];
            if (ensPart.name.equals("@error")) {
                isOpenEnded = true;
            } else {
                buffer.append(spaces);
                Ensemble.GetEnsemblePartUsage(ensPart, buffer);
                spaces = "\n  ";
            }
            ++i;
        }
        if (isOpenEnded) {
            buffer.append("\n...and others described on the man page");
        }
    }

    static void GetEnsemblePartUsage(EnsemblePart ensPart, StringBuffer buffer) {
        Itcl_List trail = new Itcl_List();
        Util.InitList(trail);
        EnsemblePart part = ensPart;
        while (part != null) {
            Util.InsertList(trail, part);
            part = part.ensemble.parent;
        }
        WrappedCommand wcmd = ensPart.ensemble.wcmd;
        String name = ensPart.ensemble.interp.getCommandName(wcmd);
        Util.AppendElement(buffer, name);
        Itcl_ListElem elem = Util.FirstListElem(trail);
        while (elem != null) {
            part = (EnsemblePart)Util.GetListValue(elem);
            Util.AppendElement(buffer, part.name);
            elem = Util.NextListElem(elem);
        }
        Util.DeleteList(trail);
        if (ensPart.usage != null && ensPart.usage.length() > 0) {
            buffer.append(" ");
            buffer.append(ensPart.usage);
        } else if (ensPart.cmd != null && ensPart.cmd instanceof HandleEnsemble) {
            buffer.append(" option ?arg arg ...?");
        }
    }

    static void CreateEnsemble(Interp interp, Ensemble parentEnsData, String ensName) throws TclException {
        EnsemblePart ensPart;
        Ensemble ensData = new Ensemble();
        ensData.interp = interp;
        ensData.numParts = 0;
        ensData.maxParts = 10;
        ensData.parts = new EnsemblePart[ensData.maxParts];
        ensData.wcmd = null;
        ensData.parent = null;
        if (parentEnsData == null) {
            WrappedCommand wcmd;
            interp.createCommand(ensName, new HandleEnsemble(ensData));
            ensData.wcmd = wcmd = Namespace.findCommand(interp, ensName, null, 2);
            return;
        }
        try {
            ensPart = Ensemble.CreateEnsemblePart(interp, parentEnsData, ensName);
        }
        catch (TclException ex) {
            Ensemble.DeleteEnsemble(ensData);
            throw ex;
        }
        ensData.wcmd = parentEnsData.wcmd;
        ensData.parent = ensPart;
        ensPart.cmd = new HandleEnsemble(ensData);
    }

    static EnsemblePart AddEnsemblePart(Interp interp, Ensemble ensData, String partName, String usageInfo, Command objProc) throws TclException {
        EnsemblePart ensPart = Ensemble.CreateEnsemblePart(interp, ensData, partName);
        if (usageInfo != null) {
            ensPart.usage = usageInfo;
        }
        WrappedCommand wcmd = new WrappedCommand();
        wcmd.ns = ensData.wcmd.ns;
        wcmd.cmd = objProc;
        ensPart.cmd = objProc;
        ensPart.wcmd = wcmd;
        return ensPart;
    }

    static void DeleteEnsemble(Ensemble ensData) {
        while (ensData.numParts > 0) {
            Ensemble.DeleteEnsemblePart(ensData.parts[0]);
        }
        ensData.parts = null;
    }

    static Ensemble FindEnsemble(Interp interp, String[] nameArgv, int nameArgc) throws TclException {
        if (nameArgc < 1) {
            return null;
        }
        WrappedCommand wcmd = Namespace.findCommand(interp, nameArgv[0], null, 512);
        if (wcmd == null || !(wcmd.cmd instanceof HandleEnsemble)) {
            throw new TclException(interp, "command \"" + nameArgv[0] + "\" is not an ensemble");
        }
        Ensemble ensData = ((HandleEnsemble)wcmd.cmd).ensData;
        int i = 1;
        while (i < nameArgc) {
            Command cmd;
            EnsemblePart ensPart = Ensemble.FindEnsemblePart(interp, ensData, nameArgv[i]);
            if (ensPart == null) {
                String pname = Ensemble.MergeEnsemble(interp, nameArgv, i);
                new TclException(interp, "invalid ensemble name \"" + pname + "\"");
            }
            if ((cmd = ensPart.cmd) == null || !(cmd instanceof HandleEnsemble)) {
                throw new TclException(interp, "part \"" + nameArgv[i] + "\" is not an ensemble");
            }
            ensData = ((HandleEnsemble)cmd).ensData;
            ++i;
        }
        return ensData;
    }

    static EnsemblePart CreateEnsemblePart(Interp interp, Ensemble ensData, String partName) throws TclException {
        int i;
        FindEnsemblePartIndexResult res = Ensemble.FindEnsemblePartIndex(ensData, partName);
        if (res.status) {
            throw new TclException(interp, "part \"" + partName + "\" already exists in ensemble");
        }
        int pos = res.pos;
        if (ensData.numParts >= ensData.maxParts) {
            EnsemblePart[] partList = new EnsemblePart[ensData.maxParts * 2];
            i = 0;
            while (i < ensData.maxParts) {
                partList[i] = ensData.parts[i];
                ++i;
            }
            ensData.parts = null;
            ensData.parts = partList;
            ensData.maxParts = partList.length;
        }
        i = ensData.numParts;
        while (i > pos) {
            ensData.parts[i] = ensData.parts[i - 1];
            --i;
        }
        ++ensData.numParts;
        EnsemblePart part = new EnsemblePart();
        part.name = partName;
        part.cmd = null;
        part.usage = null;
        part.ensemble = ensData;
        ensData.parts[pos] = part;
        Ensemble.ComputeMinChars(ensData, pos);
        Ensemble.ComputeMinChars(ensData, pos - 1);
        Ensemble.ComputeMinChars(ensData, pos + 1);
        return part;
    }

    static void DeleteEnsemblePart(EnsemblePart ensPart) {
        Command cmd = ensPart.cmd;
        if (cmd instanceof CommandWithDispose) {
            ((CommandWithDispose)cmd).disposeCmd();
        }
        ensPart.cmd = null;
        FindEnsemblePartIndexResult res = Ensemble.FindEnsemblePartIndex(ensPart.ensemble, ensPart.name);
        if (res.status) {
            int pos = res.pos;
            Ensemble ensData = ensPart.ensemble;
            int i = pos;
            while (i < ensData.numParts - 1) {
                ensData.parts[i] = ensData.parts[i + 1];
                ++i;
            }
            --ensData.numParts;
        }
        if (ensPart.usage != null) {
            ensPart.usage = null;
        }
        ensPart.name = null;
    }

    static EnsemblePart FindEnsemblePart(Interp interp, Ensemble ensData, String partName) throws TclException {
        int pos = 0;
        EnsemblePart rensPart = null;
        int first = 0;
        int last = ensData.numParts - 1;
        int nlen = partName.length();
        while (last >= first) {
            int cmp;
            pos = first + last >>> 1;
            if (partName.charAt(0) == ensData.parts[pos].name.charAt(0)) {
                cmp = partName.substring(0, nlen).compareTo(ensData.parts[pos].name);
                if (cmp == 0) {
                    break;
                }
            } else {
                cmp = partName.charAt(0) < ensData.parts[pos].name.charAt(0) ? -1 : 1;
            }
            if (cmp > 0) {
                first = pos + 1;
                continue;
            }
            last = pos - 1;
        }
        if (last < first) {
            return rensPart;
        }
        if (nlen < ensData.parts[pos].minChars) {
            while (pos > 0) {
                if (partName.substring(0, nlen).compareTo(ensData.parts[--pos].name) == 0) continue;
                ++pos;
                break;
            }
        }
        if (nlen < ensData.parts[pos].minChars) {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("ambiguous option \"" + partName + "\": should be one of...");
            int i = pos;
            while (i < ensData.numParts) {
                if (partName.substring(0, nlen).compareTo(ensData.parts[i].name) != 0) break;
                buffer.append("\n  ");
                Ensemble.GetEnsemblePartUsage(ensData.parts[i], buffer);
                ++i;
            }
            throw new TclException(interp, buffer.toString());
        }
        rensPart = ensData.parts[pos];
        return rensPart;
    }

    static FindEnsemblePartIndexResult FindEnsemblePartIndex(Ensemble ensData, String partName) {
        int pos = 0;
        int first = 0;
        int last = ensData.numParts - 1;
        while (last >= first) {
            int cmp;
            pos = first + last >>> 1;
            if (partName.charAt(0) == ensData.parts[pos].name.charAt(0)) {
                cmp = partName.compareTo(ensData.parts[pos].name);
                if (cmp == 0) {
                    break;
                }
            } else {
                cmp = partName.charAt(0) < ensData.parts[pos].name.charAt(0) ? -1 : 1;
            }
            if (cmp > 0) {
                first = pos + 1;
                continue;
            }
            last = pos - 1;
        }
        FindEnsemblePartIndexResult res = new FindEnsemblePartIndexResult();
        if (last >= first) {
            res.status = true;
            res.pos = pos;
            return res;
        }
        res.status = false;
        res.pos = first;
        return res;
    }

    static void ComputeMinChars(Ensemble ensData, int pos) {
        int max;
        int min;
        int qlen;
        int plen;
        int q;
        String qstr;
        int p;
        String pstr;
        if (pos < 0 || pos >= ensData.numParts) {
            return;
        }
        ensData.parts[pos].minChars = 1;
        if (pos - 1 >= 0) {
            pstr = ensData.parts[pos].name;
            p = 0;
            qstr = ensData.parts[pos - 1].name;
            q = 0;
            plen = pstr.length();
            qlen = qstr.length();
            min = 1;
            while (p < plen && q < qlen && pstr.charAt(p) == qstr.charAt(q)) {
                ++p;
                ++q;
                ++min;
            }
            if (min > ensData.parts[pos].minChars) {
                ensData.parts[pos].minChars = min;
            }
        }
        if (pos + 1 < ensData.numParts) {
            pstr = ensData.parts[pos].name;
            p = 0;
            qstr = ensData.parts[pos + 1].name;
            q = 0;
            plen = pstr.length();
            qlen = qstr.length();
            min = 1;
            while (p < plen && q < qlen && pstr.charAt(p) == qstr.charAt(q)) {
                ++p;
                ++q;
                ++min;
            }
            if (min > ensData.parts[pos].minChars) {
                ensData.parts[pos].minChars = min;
            }
        }
        if (ensData.parts[pos].minChars > (max = ensData.parts[pos].name.length())) {
            ensData.parts[pos].minChars = max;
        }
    }

    static EnsembleParser GetEnsembleParser(Interp interp) {
        WrappedCommand wcmd;
        Namespace childNs;
        EnsembleParser ensInfo = (EnsembleParser)interp.getAssocData("itcl_ensembleParser");
        if (ensInfo != null) {
            return ensInfo;
        }
        ensInfo = new EnsembleParser();
        ensInfo.master = interp;
        ensInfo.parser = new Interp();
        ensInfo.ensData = null;
        Namespace ns = Namespace.getGlobalNamespace(ensInfo.parser);
        while ((childNs = (Namespace)ItclAccess.FirstHashEntry(ns.childTable)) != null) {
            Namespace.deleteNamespace(childNs);
        }
        while ((wcmd = (WrappedCommand)ItclAccess.FirstHashEntry(ns.cmdTable)) != null) {
            ensInfo.parser.deleteCommandFromToken(wcmd);
        }
        ensInfo.parser.createCommand("part", new EnsPartCmd(ensInfo));
        ensInfo.parser.createCommand("option", new EnsPartCmd(ensInfo));
        ensInfo.parser.createCommand("ensemble", new EnsembleCmd(ensInfo));
        interp.setAssocData("itcl_ensembleParser", ensInfo);
        return ensInfo;
    }

    static void DeleteEnsParser(EnsembleParser ensInfo, Interp interp) {
        ensInfo.parser.dispose();
    }

    static void EnsembleErrorCmd(Ensemble ensData, Interp interp, TclObject[] objv, int skip) throws TclException {
        StringBuffer buffer = new StringBuffer(64);
        String cmdName = objv[skip].toString();
        buffer.append("bad option \"");
        buffer.append(cmdName);
        buffer.append("\": should be one of...\n");
        Ensemble.GetEnsembleUsage(ensData, buffer);
        throw new TclException(interp, buffer.toString());
    }

    static void FreeEnsInvocInternalRep(ItclEnsInvoc obj) {
        TclObject prevArgObj = obj.chainObj;
        if (prevArgObj != null) {
            prevArgObj.release();
        }
    }

    static InternalRep DupEnsInvocInternalRep(ItclEnsInvoc obj) {
        ItclEnsInvoc dup = new ItclEnsInvoc();
        dup.ensPart = obj.ensPart;
        dup.chainObj = obj.chainObj;
        if (dup.chainObj != null) {
            dup.chainObj.preserve();
        }
        return dup;
    }

    static void SetEnsInvocFromAny(Interp interp, TclObject obj) throws TclException {
    }

    static String UpdateStringOfEnsInvoc(ItclEnsInvoc obj) {
        EnsemblePart ensPart = obj.ensPart;
        TclObject chainObj = obj.chainObj;
        StringBuffer buffer = new StringBuffer(64);
        if (chainObj != null) {
            String name = chainObj.toString();
            buffer.append(name);
        }
        if (ensPart != null) {
            Util.AppendElement(buffer, ensPart.name);
        }
        return buffer.toString();
    }

    static class EnsPartCmd
    implements Command {
        EnsembleParser ensParser;

        EnsPartCmd(EnsembleParser ensParser) {
            this.ensParser = ensParser;
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            EnsembleParser ensInfo = this.ensParser;
            Ensemble ensData = ensInfo.ensData;
            if (objv.length != 4) {
                throw new TclException(interp, "wrong # args: should be \"" + objv[0].toString() + " name args body\"");
            }
            String partName = objv[1].toString();
            WrappedCommand wcmd = ensData.wcmd;
            Procedure proc = ItclAccess.newProcedure(interp, wcmd.ns, partName, objv[2], objv[3], "unknown", 0);
            StringBuffer buffer = new StringBuffer();
            boolean varArgs = false;
            boolean space = false;
            TclObject[][] argList = ItclAccess.getArgList(proc);
            int i = 0;
            while (i < argList.length) {
                TclObject vname = argList[i][0];
                TclObject def = argList[i][1];
                varArgs = false;
                if (vname.toString().equals("args")) {
                    varArgs = true;
                } else if (def != null) {
                    if (space) {
                        buffer.append(" ");
                    }
                    buffer.append("?");
                    buffer.append(vname);
                    buffer.append("?");
                    space = true;
                } else {
                    if (space) {
                        buffer.append(" ");
                    }
                    buffer.append(vname);
                    space = true;
                }
                ++i;
            }
            if (varArgs) {
                if (space) {
                    buffer.append(" ");
                }
                buffer.append("?arg arg ...?");
            }
            String usage = buffer.toString();
            EnsemblePart ensPart = Ensemble.AddEnsemblePart(interp, ensData, partName, usage, (Command)proc);
            ItclAccess.setWrappedCommand(proc, ensPart.wcmd);
        }
    }

    static class EnsembleCmd
    implements Command {
        EnsembleParser ensParser;

        EnsembleCmd(EnsembleParser ensParser) {
            this.ensParser = ensParser;
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 2) {
                StringBuffer buffer = new StringBuffer(64);
                buffer.append("wrong # args: should be \"");
                buffer.append(objv[0].toString());
                buffer.append(" name ?command arg arg...?\"");
                throw new TclException(interp, buffer.toString());
            }
            EnsembleParser ensInfo = this.ensParser != null ? this.ensParser : Ensemble.GetEnsembleParser(interp);
            Ensemble ensData = ensInfo.ensData;
            String ensName = objv[1].toString();
            if (ensData != null) {
                EnsemblePart ensPart;
                try {
                    ensPart = Ensemble.FindEnsemblePart(interp, ensData, ensName);
                }
                catch (TclException tclException) {
                    ensPart = null;
                }
                if (ensPart == null) {
                    Ensemble.CreateEnsemble(interp, ensData, ensName);
                    try {
                        ensPart = Ensemble.FindEnsemblePart(interp, ensData, ensName);
                    }
                    catch (TclException tclException) {
                        ensPart = null;
                    }
                    Util.Assert(ensPart != null, "Itcl_EnsembleCmd: can't create ensemble");
                }
                if ((cmd = ensPart.cmd) == null || !(cmd instanceof HandleEnsemble)) {
                    throw new TclException(interp, "part \"" + objv[1].toString() + "\" is not an ensemble");
                }
                ensData = ((HandleEnsemble)cmd).ensData;
            } else {
                WrappedCommand wcmd;
                try {
                    wcmd = Namespace.findCommand(interp, ensName, null, 0);
                }
                catch (TclException tclException) {
                    wcmd = null;
                }
                if (wcmd == null) {
                    Ensemble.CreateEnsemble(interp, null, ensName);
                    wcmd = Namespace.findCommand(interp, ensName, null, 0);
                }
                if ((cmd = wcmd == null ? null : wcmd.cmd) == null || !(cmd instanceof HandleEnsemble)) {
                    throw new TclException(interp, "command \"" + objv[1].toString() + "\" is not an ensemble");
                }
                ensData = ((HandleEnsemble)cmd).ensData;
            }
            TclException evalEx = null;
            Ensemble savedEnsData = ensInfo.ensData;
            ensInfo.ensData = ensData;
            if (objv.length == 3) {
                try {
                    ensInfo.parser.eval(objv[2].toString());
                }
                catch (TclException ex) {
                    evalEx = ex;
                }
            } else if (objv.length > 3) {
                TclObject tlist = TclList.newInstance();
                int i = 2;
                while (i < objv.length) {
                    TclList.append(interp, tlist, objv[i]);
                    ++i;
                }
                try {
                    ensInfo.parser.eval(tlist.toString());
                }
                catch (TclException ex) {
                    evalEx = ex;
                }
            }
            if (evalEx != null) {
                TclObject errInfoObj = ensInfo.parser.getVar("::errorInfo", 1);
                if (errInfoObj != null) {
                    interp.addErrorInfo(errInfoObj.toString());
                }
                if (objv.length == 3) {
                    String msg = "\n    (\"ensemble\" body line " + ensInfo.parser.getErrorLine() + ")";
                    interp.addErrorInfo(msg);
                }
                ensInfo.ensData = savedEnsData;
                throw new TclException(interp, ensInfo.parser.getResult().toString());
            }
            ensInfo.ensData = savedEnsData;
            interp.setResult(ensInfo.parser.getResult().toString());
        }
    }

    static class FindEnsemblePartIndexResult {
        boolean status;
        int pos;

        FindEnsemblePartIndexResult() {
        }
    }

    static class HandleEnsemble
    implements CommandWithDispose {
        Ensemble ensData;

        HandleEnsemble(Ensemble ensData) {
            this.ensData = ensData;
        }

        @Override
        public void disposeCmd() {
            Ensemble.DeleteEnsemble(this.ensData);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 2) {
                StringBuffer buffer = new StringBuffer(64);
                buffer.append("wrong # args: should be one of...\n");
                Ensemble.GetEnsembleUsage(this.ensData, buffer);
                throw new TclException(interp, buffer.toString());
            }
            String partName = objv[1].toString();
            partName.length();
            EnsemblePart ensPart = Ensemble.FindEnsemblePart(interp, this.ensData, partName);
            if (ensPart == null && (ensPart = Ensemble.FindEnsemblePart(interp, this.ensData, "@error")) != null) {
                Command cmd = ensPart.cmd;
                if (ensPart.wcmd.mustCallInvoke(interp)) {
                    ensPart.wcmd.invoke(interp, objv);
                } else {
                    cmd.cmdProc(interp, objv);
                }
                return;
            }
            if (ensPart == null) {
                Ensemble.EnsembleErrorCmd(this.ensData, interp, objv, 1);
            }
            TclObject chainObj = ItclEnsInvoc.newInstance();
            ItclEnsInvoc irep = (ItclEnsInvoc)chainObj.getInternalRep();
            irep.ensPart = ensPart;
            irep.chainObj = objv[0];
            objv[1].preserve();
            objv[0].preserve();
            TclObject cmdline = TclList.newInstance();
            TclList.append(interp, cmdline, chainObj);
            int i = 2;
            while (i < objv.length) {
                TclList.append(interp, cmdline, objv[i]);
                ++i;
            }
            cmdline.preserve();
            try {
                TclObject[] cmdlinev = TclList.getElements(interp, cmdline);
                Command cmd = ensPart.cmd;
                if (ensPart.wcmd.mustCallInvoke(interp)) {
                    ensPart.wcmd.invoke(interp, cmdlinev);
                } else {
                    cmd.cmdProc(interp, cmdlinev);
                }
            }
            finally {
                cmdline.release();
            }
        }
    }
}

