/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.itcl;

import tcl.lang.CallFrame;
import tcl.lang.Command;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.pkg.itcl.Class;
import tcl.pkg.itcl.CompiledLocal;
import tcl.pkg.itcl.ItclAccess;
import tcl.pkg.itcl.ItclClass;
import tcl.pkg.itcl.ItclContext;
import tcl.pkg.itcl.ItclInt;
import tcl.pkg.itcl.ItclJavafunc;
import tcl.pkg.itcl.ItclMember;
import tcl.pkg.itcl.ItclMemberCode;
import tcl.pkg.itcl.ItclMemberFunc;
import tcl.pkg.itcl.ItclObject;
import tcl.pkg.itcl.ItclObjectInfo;
import tcl.pkg.itcl.ItclVarDefn;
import tcl.pkg.itcl.ItclVarLookup;
import tcl.pkg.itcl.Itcl_ListElem;
import tcl.pkg.itcl.Linkage;
import tcl.pkg.itcl.Migrate;
import tcl.pkg.itcl.Util;

public class Methods {
    static void CreateMethod(Interp interp, ItclClass cdefn, String name, String arglist, String body) throws TclException {
        if (name.indexOf("::") != -1) {
            throw new TclException(interp, "bad method name \"" + name + "\"");
        }
        ItclMemberFunc mfunc = Methods.CreateMemberFunc(interp, cdefn, name, arglist, body);
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(cdefn.namesp.fullName);
        buffer.append("::");
        buffer.append(name);
        String qname = buffer.toString();
        Util.PreserveData(mfunc);
        interp.createCommand(qname, new ExecMethod(mfunc));
        mfunc.w_accessCmd = Namespace.findCommand(interp, qname, null, 2);
        mfunc.accessCmd = mfunc.w_accessCmd.cmd;
    }

    static void CreateProc(Interp interp, ItclClass cdefn, String name, String arglist, String body) throws TclException {
        if (name.indexOf("::") != -1) {
            throw new TclException(interp, "bad proc name \"" + name + "\"");
        }
        ItclMemberFunc mfunc = Methods.CreateMemberFunc(interp, cdefn, name, arglist, body);
        mfunc.member.flags |= ItclInt.COMMON;
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(cdefn.namesp.fullName);
        buffer.append("::");
        buffer.append(name);
        String qname = buffer.toString();
        Util.PreserveData(mfunc);
        interp.createCommand(qname, new ExecProc(mfunc));
        mfunc.w_accessCmd = Namespace.findCommand(interp, qname, null, 2);
        mfunc.accessCmd = mfunc.w_accessCmd.cmd;
    }

    static ItclMemberFunc CreateMemberFunc(Interp interp, ItclClass cdefn, String name, String arglist, String body) throws TclException {
        ItclMemberCode mcode;
        boolean newEntry;
        boolean bl = newEntry = cdefn.functions.get(name) == null;
        if (!newEntry) {
            throw new TclException(interp, "\"" + name + "\" already defined in class \"" + cdefn.fullname + "\"");
        }
        try {
            mcode = Methods.CreateMemberCode(interp, cdefn, arglist, body);
        }
        catch (TclException ex) {
            cdefn.functions.remove(name);
            throw ex;
        }
        Util.PreserveData(mcode);
        ItclMemberFunc mfunc = new ItclMemberFunc();
        mfunc.member = Class.CreateMember(interp, cdefn, name);
        mfunc.member.code = mcode;
        if (mfunc.member.protection == 4) {
            mfunc.member.protection = 1;
        }
        mfunc.arglist = null;
        mfunc.argcount = 0;
        mfunc.accessCmd = null;
        if (arglist != null) {
            mfunc.member.flags |= ItclInt.ARG_SPEC;
        }
        if (mcode.arglist != null) {
            CreateArgListResult cr = Methods.CreateArgList(interp, arglist);
            mfunc.arglist = cr.arglist;
            mfunc.argcount = cr.argcount;
        }
        if (name.equals("constructor")) {
            mfunc.member.flags |= ItclInt.CONSTRUCTOR;
        }
        if (name.equals("destructor")) {
            mfunc.member.flags |= ItclInt.DESTRUCTOR;
        }
        cdefn.functions.put(name, mfunc);
        Util.PreserveData(mfunc);
        return mfunc;
    }

    static void ChangeMemberFunc(Interp interp, ItclMemberFunc mfunc, String arglist, String body) throws TclException {
        ItclMemberCode mcode = null;
        mcode = Methods.CreateMemberCode(interp, mfunc.member.classDefn, arglist, body);
        if ((mfunc.member.flags & ItclInt.ARG_SPEC) != 0 && !Methods.EquivArgLists(mfunc.arglist, mfunc.argcount, mcode.arglist, mcode.argcount)) {
            TclObject obj = Methods.ArgList(mfunc.argcount, mfunc.arglist);
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("argument list changed for function \"");
            buffer.append(mfunc.member.fullname);
            buffer.append("\": should be \"");
            buffer.append(obj.toString());
            buffer.append("\"");
            Methods.DeleteMemberCode(mcode);
            throw new TclException(interp, buffer.toString());
        }
        Util.PreserveData(mcode);
        Util.ReleaseData(mfunc.member.code);
        mfunc.member.code = mcode;
    }

    static void DeleteMemberFunc(ItclMemberFunc mfunc) {
        if (mfunc != null) {
            Class.DeleteMember(mfunc.member);
            if (mfunc.arglist != null) {
                Methods.DeleteArgList(mfunc.arglist);
            }
        }
    }

    static ItclMemberCode CreateMemberCode(Interp interp, ItclClass cdefn, String arglist, String body) throws TclException {
        ItclMemberCode mcode = new ItclMemberCode();
        mcode.flags = 0;
        mcode.argcount = 0;
        mcode.arglist = null;
        mcode.proc = null;
        mcode.objCmd = null;
        if (arglist != null) {
            CreateArgListResult cr;
            try {
                cr = Methods.CreateArgList(interp, arglist);
            }
            catch (TclException ex) {
                Methods.DeleteMemberCode(mcode);
                throw ex;
            }
            mcode.argcount = cr.argcount;
            mcode.arglist = cr.arglist;
            mcode.flags |= ItclInt.ARG_SPEC;
        }
        mcode.body = body != null ? body : null;
        mcode.proc = null;
        if (body == null) {
            mcode.flags |= ItclInt.IMPLEMENT_NONE;
        } else if (body.length() >= 2 && body.charAt(0) == '@') {
            String rbody = body.substring(1);
            ItclJavafunc jfunc = Linkage.FindC(interp, rbody);
            if (jfunc == null) {
                Methods.DeleteMemberCode(mcode);
                throw new TclException(interp, "no registered C procedure with name \"" + rbody + "\"");
            }
            mcode.flags = ItclInt.IMPLEMENT_OBJCMD;
            mcode.objCmd = jfunc.objCmdProc;
        } else {
            mcode.flags |= ItclInt.IMPLEMENT_TCL;
        }
        return mcode;
    }

    static boolean IsMemberCodeImplemented(ItclMemberCode mcode) {
        return (mcode.flags & ItclInt.IMPLEMENT_NONE) == 0;
    }

    static void DeleteMemberCode(ItclMemberCode mcode) {
        if (mcode.arglist != null) {
            Methods.DeleteArgList(mcode.arglist);
        }
        if (mcode.proc != null) {
            mcode.proc = null;
        }
    }

    static void GetMemberCode(Interp interp, ItclMember member) throws TclException {
        ItclMemberCode mcode = member.code;
        if (!Methods.IsMemberCodeImplemented(mcode)) {
            try {
                interp.eval("::auto_load " + member.fullname);
            }
            catch (TclException ex) {
                interp.addErrorInfo("\n    (while autoloading code for \"" + member.fullname + "\")");
                throw ex;
            }
            interp.resetResult();
        }
        if (!Methods.IsMemberCodeImplemented(mcode = member.code)) {
            throw new TclException(interp, "member function \"" + member.fullname + "\" is not defined and cannot be autoloaded");
        }
    }

    static void EvalMemberCode(Interp interp, ItclMemberFunc mfunc, ItclMember member, ItclObject contextObj, TclObject[] objv) throws TclException {
        CallFrame oldFrame = null;
        Methods.GetMemberCode(interp, member);
        ItclMemberCode mcode = member.code;
        Util.PreserveData(mcode);
        boolean transparent = false;
        ItclObjectInfo info = member.classDefn.info;
        CallFrame frame = Migrate.GetCallFrame(interp, 0);
        int i = Util.GetStackSize(info.transparentFrames) - 1;
        while (i >= 0) {
            CallFrame transFrame = (CallFrame)Util.GetStackValue(info.transparentFrames, i);
            if (frame == transFrame) {
                transparent = true;
                break;
            }
            --i;
        }
        if (transparent) {
            frame = Migrate.GetCallFrame(interp, 1);
            oldFrame = Migrate.ActivateCallFrame(interp, frame);
        }
        ItclContext context = new ItclContext(interp);
        Methods.PushContext(interp, member, member.classDefn, contextObj, context);
        try {
            if (mfunc != null && objv.length > 0 && ((mcode.flags & ItclInt.IMPLEMENT_TCL) != 0 || (member.flags & ItclInt.CONSTRUCTOR) != 0 && member.classDefn.initCode != null)) {
                Methods.AssignArgs(interp, objv, mfunc);
            }
            if ((member.flags & ItclInt.CONSTRUCTOR) != 0 && contextObj != null && contextObj.constructed != null) {
                Methods.ConstructBase(interp, contextObj, member.classDefn);
            }
            if ((mcode.flags & ItclInt.IMPLEMENT_OBJCMD) != 0) {
                mcode.objCmd.cmdProc(interp, objv);
            } else {
                if ((mcode.flags & ItclInt.IMPLEMENT_ARGCMD) != 0) {
                    throw new TclRuntimeError("unexpected IMPLEMENT_ARGCMD");
                }
                if ((mcode.flags & ItclInt.IMPLEMENT_TCL) != 0) {
                    interp.eval(mcode.body);
                } else {
                    throw new TclRuntimeError("bad implementation flag for " + member.fullname);
                }
            }
            if ((member.flags & ItclInt.DESTRUCTOR) != 0 && contextObj != null && contextObj.destructed != null) {
                contextObj.destructed.put(member.classDefn.name, "");
            }
            if ((member.flags & ItclInt.CONSTRUCTOR) != 0 && contextObj != null && contextObj.constructed != null) {
                contextObj.constructed.put(member.classDefn.name, "");
            }
        }
        finally {
            Methods.PopContext(interp, context);
            if (transparent) {
                Migrate.ActivateCallFrame(interp, oldFrame);
            }
            Util.ReleaseData(mcode);
        }
    }

    static CreateArgListResult CreateArgList(Interp interp, String decl) throws TclException {
        int argc = 0;
        CompiledLocal last = null;
        CompiledLocal retLocal = null;
        try {
            if (decl != null) {
                TclObject[] argv = TclList.getElements(interp, TclString.newInstance(decl));
                argc = argv.length;
                int i = 0;
                while (i < argv.length) {
                    TclObject[] fargv = TclList.getElements(interp, argv[i]);
                    CompiledLocal local = null;
                    if (fargv.length == 0 || fargv[0].toString().length() == 0) {
                        throw new TclException(interp, "argument #" + i + " has no name");
                    }
                    if (fargv.length > 2) {
                        throw new TclException(interp, "too many fields in argument specifier \"" + argv[i] + "\"");
                    }
                    if (fargv[0].toString().indexOf("::") != -1) {
                        throw new TclException(interp, "bad argument name \"" + fargv[0] + "\"");
                    }
                    local = fargv.length == 1 ? Methods.CreateArg(fargv[0].toString(), null) : Methods.CreateArg(fargv[0].toString(), fargv[1].toString());
                    if (local != null) {
                        if (retLocal == null) {
                            retLocal = last = local;
                        } else {
                            last.next = local;
                            last = local;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (TclException ex) {
            Methods.DeleteArgList(retLocal);
            throw ex;
        }
        CreateArgListResult res = new CreateArgListResult();
        res.arglist = retLocal;
        res.argcount = argc;
        return res;
    }

    static CompiledLocal CreateArg(String name, String init) {
        CompiledLocal local = null;
        local = new CompiledLocal();
        local.next = null;
        if (init != null) {
            local.defValue = TclString.newInstance(init);
            local.defValue.preserve();
        } else {
            local.defValue = null;
        }
        local.name = name;
        return local;
    }

    static void DeleteArgList(CompiledLocal arglist) {
        CompiledLocal local = arglist;
        while (local != null) {
            if (local.defValue != null) {
                local.defValue.release();
                local.defValue = null;
            }
            local.name = null;
            CompiledLocal next = local.next;
            local.next = null;
            local = next;
        }
    }

    static TclObject ArgList(int argc, CompiledLocal arglist) {
        StringBuffer buffer = new StringBuffer(64);
        while (arglist != null && argc-- > 0) {
            if (arglist.defValue != null) {
                String val = arglist.defValue.toString();
                Util.StartSublist(buffer);
                Util.AppendElement(buffer, arglist.name);
                Util.AppendElement(buffer, val);
                Util.EndSublist(buffer);
            } else {
                Util.AppendElement(buffer, arglist.name);
            }
            arglist = arglist.next;
        }
        TclObject obj = TclString.newInstance(buffer.toString());
        return obj;
    }

    static boolean EquivArgLists(CompiledLocal arg1, int arg1c, CompiledLocal arg2, int arg2c) {
        while (arg1 != null && arg1c > 0 && arg2 != null && arg2c > 0) {
            if (arg1c == 1 && arg1.name.equals("args")) {
                return true;
            }
            if (arg1.defValue != null) {
                String dval2;
                if (arg2.defValue == null) {
                    return false;
                }
                String dval1 = arg1.defValue.toString();
                if (!dval1.equals(dval2 = arg2.defValue.toString())) {
                    return false;
                }
            } else if (arg2.defValue != null) {
                return false;
            }
            arg1 = arg1.next;
            --arg1c;
            arg2 = arg2.next;
            --arg2c;
        }
        if (arg1c == 1 && arg1.name.equals("args")) {
            return true;
        }
        return arg1c == 0 && arg2c == 0;
    }

    static void GetMemberFuncUsage(ItclMemberFunc mfunc, ItclObject contextObj, StringBuffer buffer) {
        int argcount;
        CompiledLocal arglist;
        if ((mfunc.member.flags & ItclInt.COMMON) == 0) {
            if ((mfunc.member.flags & ItclInt.CONSTRUCTOR) != 0 && contextObj.constructed != null) {
                ItclClass cdefn = contextObj.classDefn;
                ItclMemberFunc mf = (ItclMemberFunc)cdefn.resolveCmds.get("constructor");
                if (mf == mfunc) {
                    String fname = contextObj.classDefn.interp.getCommandFullName(contextObj.classDefn.w_accessCmd);
                    buffer.append(fname);
                    buffer.append(" ");
                    name = contextObj.classDefn.interp.getCommandName(contextObj.w_accessCmd);
                    buffer.append(name);
                } else {
                    buffer.append(mfunc.member.fullname);
                }
            } else if (contextObj != null && contextObj.accessCmd != null) {
                name = contextObj.classDefn.interp.getCommandName(contextObj.w_accessCmd);
                buffer.append(name);
                buffer.append(" ");
                buffer.append(mfunc.member.name);
            } else {
                buffer.append("<object> ");
                buffer.append(mfunc.member.name);
            }
        } else {
            buffer.append(mfunc.member.fullname);
        }
        if (mfunc.member.code != null) {
            arglist = mfunc.member.code.arglist;
            argcount = mfunc.member.code.argcount;
        } else if (mfunc.arglist != null) {
            arglist = mfunc.arglist;
            argcount = mfunc.argcount;
        } else {
            arglist = null;
            argcount = 0;
        }
        if (arglist != null) {
            CompiledLocal arg = arglist;
            while (arg != null && argcount > 0) {
                if (argcount == 1 && arg.name.equals("args")) {
                    buffer.append(" ?arg arg ...?");
                } else if (arg.defValue != null) {
                    buffer.append(" ?");
                    buffer.append(arg.name);
                    buffer.append("?");
                } else {
                    buffer.append(" ");
                    buffer.append(arg.name);
                }
                arg = arg.next;
                --argcount;
            }
        }
    }

    static void PushContext(Interp interp, ItclMember member, ItclClass contextClass, ItclObject contextObj, ItclContext context) throws TclException {
        CallFrame frame = context.frame;
        Namespace.pushCallFrame(interp, frame, contextClass.namesp, true);
        context.classDefn = contextClass;
        if (contextObj != null) {
            contextClass.info.contextFrames.put(frame, contextObj);
            Util.PreserveData(contextObj);
        }
    }

    static void PopContext(Interp interp, ItclContext context) {
        CallFrame frame = Migrate.GetCallFrame(interp, 0);
        ItclObjectInfo info = context.classDefn.info;
        ItclObject contextObj = (ItclObject)info.contextFrames.get(frame);
        if (contextObj != null) {
            Util.ReleaseData(contextObj);
            info.contextFrames.remove(frame);
        }
        Namespace.popCallFrame(interp);
    }

    static GetContextResult GetContext(Interp interp) throws TclException {
        Namespace activeNs = Namespace.getCurrentNamespace(interp);
        ItclClass cdefn = null;
        ItclObject odefn = null;
        if (Class.IsClassNamespace(activeNs)) {
            cdefn = Class.GetClassFromNamespace(activeNs);
            CallFrame frame = Migrate.GetCallFrame(interp, 0);
            ItclObjectInfo info = cdefn.info;
            odefn = (ItclObject)info.contextFrames.get(frame);
            return new GetContextResult(cdefn, odefn);
        }
        throw new TclException(interp, "namespace \"" + activeNs.fullName + "\" is not a class namespace");
    }

    /*
     * Unable to fully structure code
     */
    static void AssignArgs(Interp interp, TclObject[] objv, ItclMemberFunc mfunc) throws TclException {
        block28: {
            mcode = mfunc.member.code;
            defobjv = null;
            configc = 0;
            configVars = null;
            pcr = null;
            frame = Migrate.GetCallFrame(interp, 0);
            ItclAccess.setCallFrameObjv(frame, objv);
            try {
                gcr = Methods.GetContext(interp);
                gcr.cdefn;
                contextObj = gcr.odefn;
            }
            catch (TclException v0) {
                contextObj = null;
            }
            interp.resetResult();
            try {
                argsLeft = mcode.argcount;
                arg = mcode.arglist;
                objvi = 1;
                objc = objv.length - 1;
                while (argsLeft > 0) {
                    if (argsLeft == 1 && arg.name.equals("args")) {
                        if (objc < 0) {
                            objc = 0;
                        }
                        list = TclList.newInstance();
                        i = objvi;
                        while (i < objvi + objc) {
                            TclList.append(interp, list, objv[i]);
                            ++i;
                        }
                        Methods.AssignLocal(interp, "args", list, frame);
                        objc = 0;
                        break;
                    }
                    if (argsLeft == 1 && arg.name.equals("config") && contextObj != null) {
                        if ((mfunc.member.flags & ItclInt.OLD_STYLE) == 0) {
                            throw new TclException(interp, "\"config\" argument is an anachronism\n[incr Tcl] no longer supports the \"config\" argument.\nInstead, use the \"args\" argument and then use the\nbuilt-in configure method to handle args like this:\n  eval configure $args");
                        }
                        if (objc > 0) {
                            pcr = Methods.ParseConfig(interp, objc, objv, objvi, contextObj);
                            configc = pcr.num_variables;
                            configVars = pcr.variables;
                            pcr.values;
                            list = TclList.newInstance();
                            vi = 0;
                            while (vi < configc) {
                                buffer = new StringBuffer(64);
                                buffer.append(configVars[vi].member.classDefn.name);
                                buffer.append("::");
                                buffer.append(configVars[vi].member.name);
                                obj = TclString.newInstance(buffer.toString());
                                TclList.append(interp, list, obj);
                                ++vi;
                            }
                            Methods.AssignLocal(interp, arg.name, list, frame);
                            objc = 0;
                        } else if (arg.defValue != null) {
                            defobjv = TclList.getElements(interp, arg.defValue);
                            defargc = defobjv.length;
                            vi = 0;
                            while (vi < defargc) {
                                defobjv[vi].preserve();
                                ++vi;
                            }
                            pcr = Methods.ParseConfig(interp, defargc, defobjv, 0, contextObj);
                            configc = pcr.num_variables;
                            configVars = pcr.variables;
                            pcr.values;
                            list = TclList.newInstance();
                            vi = 0;
                            while (vi < configc) {
                                buffer = new StringBuffer(64);
                                buffer.append(configVars[vi].member.classDefn.name);
                                buffer.append("::");
                                buffer.append(configVars[vi].member.name);
                                obj = TclString.newInstance(buffer.toString());
                                TclList.append(interp, list, obj);
                                ++vi;
                            }
                            Methods.AssignLocal(interp, arg.name, list, frame);
                        } else {
                            obj = TclString.newInstance("");
                            Methods.AssignLocal(interp, arg.name, obj, frame);
                        }
                    } else if (objc > 0) {
                        obj = objv[objvi];
                        Methods.AssignLocal(interp, arg.name, obj, frame);
                    } else if (arg.defValue != null) {
                        obj = arg.defValue;
                        Methods.AssignLocal(interp, arg.name, obj, frame);
                    } else {
                        if (mfunc != null) {
                            buffer = new StringBuffer(64);
                            buffer.append("wrong # args: should be \"");
                            Methods.GetMemberFuncUsage(mfunc, contextObj, buffer);
                            buffer.append("\"");
                            throw new TclException(interp, buffer.toString());
                        }
                        throw new TclException(interp, "no value given for parameter \"" + arg.name + "\"");
                    }
                    arg = arg.next;
                    --argsLeft;
                    ++objvi;
                    --objc;
                }
                if (objc > 0) {
                    if (mfunc != null) {
                        buffer = new StringBuffer(64);
                        buffer.append("wrong # args: should be \"");
                        Methods.GetMemberFuncUsage(mfunc, contextObj, buffer);
                        buffer.append("\"");
                        throw new TclException(interp, buffer.toString());
                    }
                    throw new TclException(interp, "too many arguments");
                }
                if (configc > 0) {
                    Methods.HandleConfig(interp, pcr, contextObj);
                }
            }
            finally {
                if (defobjv == null) break block28;
                vi = 0;
                if (true) ** GOTO lbl139
            }
            {
            }
            do {
                defobjv[vi].release();
                ++vi;
lbl139:
                // 2 sources

            } while (vi < defobjv.length);
        }
    }

    static void AssignLocal(Interp interp, String name, TclObject val, CallFrame frame) throws TclException {
        ItclAccess.assignLocalVar(interp, name, val, frame);
    }

    static ParseConfigResult ParseConfig(Interp interp, int objc, TclObject[] objv, int objvIndex, ItclObject contextObj) throws TclException {
        if (objc < 0) {
            objc = 0;
        }
        int rargc = 0;
        ItclVarDefn[] rvars = new ItclVarDefn[objc];
        String[] rvals = new String[objc];
        while (objc-- > 0) {
            String varName = objv[objvIndex].toString();
            if (varName.length() < 2 || varName.charAt(0) != '-') {
                throw new TclException(interp, "syntax error in config assignment \"" + varName + "\": should be \"-variable value\"");
            }
            if (objc-- <= 0) {
                throw new TclException(interp, "syntax error in config assignment \"" + varName + "\": should be \"-variable value\" (missing value)");
            }
            ItclVarLookup vlookup = (ItclVarLookup)contextObj.classDefn.resolveVars.get(varName.substring(1));
            if (vlookup != null) {
                String value = objv[objvIndex + 1].toString();
                rvars[rargc] = vlookup.vdefn;
                rvals[rargc] = value;
                ++rargc;
                objvIndex += 2;
                continue;
            }
            throw new TclException(interp, "syntax error in config assignment \"" + varName + "\": unrecognized variable");
        }
        ParseConfigResult pcr = new ParseConfigResult();
        pcr.num_variables = rargc;
        pcr.variables = rvars;
        pcr.values = rvals;
        return pcr;
    }

    static void HandleConfig(Interp interp, ParseConfigResult pres, ItclObject contextObj) throws TclException {
        int argc = pres.num_variables;
        ItclVarDefn[] vars = pres.variables;
        String[] vals = pres.values;
        StringBuffer lastval = new StringBuffer(64);
        ItclContext context = new ItclContext(interp);
        Methods.PushContext(interp, null, contextObj.classDefn, contextObj, context);
        try {
            int i = 0;
            while (i < argc) {
                TclObject valObj = interp.getVar(vars[i].member.fullname, 0);
                String val = valObj == null ? "" : valObj.toString();
                lastval.setLength(0);
                lastval.append(val);
                try {
                    interp.setVar(vars[i].member.fullname, TclString.newInstance(vals[i]), 0);
                }
                catch (TclException ex) {
                    interp.addErrorInfo("\n    (while configuring public variable \"" + vars[i].member.fullname + "\")");
                    throw ex;
                }
                if (vars[i].member.code != null) {
                    TclException evalEx;
                    block13: {
                        CallFrame uplevelFrame = Migrate.GetCallFrame(interp, 1);
                        CallFrame oldFrame = Migrate.ActivateCallFrame(interp, uplevelFrame);
                        evalEx = null;
                        try {
                            try {
                                Methods.EvalMemberCode(interp, null, vars[i].member, contextObj, null);
                            }
                            catch (TclException ex) {
                                evalEx = ex;
                                Migrate.ActivateCallFrame(interp, oldFrame);
                                break block13;
                            }
                        }
                        catch (Throwable throwable) {
                            Migrate.ActivateCallFrame(interp, oldFrame);
                            throw throwable;
                        }
                        Migrate.ActivateCallFrame(interp, oldFrame);
                    }
                    if (evalEx != null) {
                        interp.addErrorInfo("\n    (while configuring public variable \"" + vars[i].member.fullname + "\")");
                        interp.setVar(vars[i].member.fullname, TclString.newInstance(lastval.toString()), 0);
                        throw evalEx;
                    }
                }
                ++i;
            }
        }
        finally {
            Methods.PopContext(interp, context);
        }
    }

    static void ConstructBase(Interp interp, ItclObject contextObj, ItclClass contextClass) throws TclException {
        if (contextClass.initCode != null) {
            interp.eval(contextClass.initCode.toString());
        }
        Itcl_ListElem elem = Util.LastListElem(contextClass.bases);
        while (elem != null) {
            ItclClass cdefn = (ItclClass)Util.GetListValue(elem);
            if (contextObj.constructed.get(cdefn.name) == null) {
                Methods.InvokeMethodIfExists(interp, "constructor", cdefn, contextObj, null);
                if (cdefn.functions.get("constructor") == null) {
                    Methods.ConstructBase(interp, contextObj, cdefn);
                }
            }
            elem = Util.PrevListElem(elem);
        }
    }

    static void InvokeMethodIfExists(Interp interp, String name, ItclClass contextClass, ItclObject contextObj, TclObject[] objv) throws TclException {
        ItclMemberFunc mfunc = (ItclMemberFunc)contextClass.functions.get(name);
        if (mfunc != null) {
            ItclMember member = mfunc.member;
            TclObject cmdline = Util.CreateArgs(interp, name, objv, 0);
            TclObject[] cmdlinev = TclList.getElements(interp, cmdline);
            Util.PreserveData(mfunc);
            try {
                try {
                    Methods.EvalMemberCode(interp, mfunc, member, contextObj, cmdlinev);
                }
                catch (TclException ex) {
                    Methods.ReportFuncErrors(interp, mfunc, contextObj, ex);
                    Util.ReleaseData(mfunc);
                }
            }
            finally {
                Util.ReleaseData(mfunc);
            }
        }
    }

    static void ReportFuncErrors(Interp interp, ItclMemberFunc mfunc, ItclObject contextObj, TclException exp) throws TclException {
        if (exp != null) {
            int code = exp.getCompletionCode();
            if (code == 2) {
                code = interp.updateReturnInfo();
                if (code != 0 && code != 1) {
                    interp.processUnexpectedResult(code);
                } else {
                    if (code != 0) {
                        exp.setCompletionCode(code);
                        throw exp;
                    }
                    if (code == 0) {
                        return;
                    }
                }
            } else if (code != 1) {
                exp.printStackTrace(System.out);
                throw new TclRuntimeError("unexpected TclException completion code : " + code);
            }
            StringBuffer buffer = new StringBuffer(64);
            buffer.append("\n    ");
            if ((mfunc.member.flags & ItclInt.CONSTRUCTOR) != 0) {
                buffer.append("while constructing object \"");
                buffer.append(contextObj.classDefn.interp.getCommandFullName(contextObj.w_accessCmd));
                buffer.append("\" in ");
                buffer.append(mfunc.member.fullname);
                if ((mfunc.member.code.flags & ItclInt.IMPLEMENT_TCL) != 0) {
                    buffer.append(" (");
                }
            } else if ((mfunc.member.flags & ItclInt.DESTRUCTOR) != 0) {
                buffer.append("while deleting object \"");
                buffer.append(contextObj.classDefn.interp.getCommandFullName(contextObj.w_accessCmd));
                buffer.append("\" in ");
                buffer.append(mfunc.member.fullname);
                if ((mfunc.member.code.flags & ItclInt.IMPLEMENT_TCL) != 0) {
                    buffer.append(" (");
                }
            } else {
                buffer.append("(");
                if (contextObj != null && contextObj.accessCmd != null) {
                    buffer.append("object \"");
                    buffer.append(contextObj.classDefn.interp.getCommandFullName(contextObj.w_accessCmd));
                    buffer.append("\" ");
                }
                if ((mfunc.member.flags & ItclInt.COMMON) != 0) {
                    buffer.append("procedure");
                } else {
                    buffer.append("method");
                }
                buffer.append(" \"");
                buffer.append(mfunc.member.fullname);
                buffer.append("\" ");
            }
            if ((mfunc.member.code.flags & ItclInt.IMPLEMENT_TCL) != 0) {
                buffer.append("body line ");
                buffer.append(interp.getErrorLine());
                buffer.append(")");
            } else {
                buffer.append(")");
            }
            interp.addErrorInfo(buffer.toString());
            throw exp;
        }
    }

    public static class BodyCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length != 4) {
                throw new TclNumArgsException(interp, 1, objv, "class::func arglist body");
            }
            String token = objv[1].toString();
            Util.ParseNamespPathResult res = Util.ParseNamespPath(token);
            String head = res.head;
            String tail = res.tail;
            if (head == null || head.length() == 0) {
                throw new TclException(interp, "missing class specifier for body declaration \"" + token + "\"");
            }
            ItclClass cdefn = Class.FindClass(interp, head, true);
            if (cdefn == null) {
                throw new TclException(interp, interp.getResult().toString());
            }
            ItclMemberFunc mfunc = (ItclMemberFunc)cdefn.resolveCmds.get(tail);
            if (mfunc != null && mfunc.member.classDefn != cdefn) {
                mfunc = null;
            }
            if (mfunc == null) {
                throw new TclException(interp, "function \"" + tail + "\" is not defined in class \"" + cdefn.fullname + "\"");
            }
            String arglist = objv[2].toString();
            String body = objv[3].toString();
            Methods.ChangeMemberFunc(interp, mfunc, arglist, body);
        }
    }

    public static class ConfigBodyCmd
    implements Command {
        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length != 3) {
                throw new TclNumArgsException(interp, 1, objv, "class::option body");
            }
            String token = objv[1].toString();
            Util.ParseNamespPathResult res = Util.ParseNamespPath(token);
            String head = res.head;
            String tail = res.tail;
            if (head == null || head.length() == 0) {
                throw new TclException(interp, "missing class specifier for body declaration \"" + token + "\"");
            }
            ItclClass cdefn = Class.FindClass(interp, head, true);
            if (cdefn == null) {
                throw new TclException(interp, interp.getResult().toString());
            }
            ItclVarLookup vlookup = (ItclVarLookup)cdefn.resolveVars.get(tail);
            if (vlookup != null && vlookup.vdefn.member.classDefn != cdefn) {
                vlookup = null;
            }
            if (vlookup == null) {
                throw new TclException(interp, "option \"" + tail + "\" is not defined in class \"" + cdefn.fullname + "\"");
            }
            ItclMember member = vlookup.vdefn.member;
            if (member.protection != 1) {
                throw new TclException(interp, "option \"" + member.fullname + "\" is not a public configuration option");
            }
            token = objv[2].toString();
            ItclMemberCode mcode = Methods.CreateMemberCode(interp, cdefn, null, token);
            Util.PreserveData(mcode);
            if (member.code != null) {
                Util.ReleaseData(member.code);
            }
            member.code = mcode;
        }
    }

    public static class CreateArgListResult {
        int argcount;
        CompiledLocal arglist;
    }

    public static class ExecMethod
    implements CommandWithDispose {
        final ItclMemberFunc mfunc;

        ExecMethod(ItclMemberFunc mfunc) {
            if (mfunc == null) {
                throw new NullPointerException();
            }
            this.mfunc = mfunc;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.mfunc);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            ItclMemberFunc tmp;
            Namespace contextNs;
            ItclMemberFunc mfunc = this.mfunc;
            ItclMember member = mfunc.member;
            GetContextResult gcr = Methods.GetContext(interp);
            ItclClass contextClass = gcr.cdefn;
            ItclObject contextObj = gcr.odefn;
            if (contextObj == null) {
                throw new TclException(interp, "cannot access object-specific info without an object context");
            }
            if (mfunc.member.protection != 1 && !Util.CanAccessFunc(mfunc, contextNs = Util.GetTrueNamespace(interp, contextClass.info))) {
                throw new TclException(interp, "can't access \"" + member.fullname + "\": " + Util.ProtectionStr(member.protection) + " function");
            }
            String token = objv[0].toString();
            if (token.indexOf("::") == -1 && (tmp = (ItclMemberFunc)contextObj.classDefn.resolveCmds.get(member.name)) != null) {
                mfunc = tmp;
                member = mfunc.member;
            }
            Util.PreserveData(mfunc);
            try {
                try {
                    Methods.EvalMemberCode(interp, mfunc, member, contextObj, objv);
                }
                catch (TclException ex) {
                    Methods.ReportFuncErrors(interp, mfunc, contextObj, ex);
                    Util.ReleaseData(mfunc);
                }
            }
            finally {
                Util.ReleaseData(mfunc);
            }
        }
    }

    public static class ExecProc
    implements CommandWithDispose {
        ItclMemberFunc mfunc;

        ExecProc(ItclMemberFunc mfunc) {
            this.mfunc = mfunc;
        }

        @Override
        public void disposeCmd() {
            Util.ReleaseData(this.mfunc);
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            Namespace contextNs;
            ItclMember member = this.mfunc.member;
            if (this.mfunc.member.protection != 1 && !Util.CanAccessFunc(this.mfunc, contextNs = Util.GetTrueNamespace(interp, this.mfunc.member.classDefn.info))) {
                throw new TclException(interp, "can't access \"" + member.fullname + "\": " + Util.ProtectionStr(member.protection) + " function");
            }
            Util.PreserveData(this.mfunc);
            try {
                try {
                    Methods.EvalMemberCode(interp, this.mfunc, member, null, objv);
                }
                catch (TclException ex) {
                    Methods.ReportFuncErrors(interp, this.mfunc, null, ex);
                    Util.ReleaseData(this.mfunc);
                }
            }
            finally {
                Util.ReleaseData(this.mfunc);
            }
        }
    }

    public static class GetContextResult {
        ItclClass cdefn;
        ItclObject odefn;

        public GetContextResult(ItclClass cdefn, ItclObject odefn) {
            this.cdefn = cdefn;
            this.odefn = odefn;
        }
    }

    public static class ParseConfigResult {
        int num_variables;
        ItclVarDefn[] variables;
        String[] values;
    }
}

