/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.itcl;

import java.util.HashMap;
import java.util.Map;
import tcl.lang.CallFrame;
import tcl.lang.CommandWithDispose;
import tcl.lang.Interp;
import tcl.lang.Namespace;
import tcl.lang.Resolver;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.Var;
import tcl.lang.VarTrace;
import tcl.lang.WrappedCommand;
import tcl.pkg.itcl.Class;
import tcl.pkg.itcl.Cmds;
import tcl.pkg.itcl.ItclAccess;
import tcl.pkg.itcl.ItclClass;
import tcl.pkg.itcl.ItclContext;
import tcl.pkg.itcl.ItclHierIter;
import tcl.pkg.itcl.ItclInt;
import tcl.pkg.itcl.ItclMemberFunc;
import tcl.pkg.itcl.ItclObject;
import tcl.pkg.itcl.ItclObjectInfo;
import tcl.pkg.itcl.ItclVarDefn;
import tcl.pkg.itcl.ItclVarLookup;
import tcl.pkg.itcl.Itcl_InterpState;
import tcl.pkg.itcl.Itcl_List;
import tcl.pkg.itcl.Itcl_ListElem;
import tcl.pkg.itcl.Methods;
import tcl.pkg.itcl.Migrate;
import tcl.pkg.itcl.Util;

class Objects {
    static HashMap dangleTable = new HashMap();

    Objects() {
    }

    static ItclObject CreateObject(Interp interp, String name, ItclClass cdefn, TclObject[] objv) throws TclException {
        Namespace parentNs;
        TclException ctorEx = null;
        WrappedCommand wcmd = Namespace.findCommand(interp, name, null, 2);
        if (wcmd != null && !Cmds.IsStub(wcmd)) {
            throw new TclException(interp, "command \"" + name + "\" already exists in namespace \"" + Namespace.getCurrentNamespace((Interp)interp).fullName + "\"");
        }
        Util.ParseNamespPathResult res = Util.ParseNamespPath(name);
        String head = res.head;
        String tail = res.tail;
        if (head != null) {
            parentNs = Class.FindClassNamespace(interp, head);
            if (parentNs == null) {
                throw new TclException(interp, "namespace \"" + head + "\" not found in context \"" + Namespace.getCurrentNamespace((Interp)interp).fullName + "\"");
            }
        } else {
            parentNs = Namespace.getCurrentNamespace(interp);
        }
        StringBuffer objName = new StringBuffer();
        if (parentNs != Namespace.getGlobalNamespace(interp)) {
            objName.append(parentNs.fullName);
        }
        objName.append("::");
        objName.append(tail);
        ItclObject newObj = new ItclObject();
        newObj.classDefn = cdefn;
        Util.PreserveData(cdefn);
        newObj.dataSize = cdefn.numInstanceVars;
        newObj.data = new Var[newObj.dataSize];
        newObj.constructed = new HashMap();
        newObj.destructed = null;
        Util.PreserveData(newObj);
        interp.createCommand(objName.toString(), new HandleInstanceCmd(newObj));
        newObj.w_accessCmd = wcmd = Namespace.findCommand(interp, name, null, 2);
        newObj.accessCmd = wcmd.cmd;
        Util.PreserveData(newObj);
        ItclContext context = new ItclContext(interp);
        Methods.PushContext(interp, null, cdefn, newObj, context);
        ItclHierIter hier = new ItclHierIter();
        Class.InitHierIter(hier, cdefn);
        ItclClass cd = Class.AdvanceHierIter(hier);
        while (cd != null) {
            for (Map.Entry entry : cd.variables.entrySet()) {
                ItclVarDefn vdefn = (ItclVarDefn)entry.getValue();
                if ((vdefn.member.flags & ItclInt.THIS_VAR) != 0) {
                    if (cd != cdefn) continue;
                    Objects.CreateObjVar(interp, vdefn, newObj);
                    interp.setVar("this", TclString.newInstance(""), 0);
                    interp.traceVar("this", (VarTrace)newObj, 48);
                    continue;
                }
                if ((vdefn.member.flags & ItclInt.COMMON) != 0) continue;
                Objects.CreateObjVar(interp, vdefn, newObj);
            }
            cd = Class.AdvanceHierIter(hier);
        }
        Class.DeleteHierIter(hier);
        Methods.PopContext(interp, context);
        boolean ctorErr = true;
        try {
            Methods.InvokeMethodIfExists(interp, "constructor", cdefn, newObj, objv);
            ctorErr = false;
        }
        catch (TclException ex) {
            ctorEx = ex;
        }
        if (cdefn.functions.get("constructor") == null) {
            ctorErr = true;
            try {
                Methods.ConstructBase(interp, newObj, cdefn);
                ctorErr = false;
            }
            catch (TclException ex) {
                ctorEx = ex;
            }
        }
        if (ctorErr) {
            Itcl_InterpState istate = Util.SaveInterpState(interp, 0);
            if (newObj.accessCmd != null) {
                if (interp.deleteCommandFromToken(newObj.w_accessCmd) != 0) {
                    throw new TclRuntimeError("could not delete instance command from token");
                }
                newObj.accessCmd = null;
            }
            Util.RestoreInterpState(interp, istate);
        }
        newObj.constructed.clear();
        newObj.constructed = null;
        if (!ctorErr && newObj.accessCmd != null) {
            cdefn.info.objects.put(newObj.accessCmd, newObj);
        }
        Util.ReleaseData(newObj);
        if (ctorErr) {
            throw ctorEx;
        }
        return newObj;
    }

    static void DeleteObject(Interp interp, ItclObject contextObj) throws TclException {
        ItclClass cdefn = contextObj.classDefn;
        Util.PreserveData(contextObj);
        try {
            Objects.DestructObject(interp, contextObj, 0);
        }
        catch (TclException ex) {
            Util.ReleaseData(contextObj);
            throw ex;
        }
        cdefn.info.objects.remove(contextObj.accessCmd);
        ((HandleInstanceCmd)contextObj.accessCmd).deleteToken = true;
        if (interp.deleteCommandFromToken(contextObj.w_accessCmd) != 0) {
            throw new TclRuntimeError("could not delete instance command from token");
        }
        contextObj.accessCmd = null;
        Util.ReleaseData(contextObj);
    }

    static void DestructObject(Interp interp, ItclObject contextObj, int flags) throws TclException {
        if (contextObj.destructed != null) {
            if ((flags & ItclInt.IGNORE_ERRS) == 0) {
                throw new TclException(interp, "can't delete an object while it is being destructed");
            }
            return;
        }
        contextObj.destructed = new HashMap();
        TclException dtorEx = null;
        try {
            Objects.DestructBase(interp, contextObj, contextObj.classDefn, flags);
        }
        catch (TclException ex) {
            dtorEx = ex;
        }
        if (dtorEx == null) {
            interp.resetResult();
        }
        contextObj.destructed.clear();
        contextObj.destructed = null;
        if (dtorEx != null) {
            throw dtorEx;
        }
    }

    static void DestructBase(Interp interp, ItclObject contextObj, ItclClass contextClass, int flags) throws TclException {
        if (contextObj.destructed.get(contextClass.name) == null) {
            Methods.InvokeMethodIfExists(interp, "destructor", contextClass, contextObj, null);
        }
        Itcl_ListElem elem = Util.FirstListElem(contextClass.bases);
        while (elem != null) {
            ItclClass cdefn = (ItclClass)Util.GetListValue(elem);
            Objects.DestructBase(interp, contextObj, cdefn, flags);
            elem = Util.NextListElem(elem);
        }
        interp.resetResult();
    }

    static ItclObject FindObject(Interp interp, String name) throws TclException {
        WrappedCommand wcmd;
        Namespace contextNs = null;
        Util.DecodeScopedCommandResult res = Util.DecodeScopedCommand(interp, name);
        contextNs = res.rNS;
        String cmdName = res.rCmd;
        try {
            wcmd = Namespace.findCommand(interp, cmdName, contextNs, 0);
        }
        catch (TclException tclException) {
            wcmd = null;
        }
        if (wcmd != null && Objects.IsObject(wcmd)) {
            return Objects.GetContextFromObject(wcmd);
        }
        return null;
    }

    static boolean IsObject(WrappedCommand wcmd) {
        if (wcmd.cmd instanceof HandleInstanceCmd) {
            return true;
        }
        return (wcmd = Namespace.getOriginalCommand(wcmd)) != null && wcmd.cmd instanceof HandleInstanceCmd;
    }

    static ItclObject GetContextFromObject(WrappedCommand wcmd) {
        return ((HandleInstanceCmd)wcmd.cmd).contextObj;
    }

    static boolean ObjectIsa(ItclObject contextObj, ItclClass cdefn) {
        return contextObj.classDefn.heritage.get(cdefn) != null;
    }

    static String GetInstanceVar(Interp interp, String name, ItclObject contextObj, ItclClass contextClass) {
        TclObject val;
        block9: {
            val = null;
            if (contextObj == null) {
                interp.setResult("cannot access object-specific info without an object context");
                return null;
            }
            ItclContext context = new ItclContext(interp);
            try {
                Methods.PushContext(interp, null, contextClass, contextObj, context);
            }
            catch (TclException tclException) {
                return null;
            }
            try {
                try {
                    val = interp.getVar(name, 512);
                }
                catch (TclException tclException) {
                    Methods.PopContext(interp, context);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                Methods.PopContext(interp, context);
                throw throwable;
            }
            Methods.PopContext(interp, context);
        }
        if (val != null) {
            return val.toString();
        }
        return null;
    }

    static String ReportObjectUsage(Interp interp, ItclObject contextObj) {
        Itcl_ListElem elem;
        ItclMemberFunc mfunc;
        ItclClass cdefn = contextObj.classDefn;
        int ignore = ItclInt.CONSTRUCTOR | ItclInt.DESTRUCTOR | ItclInt.COMMON;
        Itcl_List cmdList = new Itcl_List();
        Util.InitList(cmdList);
        for (Map.Entry entry : cdefn.resolveCmds.entrySet()) {
            Namespace contextNs;
            String name = (String)entry.getKey();
            mfunc = (ItclMemberFunc)entry.getValue();
            if (name.indexOf("::") != -1 || (mfunc.member.flags & ignore) != 0) {
                mfunc = null;
            } else if (mfunc.member.protection != 1 && !Util.CanAccessFunc(mfunc, contextNs = Util.GetTrueNamespace(interp, mfunc.member.classDefn.info))) {
                mfunc = null;
            }
            if (mfunc == null) continue;
            elem = Util.FirstListElem(cmdList);
            while (elem != null) {
                ItclMemberFunc cmpDefn = (ItclMemberFunc)Util.GetListValue(elem);
                int cmp = mfunc.member.name.compareTo(cmpDefn.member.name);
                if (cmp < 0) {
                    Util.InsertListElem(elem, mfunc);
                    mfunc = null;
                    break;
                }
                if (cmp == 0) {
                    mfunc = null;
                    break;
                }
                elem = Util.NextListElem(elem);
            }
            if (mfunc == null) continue;
            Util.AppendList(cmdList, mfunc);
        }
        StringBuffer buffer = new StringBuffer(64);
        elem = Util.FirstListElem(cmdList);
        while (elem != null) {
            mfunc = (ItclMemberFunc)Util.GetListValue(elem);
            buffer.append("\n  ");
            Methods.GetMemberFuncUsage(mfunc, contextObj, buffer);
            elem = Util.NextListElem(elem);
        }
        Util.DeleteList(cmdList);
        return buffer.toString();
    }

    static void TraceThisVar(ItclObject contextObj, Interp interp, String name1, String name2, int flags) throws TclException {
        if ((flags & 0x10) != 0) {
            String objName = contextObj.accessCmd != null ? interp.getCommandFullName(contextObj.w_accessCmd) : "";
            interp.setVar(name1, TclString.newInstance(objName), 0);
            return;
        }
        if ((flags & 0x20) != 0) {
            throw new TclException(interp, "variable \"this\" cannot be modified");
        }
    }

    static void DestroyObject(ItclObject contextObj) {
        ItclClass cdefn = contextObj.classDefn;
        Itcl_InterpState istate = Util.SaveInterpState(cdefn.interp, 0);
        try {
            Objects.DestructObject(cdefn.interp, contextObj, ItclInt.IGNORE_ERRS);
        }
        catch (TclException tclException) {}
        Util.RestoreInterpState(cdefn.interp, istate);
        if (contextObj.accessCmd != null) {
            cdefn.info.objects.remove(contextObj.accessCmd);
            contextObj.accessCmd = null;
        }
        Util.ReleaseData(contextObj);
    }

    static void FreeObject(ItclObject contextObj) {
        Interp interp = contextObj.classDefn.interp;
        Itcl_InterpState istate = Util.SaveInterpState(interp, 0);
        ItclHierIter hier = new ItclHierIter();
        Class.InitHierIter(hier, contextObj.classDefn);
        ItclClass cd = Class.AdvanceHierIter(hier);
        while (cd != null) {
            boolean pushErr = false;
            ItclContext context = new ItclContext(interp);
            try {
                Methods.PushContext(interp, null, cd, contextObj, context);
            }
            catch (TclException tclException) {
                pushErr = true;
            }
            if (!pushErr) {
                for (Map.Entry entry : cd.variables.entrySet()) {
                    String cfr_ignored_0 = (String)entry.getKey();
                    ItclVarDefn vdefn = (ItclVarDefn)entry.getValue();
                    if ((vdefn.member.flags & ItclInt.THIS_VAR) != 0) {
                        if (cd != contextObj.classDefn) continue;
                        try {
                            interp.unsetVar(vdefn.member.fullname, 0);
                        }
                        catch (TclException tclException) {}
                        continue;
                    }
                    if ((vdefn.member.flags & ItclInt.COMMON) != 0) continue;
                    try {
                        interp.unsetVar(vdefn.member.fullname, 0);
                    }
                    catch (TclException tclException) {}
                }
                Methods.PopContext(interp, context);
            }
            cd = Class.AdvanceHierIter(hier);
        }
        Class.DeleteHierIter(hier);
        int i = 0;
        while (i < contextObj.dataSize) {
            if (contextObj.data[i] != null) {
                contextObj.data[i] = null;
            }
            ++i;
        }
        Util.RestoreInterpState(interp, istate);
        contextObj.data = null;
        if (contextObj.constructed != null) {
            contextObj.constructed.clear();
            contextObj.constructed = null;
        }
        if (contextObj.destructed != null) {
            contextObj.destructed.clear();
            contextObj.destructed = null;
        }
        Util.ReleaseData(contextObj.classDefn);
    }

    static void CreateObjVar(Interp interp, ItclVarDefn vdefn, ItclObject contextObj) {
        Var var = Migrate.NewVar();
        ItclAccess.createObjVar(var, vdefn.member.name, vdefn.member.classDefn.namesp, dangleTable);
        ItclVarLookup vlookup = (ItclVarLookup)contextObj.classDefn.resolveVars.get(vdefn.member.fullname);
        if (vlookup != null) {
            contextObj.data[vlookup.index] = var;
        }
        if (vdefn.init != null) {
            ItclContext context = new ItclContext(interp);
            try {
                try {
                    Methods.PushContext(interp, null, vdefn.member.classDefn, contextObj, context);
                    interp.setVar(vdefn.member.fullname, TclString.newInstance(vdefn.init), 0);
                }
                catch (TclException tclException) {
                    Methods.PopContext(interp, context);
                }
            }
            finally {
                Methods.PopContext(interp, context);
            }
        }
    }

    static Var ScopedVarResolver(Interp interp, String name, Namespace contextNs, int flags) throws TclException {
        if (!name.startsWith("@itcl")) {
            return null;
        }
        TclObject list = TclString.newInstance(name);
        TclObject[] elems = TclList.getElements(interp, list);
        if (elems.length != 3) {
            throw new TclException(interp, "scoped variable \"" + name + "\" is malformed: " + "should be: @itcl object variable");
        }
        WrappedCommand wcmd = Namespace.findCommand(interp, elems[1].toString(), null, 0);
        if (!Objects.IsObject(wcmd)) {
            throw new TclException(interp, "can't resolve scoped variable \"" + name + "\": " + "can't find object " + elems[1]);
        }
        ItclObject contextObj = Objects.GetContextFromObject(wcmd);
        ItclVarLookup vlookup = (ItclVarLookup)contextObj.classDefn.resolveVars.get(elems[2].toString());
        if (vlookup == null) {
            throw new TclException(interp, "can't resolve scoped variable \"" + name + "\": " + "no such data member " + elems[2]);
        }
        return contextObj.data[vlookup.index];
    }

    static class HandleInstanceCmd
    implements CommandWithDispose {
        ItclObject contextObj;
        boolean deleteToken;

        HandleInstanceCmd(ItclObject contextObj) {
            this.contextObj = contextObj;
            this.deleteToken = false;
        }

        @Override
        public void disposeCmd() {
            if (!this.deleteToken) {
                Objects.DestroyObject(this.contextObj);
            } else {
                Util.ReleaseData(this.contextObj);
            }
        }

        @Override
        public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
            if (objv.length < 2) {
                throw new TclException(interp, "wrong # args: should be one of..." + Objects.ReportObjectUsage(interp, this.contextObj));
            }
            String token = objv[1].toString();
            ItclMemberFunc mfunc = (ItclMemberFunc)this.contextObj.classDefn.resolveCmds.get(token);
            if (mfunc != null) {
                Namespace contextNs;
                if ((mfunc.member.flags & ItclInt.COMMON) != 0) {
                    mfunc = null;
                } else if (mfunc.member.protection != 1 && !Util.CanAccessFunc(mfunc, contextNs = Util.GetTrueNamespace(interp, mfunc.member.classDefn.info))) {
                    mfunc = null;
                }
            }
            if (mfunc == null && !token.equals("info")) {
                throw new TclException(interp, "bad option \"" + token + "\": should be one of..." + Objects.ReportObjectUsage(interp, this.contextObj));
            }
            ItclObjectInfo info = this.contextObj.classDefn.info;
            ItclContext context = new ItclContext(interp);
            Methods.PushContext(interp, null, this.contextObj.classDefn, this.contextObj, context);
            try {
                CallFrame frame = context.frame;
                Util.PushStack(frame, info.transparentFrames);
                if (token.equals("info")) {
                    ItclAccess.setProcCallFrameFalse(frame);
                }
                TclObject cmdline = Util.CreateArgs(interp, null, objv, 1);
                TclObject[] cmdlinev = TclList.getElements(interp, cmdline);
                Util.EvalArgs(interp, cmdlinev);
            }
            finally {
                Util.PopStack(info.transparentFrames);
                Methods.PopContext(interp, context);
            }
        }
    }

    static class ScopedVarResolverImpl
    implements Resolver {
        ScopedVarResolverImpl() {
        }

        @Override
        public WrappedCommand resolveCmd(Interp interp, String name, Namespace context, int flags) throws TclException {
            return null;
        }

        @Override
        public Var resolveVar(Interp interp, String name, Namespace context, int flags) throws TclException {
            return Objects.ScopedVarResolver(interp, name, context, flags);
        }
    }
}

