/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java;

import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.pkg.java.FuncSig;
import tcl.pkg.java.JavaInvoke;
import tcl.pkg.java.reflect.PkgInvoker;

class ArraySig
implements InternalRep {
    Class arrayType;
    int dimensions;

    ArraySig(Class type, int n) {
        this.arrayType = type;
        this.dimensions = n;
    }

    @Override
    public InternalRep duplicate() {
        return new ArraySig(this.arrayType, this.dimensions);
    }

    @Override
    public void dispose() {
    }

    static boolean looksLikeArraySig(Interp interp, TclObject signature) throws TclException {
        InternalRep rep = signature.getInternalRep();
        if (rep instanceof FuncSig) {
            return false;
        }
        if (rep instanceof ArraySig) {
            return true;
        }
        int sigLen = TclList.getLength(interp, signature);
        if (sigLen < 1) {
            return false;
        }
        String clsName = sigLen == 1 ? signature.toString() : TclList.index(interp, signature, 0).toString();
        return clsName.endsWith("[]") || clsName.startsWith("[");
    }

    static ArraySig get(Interp interp, TclObject signature) throws TclException {
        String clsName;
        InternalRep rep = signature.getInternalRep();
        if (rep instanceof ArraySig) {
            return (ArraySig)rep;
        }
        if (TclList.getLength(interp, signature) == 1 && ((clsName = signature.toString()).endsWith("[]") || clsName.startsWith("["))) {
            Class<?> arrayType;
            Class<?> componentType = arrayType = JavaInvoke.getClassByName(interp, clsName);
            while (componentType.isArray()) {
                componentType = componentType.getComponentType();
            }
            if (!PkgInvoker.isAccessible(componentType)) {
                JavaInvoke.notAccessibleError(interp, componentType);
            }
            int dimensions = 0;
            if (clsName.charAt(0) == '[') {
                while (clsName.charAt(++dimensions) == '[') {
                }
            } else {
                int end = clsName.length() - 1;
                while (end > 0 && clsName.charAt(end - 1) == '[' && clsName.charAt(end) == ']') {
                    ++dimensions;
                    end -= 2;
                }
            }
            ArraySig sigRep = new ArraySig(arrayType, dimensions);
            signature.setInternalRep(sigRep);
            return sigRep;
        }
        throw new TclException(interp, "bad array signature \"" + signature + "\"");
    }
}

