/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java;

import java.beans.EventSetDescriptor;
import java.lang.reflect.Method;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import tcl.lang.AssocData;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.pkg.java.AdaptorClassLoader;
import tcl.pkg.java.BeanEventParamSet;
import tcl.pkg.java.EventAdaptor;
import tcl.pkg.java.ReflectObject;

class BeanEventMgr
implements AssocData {
    private static Hashtable adaptorClsTab = new Hashtable();
    private static AdaptorClassLoader adaptorLoader = new AdaptorClassLoader();
    Stack eventParamSetStack = new Stack();

    private BeanEventMgr() {
    }

    static BeanEventMgr getBeanEventMgr(Interp interp) {
        BeanEventMgr mgr = (BeanEventMgr)interp.getAssocData("tclBeanEvent");
        if (mgr == null) {
            mgr = new BeanEventMgr();
            interp.setAssocData("tclBeanEvent", mgr);
        }
        return mgr;
    }

    void pushEventParamSet(BeanEventParamSet p) {
        this.eventParamSetStack.push(p);
    }

    void popEventParamSet() throws EmptyStackException {
        this.eventParamSetStack.pop();
    }

    BeanEventParamSet peekEventParamSet() {
        if (this.eventParamSetStack.size() == 0) {
            return null;
        }
        return (BeanEventParamSet)this.eventParamSetStack.peek();
    }

    @Override
    public void disposeAssocData(Interp interp) {
        this.eventParamSetStack = null;
    }

    void setBinding(Interp interp, ReflectObject reflectObj, EventSetDescriptor eventSet, Method event, TclObject command) throws TclException {
        EventAdaptor adaptor = null;
        if (reflectObj.bindings == null) {
            reflectObj.bindings = new Hashtable();
        } else {
            adaptor = (EventAdaptor)reflectObj.bindings.get(eventSet);
        }
        if (adaptor == null) {
            Class<?> lsnType = eventSet.getListenerType();
            Class adaptorCls = (Class)adaptorClsTab.get(lsnType);
            if (adaptorCls == null) {
                adaptorCls = adaptorLoader.loadEventAdaptor(interp, eventSet);
                adaptorClsTab.put(lsnType, adaptorCls);
            }
            try {
                adaptor = (EventAdaptor)adaptorCls.newInstance();
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (adaptor == null) {
                throw new TclException(interp, "couldn't instantiate adaptor class for eventset \"" + eventSet + "\"");
            }
            adaptor.init(interp, reflectObj.javaObj, eventSet);
            reflectObj.bindings.put(eventSet, adaptor);
        }
        if (command.toString().length() > 0) {
            adaptor.setCallback(event.getName(), command);
        } else if (adaptor.deleteCallback(event.getName()) == 0) {
            reflectObj.bindings.remove(eventSet);
            if (reflectObj.bindings.size() == 0) {
                reflectObj.bindings = null;
            }
        }
    }

    TclObject getBinding(Interp interp, ReflectObject reflectObj, EventSetDescriptor eventSet, Method event) {
        EventAdaptor adaptor = null;
        if (reflectObj.bindings != null) {
            adaptor = (EventAdaptor)reflectObj.bindings.get(eventSet);
        }
        if (adaptor == null) {
            return null;
        }
        return adaptor.getCallback(event.getName());
    }

    TclObject getHandledEvents(ReflectObject reflectObj) {
        TclObject list = TclList.newInstance();
        if (reflectObj.bindings != null) {
            Enumeration e = reflectObj.bindings.elements();
            while (e.hasMoreElements()) {
                EventAdaptor adaptor = (EventAdaptor)e.nextElement();
                adaptor.getHandledEvents(list);
            }
        }
        return list;
    }
}

