/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java;

import java.lang.reflect.Field;
import java.util.ArrayList;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.pkg.java.ClassRep;
import tcl.pkg.java.JavaInfoCmd;
import tcl.pkg.java.JavaInvoke;
import tcl.pkg.java.reflect.PkgInvoker;

class FieldSig
implements InternalRep {
    Class targetCls;
    Class sigCls;
    Field field;
    PkgInvoker pkgInvoker;

    FieldSig(Class tc, Class sc, PkgInvoker p, Field f) {
        this.targetCls = tc;
        this.sigCls = sc;
        this.pkgInvoker = p;
        this.field = f;
    }

    @Override
    public InternalRep duplicate() {
        return new FieldSig(this.targetCls, this.sigCls, this.pkgInvoker, this.field);
    }

    @Override
    public void dispose() {
    }

    static FieldSig get(Interp interp, TclObject signature, Class targetCls) throws TclException {
        Field field;
        Class sigCls;
        TclObject sigClsObj;
        String fieldName;
        InternalRep rep = signature.getInternalRep();
        if (rep instanceof FieldSig && ((FieldSig)rep).targetCls == targetCls) {
            return (FieldSig)rep;
        }
        int len = TclList.getLength(interp, signature);
        if (len < 1 || len > 2) {
            throw new TclException(interp, "bad field signature \"" + signature + "\"");
        }
        if (len == 1) {
            fieldName = signature.toString();
            sigClsObj = null;
        } else {
            fieldName = TclList.index(interp, signature, 0).toString();
            sigClsObj = TclList.index(interp, signature, 1);
        }
        if (sigClsObj != null) {
            sigCls = ClassRep.get(interp, sigClsObj);
            if (!sigCls.isAssignableFrom(targetCls)) {
                throw new TclException(interp, "\"" + JavaInfoCmd.getNameFromClass(sigCls) + "\" is not a superclass of \"" + JavaInfoCmd.getNameFromClass(targetCls) + "\"");
            }
            if (!PkgInvoker.isAccessible(sigCls)) {
                JavaInvoke.notAccessibleError(interp, sigCls);
            }
        } else {
            sigCls = targetCls;
        }
        try {
            field = FieldSig.getAccessibleField(sigCls, fieldName);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new TclException(interp, "no accessible field \"" + signature + "\" found in class " + JavaInfoCmd.getNameFromClass(sigCls));
        }
        FieldSig sig = new FieldSig(targetCls, sigCls, PkgInvoker.getPkgInvoker(targetCls), field);
        signature.setInternalRep(sig);
        return sig;
    }

    static Field[] getAccessibleFields(Class cls) {
        if (PkgInvoker.usesDefaultInvoker(cls)) {
            return cls.getFields();
        }
        Field[] fields = cls.getDeclaredFields();
        ArrayList<Field> alist = null;
        boolean skipped_any = false;
        int i = 0;
        while (i < fields.length) {
            Field f = fields[i];
            if (PkgInvoker.isAccessible(f)) {
                if (alist == null) {
                    alist = new ArrayList<Field>(fields.length);
                }
                alist.add(f);
            } else {
                skipped_any = true;
            }
            ++i;
        }
        if (skipped_any) {
            fields = new Field[alist.size()];
            i = 0;
            while (i < fields.length) {
                fields[i] = (Field)alist.get(i);
                ++i;
            }
        }
        return fields;
    }

    static Field getAccessibleField(Class cls, String fieldName) throws NoSuchFieldException {
        if (PkgInvoker.usesDefaultInvoker(cls)) {
            return cls.getField(fieldName);
        }
        Field f = cls.getDeclaredField(fieldName);
        if (!PkgInvoker.isAccessible(f)) {
            throw new NoSuchFieldException();
        }
        return f;
    }
}

