/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import tcl.lang.InternalRep;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.pkg.java.JavaInfoCmd;
import tcl.pkg.java.JavaInvoke;
import tcl.pkg.java.ReflectObject;
import tcl.pkg.java.reflect.PkgInvoker;

class FuncSig
implements InternalRep {
    private static final Method[] ZERO_METHODS = new Method[0];
    Class targetCls;
    PkgInvoker pkgInvoker;
    Object func;
    static Hashtable instanceMethodTable = new Hashtable();
    static Hashtable staticMethodTable = new Hashtable();
    static Hashtable<Class<?>, HashMap<String, Method[]>> instanceMethodTableByName = new Hashtable();

    FuncSig(Class cls, PkgInvoker p, Object f) {
        this.targetCls = cls;
        this.pkgInvoker = p;
        this.func = f;
    }

    @Override
    public InternalRep duplicate() {
        return new FuncSig(this.targetCls, this.pkgInvoker, this.func);
    }

    @Override
    public void dispose() {
    }

    static FuncSig get(Interp interp, Class cls, TclObject signature, TclObject[] argv, int startIdx, int count, boolean isStatic) throws TclException {
        Object match;
        boolean isConstructor = cls == null;
        int sigLength = TclList.getLength(interp, signature);
        String methodName = null;
        if (sigLength == 0) {
            throw new TclException(interp, "bad signature \"" + signature + "\"");
        }
        TclObject class_or_method = sigLength == 1 ? signature : TclList.index(interp, signature, 0);
        if (isConstructor) {
            cls = JavaInvoke.getClassByName(interp, class_or_method.toString());
        } else {
            methodName = class_or_method.toString();
        }
        if ((isConstructor || isStatic) && !PkgInvoker.isAccessible(cls)) {
            JavaInvoke.notAccessibleError(interp, cls);
        }
        if (isConstructor && Modifier.isAbstract(cls.getModifiers())) {
            throw new TclException(interp, "Class \"" + JavaInfoCmd.getNameFromClass(cls) + "\" is abstract");
        }
        if (sigLength > 1 || sigLength == 1 && count == 0) {
            int sigNumArgs = sigLength - 1;
            Class[] paramTypes = new Class[sigNumArgs];
            int i = 0;
            while (i < sigNumArgs) {
                String clsName = TclList.index(interp, signature, i + 1).toString();
                paramTypes[i] = JavaInvoke.getClassByName(interp, clsName);
                ++i;
            }
            if (isConstructor) {
                try {
                    match = FuncSig.getAccessibleConstructor(cls, paramTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (sigLength > 1) {
                        throw new TclException(interp, "no accessible constructor \"" + signature + "\"");
                    }
                    throw new TclException(interp, "can't find accessible constructor with " + count + " argument(s) for class \"" + JavaInfoCmd.getNameFromClass(cls) + "\"");
                }
            } else {
                match = FuncSig.lookupMethod(interp, cls, methodName, paramTypes, signature, isStatic);
            }
        } else {
            match = FuncSig.matchSignature(interp, cls, signature, methodName, isConstructor, argv, startIdx, count, isStatic);
        }
        FuncSig sig = new FuncSig(cls, PkgInvoker.getPkgInvoker(cls), match);
        return sig;
    }

    static Method lookupMethod(Interp interp, Class cls, String methodName, Class[] paramTypes, TclObject signature, boolean isStatic) throws TclException {
        boolean foundSameName = false;
        Method[] methods = isStatic ? FuncSig.getAccessibleStaticMethods(cls) : FuncSig.getAccessibleInstanceMethods(cls, methodName);
        int i = 0;
        while (i < methods.length) {
            if (methodName.equals(methods[i].getName())) {
                foundSameName = true;
                Class<?>[] pt = methods[i].getParameterTypes();
                if (pt.length == paramTypes.length) {
                    boolean good = true;
                    int j = 0;
                    while (j < pt.length) {
                        if (pt[j] != paramTypes[j]) {
                            good = false;
                            break;
                        }
                        ++j;
                    }
                    if (good) {
                        return methods[i];
                    }
                }
            }
            ++i;
        }
        if (paramTypes.length > 0 || !foundSameName) {
            throw new TclException(interp, "no accessible" + (isStatic ? " static " : " ") + "method \"" + signature + "\" in class " + JavaInfoCmd.getNameFromClass(cls));
        }
        throw new TclException(interp, "can't find accessible" + (isStatic ? " static " : " ") + "method \"" + signature + "\" with " + paramTypes.length + " argument(s) for class \"" + JavaInfoCmd.getNameFromClass(cls) + "\"");
    }

    static Object matchSignature(Interp interp, Class cls, TclObject signature, String methodName, boolean isConstructor, TclObject[] argv, int startIdx, int argv_count, boolean isStatic) throws TclException {
        boolean foundSameName;
        block53: {
            StringBuffer sb;
            int j;
            Class<?>[] match_classes;
            int i;
            ArrayList<Executable> match_list;
            block58: {
                block54: {
                    Class c;
                    foundSameName = false;
                    match_list = new ArrayList<Executable>();
                    Executable[] funcs = isConstructor ? FuncSig.getAccessibleConstructors(cls) : (isStatic ? FuncSig.getAccessibleStaticMethods(cls) : FuncSig.getAccessibleInstanceMethods(cls, methodName));
                    i = 0;
                    while (i < funcs.length) {
                        block52: {
                            Class<?>[] paramTypes;
                            block51: {
                                block50: {
                                    if (!isConstructor) break block50;
                                    paramTypes = ((Constructor)funcs[i]).getParameterTypes();
                                    break block51;
                                }
                                Method method = (Method)funcs[i];
                                if (!methodName.equals(method.getName())) break block52;
                                foundSameName = true;
                                paramTypes = method.getParameterTypes();
                            }
                            if (paramTypes.length == argv_count) {
                                match_list.add(funcs[i]);
                            }
                        }
                        ++i;
                    }
                    if (match_list.size() == 1) {
                        return match_list.get(0);
                    }
                    if (match_list.size() <= 1) break block53;
                    Class[] argv_classes = new Class[argv_count];
                    i = 0;
                    while (i < argv_count) {
                        TclObject tobj = argv[startIdx + i];
                        boolean isJavaObj = true;
                        c = null;
                        try {
                            c = ReflectObject.getClass(interp, tobj);
                        }
                        catch (TclException tclException) {
                            isJavaObj = false;
                        }
                        argv_classes[i] = isJavaObj ? c : String.class;
                        ++i;
                    }
                    i = 0;
                    while (i < match_list.size()) {
                        match_classes = isConstructor ? ((Constructor)match_list.get(i)).getParameterTypes() : ((Method)match_list.get(i)).getParameterTypes();
                        boolean exact = true;
                        j = 0;
                        while (j < argv_count) {
                            if (match_classes[j] != argv_classes[j]) {
                                exact = false;
                                break;
                            }
                            ++j;
                        }
                        if (exact) {
                            return match_list.get(i);
                        }
                        ++i;
                    }
                    i = match_list.size() - 1;
                    while (i >= 0) {
                        match_classes = isConstructor ? ((Constructor)match_list.get(i)).getParameterTypes() : ((Method)match_list.get(i)).getParameterTypes();
                        j = 0;
                        while (j < argv_count) {
                            if (!JavaInvoke.isAssignable(match_classes[j], argv_classes[j])) {
                                match_list.remove(i);
                                break;
                            }
                            ++j;
                        }
                        --i;
                    }
                    if (match_list.size() == 1) {
                        return match_list.get(0);
                    }
                    if (match_list.size() > 1) {
                        Class[][] argv_classes_lookup = new Class[argv_count][];
                        ArrayList class_list = new ArrayList();
                        i = 0;
                        while (i < argv_count) {
                            c = argv_classes[i];
                            if (c != null) {
                                j = 0;
                                while (j < i) {
                                    if (c == argv_classes_lookup[j][0]) {
                                        argv_classes_lookup[i] = argv_classes_lookup[j];
                                    }
                                    ++j;
                                }
                                while (c != null) {
                                    class_list.add(null);
                                    FuncSig.addInterfaces(c, class_list);
                                    c = c.getSuperclass();
                                }
                                class_list.remove(0);
                                Class[] classes = new Class[class_list.size()];
                                j = 0;
                                while (j < classes.length) {
                                    classes[j] = (Class)class_list.get(j);
                                    ++j;
                                }
                                argv_classes_lookup[i] = classes;
                                class_list.clear();
                            }
                            ++i;
                        }
                        int[] super_steps = new int[match_list.size()];
                        int[] total_steps = new int[match_list.size()];
                        boolean[] trim_matches = new boolean[match_list.size()];
                        j = 0;
                        while (j < argv_count) {
                            int min_super_step = Integer.MAX_VALUE;
                            int min_total_step = Integer.MAX_VALUE;
                            Class min_class = Object.class;
                            i = 0;
                            while (i < match_list.size()) {
                                match_classes = isConstructor ? ((Constructor)match_list.get(i)).getParameterTypes() : ((Method)match_list.get(i)).getParameterTypes();
                                Class<?> match_to = match_classes[j];
                                Class[] arg_classes = argv_classes_lookup[j];
                                if (arg_classes == null) {
                                    super_steps[i] = Integer.MAX_VALUE;
                                    total_steps[i] = Integer.MAX_VALUE;
                                } else {
                                    int super_step = 0;
                                    int total_step = 0;
                                    while (total_step < arg_classes.length) {
                                        Class c2 = arg_classes[total_step];
                                        if (c2 == null) {
                                            ++super_step;
                                        } else if (c2 == match_to) {
                                            super_steps[i] = super_step;
                                            total_steps[i] = total_step;
                                            if (super_step > min_super_step || c2.isInterface() && min_class != Object.class && !min_class.isInterface()) break;
                                            min_class = c2;
                                            min_super_step = super_step;
                                            if (total_step >= min_total_step) break;
                                            min_total_step = total_step;
                                            break;
                                        }
                                        ++total_step;
                                    }
                                }
                                ++i;
                            }
                            i = match_list.size() - 1;
                            while (i >= 0) {
                                if (super_steps[i] > min_super_step || super_steps[i] == min_super_step && total_steps[i] > min_total_step) {
                                    trim_matches[i] = true;
                                }
                                --i;
                            }
                            ++j;
                        }
                        i = match_list.size() - 1;
                        while (i >= 0) {
                            if (trim_matches[i]) {
                                match_list.remove(i);
                            }
                            --i;
                        }
                    }
                    if (match_list.size() == 1) {
                        return match_list.get(0);
                    }
                    sb = new StringBuffer(100);
                    sb.append("ambiguous ");
                    if (isConstructor) {
                        sb.append("constructor");
                    } else {
                        sb.append("method");
                    }
                    sb.append(" signature");
                    if (match_list.size() != 0) break block54;
                    sb.append(", could not choose between ");
                    funcs = isConstructor ? FuncSig.getAccessibleConstructors(cls) : (isStatic ? FuncSig.getAccessibleStaticMethods(cls) : FuncSig.getAccessibleInstanceMethods(cls, methodName));
                    i = 0;
                    while (i < funcs.length) {
                        block57: {
                            Class<?>[] paramTypes;
                            block56: {
                                block55: {
                                    if (!isConstructor) break block55;
                                    paramTypes = ((Constructor)funcs[i]).getParameterTypes();
                                    break block56;
                                }
                                Method method = (Method)funcs[i];
                                if (!methodName.equals(method.getName())) break block57;
                                foundSameName = true;
                                paramTypes = method.getParameterTypes();
                            }
                            if (paramTypes.length == argv_count) {
                                match_list.add(funcs[i]);
                            }
                        }
                        ++i;
                    }
                    break block58;
                }
                sb.append(", assignable signatures are ");
            }
            TclObject siglist = TclList.newInstance();
            siglist.preserve();
            i = 0;
            while (i < match_list.size()) {
                TclObject cur_siglist = TclList.newInstance();
                cur_siglist.preserve();
                if (isConstructor) {
                    Constructor con = (Constructor)match_list.get(i);
                    TclList.append(interp, cur_siglist, TclString.newInstance(con.getName()));
                    match_classes = con.getParameterTypes();
                } else {
                    Method meth = (Method)match_list.get(i);
                    TclList.append(interp, cur_siglist, TclString.newInstance(meth.getName()));
                    match_classes = meth.getParameterTypes();
                }
                j = 0;
                while (j < argv_count) {
                    Class<?> c = match_classes[j];
                    TclList.append(interp, cur_siglist, TclString.newInstance(JavaInfoCmd.getNameFromClass(c)));
                    ++j;
                }
                TclList.append(interp, siglist, cur_siglist);
                cur_siglist.release();
                ++i;
            }
            sb.append(siglist.toString());
            siglist.release();
            throw new TclException(interp, sb.toString());
        }
        if (isConstructor) {
            throw new TclException(interp, "can't find accessible constructor with " + argv_count + " argument(s) for class \"" + JavaInfoCmd.getNameFromClass(cls) + "\"");
        }
        if (!foundSameName) {
            throw new TclException(interp, "no accessible" + (isStatic ? " static " : " ") + "method \"" + signature + "\" in class " + JavaInfoCmd.getNameFromClass(cls));
        }
        throw new TclException(interp, "can't find accessible" + (isStatic ? " static " : " ") + "method \"" + signature + "\" with " + argv_count + " argument(s) for class \"" + JavaInfoCmd.getNameFromClass(cls) + "\"");
    }

    private static void addInterfaces(Class cls, ArrayList alist) {
        alist.add(cls);
        Class<?>[] interfaces = cls.getInterfaces();
        int i = 0;
        while (i < interfaces.length) {
            FuncSig.addInterfaces(interfaces[i], alist);
            ++i;
        }
    }

    static Constructor[] getAccessibleConstructors(Class cls) {
        if (PkgInvoker.usesDefaultInvoker(cls)) {
            return cls.getConstructors();
        }
        Constructor[] constructors = cls.getDeclaredConstructors();
        ArrayList alist = null;
        boolean skipped_any = false;
        int i = 0;
        while (i < constructors.length) {
            Constructor<?> c = constructors[i];
            if (PkgInvoker.isAccessible(c)) {
                if (alist == null) {
                    alist = new ArrayList(constructors.length);
                }
                alist.add(c);
            } else {
                skipped_any = true;
            }
            ++i;
        }
        if (skipped_any) {
            if (alist == null) {
                constructors = new Constructor[]{};
            } else {
                constructors = new Constructor[alist.size()];
                i = 0;
                while (i < constructors.length) {
                    constructors[i] = (Constructor)alist.get(i);
                    ++i;
                }
            }
        }
        return constructors;
    }

    static Constructor getAccessibleConstructor(Class cls, Class[] parameterTypes) throws NoSuchMethodException {
        if (PkgInvoker.usesDefaultInvoker(cls)) {
            return cls.getConstructor(parameterTypes);
        }
        Constructor constructor = cls.getDeclaredConstructor(parameterTypes);
        if (!PkgInvoker.isAccessible(constructor)) {
            throw new NoSuchMethodException();
        }
        return constructor;
    }

    static Method[] getAccessibleInstanceMethods(Class cls, String name) {
        FuncSig.getAccessibleInstanceMethods(cls);
        Method[] methods = instanceMethodTableByName.get(cls).get(name);
        if (methods == null) {
            return ZERO_METHODS;
        }
        return methods;
    }

    static Method[] getAccessibleInstanceMethods(Class cls) {
        Method[] methods = (Method[])instanceMethodTable.get(cls);
        if (methods != null) {
            return methods;
        }
        ArrayList alist = new ArrayList();
        Class c = cls;
        while (c != null) {
            methods = c.getDeclaredMethods();
            FuncSig.mergeInstanceMethods(c, methods, alist);
            Class<?>[] interfaces = c.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                FuncSig.mergeInstanceMethods(interfaces[i], interfaces[i].getMethods(), alist);
                ++i;
            }
            c = c.isInterface() ? Object.class : c.getSuperclass();
        }
        FuncSig.sortMethods(alist);
        methods = new Method[alist.size()];
        HashMap<String, ArrayList<Method>> map = new HashMap<String, ArrayList<Method>>();
        int i = 0;
        while (i < methods.length) {
            methods[i] = (Method)alist.get(i);
            String name = methods[i].getName();
            ArrayList<Method> lst = (ArrayList<Method>)map.get(name);
            if (lst == null) {
                lst = new ArrayList<Method>();
                map.put(name, lst);
            }
            lst.add(methods[i]);
            ++i;
        }
        HashMap<String, Method[]> mapT = new HashMap<String, Method[]>();
        for (Map.Entry entry : map.entrySet()) {
            mapT.put((String)entry.getKey(), ((ArrayList)entry.getValue()).toArray(new Method[0]));
        }
        instanceMethodTableByName.put(cls, mapT);
        instanceMethodTable.put(cls, methods);
        return methods;
    }

    static Method[] getAccessibleStaticMethods(Class cls) {
        Method[] methods = (Method[])staticMethodTable.get(cls);
        if (methods != null) {
            return methods;
        }
        methods = cls.getDeclaredMethods();
        ArrayList<Method> alist = new ArrayList<Method>();
        int i = 0;
        while (i < methods.length) {
            Method m = methods[i];
            if (Modifier.isStatic(m.getModifiers()) && PkgInvoker.isAccessible(m)) {
                alist.add(m);
            }
            ++i;
        }
        FuncSig.sortMethods(alist);
        methods = new Method[alist.size()];
        i = 0;
        while (i < methods.length) {
            methods[i] = (Method)alist.get(i);
            ++i;
        }
        staticMethodTable.put(cls, methods);
        return methods;
    }

    private static void mergeInstanceMethods(Class c, Method[] methods, ArrayList alist) {
        int i = 0;
        while (i < methods.length) {
            boolean sameSigExists = false;
            Method newMeth = methods[i];
            if (newMeth != null && !Modifier.isStatic(newMeth.getModifiers()) && PkgInvoker.isAccessible(newMeth) && PkgInvoker.isAccessible(newMeth.getReturnType())) {
                int j = 0;
                while (j < alist.size()) {
                    Method oldMeth = (Method)alist.get(j);
                    if (FuncSig.methodSigEqual(oldMeth, newMeth)) {
                        int oldHier;
                        int newHier;
                        int oldRank;
                        sameSigExists = true;
                        Class<?> oldCls = oldMeth.getDeclaringClass();
                        int newRank = FuncSig.getMethodRank(c, newMeth);
                        if (newRank > (oldRank = FuncSig.getMethodRank(oldCls, oldMeth))) {
                            alist.set(j, newMeth);
                            break;
                        }
                        if (newRank != oldRank || (newHier = FuncSig.getParents(newMeth.getDeclaringClass())) <= (oldHier = FuncSig.getParents(oldMeth.getDeclaringClass()))) break;
                        alist.set(j, newMeth);
                        break;
                    }
                    ++j;
                }
                if (!sameSigExists) {
                    alist.add(newMeth);
                }
            }
            ++i;
        }
    }

    private static boolean methodSigEqual(Method method1, Method method2) {
        Class<?>[] param2;
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        Class<?>[] param1 = method1.getParameterTypes();
        if (param1.length != (param2 = method2.getParameterTypes()).length) {
            return false;
        }
        int i = 0;
        while (i < param1.length) {
            if (param1[i] != param2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static void sortMethods(ArrayList alist) {
        int insize = alist.size();
        int i = 1;
        while (i < alist.size()) {
            int c = i;
            Method cm = (Method)alist.get(c);
            String cms = FuncSig.getMethodDescription(cm);
            int j = c - 1;
            while (j >= 0) {
                Method jm = (Method)alist.get(j);
                String jms = FuncSig.getMethodDescription(jm);
                if (cms.compareTo(jms) > 0) break;
                alist.set(c, jm);
                alist.set(j, cm);
                c = j--;
            }
            ++i;
        }
        if (insize != alist.size()) {
            throw new RuntimeException("lost elements");
        }
    }

    private static String getMethodDescription(Method m) {
        StringBuffer sb = new StringBuffer(50);
        sb.append(m.getName());
        Class<?>[] params = m.getParameterTypes();
        sb.append('(');
        int i = 0;
        while (i < params.length) {
            sb.append(JavaInfoCmd.getNameFromClass(params[i]));
            if (i < params.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append(") returns ");
        Class<?> ret = m.getReturnType();
        sb.append(JavaInfoCmd.getNameFromClass(ret));
        return sb.toString();
    }

    private static int getMethodRank(Class declaringCls, Method method) {
        int methMod = method.getModifiers();
        if (Modifier.isPrivate(methMod)) {
            return 0;
        }
        int clsMod = declaringCls.getModifiers();
        if (Modifier.isPublic(methMod) && Modifier.isPublic(clsMod)) {
            return 2;
        }
        return 0;
    }

    private static int getParents(Class c) {
        Class parent = c.getSuperclass();
        if (parent == null) {
            return 1;
        }
        return 1 + FuncSig.getParents(parent);
    }
}

