/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.PackageNameException;
import tcl.lang.TclClassLoader;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.pkg.java.JavaInvoke;
import tcl.pkg.java.reflect.PkgInvoker;

public class JavaImportCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        ArrayList<String> class_list;
        String class_package;
        ListIterator iter;
        HashMap classTable = interp.importTable[0];
        HashMap packageTable = interp.importTable[1];
        HashMap wildcardTable = interp.importTable[2];
        boolean forget = false;
        String pkg = null;
        if (objv.length == 1) {
            TclObject import_list = TclList.newInstance();
            for (Map.Entry entry : classTable.entrySet()) {
                String cfr_ignored_0 = (String)entry.getKey();
                String value = (String)entry.getValue();
                TclList.append(interp, import_list, TclString.newInstance(value));
            }
            ArrayList wildcardList = (ArrayList)wildcardTable.get("*");
            if (wildcardList != null) {
                for (String wildcardPkg : wildcardList) {
                    TclList.append(interp, import_list, TclString.newInstance(String.valueOf(wildcardPkg) + ".*"));
                }
            }
            interp.setResult(import_list);
            return;
        }
        int startIdx = 1;
        String elem = objv[startIdx].toString();
        if (elem.equals("-forget")) {
            forget = true;
            ++startIdx;
        }
        if (startIdx >= objv.length) {
            interp.resetResult();
            return;
        }
        elem = objv[startIdx].toString();
        if (elem.equals("-package")) {
            if (++startIdx >= objv.length) {
                throw new TclException(interp, "java::import ?-forget? ?-package pkg? ?class ...?");
            }
            pkg = objv[startIdx].toString();
            if (pkg.length() == 0) {
                throw new TclException(interp, "java::import ?-forget? ?-package pkg? ?class ...?");
            }
            ++startIdx;
        }
        if (startIdx >= objv.length) {
            if (forget) {
                if (pkg == null) {
                    throw new TclException(interp, "java::import ?-forget? ?-package pkg? ?class ...?");
                }
                boolean found = false;
                for (Map.Entry entry : packageTable.entrySet()) {
                    elem = (String)entry.getKey();
                    if (!elem.equals(pkg)) continue;
                    if (found) {
                        throw new TclRuntimeError("unexpected : found == true");
                    }
                    found = true;
                    ArrayList alist = (ArrayList)entry.getValue();
                    ListIterator iter2 = alist.listIterator();
                    while (iter2.hasNext()) {
                        String elem2 = (String)iter2.next();
                        if (classTable.remove(elem2) != null) continue;
                        throw new TclRuntimeError("key " + elem2 + " not in classTable");
                    }
                    if (packageTable.remove(elem) != null) continue;
                    throw new TclRuntimeError("key " + elem + " not in packageTable");
                }
                if (!found) {
                    throw new TclException(interp, "cannot forget package \"" + pkg + "\", no classes were imported from it");
                }
                interp.resetResult();
                return;
            }
            if (pkg == null) {
                throw new TclRuntimeError("unexpected : pkg == null");
            }
            for (Map.Entry entry : packageTable.entrySet()) {
                elem = (String)entry.getKey();
                if (!elem.equals(pkg)) continue;
                TclObject import_list = TclList.newInstance();
                ArrayList alist = (ArrayList)entry.getValue();
                ListIterator iter2 = alist.listIterator();
                while (iter2.hasNext()) {
                    String elem2 = (String)iter2.next();
                    TclList.append(interp, import_list, TclString.newInstance((String)classTable.get(elem2)));
                }
                ArrayList wildcardList = (ArrayList)wildcardTable.get("*");
                if (wildcardList != null && wildcardList.contains(pkg)) {
                    TclList.append(interp, import_list, TclString.newInstance(String.valueOf(pkg) + ".*"));
                }
                interp.setResult(import_list);
                return;
            }
            ArrayList wildcardList = (ArrayList)wildcardTable.get("*");
            if (wildcardList != null && wildcardList.contains(pkg)) {
                TclObject import_list = TclList.newInstance();
                TclList.append(interp, import_list, TclString.newInstance(String.valueOf(pkg) + ".*"));
                interp.setResult(import_list);
                return;
            }
            interp.resetResult();
            return;
        }
        ArrayList<String> importClasses = new ArrayList<String>();
        ArrayList<String> forgetClasses = new ArrayList<String>();
        boolean addedWildcard = false;
        String operation = "import";
        if (forget) {
            operation = "forget";
        }
        int i = startIdx;
        while (i < objv.length) {
            ArrayList<String> wildcardList;
            elem = objv[i].toString();
            if (elem.length() == 0 || elem.equals("-forget") || elem.equals("-package")) {
                throw new TclException(interp, "java::import ?-forget? ?-package pkg? ?class ...?");
            }
            if (pkg != null && elem.indexOf(46) != -1) {
                throw new TclException(interp, "class argument must not contain a package specifier when the -package pkg arguments are given");
            }
            if (elem.equals("int") || elem.equals("boolean") || elem.equals("long") || elem.equals("float") || elem.equals("double") || elem.equals("byte") || elem.equals("short") || elem.equals("char")) {
                throw new TclException(interp, "cannot " + operation + " primitive type \"" + elem + "\"");
            }
            String fullyqualified = pkg == null ? elem : String.valueOf(pkg) + "." + elem;
            int ind = fullyqualified.lastIndexOf(46);
            if (ind == -1) {
                throw new TclException(interp, "cannot " + operation + " from global package");
            }
            String class_package2 = fullyqualified.substring(0, ind);
            String class_name = fullyqualified.substring(ind + 1, fullyqualified.length());
            boolean wildcardClass = "*".equals(class_name);
            if (class_package2.equals("java.lang")) {
                throw new TclException(interp, "cannot " + operation + " class \"" + fullyqualified + "\", it is in the java.lang package");
            }
            if (!forget) {
                if (wildcardClass) {
                    wildcardList = (ArrayList<String>)wildcardTable.get("*");
                    if (wildcardList == null) {
                        wildcardList = new ArrayList<String>();
                        wildcardTable.put("*", wildcardList);
                    }
                    if (!wildcardList.contains(class_package2)) {
                        wildcardList.add(class_package2);
                    }
                    addedWildcard = true;
                } else {
                    JavaImportCmd.attemptLoadClass(interp, fullyqualified, class_name);
                }
            }
            if (forget && !wildcardClass && classTable.get(class_name) == null) {
                throw new TclException(interp, "cannot forget class \"" + fullyqualified + "\", it was never imported");
            }
            if (wildcardClass) {
                if (forget && (wildcardList = (ArrayList)wildcardTable.get("*")) != null) {
                    wildcardList.remove(class_package2);
                }
            } else if (forget) {
                forgetClasses.add(fullyqualified);
            } else {
                importClasses.add(fullyqualified);
            }
            ++i;
        }
        if (!addedWildcard && forgetClasses.size() != 0 && importClasses.size() != 0) {
            throw new TclRuntimeError("unexpected : forgetClasses and importClasses are both nonempty");
        }
        if (forgetClasses.size() != 0) {
            iter = forgetClasses.listIterator();
            while (iter.hasNext()) {
                String fullyqualified = (String)iter.next();
                int ind = fullyqualified.lastIndexOf(46);
                if (ind == -1) {
                    throw new TclRuntimeError("unexpected : no package in forget class");
                }
                class_package = fullyqualified.substring(0, ind);
                String class_name = fullyqualified.substring(ind + 1, fullyqualified.length());
                class_list = (ArrayList<String>)packageTable.get(class_package);
                int cindex = class_list.indexOf(class_name);
                if (cindex == -1) {
                    throw new TclRuntimeError("unexpected : class not found in package list");
                }
                if (class_list.remove(cindex) == null) {
                    throw new TclRuntimeError("could not remove element at index " + cindex + " from {" + class_list + "}, class_name is " + class_name);
                }
                if (class_list.size() == 0 && packageTable.remove(class_package) == null) {
                    throw new TclRuntimeError("could not remove " + class_package + " from packageTable");
                }
                if (classTable.remove(class_name) != null) continue;
                throw new TclRuntimeError("could not remove " + class_name + " from classTable");
            }
        }
        if (importClasses.size() != 0) {
            iter = importClasses.listIterator();
            while (iter.hasNext()) {
                String fullyqualified = (String)iter.next();
                int ind = fullyqualified.lastIndexOf(46);
                if (ind == -1) {
                    throw new TclRuntimeError("unexpected : no package in import class");
                }
                class_package = fullyqualified.substring(0, ind);
                String class_name = fullyqualified.substring(ind + 1, fullyqualified.length());
                if (classTable.get(class_name) != null) continue;
                classTable.put(class_name, fullyqualified);
                class_list = (ArrayList)packageTable.get(class_package);
                if (class_list == null) {
                    class_list = new ArrayList<String>();
                    packageTable.put(class_package, class_list);
                }
                class_list.add(class_name);
            }
        }
        interp.resetResult();
    }

    private static void attemptLoadClass(Interp interp, String fullyqualified, String class_name) throws TclException {
        TclClassLoader tclClassLoader = (TclClassLoader)interp.getClassLoader();
        boolean inGlobal = true;
        try {
            tclClassLoader.loadClass(class_name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            inGlobal = false;
        }
        catch (PackageNameException e) {
            throw e;
        }
        if (inGlobal) {
            tclClassLoader.removeCache(class_name);
            throw new TclException(interp, "cannot import \"" + fullyqualified + "\" it conflicts with a class with the same name" + " in the global package");
        }
        Class c = null;
        try {
            c = tclClassLoader.loadClass(fullyqualified);
            if (!PkgInvoker.isAccessible(c)) {
                JavaInvoke.notAccessibleError(interp, c);
            }
            if (JavaInvoke.isInnerClass(c)) {
                throw new TclException(interp, "can't import an inner class");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (PackageNameException packageNameException) {}
        if (c == null) {
            Class inner = null;
            try {
                inner = JavaInvoke.getClassByName(interp, fullyqualified);
            }
            catch (TclException tclException) {}
            if (inner != null && JavaInvoke.isInnerClass(inner)) {
                throw new TclException(interp, "can't import an inner class");
            }
            throw new TclException(interp, "cannot import class \"" + fullyqualified + "\", it does not exist");
        }
    }

    public static String getImport(Interp interp, String name) {
        HashMap classTable = interp.importTable[0];
        String fullyqualified = (String)classTable.get(name);
        if (fullyqualified != null) {
            return fullyqualified;
        }
        HashMap packageTable = interp.importTable[1];
        HashMap wildcardTable = interp.importTable[2];
        ArrayList wildcardList = (ArrayList)wildcardTable.get("*");
        if (wildcardList != null) {
            for (String class_package : wildcardList) {
                fullyqualified = String.valueOf(class_package) + "." + name;
                boolean loaded = false;
                TclClassLoader tclClassLoader = (TclClassLoader)interp.getClassLoader();
                try {
                    tclClassLoader.loadClass(fullyqualified);
                    loaded = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
                catch (PackageNameException packageNameException) {}
                if (!loaded) continue;
                classTable.put(name, fullyqualified);
                ArrayList<String> class_list = (ArrayList<String>)packageTable.get(class_package);
                if (class_list == null) {
                    class_list = new ArrayList<String>();
                    packageTable.put(class_package, class_list);
                }
                if (!class_list.contains(name)) {
                    class_list.add(name);
                }
                return fullyqualified;
            }
        }
        return null;
    }
}

