/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java;

import tcl.lang.Command;
import tcl.lang.Extension;
import tcl.lang.Interp;
import tcl.lang.PackageNameException;
import tcl.lang.TclClassLoader;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

public class JavaLoadCmd
implements Command {
    private static final String[] validOpts = new String[]{"-classpath"};

    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        Class pkgClass;
        TclClassLoader tclClassLoader;
        String packageName;
        TclObject classpath;
        Extension pkg = null;
        boolean validLoad = false;
        if (argv.length != 2 && argv.length != 4) {
            throw new TclNumArgsException(interp, 1, argv, "?-classpath arg? packageName");
        }
        if (argv.length == 4) {
            TclIndex.get(interp, argv[1], validOpts, "switch", 0);
            classpath = argv[2];
            packageName = argv[3].toString();
        } else {
            classpath = null;
            packageName = argv[1].toString();
        }
        String errorMsg = "load \"" + packageName + "\" failed: ";
        if (packageName.endsWith(".class")) {
            packageName = packageName.substring(0, packageName.lastIndexOf(".class"));
        }
        if (classpath == null) {
            tclClassLoader = (TclClassLoader)interp.getClassLoader();
        } else {
            tclClassLoader = (TclClassLoader)interp.getClassLoader();
            tclClassLoader = new TclClassLoader(interp, classpath, tclClassLoader);
        }
        try {
            try {
                validLoad = false;
                pkgClass = tclClassLoader.loadClass(packageName);
                validLoad = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new TclException(interp, "package \"" + packageName + "\" not found");
            }
            catch (ClassFormatError classFormatError) {
                throw new TclException(interp, String.valueOf(errorMsg) + "use the fully qualified package name");
            }
            catch (PackageNameException e) {
                throw new TclException(interp, String.valueOf(errorMsg) + e);
            }
        }
        finally {
            if (!validLoad) {
                tclClassLoader.removeCache(packageName);
            }
        }
        try {
            try {
                validLoad = false;
                pkg = (Extension)pkgClass.newInstance();
                pkg.init(interp);
                validLoad = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TclException(interp, String.valueOf(errorMsg) + "class or initializer is not accessible");
            }
            catch (InstantiationException instantiationException) {
                throw new TclException(interp, String.valueOf(errorMsg) + "object instantiation failure");
            }
            catch (ClassCastException classCastException) {
                throw new TclException(interp, String.valueOf(errorMsg) + "not a subclass of tcl.lang.Extension");
            }
            catch (Exception e) {
                throw new TclException(interp, String.valueOf(errorMsg) + "can't find class \"" + e.getMessage() + "\"");
            }
            catch (LinkageError e) {
                throw new TclException(interp, "Extension \"" + packageName + "\" contains a dependency \"" + e.getMessage() + "\" that could not be resolved.");
            }
        }
        finally {
            if (!validLoad) {
                tclClassLoader.removeCache(packageName);
            }
        }
    }
}

