/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.java;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.pkg.java.ArrayObject;
import tcl.pkg.java.ArraySig;
import tcl.pkg.java.JavaInvoke;
import tcl.pkg.java.ReflectObject;

public class JavaNewCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] argv) throws TclException {
        if (argv.length < 2) {
            throw new TclNumArgsException(interp, 1, argv, "signature ?arg arg ...?");
        }
        if (ArraySig.looksLikeArraySig(interp, argv[1])) {
            if (argv.length < 3 || argv.length > 4) {
                throw new TclNumArgsException(interp, 2, argv, "sizeList ?valueList?");
            }
            ArraySig sig = ArraySig.get(interp, argv[1]);
            Class arrayType = sig.arrayType;
            int dimensions = sig.dimensions;
            TclObject sizeListObj = argv[2];
            int sizeListLen = TclList.getLength(interp, sizeListObj);
            if (sizeListLen > dimensions) {
                throw new TclException(interp, "size list \"" + sizeListObj + "\" doesn't match array dimension (" + dimensions + ")");
            }
            TclObject valueListObj = null;
            if (argv.length == 4) {
                valueListObj = argv[3];
            }
            Object obj = ArrayObject.initArray(interp, sizeListObj, sizeListLen, 0, dimensions, arrayType, valueListObj);
            interp.setResult(ReflectObject.newInstance(interp, arrayType, obj));
        } else {
            int startIdx = 2;
            int count = argv.length - startIdx;
            interp.setResult(JavaInvoke.newInstance(interp, argv[1], argv, startIdx, count));
        }
    }
}

