/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.tjc;

import tcl.lang.ExprValue;
import tcl.lang.Expression;
import tcl.lang.Interp;
import tcl.lang.TclBoolean;
import tcl.lang.TclDouble;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.pkg.tjc.TJC;

public class TJCBench
extends TJC.CompiledCommand {
    static long RESULT_INT = 0L;
    static Object RESULT_OBJ = null;

    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        if (objv.length != 2) {
            throw new TclNumArgsException(interp, 2, objv, "testname");
        }
        String testname = objv[1].toString();
        if (testname.equals("InternalTclObjectPreserve")) {
            this.InternalTclObjectPreserve(interp);
        } else if (testname.equals("InternalTclObjectPreserveRelease")) {
            this.InternalTclObjectPreserveRelease(interp);
        } else if (testname.equals("InternalExprParseIntValue")) {
            this.InternalExprParseIntValue(interp);
        } else if (testname.equals("InternalExprParseDoubleValue")) {
            this.InternalExprParseDoubleValue(interp);
        } else if (testname.equals("InternalExprGetBooleanInt")) {
            this.InternalExprGetBooleanInt(interp);
        } else if (testname.equals("InternalExprGetBooleanDouble")) {
            this.InternalExprGetBooleanDouble(interp);
        } else if (testname.equals("InternalExprGetBooleanString")) {
            this.InternalExprGetBooleanString(interp);
        } else if (testname.equals("InternalIncr")) {
            this.InternalIncr(interp);
        } else if (testname.equals("InternalTclListAppend")) {
            this.InternalTclListAppend(interp);
        } else if (testname.equals("InternalTclListLength")) {
            this.InternalTclListLength(interp);
        } else if (testname.equals("InternalTclListLindex")) {
            this.InternalTclListLindex(interp);
        } else if (testname.equals("InternalTclStringNewInstance")) {
            this.InternalTclStringNewInstance(interp);
        } else if (testname.equals("InternalTclIntegerNewInstance")) {
            this.InternalTclIntegerNewInstance(interp);
        } else if (testname.equals("InternalTclDoubleNewInstance")) {
            this.InternalTclDoubleNewInstance(interp);
        } else if (testname.equals("InternalTclListNewInstance")) {
            this.InternalTclListNewInstance(interp);
        } else if (testname.equals("InternalTclStringDuplicate")) {
            this.InternalTclStringDuplicate(interp);
        } else if (testname.equals("InternalTclIntegerDuplicate")) {
            this.InternalTclIntegerDuplicate(interp);
        } else if (testname.equals("InternalTclDoubleDuplicate")) {
            this.InternalTclDoubleDuplicate(interp);
        } else if (testname.equals("InternalTclListDuplicate")) {
            this.InternalTclListDuplicate(interp);
        } else if (testname.equals("InternalTclIntegerType")) {
            this.InternalTclIntegerType(interp);
        } else if (testname.equals("InternalTclDoubleType")) {
            this.InternalTclDoubleType(interp);
        } else if (testname.equals("InternalTclStringType")) {
            this.InternalTclStringType(interp);
        } else if (testname.equals("InternalTclListType")) {
            this.InternalTclListType(interp);
        } else if (testname.equals("InternalTclIntegerGet")) {
            this.InternalTclIntegerGet(interp);
        } else if (testname.equals("InternalExprGetKnownInt")) {
            this.InternalExprGetKnownInt(interp);
        } else if (testname.equals("InternalExprInlineGetInt")) {
            this.InternalExprInlineGetInt(interp);
        } else if (testname.equals("InternalTclDoubleGet")) {
            this.InternalTclDoubleGet(interp);
        } else if (testname.equals("InternalExprGetKnownDouble")) {
            this.InternalExprGetKnownDouble(interp);
        } else if (testname.equals("InternalExprInlinedIntNotOperator")) {
            this.InternalExprInlinedIntNotOperator(interp);
        } else if (testname.equals("InternalExprInlinedIntNotBitwiseOperator")) {
            this.InternalExprInlinedIntNotBitwiseOperator(interp);
        } else if (testname.equals("InternalExprValueIntNotOperator")) {
            this.InternalExprValueIntNotOperator(interp);
        } else if (testname.equals("InternalExprValueIntNotNstrOperator")) {
            this.InternalExprValueIntNotNstrOperator(interp);
        } else if (testname.equals("InternalSetTclObjectResult")) {
            this.InternalSetTclObjectResult(interp);
        } else if (testname.equals("InternalSetSameTclObjectResult")) {
            this.InternalSetSameTclObjectResult(interp);
        } else if (testname.equals("InternalResetResult")) {
            this.InternalResetResult(interp);
        } else if (testname.equals("InternalSetBooleanResult")) {
            this.InternalSetBooleanResult(interp);
        } else if (testname.equals("InternalSetIntResult")) {
            this.InternalSetIntResult(interp);
        } else if (testname.equals("InternalSetUncommonIntResult")) {
            this.InternalSetUncommonIntResult(interp);
        } else if (testname.equals("InternalSetUncommonDoubleResult")) {
            this.InternalSetUncommonDoubleResult(interp);
        } else if (testname.equals("InternalSetUncommonStringResult")) {
            this.InternalSetUncommonStringResult(interp);
        } else if (testname.equals("InternalSetIntResultViaExprValue")) {
            this.InternalSetIntResultViaExprValue(interp);
        } else if (testname.equals("InternalExprSetIntResult")) {
            this.InternalExprSetIntResult(interp);
        } else if (testname.equals("InternalExprOpIntNot")) {
            this.InternalExprOpIntNot(interp);
        } else if (testname.equals("InternalExprOpIntNotGrabReleaseResult")) {
            this.InternalExprOpIntNotGrabReleaseResult(interp);
        } else if (testname.equals("InternalExprOpIntNotStackValueResult")) {
            this.InternalExprOpIntNotStackValueResult(interp);
        } else if (testname.equals("InternalExprOpIntNotStackValueIntResult")) {
            this.InternalExprOpIntNotStackValueIntResult(interp);
        } else if (testname.equals("InternalExprOpIntNotStackValueBooleanResult")) {
            this.InternalExprOpIntNotStackValueBooleanResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotStackValueResult")) {
            this.InternalExprOpIntInlinedNotStackValueResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotNstrStackValueResult")) {
            this.InternalExprOpIntInlinedNotNstrStackValueResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotNstrStackValueIntResult")) {
            this.InternalExprOpIntInlinedNotNstrStackValueIntResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotNstrStackValueBooleanResult")) {
            this.InternalExprOpIntInlinedNotNstrStackValueBooleanResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotKnownIntResult")) {
            this.InternalExprOpIntInlinedNotKnownIntResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotKnownIntInlineResult")) {
            this.InternalExprOpIntInlinedNotKnownIntInlineResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotKnownIntInlineBooleanResult")) {
            this.InternalExprOpIntInlinedNotKnownIntInlineBooleanResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotNstrAsBoolean")) {
            this.InternalExprOpIntInlinedNotNstrAsBoolean(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotNstrKnownIntAsBoolean")) {
            this.InternalExprOpIntInlinedNotNstrKnownIntAsBoolean(interp);
        } else if (testname.equals("InternalExprOpIntInlinedNotNstrLocalAsBoolean")) {
            this.InternalExprOpIntInlinedNotNstrLocalAsBoolean(interp);
        } else if (testname.equals("InternalExprOpIntPlus")) {
            this.InternalExprOpIntPlus(interp);
        } else if (testname.equals("InternalExprOpIntPlusGrabReleaseResult")) {
            this.InternalExprOpIntPlusGrabReleaseResult(interp);
        } else if (testname.equals("InternalExprOpIntPlusStackValueResult")) {
            this.InternalExprOpIntPlusStackValueResult(interp);
        } else if (testname.equals("InternalExprOpIntPlusStackValueIntResult")) {
            this.InternalExprOpIntPlusStackValueIntResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedPlusStackValueIntResult")) {
            this.InternalExprOpIntInlinedPlusStackValueIntResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedPlusNBStackValueIntResult")) {
            this.InternalExprOpIntInlinedPlusNBStackValueIntResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedPlusIMStackValueIntResult")) {
            this.InternalExprOpIntInlinedPlusIMStackValueIntResult(interp);
        } else if (testname.equals("InternalExprOpIntInlinedPlusIMRStackValueIntResult")) {
            this.InternalExprOpIntInlinedPlusIMRStackValueIntResult(interp);
        } else if (testname.equals("InternalExprOpDoublePlus")) {
            this.InternalExprOpDoublePlus(interp);
        } else if (testname.equals("InternalExprOpLogicalOrResult")) {
            this.InternalExprOpLogicalOrResult(interp);
        } else if (testname.equals("InternalExprOpInlinedLogicalOrResult")) {
            this.InternalExprOpInlinedLogicalOrResult(interp);
        } else if (testname.equals("InternalExprOpInlinedIntLogicalOrResult")) {
            this.InternalExprOpInlinedIntLogicalOrResult(interp);
        } else if (testname.equals("InternalExprOpInlinedNoExprLogicalOrResult")) {
            this.InternalExprOpInlinedNoExprLogicalOrResult(interp);
        } else if (testname.equals("InternalObjvInvoke")) {
            this.InternalObjvInvoke(interp);
        } else if (testname.equals("InternalObjvInvokeOnStack")) {
            this.InternalObjvInvokeOnStack(interp);
        } else if (testname.equals("InternalObjvInvokeOnStackAssigned")) {
            this.InternalObjvInvokeOnStackAssigned(interp);
        } else if (testname.equals("InternalObjvInvokeOnStackAssignedIndex")) {
            this.InternalObjvInvokeOnStackAssignedIndex(interp);
        } else if (testname.equals("InternalObjvInvokeOnStackStack")) {
            this.InternalObjvInvokeOnStackStack(interp);
        } else if (testname.equals("InternalObjvInvokeOnStackTryStack")) {
            this.InternalObjvInvokeOnStackTryStack(interp);
        } else {
            throw new TclException(interp, "unknown test name \"" + testname + "\"");
        }
    }

    void InternalTclObjectPreserve(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance(1L);
        int i = 0;
        while (i < 5000) {
            tobj.preserve();
            ++i;
        }
        RESULT_INT = tobj.getRefCount();
    }

    void InternalTclObjectPreserveRelease(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance(1L);
        tobj.preserve();
        tobj.preserve();
        int i = 0;
        while (i < 5000) {
            tobj.preserve();
            tobj.release();
            ++i;
        }
        RESULT_INT = tobj.getRefCount();
    }

    void InternalExprParseIntValue(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance(1L);
        ExprValue value = new ExprValue(0L, null);
        int i = 0;
        while (i < 5000) {
            Expression.ExprParseObject(interp, tobj, value);
            ++i;
        }
        RESULT_INT = TclInteger.getLong(interp, tobj);
    }

    void InternalExprParseDoubleValue(Interp interp) throws TclException {
        TclObject tobj = TclDouble.newInstance(1.0);
        ExprValue value = new ExprValue(0L, null);
        int i = 0;
        while (i < 5000) {
            Expression.ExprParseObject(interp, tobj, value);
            ++i;
        }
        RESULT_INT = (long)TclDouble.get(interp, tobj);
    }

    void InternalExprGetBooleanInt(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance(1L);
        boolean b = false;
        int i = 0;
        while (i < 5000) {
            b = TJC.getBoolean(interp, tobj);
            ++i;
        }
        RESULT_INT = b ? 1 : 0;
    }

    void InternalExprGetBooleanDouble(Interp interp) throws TclException {
        TclObject tobj = TclDouble.newInstance(1.0);
        boolean b = false;
        int i = 0;
        while (i < 5000) {
            b = TJC.getBoolean(interp, tobj);
            ++i;
        }
        RESULT_INT = b ? 1 : 0;
    }

    void InternalExprGetBooleanString(Interp interp) throws TclException {
        TclObject tobj = TclString.newInstance("true");
        boolean b = false;
        int i = 0;
        while (i < 5000) {
            b = TJC.getBoolean(interp, tobj);
            ++i;
        }
        RESULT_INT = b ? 1 : 0;
    }

    void InternalIncr(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance(0L);
        int i = 0;
        while (i < 5000) {
            TclInteger.incr(interp, tobj, 1L);
            ++i;
        }
        RESULT_INT = TclInteger.getLong(interp, tobj);
    }

    void InternalTclListLength(Interp interp) throws TclException {
        TclObject tlist = TclList.newInstance();
        TclObject tobj = interp.checkCommonString(null);
        TclList.append(interp, tlist, tobj);
        TclList.append(interp, tlist, tobj);
        TclList.append(interp, tlist, tobj);
        int size = 0;
        int i = 0;
        while (i < 5000) {
            size += TclList.getLength(interp, tlist);
            ++i;
        }
        RESULT_INT = size;
    }

    void InternalTclListLindex(Interp interp) throws TclException {
        TclObject tlist = TclList.newInstance();
        TclObject tobj = interp.checkCommonString(null);
        TclList.append(interp, tlist, tobj);
        TclList.append(interp, tlist, tobj);
        TclList.append(interp, tlist, tobj);
        TclList.append(interp, tlist, tobj);
        TclList.append(interp, tlist, tobj);
        TclList.append(interp, tlist, tobj);
        TclList.append(interp, tlist, tobj);
        TclList.append(interp, tlist, tobj);
        TclList.append(interp, tlist, tobj);
        TclList.append(interp, tlist, tobj);
        int i = 0;
        while (i < 5000) {
            tobj = TclList.index(interp, tlist, 6);
            ++i;
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclListAppend(Interp interp) throws TclException {
        TclObject tlist = TclList.newInstance();
        TclObject tobj = interp.checkCommonString(null);
        int i = 0;
        while (i < 5000) {
            TclList.append(interp, tlist, tobj);
            ++i;
        }
        RESULT_OBJ = tlist;
    }

    void InternalTclStringNewInstance(Interp interp) throws TclException {
        TclObject tobj = null;
        int i = 0;
        while (i < 5000) {
            tobj = TclString.newInstance("foo");
            ++i;
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclIntegerNewInstance(Interp interp) throws TclException {
        TclObject tobj = null;
        int i = 0;
        while (i < 5000) {
            tobj = TclInteger.newInstance(1L);
            ++i;
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclDoubleNewInstance(Interp interp) throws TclException {
        TclObject tobj = null;
        int i = 0;
        while (i < 5000) {
            tobj = TclDouble.newInstance(1.0);
            ++i;
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclListNewInstance(Interp interp) throws TclException {
        TclObject tobj = null;
        int i = 0;
        while (i < 5000) {
            tobj = TclList.newInstance();
            ++i;
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclStringDuplicate(Interp interp) throws TclException {
        TclObject tobj = TclString.newInstance("foo");
        int i = 0;
        while (i < 5000) {
            tobj = tobj.duplicate();
            ++i;
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclIntegerDuplicate(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance(1L);
        int i = 0;
        while (i < 5000) {
            tobj = tobj.duplicate();
            ++i;
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclDoubleDuplicate(Interp interp) throws TclException {
        TclObject tobj = TclDouble.newInstance(1.0);
        int i = 0;
        while (i < 5000) {
            tobj = tobj.duplicate();
            ++i;
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclListDuplicate(Interp interp) throws TclException {
        TclObject tobj = TclList.newInstance();
        int i = 0;
        while (i < 5000) {
            tobj = tobj.duplicate();
            ++i;
        }
        RESULT_OBJ = tobj;
    }

    void InternalTclIntegerType(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance(1L);
        boolean b = false;
        int i = 0;
        while (i < 5000) {
            b = tobj.isIntType();
            ++i;
        }
        RESULT_INT = b ? 1 : 0;
    }

    void InternalTclDoubleType(Interp interp) throws TclException {
        TclObject tobj = TclDouble.newInstance(1.0);
        boolean b = false;
        int i = 0;
        while (i < 5000) {
            b = tobj.isDoubleType();
            ++i;
        }
        RESULT_INT = b ? 1 : 0;
    }

    void InternalTclStringType(Interp interp) throws TclException {
        TclObject tobj = TclString.newInstance("foo");
        boolean b = false;
        int i = 0;
        while (i < 5000) {
            b = tobj.isStringType();
            ++i;
        }
        RESULT_INT = b ? 1 : 0;
    }

    void InternalTclListType(Interp interp) throws TclException {
        TclObject tobj = TclList.newInstance();
        boolean b = false;
        int i = 0;
        while (i < 5000) {
            b = tobj.isListType();
            ++i;
        }
        RESULT_INT = b ? 1 : 0;
    }

    void InternalTclIntegerGet(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance(1L);
        long ivalue = 0L;
        int i = 0;
        while (i < 5000) {
            ivalue = TclInteger.getLong(interp, tobj);
            ++i;
        }
        RESULT_INT = ivalue;
    }

    void InternalExprGetKnownInt(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance(1L);
        long ivalue = 0L;
        int i = 0;
        while (i < 5000) {
            ivalue = TJC.exprGetKnownInt(tobj);
            ++i;
        }
        RESULT_INT = ivalue;
    }

    void InternalExprInlineGetInt(Interp interp) throws TclException {
        TclObject tobj = TclInteger.newInstance(1L);
        long ivalue = 0L;
        int i = 0;
        while (i < 5000) {
            ivalue = tobj.ivalue;
            ++i;
        }
        RESULT_INT = ivalue;
    }

    void InternalTclDoubleGet(Interp interp) throws TclException {
        TclObject tobj = TclDouble.newInstance(1.0);
        double d = 0.0;
        int i = 0;
        while (i < 5000) {
            d = TclDouble.get(interp, tobj);
            ++i;
        }
        RESULT_INT = (long)d;
    }

    void InternalExprGetKnownDouble(Interp interp) throws TclException {
        TclObject tobj = TclDouble.newInstance(1.0);
        double d = 0.0;
        int i = 0;
        while (i < 5000) {
            d = TJC.exprGetKnownDouble(tobj);
            ++i;
        }
        RESULT_INT = (long)d;
    }

    void InternalExprInlinedIntNotOperator(Interp interp) throws TclException {
        int v = 1;
        int i = 0;
        while (i < 5000) {
            v = v == 0 ? 1 : 0;
            ++i;
        }
        RESULT_INT = v;
    }

    void InternalExprInlinedIntNotBitwiseOperator(Interp interp) throws TclException {
        int v = 1;
        int i = 0;
        while (i < 5000) {
            v = (v | -v) >>> 31 ^ 1;
            ++i;
        }
        RESULT_INT = v;
    }

    void InternalExprValueIntNotOperator(Interp interp) throws TclException {
        ExprValue ev = new ExprValue(1L, null);
        int i = 0;
        while (i < 5000) {
            ev.optIntUnaryNot();
            ++i;
        }
        RESULT_INT = ev.getIntValue();
    }

    void InternalExprValueIntNotNstrOperator(Interp interp) throws TclException {
        ExprValue ev = new ExprValue(1L, null);
        int i = 0;
        while (i < 5000) {
            ev.optIntUnaryNotNstr();
            ++i;
        }
        RESULT_INT = ev.getIntValue();
    }

    void InternalSetTclObjectResult(Interp interp) throws TclException {
        TclObject tobj1 = TclInteger.newInstance(1L);
        TclObject tobj2 = TclInteger.newInstance(2L);
        tobj1.preserve();
        tobj1.preserve();
        tobj2.preserve();
        tobj2.preserve();
        int i = 0;
        while (i < 5000) {
            interp.setResult(tobj1);
            interp.setResult(tobj2);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalSetSameTclObjectResult(Interp interp) throws TclException {
        TclObject tobj1 = TclInteger.newInstance(1L);
        tobj1.preserve();
        tobj1.preserve();
        int i = 0;
        while (i < 5000) {
            interp.setResult(tobj1);
            interp.setResult(tobj1);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalResetResult(Interp interp) throws TclException {
        int i = 0;
        while (i < 5000) {
            interp.resetResult();
            interp.resetResult();
            ++i;
        }
        RESULT_OBJ = interp.getResult();
    }

    void InternalSetBooleanResult(Interp interp) throws TclException {
        boolean b1 = true;
        boolean b2 = false;
        if (RESULT_INT == 0L) {
            b1 = false;
            b2 = true;
        }
        int i = 0;
        while (i < 5000) {
            interp.setResult(b1);
            interp.setResult(b2);
            ++i;
        }
        RESULT_INT = TclBoolean.get(interp, interp.getResult()) ? 1 : 0;
    }

    void InternalSetIntResult(Interp interp) throws TclException {
        long i1 = 1L;
        long i2 = 0L;
        if (RESULT_INT == 0L) {
            i1 = 0L;
            i2 = 1L;
        }
        int i = 0;
        while (i < 5000) {
            interp.setResult(i1);
            interp.setResult(i2);
            ++i;
        }
        RESULT_INT = TclInteger.getLong(interp, interp.getResult());
    }

    void InternalSetUncommonIntResult(Interp interp) throws TclException {
        long i = 0L;
        while (i < 5000L) {
            interp.setResult(i * 2L);
            interp.setResult(i * 3L);
            ++i;
        }
        RESULT_INT = TclInteger.getLong(interp, interp.getResult());
    }

    void InternalSetUncommonDoubleResult(Interp interp) throws TclException {
        int i = 0;
        while (i < 5000) {
            interp.setResult((double)i * 2.0);
            interp.setResult((double)i * 3.0);
            ++i;
        }
        RESULT_INT = (long)TclDouble.get(interp, interp.getResult());
    }

    void InternalSetUncommonStringResult(Interp interp) throws TclException {
        int i = 0;
        while (i < 5000) {
            interp.setResult("2" + i);
            interp.setResult("3" + i);
            ++i;
        }
        RESULT_OBJ = interp.getResult();
    }

    void InternalSetIntResultViaExprValue(Interp interp) throws TclException {
        long i1 = 1L;
        long i2 = 0L;
        if (RESULT_INT == 0L) {
            i1 = 0L;
            i2 = 1L;
        }
        ExprValue value1 = TJC.exprGetValue(interp, i1, null);
        ExprValue value2 = TJC.exprGetValue(interp, i2, null);
        int i = 0;
        while (i < 5000) {
            interp.setResult(value1.getIntValue());
            interp.setResult(value2.getIntValue());
            ++i;
        }
        RESULT_INT = TclInteger.getLong(interp, interp.getResult());
    }

    void InternalExprSetIntResult(Interp interp) throws TclException {
        long i1 = 1L;
        long i2 = 0L;
        if (RESULT_INT == 0L) {
            i1 = 0L;
            i2 = 1L;
        }
        ExprValue value1 = TJC.exprGetValue(interp, i1, null);
        ExprValue value2 = TJC.exprGetValue(interp, i2, null);
        int i = 0;
        while (i < 5000) {
            TJC.exprSetResult(interp, value1);
            TJC.exprSetResult(interp, value2);
            ++i;
        }
        RESULT_INT = TclInteger.getLong(interp, interp.getResult());
    }

    void InternalExprOpIntNot(Interp interp) throws TclException {
        ExprValue value = new ExprValue(1L, null);
        int i = 0;
        while (i < 5000) {
            Expression.evalUnaryOperator(interp, 32, value);
            ++i;
        }
        RESULT_INT = value.getIntValue();
    }

    void InternalExprOpIntNotGrabReleaseResult(Interp interp) throws TclException {
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = TJC.exprGetValue(interp, 1L, null);
            TJC.exprUnaryOperator(interp, 32, tmp0);
            TJC.exprSetResult(interp, tmp0);
            TJC.exprReleaseValue(interp, tmp0);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntNotStackValueResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1L);
            TJC.exprUnaryOperator(interp, 32, tmp0);
            TJC.exprSetResult(interp, tmp0);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntNotStackValueIntResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1L);
            TJC.exprUnaryOperator(interp, 32, tmp0);
            interp.setResult(tmp0.getIntValue());
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntNotStackValueBooleanResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1L);
            TJC.exprUnaryOperator(interp, 32, tmp0);
            interp.setResult(tmp0.getIntValue() != 0L);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotStackValueResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1L);
            if (!tmp0.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            tmp0.optIntUnaryNot();
            TJC.exprSetResult(interp, tmp0);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotNstrStackValueResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1L);
            if (!tmp0.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            tmp0.optIntUnaryNotNstr();
            TJC.exprSetResult(interp, tmp0);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotNstrStackValueIntResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1L);
            if (!tmp0.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            tmp0.optIntUnaryNotNstr();
            interp.setResult(tmp0.getIntValue());
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotNstrStackValueBooleanResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(0L);
            if (!tmp0.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            tmp0.optIntUnaryNotNstr();
            interp.setResult(tmp0.getIntValue() != 0L);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotKnownIntResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        TclObject tobj = TclInteger.newInstance(1L);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            if (!tobj.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            TJC.exprUnaryNotOperatorKnownInt(tmp0, tobj);
            interp.setResult(tmp0.getIntValue() != 0L);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotKnownIntInlineResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        TclObject tobj = TclInteger.newInstance(1L);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            if (!tobj.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            tmp0.setIntValue(TJC.exprGetKnownInt(tobj) == 0L ? 1 : 0);
            interp.setResult(tmp0.getIntValue() != 0L);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotKnownIntInlineBooleanResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        TclObject tobj = TclInteger.newInstance(1L);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            if (!tobj.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            tmp0.setIntValue(TJC.exprGetKnownInt(tobj) == 0L);
            interp.setResult(tmp0.getIntValue() != 0L);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedNotNstrAsBoolean(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1L);
            tmp0.optIntUnaryNotNstr();
            boolean tmp1 = tmp0.getBooleanValue(interp);
            RESULT_INT = tmp1 ? 1L : 0L;
            ++i;
        }
    }

    void InternalExprOpIntInlinedNotNstrKnownIntAsBoolean(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1L);
            tmp0.optIntUnaryNotNstr();
            boolean tmp1 = tmp0.getIntValue() != 0L;
            RESULT_INT = tmp1 ? 1L : 0L;
            ++i;
        }
    }

    void InternalExprOpIntInlinedNotNstrLocalAsBoolean(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp1 = evs0;
            tmp1.setIntValue(1L);
            boolean result0 = tmp1.getIntValue() != 0L;
            RESULT_INT = result0 ? 1L : 0L;
            ++i;
        }
    }

    void InternalExprOpIntPlus(Interp interp) throws TclException {
        ExprValue value1 = new ExprValue(1L, null);
        ExprValue value2 = new ExprValue(2L, null);
        int i = 0;
        while (i < 5000) {
            Expression.evalBinaryOperator(interp, 11, value1, value2);
            ++i;
        }
        RESULT_INT = value1.getIntValue();
    }

    void InternalExprOpIntPlusGrabReleaseResult(Interp interp) throws TclException {
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = TJC.exprGetValue(interp, 1L, null);
            ExprValue tmp1 = TJC.exprGetValue(interp, 2L, null);
            TJC.exprBinaryOperator(interp, 11, tmp0, tmp1);
            TJC.exprReleaseValue(interp, tmp1);
            TJC.exprSetResult(interp, tmp0);
            TJC.exprReleaseValue(interp, tmp0);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntPlusStackValueResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        ExprValue evs1 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1L);
            ExprValue tmp1 = evs1;
            tmp1.setIntValue(2L);
            TJC.exprBinaryOperator(interp, 11, tmp0, tmp1);
            TJC.exprSetResult(interp, tmp0);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntPlusStackValueIntResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        ExprValue evs1 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1L);
            ExprValue tmp1 = evs1;
            tmp1.setIntValue(2L);
            TJC.exprBinaryOperator(interp, 11, tmp0, tmp1);
            interp.setResult(tmp0.getIntValue());
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedPlusStackValueIntResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        ExprValue evs1 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1L);
            ExprValue tmp1 = evs1;
            tmp1.setIntValue(2L);
            if (!tmp0.isIntType() || !tmp1.isIntType()) {
                throw new TclRuntimeError("else branch reached");
            }
            tmp0.optIntPlus(tmp1);
            interp.setResult(tmp0.getIntValue());
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedPlusNBStackValueIntResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        ExprValue evs1 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(1L);
            ExprValue tmp1 = evs1;
            tmp1.setIntValue(2L);
            tmp0.optIntPlus(tmp1);
            interp.setResult(tmp0.getIntValue());
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedPlusIMStackValueIntResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(3L);
            interp.setResult(tmp0.getIntValue());
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpIntInlinedPlusIMRStackValueIntResult(Interp interp) throws TclException {
        int i = 0;
        while (i < 5000) {
            int tmp0 = 3;
            interp.setResult(tmp0);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpDoublePlus(Interp interp) throws TclException {
        ExprValue value1 = new ExprValue(1.0, null);
        ExprValue value2 = new ExprValue(2.0, null);
        int i = 0;
        while (i < 5000) {
            Expression.evalBinaryOperator(interp, 11, value1, value2);
            ++i;
        }
        RESULT_INT = (int)value1.getDoubleValue();
    }

    void InternalExprOpLogicalOrResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        ExprValue evs1 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp0 = evs0;
            tmp0.setIntValue(0L);
            if (!tmp0.getBooleanValue(interp)) {
                ExprValue tmp1 = evs1;
                tmp1.setIntValue(1L);
                tmp0.setIntValue(tmp1.getBooleanValue(interp));
            } else {
                tmp0.setIntValue(1L);
            }
            TJC.exprSetResult(interp, tmp0);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpInlinedLogicalOrResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            ExprValue tmp1 = evs0;
            tmp1.setIntValue(0L);
            boolean tmp0 = tmp1.getBooleanValue(interp);
            if (!tmp0) {
                ExprValue tmp2 = evs0;
                tmp2.setIntValue(1L);
                tmp0 = tmp2.getBooleanValue(interp);
            }
            interp.setResult(tmp0);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpInlinedIntLogicalOrResult(Interp interp) throws TclException {
        ExprValue evs0 = TJC.exprGetValue(interp);
        int i = 0;
        while (i < 5000) {
            boolean tmp0;
            ExprValue tmp1 = evs0;
            tmp1.setIntValue(0L);
            boolean bl = tmp0 = tmp1.getIntValue() != 0L;
            if (!tmp0) {
                ExprValue tmp2 = evs0;
                tmp2.setIntValue(1L);
                tmp0 = tmp2.getIntValue() != 0L;
            }
            interp.setResult(tmp0);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalExprOpInlinedNoExprLogicalOrResult(Interp interp) throws TclException {
        int i = 0;
        while (i < 5000) {
            boolean tmp0;
            boolean value = false;
            boolean bl = tmp0 = value;
            if (!tmp0) {
                value = true;
                tmp0 = value;
            }
            interp.setResult(tmp0);
            ++i;
        }
        RESULT_INT = TclInteger.getInt(interp, interp.getResult());
    }

    void InternalObjvInvoke(Interp interp) throws TclException {
        TclObject const0 = TclString.newInstance("cmd");
        TclObject var1 = TclString.newInstance("value1");
        var1.preserve();
        TclObject const1 = TclString.newInstance("const1");
        TclObject var2 = TclString.newInstance("value2");
        var2.preserve();
        int i = 0;
        while (i < 5000) {
            TclObject tmp1;
            TclObject[] objv0 = TJC.grabObjv(interp, 4);
            try {
                objv0[0] = const0;
                tmp1 = var1;
                tmp1.preserve();
                objv0[1] = tmp1;
                objv0[2] = const1;
                tmp1 = var2;
                tmp1.preserve();
                objv0[3] = tmp1;
                RESULT_OBJ = objv0;
            }
            finally {
                tmp1 = objv0[1];
                if (tmp1 != null) {
                    tmp1.release();
                }
                if ((tmp1 = objv0[3]) != null) {
                    tmp1.release();
                }
                TJC.releaseObjv(interp, objv0, 4);
            }
            ++i;
        }
    }

    void InternalObjvInvokeOnStack(Interp interp) throws TclException {
        TclObject[] objvOnStack = TJC.grabObjv(interp, 4);
        TclObject const0 = TclString.newInstance("cmd");
        TclObject var1 = TclString.newInstance("value1");
        var1.preserve();
        TclObject const1 = TclString.newInstance("const1");
        TclObject var2 = TclString.newInstance("value2");
        var2.preserve();
        int i = 0;
        while (i < 5000) {
            TclObject tmp1;
            TclObject[] objv0 = objvOnStack;
            try {
                objv0[0] = const0;
                tmp1 = var1;
                tmp1.preserve();
                objv0[1] = tmp1;
                objv0[2] = const1;
                tmp1 = var2;
                tmp1.preserve();
                objv0[3] = tmp1;
                RESULT_OBJ = objv0;
            }
            finally {
                objv0[0] = null;
                tmp1 = objv0[1];
                if (tmp1 != null) {
                    tmp1.release();
                }
                objv0[1] = null;
                objv0[2] = null;
                tmp1 = objv0[3];
                if (tmp1 != null) {
                    tmp1.release();
                }
                objv0[3] = null;
            }
            ++i;
        }
        TJC.releaseObjv(interp, objvOnStack, 4);
    }

    void InternalObjvInvokeOnStackAssigned(Interp interp) throws TclException {
        TclObject[] objvOnStack = TJC.grabObjv(interp, 4);
        TclObject const0 = TclString.newInstance("cmd");
        TclObject var1 = TclString.newInstance("value1");
        var1.preserve();
        TclObject const1 = TclString.newInstance("const1");
        TclObject var2 = TclString.newInstance("value2");
        var2.preserve();
        TclObject ASSIGNED = TclString.newInstance("");
        int i = 0;
        while (i < 5000) {
            TclObject[] objv0 = objvOnStack;
            TclObject tmp1 = null;
            try {
                objv0[0] = const0;
                tmp1 = var1;
                tmp1.preserve();
                objv0[1] = tmp1;
                objv0[2] = const1;
                tmp1 = var2;
                tmp1.preserve();
                objv0[3] = tmp1;
                tmp1 = ASSIGNED;
                RESULT_OBJ = objv0;
            }
            finally {
                objv0[0] = null;
                objv0[2] = null;
                if (tmp1 != ASSIGNED) {
                    tmp1 = objv0[1];
                    if (tmp1 != null) {
                        tmp1.release();
                    }
                    objv0[1] = null;
                    tmp1 = objv0[3];
                    if (tmp1 != null) {
                        tmp1.release();
                    }
                    objv0[3] = null;
                } else {
                    objv0[1].release();
                    objv0[1] = null;
                    objv0[3].release();
                    objv0[3] = null;
                }
            }
            ++i;
        }
        TJC.releaseObjv(interp, objvOnStack, 4);
    }

    /*
     * Unable to fully structure code
     */
    void InternalObjvInvokeOnStackAssignedIndex(Interp interp) throws TclException {
        objvOnStack = TJC.grabObjv(interp, 4);
        const0 = TclString.newInstance("cmd");
        var1 = TclString.newInstance("value1");
        var1.preserve();
        const1 = TclString.newInstance("const1");
        var2 = TclString.newInstance("value2");
        var2.preserve();
        i = 0;
        while (i < 5000) {
            block7: {
                block6: {
                    objv0 = objvOnStack;
                    assignedIndex = -1;
                    try {
                        objv0[0] = const0;
                        assignedIndex = 0;
                        tmp1 = var1;
                        tmp1.preserve();
                        objv0[1] = tmp1;
                        assignedIndex = 1;
                        objv0[2] = const1;
                        assignedIndex = 2;
                        tmp1 = var2;
                        tmp1.preserve();
                        objv0[3] = tmp1;
                        assignedIndex = 3;
                        TJCBench.RESULT_OBJ = objv0;
                    }
                    finally {
                        if (assignedIndex >= 3) break block6;
                        objv0[0] = null;
                        objv0[2] = null;
                        j = 0;
                        ** while (j <= assignedIndex)
                    }
lbl-1000:
                    // 1 sources

                    {
                        tmp1 = objv0[j];
                        if (tmp1 != null) {
                            tmp1.release();
                        }
                        ++j;
                        continue;
lbl38:
                        // 1 sources

                        break block7;
                    }
                }
                objv0[1].release();
                objv0[3].release();
            }
            ++i;
        }
        TJC.releaseObjv(interp, objvOnStack, 4);
    }

    void InternalObjvInvokeOnStackStack(Interp interp) throws TclException {
        TclObject[] objv0 = TJC.grabObjv(interp, 4);
        TclObject const0 = TclString.newInstance("cmd");
        TclObject var1 = TclString.newInstance("value1");
        var1.preserve();
        TclObject const1 = TclString.newInstance("const1");
        TclObject var2 = TclString.newInstance("value2");
        var2.preserve();
        int i = 0;
        while (i < 5000) {
            TclObject tmp1 = null;
            TclObject tmp2 = null;
            try {
                objv0[0] = const0;
                tmp1 = var1;
                tmp1.preserve();
                objv0[1] = tmp1;
                objv0[2] = const1;
                tmp2 = var2;
                tmp2.preserve();
                objv0[3] = tmp2;
                RESULT_OBJ = objv0;
            }
            finally {
                if (tmp1 != null) {
                    tmp1.release();
                }
                if (tmp2 != null) {
                    tmp2.release();
                }
            }
            ++i;
        }
        TJC.releaseObjv(interp, objv0, 4);
    }

    void InternalObjvInvokeOnStackTryStack(Interp interp) throws TclException {
        TclObject[] objv0 = TJC.grabObjv(interp, 4);
        TclObject const0 = TclString.newInstance("cmd");
        TclObject var1 = TclString.newInstance("value1");
        var1.preserve();
        TclObject const1 = TclString.newInstance("const1");
        TclObject var2 = TclString.newInstance("value2");
        var2.preserve();
        int i = 0;
        while (i < 5000) {
            TclObject tmp1 = null;
            TclObject tmp2 = null;
            try {
                objv0[0] = const0;
                tmp1 = var1;
                tmp1.preserve();
                objv0[1] = tmp1;
                objv0[2] = const1;
                tmp2 = var2;
                tmp2.preserve();
                objv0[3] = tmp2;
            }
            finally {
                if (tmp2 == null && tmp1 != null) {
                    tmp1.release();
                }
            }
            try {
                RESULT_OBJ = objv0;
            }
            finally {
                tmp1.release();
                tmp2.release();
            }
            ++i;
        }
        TJC.releaseObjv(interp, objv0, 4);
    }
}

