/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.tjc;

import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.PackageNameException;
import tcl.lang.Procedure;
import tcl.lang.TclClassLoader;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.cmd.NamespaceCmd;
import tcl.pkg.tjc.TJCCompileJavaCmd;
import tcl.pkg.tjc.TJCCompileTclCmd;
import tcl.pkg.tjc.TJCThread;

public class TJCCompileCmd
implements Command {
    @Override
    public void cmdProc(Interp interp, TclObject[] objv) throws TclException {
        int next;
        if (objv.length < 2 || objv.length == 3 || objv.length > 5) {
            throw new TclNumArgsException(interp, 1, objv, "?cmd? ?options?");
        }
        String javaInfo = null;
        String cmd = null;
        String readycmd = null;
        String readyvar = null;
        cmd = objv[1].toString();
        if (cmd.equals("-java")) {
            if (objv.length != 5) {
                throw new TclNumArgsException(interp, 1, objv, "?cmd? ?options?");
            }
            TclObject obj = objv[2];
            if (TclList.getLength(interp, obj) != 2) {
                throw new TclException(interp, "-java JINFO argument must be a 2 element list of {JCLASSNAME JSRCCODE}");
            }
            javaInfo = objv[2].toString();
            cmd = null;
            next = 3;
        } else {
            next = 2;
        }
        if (next != objv.length) {
            if (next + 2 != objv.length) {
                throw new TclNumArgsException(interp, 1, objv, "?cmd? ?options?");
            }
            String option = objv[next].toString();
            String value = objv[next + 1].toString();
            if (option.equals("-readycmd")) {
                readycmd = value;
            } else if (option.equals("-readyvar")) {
                readyvar = value;
            } else {
                throw new TclNumArgsException(interp, 1, objv, "?cmd? ?options?");
            }
        }
        if (javaInfo != null && cmd != null) {
            throw new TclRuntimeError("can set both cmd and -java");
        }
        if (readycmd != null && readyvar != null) {
            throw new TclRuntimeError("can set both -readyvar and -readycmd");
        }
        if (javaInfo != null) {
            TJCCompileCmd.JavaCompile(interp, javaInfo, readycmd, readyvar);
        } else {
            TJCCompileCmd.TclCompile(interp, cmd, readycmd, readyvar);
        }
    }

    static void JavaCompile(Interp interp, String javaInfo, String readyCmd, String readyVar) throws TclException {
        TJCThread.startThread();
        TJCCompileJavaCmd cjobj = new TJCCompileJavaCmd(interp, javaInfo, readyCmd, readyVar);
        String javaFileName = cjobj.getJavaFileName();
        String javaSrc = cjobj.getJavaSource();
        cjobj.getClass();
        TJCThread.compileJavaSource(javaFileName, javaSrc, cjobj);
    }

    static void TclCompile(Interp interp, String cmd, String readyCmd, String readyVar) throws TclException {
        String fullyQualifiedCmd;
        TJCThread.startThread();
        Procedure proc = Procedure.findProc(interp, cmd);
        if (proc == null) {
            throw new TclException(interp, "\"" + cmd + "\" isn't a procedure");
        }
        StringBuffer pname = new StringBuffer(64);
        StringBuffer cname = new StringBuffer(64);
        if (cmd.startsWith("::")) {
            pname.append(cmd);
        } else {
            String nsName = proc.wcmd.ns.fullName;
            if (nsName.equals("::")) {
                pname.append(nsName);
            } else {
                pname.append(nsName);
                pname.append("::");
            }
            pname.append(NamespaceCmd.tail(cmd));
        }
        String upper = fullyQualifiedCmd = pname.toString();
        boolean cap = true;
        int len = upper.length();
        int i = 0;
        while (i < len) {
            char c = upper.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                if (cap) {
                    c = Character.toUpperCase(c);
                    cap = false;
                }
                cname.append(c);
            } else {
                cap = true;
            }
            ++i;
        }
        cname.append("Cmd");
        String javaClassName = cname.toString();
        if (TJCCompileCmd.isClassDefined(interp, javaClassName)) {
            String prefix = cname.toString();
            String suffix = null;
            i = 2;
            while (i < Integer.MAX_VALUE) {
                suffix = String.valueOf(i);
                if (!TJCCompileCmd.isClassDefined(interp, String.valueOf(prefix) + suffix)) break;
                ++i;
            }
            if (i == Integer.MAX_VALUE) {
                throw new TclRuntimeError("suffix integer overflow");
            }
            cname.append(suffix);
            javaClassName = cname.toString();
        }
        TclObject procList = TclList.newInstance();
        TclList.append(interp, procList, TclString.newInstance("proc"));
        TclList.append(interp, procList, TclString.newInstance(cmd));
        TclObject args = TclList.newInstance();
        len = proc.argList.length;
        i = 0;
        while (i < len) {
            TclObject name = proc.argList[i][0];
            TclObject defval = proc.argList[i][1];
            if (defval == null) {
                TclList.append(interp, args, TclString.newInstance(name.toString()));
            } else {
                TclObject defpair = TclList.newInstance();
                TclList.append(interp, defpair, TclString.newInstance(name.toString()));
                TclList.append(interp, defpair, TclString.newInstance(defval.toString()));
                TclList.append(interp, args, defpair);
            }
            ++i;
        }
        if (proc.isVarArgs) {
            TclList.append(interp, args, TclString.newInstance("args"));
        }
        TclList.append(interp, procList, TclString.newInstance(args));
        TclList.append(interp, procList, TclString.newInstance(proc.body.toString()));
        TJCCompileTclCmd ctobj = new TJCCompileTclCmd(interp, fullyQualifiedCmd, readyCmd, readyVar);
        ctobj.getClass();
        TJCThread.compileTclSource(javaClassName, procList.toString(), ctobj);
    }

    static boolean isClassDefined(Interp interp, String javaClassName) {
        TclClassLoader tclClassLoader = (TclClassLoader)interp.getClassLoader();
        Class alreadyLoaded = null;
        try {
            alreadyLoaded = tclClassLoader.loadClass(javaClassName);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (PackageNameException e) {
            throw new TclRuntimeError("unexpected PackageNameException :" + e.getMessage());
        }
        boolean isDefined = alreadyLoaded != null;
        return isDefined;
    }
}

