/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.tjc;

import java.util.ArrayList;
import tcl.lang.Interp;
import tcl.lang.TclClassLoader;
import tcl.lang.TclEvent;
import tcl.lang.TclException;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.pkg.tjc.TJCThread;

class TJCCompileJavaCmd
extends TclEvent
implements TJCThread.CompiledClassReady {
    final boolean debug = false;
    final Interp interp;
    final TclObject javaInfo;
    final String readyCmd;
    final String readyVar;
    boolean status;
    String errorMsg = "";
    ArrayList cnames;
    ArrayList cdata;

    TJCCompileJavaCmd(Interp interp, String javaInfo, String readyCmd, String readyVar) {
        this.interp = interp;
        this.javaInfo = TclString.newInstance(javaInfo);
        this.readyCmd = readyCmd;
        this.readyVar = readyVar;
    }

    @Override
    public void compiled(String geninfo, String jfilename, String jsrcode, ArrayList cnames, ArrayList cdata, int status, String msg) {
        if (status == 0) {
            this.status = true;
        } else {
            this.status = false;
            this.errorMsg = msg;
        }
        if (cdata != null) {
            this.cnames = cnames;
            this.cdata = cdata;
        }
        this.interp.getNotifier().queueEvent(this, 0);
    }

    @Override
    public int processEvent(int flags) {
        if (!this.status) {
            this.readyReport();
            return 1;
        }
        TclClassLoader tclClassLoader = (TclClassLoader)this.interp.getClassLoader();
        ArrayList<String> resolved_cnames = new ArrayList<String>();
        int i = 0;
        while (i < this.cdata.size()) {
            byte[] classBytes;
            Class cl;
            String cname = null;
            if (this.cnames != null && (cname = (String)this.cnames.get(i)).length() == 0) {
                cname = null;
            }
            if ((cl = tclClassLoader.defineClass(cname, classBytes = (byte[])this.cdata.get(i))) == null) {
                this.status = false;
                this.errorMsg = cname != null ? "class \"" + cname + "\" not loaded by TclClassLoader" : "class not loaded by TclClassLoader";
                this.readyReport();
                return 1;
            }
            if (cname == null) {
                cname = cl.getName();
            }
            resolved_cnames.add(cname);
            ++i;
        }
        this.cnames = resolved_cnames;
        this.readyReport();
        return 1;
    }

    void readyReport() {
        try {
            if (this.readyVar != null) {
                TclObject tlist = TclList.newInstance();
                if (this.status) {
                    TclList.append(this.interp, tlist, TclString.newInstance("OK"));
                } else {
                    TclList.append(this.interp, tlist, TclString.newInstance("FAIL"));
                }
                TclObject cnames_list = TclList.newInstance();
                if (this.cnames != null) {
                    int i = 0;
                    while (i < this.cnames.size()) {
                        String cname = (String)this.cnames.get(i);
                        TclList.append(this.interp, cnames_list, TclString.newInstance(cname));
                        ++i;
                    }
                }
                TclList.append(this.interp, tlist, cnames_list);
                TclList.append(this.interp, tlist, TclString.newInstance(this.errorMsg));
                this.interp.setVar(this.readyVar, null, tlist, 1);
            } else if (this.readyCmd != null) {
                TclObject tlist = TclList.newInstance();
                TclList.append(this.interp, tlist, TclString.newInstance(this.readyCmd));
                if (this.status) {
                    TclList.append(this.interp, tlist, TclString.newInstance("OK"));
                } else {
                    TclList.append(this.interp, tlist, TclString.newInstance("FAIL"));
                }
                TclObject cnames_list = TclList.newInstance();
                if (this.cnames != null) {
                    int i = 0;
                    while (i < this.cnames.size()) {
                        String cname = (String)this.cnames.get(i);
                        TclList.append(this.interp, cnames_list, TclString.newInstance(cname));
                        ++i;
                    }
                }
                TclList.append(this.interp, tlist, cnames_list);
                TclList.append(this.interp, tlist, TclString.newInstance(this.errorMsg));
                this.interp.eval(tlist, 131072);
            }
        }
        catch (TclException te) {
            te.printStackTrace(System.err);
        }
    }

    String getJavaFileName() throws TclException {
        TclObject obj = TclList.index(this.interp, this.javaInfo, 0);
        String clName = obj.toString();
        StringBuffer nbuff = new StringBuffer(64);
        if (clName.indexOf(46) == -1) {
            nbuff.append(clName);
        } else {
            nbuff.append(clName.replace('.', '/'));
        }
        nbuff.append(".java");
        return nbuff.toString();
    }

    String getJavaSource() throws TclException {
        TclObject src = TclList.index(this.interp, this.javaInfo, 1);
        return src.toString();
    }
}

