/*
 * Decompiled with CFR 0.152.
 */
package tcl.pkg.tjc;

import tcl.lang.ConsoleThread;
import tcl.lang.Interp;
import tcl.lang.Notifier;
import tcl.lang.TclException;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;

public class TJCShell {
    public static void main(String[] args) {
        String fileName = "resource:/tcl/pkg/tjc/library/tjc.tcl";
        int startIndex = 0;
        Interp interp = new Interp();
        if (args.length > 0 && (args[0].equals("-s") || args[0].equals("-shell"))) {
            startIndex = 1;
        }
        TclObject argv = TclList.newInstance();
        argv.preserve();
        try {
            try {
                if (startIndex == 1) {
                    interp.setVar("argv0", "tjc", 1);
                    interp.setVar("tcl_interactive", "1", 1);
                } else {
                    interp.setVar("argv0", "tjc.tcl", 1);
                    interp.setVar("tcl_interactive", "0", 1);
                }
                int i = startIndex;
                while (i < args.length) {
                    TclList.append(interp, argv, TclString.newInstance(args[i]));
                    ++i;
                }
                interp.setVar("argv", argv, 1);
                interp.setVar("argc", TclInteger.newInstance(TclList.getLength(interp, argv)), 1);
            }
            catch (TclException e) {
                throw new TclRuntimeError("unexpected TclException: " + e);
            }
        }
        finally {
            argv.release();
        }
        if (fileName != null) {
            int exitCode = 0;
            try {
                interp.eval("package require TJC");
                interp.eval("source " + fileName);
            }
            catch (TclException e) {
                int code = e.getCompletionCode();
                if (code == 2) {
                    code = interp.updateReturnInfo();
                    if (code != 0) {
                        System.err.println("command returned bad code: " + code);
                        exitCode = 2;
                    }
                }
                if (code == 1) {
                    System.err.println(interp.getResult().toString());
                    exitCode = 1;
                }
                System.err.println("command returned bad code: " + code);
                exitCode = 2;
            }
            if (startIndex == 0) {
                interp.dispose();
                System.exit(exitCode);
            }
        }
        if (startIndex == 1) {
            ConsoleThread consoleThread = new ConsoleThread(interp);
            consoleThread.setDaemon(true);
            consoleThread.start();
            Notifier notifier = interp.getNotifier();
            while (true) {
                notifier.doOneEvent(-3);
            }
        }
    }
}

