<'

//@non_standard
type count : uint;

//@non_standard
struct base_struct like __dvt_null_parent {

   // SIMI: moved to RfType constructor
   // Returns a shallow, non-recursive copy of the expression.
   // This means that if the expression is a list or a struct that contains other lists or structs, the second-level items are not duplicated.
   // Instead, they are copied by reference.
   //   copy() is empty;

   // Controls the printing of information about a particular struct.
   // You can extend this method to customize the way information is displayed.
   do_print() is empty;

   // Returns the printed lines as a list of strings.
   get_printed_lines(): list of string is empty;

   // The init() method of a struct is called when you create a new instance with a test, start or generate command (pre-run generation)
   //  or with a new, gen or unpack() action (on-the-fly generation).
   // You should consider initializing the non-generated fields of a struct,
   //  especially fields of an enumerated scalar type or unsized lists.
   init() is empty;
   
   // @non_standard
   type(): struct_descriptor is empty;

// SIMI: moved to RfType constructor
// Returns the string representation.
//   to_string(): string is empty;
};

'>

<'

// The default parent of a declared struct.
struct any_struct like base_struct {

   // Emitted when a struct's quit() method is called.
   // Only exists in structs that contain events or have members that consume time (for example, time-consuming methods and on struct members).
   event quit;

   // This is an empty method that you can extend for performing post-test checks.
   // This method is called by global.check_test()
   //  when you issue a test or check command from the Specman command line.
   check() is empty;

   // @deprecated
   // @non_standard
   at_message_verbosity(verbosity : message_verbosity) : bool is empty;

   // Pack the physical fields of the struct.
   do_pack(options: pack_options, l: *list of bit) is empty;

   // Unpack a packed list of bit into a struct.
   do_unpack(options: pack_options, l: list of bit, begin: int) : int is empty;

   // This method is called before the post-run checking is performed
   //  when you issue a check or finalize command from the Specman command line.
   // The method is initially empty.
   // You can extend this method to extract data from the DUT before checking the test results.
   extract() is empty;

   // The global.finalize_test() method calls the finalize() method of each struct or unit
   //  as part of the post-checking activities, which include writing coverage information.
   // You can also call this method from the command line with the finalize command.
   // You can extend the finalize() method of a unit or struct to display or manipulate data.
   finalize() is empty;

   // The generate() method is run automatically after an instance of the enclosing struct is allocated.
   // It is not recommended to extend sys.generate().
   // Instead, you should extend the related pre_generate() or post_generate() method of a particular struct or unit.
   generate() is empty;

   // This pseudomethod receives a unit type as a parameter and returns a list of instances of this unit type as well as any unit instances
   // contained within each instance.
   get_all_units(type_name: string) : list of any_unit is empty;

   // Returns a reference to the nearest higher-level unit instance of the specified type, allowing you to access fields of the
   // parent unit in a typed manner. If a unit instance of the specified type is not found, a runtime error is issued.
   get_enclosing_unit(type_name: string) : any_unit is empty;

   // When applied to an allocated struct instance, this method returns a reference to the parent unit, the unit to which the struct is bound.
   // When applied to a unit, it returns the unit itself.
   get_unit(): any_unit is empty;

   // If there are handling loggers for the action, the action creates a message (consisting of a list of string plus related
   // information) and sends it to all of the handling loggers. Those loggers then format the message and send it to the screen or to files.
   message(__dvt_ignore_args) is empty;

   // If there are handling loggers for the action, the action creates a message (consisting of a list of string plus related
   // information) and sends it to all of the handling loggers. Those loggers then format the message and send it to the screen or to files.
   messagef(__dvt_ignore_args) is empty;

   // The pre_generate() method is run automatically after an instance of the enclosing struct is allocated but before generation is performed.
   // This method is initially empty, but you can extend it to apply values procedurally to prepare constraints for generation.
   // The pre_generate() method allows you to simplify constraint expressions before they are analyzed by the constraint solver.
   pre_generate() is empty;

   // The post_generate() method is run automatically after an instance of the enclosing struct is allocated and both pre-generation and generation have been performed.
   // You can extend the predefined post_generate() method for any struct to manipulate values produced during generation.
   // The post_generate() method allows you to derive more complex expressions or values from the generated values.
   post_generate() is empty;

   // Deactivates a struct instance, killing all threads associated with the struct and enabling garbage collection.
   // The quit() method emits a quit event for that struct instance at the end of the current tick.
   // At the end of the current tick, the quit() method kills any TCM threads that were started within the struct in which the quit() method is called.
   // All attached events and expect members of the struct that are still running are also killed.
   quit() is empty;

   // Method of any struct or unit.
   // Can be extended to start user-defined TCMs.
   // The method is initially empty.
   run() is empty;

   // The rerun() method:
   // 1. Deactivates a struct or unit instance at the end of the current tick by calling its quit() method.
   //    The quit() method kills any TCM threads, attached events, or expect members that are still running.
   // 2. Reactivates the struct or unit instance at the beginning of the next cycle (new specman time)
   //    by calling its run() method and activating the attached event and expect members.
   // Similarly to the quit() method, rerun() is not called recursively for struct sub-structs.
   // If required, you can extend rerun() to call sub-struct rerun() methods also.
   rerun() is empty;

   // Changes the parent unit of a struct to the specified unit instance.
   set_unit(parent: any_unit) is empty;


   // Strangely enough scope appears as any_unit in the documentation, but when playing with Specman it seems to be any_struct
   // extend any_struct {
   //   tr... (scope: any_unit...) is also {} // this doesn't load, parameter differs from previous definition...
   // }

   // For structs: A callback method that returns the value of an attribute for this data-item instance in the given scope unit.
   // It is invoked on data-item instances for which the attribute was registered at the appropriate sampling points by calling <b>register_callback_attribute()</b>.
   // <br>
   // For units: A callback method that returns the value of an attribute for the given instance.
   // It is invoked on data-item instances for which the attribute was registered at the appropriate sampling points.
   // <br>
   // The returned value is written to the message destination.
   // <br><b>Notes:</b>
   // <br>*  This method may be implemented by the user, but should not be called explicitly. By default it returns "" (an empty string).
   // <br>* tr_get_attribute_value() is strongly connected to register_callback_attribute().
   tr_get_attribute_value(
      // For structs: A reference to the unit in the scope where the attribute should be evaluated.
      // For units: A reference to the data item instance that is being considered.
      inst: any_struct,
      // The name of the registered attributes.
      attr_name: string
   ): string is empty;

   // @non_standard
   type(): struct_descriptor is empty;

   // Like get_enclosing_unit(), this method returns a reference to the nearest higher-level unit instance of the specified type,
   // allowing you to access fields of the parent unit in a typed manner. Unlike get_enclosing_unit(), this method does not issue a
   // runtime error if no unit instance of the specified type is found. Instead, it returns NULL.
   try_enclosing_unit(type_name: string) : any_unit is empty;

   // Show struct information graphically.
   visualize() is empty;

   // Apply the abort operator on the expect struct member
   do_abort_on_expect(name : string, force : bool) is {};
   
   // Apply the stop operator on the expect struct member
   do_stop_on_expect(name : string, force : bool) is {};
   
   // Apply the start operator on the expect struct member
   do_start_on_expect(name : string, force : bool) is {};
   
   // Apply the abort operator on the event struct member
   do_abort_on_event(name : string, force : bool) is {};
   
   // Apply the stop operator on the event struct member
   do_stop_on_event(name : string, force : bool) is {};
   
   // Apply the start operator on the event struct member
   do_start_on_event(name : string, force : bool) is {};
   
   // Apply the abort operator on events and expects of a struct.
   do_abort_on_struct(force : bool) is {};
   
   // Apply the stop operator on events and expects of a struct.
   do_stop_on_struct(force : bool) is {};
   
   // Apply the start operator on events and expects of a struct.
   do_start_on_struct(force : bool) is {};
   
   // Customize how the abort operator is applied on temporal struct members of a struct
   apply_abort_on_struct(force : bool) is {};
   
   // Customize how the stop operator is applied on temporal struct members of a struct
   apply_stop_on_struct(force : bool) is {};
   
   // Customize how the start operator is applied on temporal struct members of a struct
   apply_start_on_struct(force : bool) is {};
   
   // Apply the abort operator on the events of a struct
   do_abort_on_all_events(force : bool) is {};
   
   // Apply the abort operator on the expects of a struct
   do_abort_on_all_expects(force : bool) is {};
   
   // Apply the stop operator on the events of a struct
   do_stop_on_all_events(force : bool) is {};
   
   // Apply the stop operator on the expects of a struct
   do_stop_on_all_expects(force : bool) is {};
   
   // Apply the start operator on the events of a struct
   do_start_on_all_events(force : bool) is {};
   
   // Apply the start operator on the expects of a struct
   do_start_on_all_expects(force : bool) is {};
};

'>

<'

template unit any_tlm_socket of <type> like any_port {

    // Turns off transaction mapping for specified TLM2 socket(s).
    turn_transaction_mapping_off() is empty;
    
	// ATTRIBUTE Sets the bus width associated with the socket.
	bus_width() : uint is empty;
    
};

'>

<'

// The default parent of a declared unit.
// Units, like structs, are compound data types that contain data fields, procedural methods, and other members.
// Unlike structs, however, a unit instance is bound to a particular component in the DUT (an HDL path).
// Furthermore, each unit instance has a unique and constant place (an e path) in the runtime data structure of an e program.
// The basic runtime data structure of an e program is a tree of unit instances whose root is sys.
unit any_unit like any_struct {

   // ATTRIBUTE Identifies the simulator used to simulate the corresponding DUT component.
   // Specman uses the hdl_path() and agent() constraints to create a correspondence map between the path to the external object and the agent name defined for the unit.
   // The agent() definition is not needed in a single-agent environment that is,
   //  if the entire DUT is described only in Verilog or only in VHDL or only in SystemC (when in master mode).
   agent(): string is empty;

   // ATTRIBUTE Defines text written in an external language that is to be written to the stubs file.
   agent_code(): string is empty;

   // Issue a command to the agent of the current unit.
   // Passes a command to the agent of the current unit from e. The routine returns no value. The output of the routine may be sent to standard output and/or to the log file, depending on the agent.
   agent_command(command: string) is empty;

   // Map port instance to an external object
   // Defining an agent_expression() attribute for an external indexed port lets you access a multidimensional array using variable index parameters passed at runtime.
   agent_expression() : string is empty;

   // Map port instance to an external object.
   // To access an external, simulated object, you must identify the object with the agent_path() attribute.
   // The path defined by agent_path() is not concatenated with the paths of the enclosing units.
   agent_path() : string is empty;

   // This extensible method is initially empty, except sys.all_objections_dropped() when the kind is TEST_DONE (see 'End-Of-Test Solution').
   // This method is called by Specman whenever the objection total for objection_kind goes down to zero in the current unit.
   // In other words, whenever the objection status for objection_kind is changed in some unit (by calling raise_objection() or drop_objection() on that unit), the total for that unit changes immediately. If the total becomes 0, all_objections_dropped() gets called on the unit.
   // After all_objections_dropped() returns, Specman continues going up the unit tree towards sys, decrementing the counter (and hence the total) and calling all_objections_dropped() for any unit in which the total is zero.
   // This method is the main workhorse for doing things upon the change (for example, raising another objection, starting a TCM that will drop an objection later, and so on).
   // Note: This is the only objection mechanism method that should be extended by the user.
   all_objections_dropped(kind: objection_kind) is empty;

   // ATTRIBUTE Identifies text that is automatically added to the Verilog-AMS stubs file by the write stubs command.
   analog_agent_code(): string is empty;

   // ATTRIBUTE Identifies text that is automatically added to the Verilog stubs file by the write stubs command.
   analog_code(): string is empty;

   // Assigns the given recording_config object to this unit instance.
   // Note that this affects the configuration of all descendant units that have not been assigned a recording_config object explicitly,
   //  or associated with one through a closer parent.
   assign_recording_config(rec: recording_config) is empty;

   // Implement user-defined checks, including connection checks.
   check_generation() is empty;

   // Connect unit references (pointers).
   // Because connect_pointers() is called after the unit tree is generated and after post_generate() is called,
   //  any reference assigned in connect_pointers() must not be used in constraints or in post_generate().
   // In general, connect_pointers() is recommended only to create cross references between sibling units.
   connect_pointers() is empty;

   // Connect ports procedurally.
   connect_ports() is empty;

   // Create a path for the agent if it does not exist.
   // If TRUE, the variable denoted by this attribute should be created if it doesn't exist. (Default: FALSE)
   create_agent_path() : bool is empty;

   // The create_formatted_message() method is a hook (callback) method used for
   // implementing user-defined formatting on message output. This method only gets called
   // when the message is being sent to the screen and/or to file destination(s) - it can be
   // called more than once for the same message - and it creates the actual message text that will be sent.
   // At the start of this method, buffer contains the base text of the message before formatting.
   // The default implementation of this method uses the default formatting of the three
   // formats (short, long, and none), according to the message format settings.
   create_formatted_message(
      // Message being issued.
      message: message_action,
      // Buffer for the formatted message.
      buffer: list of string) is empty;

   // By calling this method, the unit decrements by 1 its objection counter to objection_kind.
   // Calling this method when the objection counter is 0 results in an error.
   drop_objection(kind: objection_kind) is empty;

   // Returns the location of a unit instance in the unit tree.
   e_path(): string is empty;

   // Called during the elaboration phase.
   elaborate() is empty;

   // @non_standard
   external_ovm_class(): string is empty;

   // ATTRIBUTE Identifies the SystemVerilog class type that contains the task or function being called by the method port.
   external_uvm_class(): string is empty;

   // ATTRIBUTE Returns the external uvm path of a unit instance.
   external_uvm_path(): string is empty;

   // Returns a full OVM path for a unit instance.
   full_external_ovm_path(): string is empty;

   //Returns the external UVM path for the specified unit instance.
   full_external_uvm_path(): string is empty;

   // Returns the absolute HDL path for the specified unit instance.
   full_hdl_path(): string is empty;

   // Return a list of all units instantiated directly under a given unit.
   //
   // This method returns a list of all units instantiated directly under the given unit. This includes the values of all unit instance fields of the given unit, and all elements of unit instance list fields, including multi-dimensional lists.
   // The order of the units in the resulting list is according to the order of instance field declarations:
   // For lists of units, the order of the elements in the resulting list is the same as in the original list.
   // For a multi-dimensional list, the order of its elements is according to the flattened list (similarly to the result of flatten() pseudo-method).
   // Only real unit instances appear in the resulting list. If the value of some unit instance field, or some element of a unit instance list field, is NULL, it is not added to the result.
   // If the optional with_ports parameter is TRUE, the return value includes also ports instantiated under port instance fields of the unit, including port instance list fields.
   // @param with_ports When TRUE, the return value also includes ports instantiated under port instance fields of the unit, including port instance list fields. Default: FALSE
   get_children(with_ports : bool = TRUE) : list of any_unit is empty;

   // @non_standard
   get_hdl_path_list(): list of string is empty;

   // Returns the native HDL path for a unit instance.
   get_native_path_name(): string is empty;

   // Returns the objection counter for the unit, that is, the current number of objections to objection_kind in the unit itself, regardless of its subunits.
   get_objection_counter(kind: objection_kind): int is empty;

   // Returns the list of units directly under the unit (not including it) for which the objection total is not zero.
   get_objection_list(kind: objection_kind): list of any_unit is empty;

   // Returns the objection total of the unit, that is, the total number of objections to objection_kind in the tree that includes both the unit itself and all of its subunits.
   get_objection_total(kind: objection_kind): int is empty;

   // Returns a reference to the unit containing the current unit instance.
   get_parent_unit(): any_unit is empty;

   // Returns the list of port instances for the given unit.
   get_ports(): list of any_port is empty;

   // Returns a list of port instances for the given unit, and in all units under it.
   get_ports_recursively(): list of any_port is empty;

   // Returns the recording_config object that is associated with this unit instance.
   // A unit is associated with a recording_config object either by explicit assignment using "assign_recording_config()"
   //  or otherwise inherits the association from its parent unit (recursively).
   // Unit sys (and units with no parent unit in general) is associated by default with an empty recording_config object.
   get_recording_config(): recording_config is empty;

   // ATTRIBUTE Returns the HDL path of a unit instance.
   // The most typical use of this method is to bind a unit instance to a particular component in the DUT hierarchy.
   hdl_path(): string is empty;

   // ATTRIBUTE Specify how an external port's data element is implicitly packed and unpacked.
   pack_options(): string is empty;

   // ATTRIBUTE For coverage data to be used in Enterprise Manager, sets the default coverage collection behavior for cover entities of a unit instance.
   per_inst_cover(): sn_per_inst_cover_t is empty;

   // By calling this method, the unit increments by 1 its objection counter to objection_kind.
   raise_objection(kind: objection_kind) is empty;

   // Returns a shorthand notation for a unit.
   // You must never modify the short_name_path() directly.
   // Instead, you should extend the short_name() method, which short_name_path() calls.
   short_name_path(): string is empty;

   // You can change this method to return the desired short-name for the unit.
   short_name(): string is empty;

   // Returns the short-name path for a unit.
   // The "plain" boolean parameter for short_name_path() determines whether the string of short names returned is colored or not.
   short_name_path(plain: bool) is empty;

   // You can change this method to return the color that will be used when writing the short name.
   short_name_style(): vt::vt_style is empty;

   // See any_struct.tr_get_attribute_value()
   //    // A callback method that returns the value of an attribute for the given instance.
   //    // It is invoked on data-item instances for which the attribute was registered at the appropriate sampling points.
   //    // The value retuned by it is written to the message destination.
   //    // <br><b>Notes:</b>
   //    // <br>* This method may be implemented by the user but should not be called explicitly. By default it returns "" (an empty string).
   //    // <br>* tr_get_attribute_value() is strongly connected to register_callback_attribute()
   //    tr_get_attribute_value(
   //    // A reference to the data item instance that is being considered.
   //    inst: any_struct,
   //    // The name of the registered attributes.
   //    attr_name: string): string is empty;

   // A callback method that returns the value of a registered state variable for this unit instance. It is invoked on scope units for which the state variable was registered upon execution of msg_changed(). The value returned by it is written to the message destination.
   // <br><b>Note:</b> This method may be implemented by the user but should not be called explicitly. By default it returns "" (an empty string).
   tr_get_state_var_value(
      // The name of the registered attributes.
      attr_name: string
   ): string is empty;

   // @non_standard
   uvm_unit_id(): int is empty;

};

'>

<'

// The parent of any struct to be used as a sequence item.
// Typically it is a struct that represents the main input to the DUT (for example, packet, transaction, instruction).
struct any_sequence_item {

   // A const generatable field that defines the priority of the sequence. When the sequence is generated, by default the priority set to be the same as its parent sequence's priority. If the generated sequence does not have a parent (when it is invoked with start_sequence() rather than with do), it defaults to 100.
   // Because it is defined as const, this field's value is determined once and for all at generation. Generation can be controlled either by constraints, by direct assignment in the scope of pre_generate() or post_generate(), or by calling any_sequence.set_priority().
   const initial_priority: int;

   // Backpointer to the sequence in which this sequence was created.
   // Assigned automatically in pre_generate() of the sequence if such a parent exists.
   !parent_sequence: any_sequence;

   // @non_standard
   stripe_info: sn_stripe_info;

   // Quitting Sequences and Sequence Items: Specman continues evaluating temporal expressions until quit() is called. Garbage collection for structs, sequences, and sequence items only occurs after Specman stops evaluating temporal expressions. Therefore, if you use temporal expressions in a sequence or sequence item, you must call quit() before Specman can perform garbage collection on the sequence or sequence item.
   // To enable automatic quitting of sequences and sequence items:
   // Set the any_sequence_item.auto_quit() predefined method to TRUE.
   // When auto_quit() returns TRUE, quit() is automatically called for:
   // sequences after the sequence is finished,
   // sequence items after driver.item_done is emitted.
   // Note: By default, auto_quit() currently returns FALSE.
   auto_quit() : bool is empty;

   // Returns a string describing the source location of the do action that generated the current item.
   // Not relevant for sequence_items not created via the do action.
   do_location(): string is empty;

   // RO Depth from the sequence driver, valid from pre-generation.
   get_depth(): int is empty;

   // RO Returns the driver.
   get_driver() : any_sequence_driver is empty;

   // @non_standard
   get_parent_driver() : any_sequence_driver is empty;

   // Returns an integer indicating the priority of the sequence.
   get_priority(): int is empty;

   // Apply a condition for performing a do item action, so that the do action will not be scheduled until is_relevant() returns TRUE.
   is_relevant(): bool is empty;

   // Returns a short string representing the item for tracing.
   // It is used by trace sequence, wave sequence, and show sequence.
   // The default implementation returns the value of to_string().
   nice_string(): string is empty;

   // Hook TCM called after post_do(). Extends the life of a do after the item_done event is emitted.
   // The sequence driver, freed by the item_done event, no longer manages the current item. It can handle other items.
   post_do_tcm(s: any_sequence_item) @sys.any is empty;

   // @non_standard
   set_driver(driver : any_sequence_driver) is empty;

   // Can be called in the scope of pre_generate() or post_generate() to set the priority of the sequence relative to other sequences.
   set_priority(new_val: int) is empty;

};

'>

<'

// The parent of any sequence struct.
// It is a struct that represents a stream of items signifying a high-level scenario of stimuli.
struct any_sequence like any_sequence_item {

   // Emitted immediately after body() is finished.
   event done;

   // The recommended coverage sampling event for the sequence kind.
   event ended;

   // Emitted just before body() is called.
   event started;

   // Emitted when the sequence is stopped.
   event stopped;

   // RW Main method called by do of parent sequence after it generates the current sequence.
   body() @driver.clock is empty;

   // RO Starts at 0 and gets incremented after every do.
   get_index(): int is empty;

   // @non_standard
   get_default_priority(): int is empty;

   // RO grab() is a blocking TCM that grants its calling sequence an exclusive access to driver.
   // A sequence that wants exclusivity can call grab(driver).
   // This grants exclusive access to that sequence and its subsequences from the moment grab() returns
   //  (perhaps, after a slight delay) until the sequence calls a corresponding ungrab(driver).
   // During this grabbing period, the sequence driver belongs to the sequence.
   // The driver drives only the items that were done by the grabbing sequence or its subsequences.
   // When a sequence driver belongs to a sequence, only that sequence can send items to the sequence driver.
   // All other sequences are blocked from sending (that is, their items remain blocked).
   grab(driver : any_sequence_driver) @sys.any is empty;

   // @non_standard
   is_abstract(): bool is empty;

   // RO This method is valid for BFM sequences only.
   // It indicates whether a sequence is blocked from sending items.
   // It happens when another sequence that is not an ancestor has grabbed the sequence driver.
   is_blocked(): bool is empty;

   // @non_standard
   is_virtual(): bool is empty;

   // RW Hook method called in the middle of do, just after s is generated and before it is executed by calling the body() TCM.
   mid_do(s: any_sequence_item) is empty;

   // RW Hook TCM called before body() when sequence is started using the start_sequence() method.
   pre_body() @sys.any is empty;

   // RW Hook TCM called at start of a do performed by the sequence.
   // `is_item' specifies whether you are in a context of do-ing an item or a sequence.
   pre_do(is_item: bool) @sys.any is empty;

   // RW Hook TCM called after body() when sequence is started using the start_sequence() method.
   post_body() @sys.any is empty;

   // RW Hook method called at end of do, just after the execution of s.body().
   post_do(s: any_sequence_item) is empty;

   // RW Gets called for every sequence just after a trace message about it gets printed. Useful for breakpoints.
   post_trace() is empty;

   // @deprecated
   // RO start() was replaced by start_sequence().
   start() is empty;

   // RO start_sequence() is a non-time-consuming method that starts the body() TCM of the sequence.
   // Use this method instead of starting the body() TCM directly.
   // When doing so, a new sequence tree is executed.
   start_sequence() is empty;

   // RO stop() is a non-time-consuming method that terminates the execution of body() (if such exists) by killing its thread.
   // This might become useful if, for example, you want to terminate a sequence in the middle upon interrupt
   //  and execute an alternative sequence instead.
   stop() is empty;

   // RO ungrab() is a non-time-consuming method that releases the driver from the exclusive control of the sequence
   // that was previously granted by calling grab().
   ungrab(driver : any_sequence_driver) is empty;

};

'>

<'

// The parent of any sequence driver.
// A unit that serves as the mediator between the sequences and the verification environment.
// The generated items are passed from the sequence to the sequence driver and the sequence driver acts upon them one by one,
//  typically passing them to some kind of BFM (Bus Functional Model).
unit any_sequence_driver {

   // Specifies the way the driver and the BFM interact with each other.
   // Possible options are PULL_MODE (the default) and PUSH_MODE. It can be constrained.
   bfm_interaction_mode: bfm_interaction_mode_t;

   // Enable or disable automatic generation and launch of the MAIN sequence upon run. Default is TRUE (MAIN sequence is generated and started).
   gen_and_start_main: bool;

   // Used in setting the maximum number of subsequences in a RANDOM or MAIN sequence.
   max_random_count: int;

   // Used for setting the maximum depth inside RANDOM sequences. (Beyond that depth, RANDOM creates only SIMPLE sequences.
   max_random_depth: int;

   // Used for setting the length of the history of previously sent items. Default is 1.
   num_of_last_items: int;

   // @non_standard
   sequence_imp___pending_dos: list of do_request;

   // @non_standard
   using_new_sequence_naming: bool;

   // The main clock. Should be tied to some temporal formula by users during the sequence driver hooking.
   event clock;

   // Synchronization event for the do action in PULL_MODE.
   // When working in PULL_MODE, you must emit this event to complete the do item and let the driver get more items using get_next_item().
   event item_done;

   // Drops the currently granted request altogether.
   // The driver is released to attend to or wait for other do requests for the same get/try_next_item() call.
   // A runtime error is issued if this method is called while the driver is not in a waiting-for-item state.
   abort_do_request() is empty;

   // RO This method lets you resume normal operation in the current cycle when a do action in a first of block terminates prematurely.
   branch_terminated() is empty;

   // RO For forcing a driver to recheck the relevance (value of is_relevant()) for each sequence that has items in the driver's item queue.
   // It can be useful when something has changed in the BFM that affects the relevance of some sequences.
   check_is_relevant() is empty;

   // @non_standard
   clean_previous_call() is empty;

   // RO Indicates which sequence (if any) has exclusive control over a sequence driver.
   current_grabber(): any_sequence is empty;

   // RO This TCM can be used to emit the driver's clock with some inter-cycle delay
   //  to let the BFM export its state before activation of sequences in a specific cycle.
   // This TCM should be activated INSTEAD of connecting the clock to another event.
   delay_clock() @sys.any is empty;

   // Hands over an item to be sent to the item consumer.
   // An item can be delivered only when this sequence driver has granted a do request, and only once per request.
   // A runtime error is issued if the method is called while the driver is not in a waiting-for-item state.
   deliver_item(item: any_sequence_item) is empty;

   // Hand over an item to be sent to the item consumer when its turn comes and wait for item_done acknowledgement from the consumer
   execute_item(item: any_sequence_item) is empty;

   // @non_standard
   get_all_kinds() : list of string is empty;

   // RO Returns the item currently being sent. NULL if the BFM is currently idle.
   get_current_item(): any_sequence_item is empty;

   // RO Returns index of this sequence driver in the all-driver list.
   get_index(): int is empty;

   // @non_standard RO Returns a list of the items handled (sent) by the sequence driver (the item sublist of the trace log).
   // The list is populated only if the trace sequence command was activated in On or Log Only mode.
   get_item_trace_list(): list of any_sequence_item is empty;

   // @non_standard
   get_last_item_idx(): uint is empty;

   // @non_standard
   get_last_items(): list of any_sequence_item is empty;

   // RO Returns count of items sent (excluding current_item, if any).
   get_num_items_sent(): int is empty;

   // @non_standard RO Returns a list of the sequences handled by the sequence driver (the sequence sublist of the trace log).
   // The list is populated only if the trace sequence command was activated in On or Log Only mode.
   get_sequence_trace_list(): list of any_sequence is empty;

   // RW For virtual sequence drivers, this method is to be filled in by the writer of the specific sequence driver.
   // It should return the list of subdrivers of the sequence driver.
   // For a BFM sequence driver, it should be left unchanged, that is, return an empty list.
   get_sub_drivers(): list of any_sequence_driver is empty;

   // @non_standard RO Returns a list of all sequences and items handled by the sequence driver (the full trace log).
   // The list is populated only if the trace sequence command was activated in On or Log Only mode.
   get_trace_list(): list of any_sequence_item is empty;

   //This method of any_sequence_driver returns TRUE if the driver can execute a do immediately.
   has_do_available(): bool is empty;

   // @non_standard
   internal_get_next_item(a: bool): any_sequence_item is empty;

   // RO This method is valid for BFM sequence drivers only. It indicates the grab status of the sequence driver.
   is_grabbed(): bool is empty;

   // @non_standard
   is_virtual(): bool is empty;

   // RO This method is valid for BFM sequence drivers only. It enables access to previously sent items in the sequence driver.
   last(index: int): any_sequence_item is empty;

   // Hands over an item to be sent to the item consumer when its turn comes.
   // You can use this method when just-in-time generation of the item is not required.
   queue_item(seq: any_sequence, item: any_sequence_item) is empty;

   // RW For implementing a DUT-independent interface.
   read(address: list of bit): list of bit @clock is empty;

   // RW Regenerates driver's data upon rerun().
   regenerate_data() is empty;

   // @non_standard RO remove_started_seq() is a non-time-consuming method that stops the current sequence.
   remove_started_seq(seq: any_sequence) is empty;

   // @non_standard
   report_default_main(seq: any_sequence, count: uint) is empty;

   // @non_standard
   run_sequences() is empty;

   // @non_standard
   set_branch_handle() is empty;

   // @non_standard
   send_loop() @clock is empty;

   // @non_standard
   stop_handling_item() is empty;

   // Registers a do-item request and waits until the request is granted.
   // Use this TCM to synchronize with a consume request (get/try_next_item()), so as to enable just-in-time generation.
   // When it returns, the driver is in a waiting-for-item state and does not go on to handle another do request until an item is delivered, or until the grant is waived.
   wait_for_grant(seq: any_sequence) @sys.any is empty;

   // Waits for item_done acknowledgement from the consumer.
   // If NULL is passed as item, the call waits for item_done notification for the last item delivered.
   wait_for_item_done(item: any_sequence_item)@sys.any is empty;

   // Skips the currently granted request's turn to deliver an item and waits for its next grant.
   // The request keeps its place in the driver's do queue, and gets another chance to deliver an item when its turn comes around.
   // A runtime error is issued if this TCM is called while the driver is not in a waiting-for-item state.
   wait_for_next_grant()@sys.any is empty;

   // RW This TCM is called to delay the return of try_next_item() and let sequences create items.
   // It can also be called in other locations to help propagation of activity (for example, among several layers of sequences).
   // It can also be overridden to implement a different scheme than the default one.
   wait_for_sequences() @sys.any is empty;

   // RW For implementing a DUT-independent interface.
   write(address: list of bit, data: list of bit) @clock is empty;

};

'>

<'

// It should be the root unit for any separately packaged verification component.
unit any_env {

   // RW Add waveform info for that package. By default, empty. To be filled by the user.
   add_wave_info() is empty;

   // RO Return the full file name (starting with '/') of that file, looking for it under the package directory (as it exists now).
   // For an empty string - return the package directory. If it does not exist, issue an error.
   // Computed from definition file of package. User should not override.
   get_file(name: string): string is empty;

   // RO Return the name of the package (e.g. 'vr_xbus', not the name of this unit, which is e.g. 'vr_xbus_env').
   // Computed from definition file of package. User should not override.
   get_name(): string is empty;

   // RW Return the title of the package. By default, returns PACKAGE_README.txt title. User can modify it.
   get_title(): string is empty;

   // RW Return the version of that package, as a string. By default, returns PACKAGE_README.txt version. User can modify it.
   get_version(): string is empty;

   // RW Print the banner for this instance of the env.
   // By default, shows a single line, with get_title() and get_version().
   // User can modify it, adding e.g. copyright notice and a short description of the configuration of this instance.
   // We suggest indenting all the extra information by four spaces.
   show_banner() is empty;

   // RW Print the current status of this instance of the env. By default, empty. To be filled by the user.
   show_status() is empty;

};

'>

<'

// Enables instantiation of a foreign framework component.
unit child_component_proxy like foreign_component_proxy {
    // The type name of the SystemVerilog component.
    type_name: string;

    // @non_standard
    end_of_elaboration() is empty;

    // @non_standard
    n_ml_hook() is empty;
};

'>

<'

struct covers {

   // @non_standard
   check_illegal() is empty;

   // Return the normalized overall coverage grade for the current set of tests.
   compute_overall_grade(): int is empty;

   // Return a list of the test runs that contributed samples to a bucket.
   get_contributing_runs(item_name: string, bucket_name: string): list of string is empty;

   // Return the normalized overall coverage grade for the most recently analyzed group or item.
   get_overall_grade(): int is empty;

   // Return the value of the seed for the current test.
   get_seed(): int is empty;

   // Return the name of the most recently loaded e file (the file containing the top module for the current test).
   get_test_name(): string is empty;

   // Prints which item definitions contributed the largest number of buckets when dumping the latest ucm file.
   get_top_size_items(num_of_items_to_display: int) is empty;

   // Return the path for the .ucd file.
   get_ucd_path(): string is empty;

   // Return a list of the names of unique buckets from specific tests.
   get_unique_buckets(file_name: string): list of string is empty;

   // Specify which test runs coverage information will be displayed for.
   include_tests(full_run_name: string, exp: bool) is empty;

   // Enable procedural sampling of a covergroup without emitting the sampling event
   sample_cg(cg_name: string, inst: any_struct) is empty;

   // Set the minimum number of samples needed to fill a bucket.
   set_at_least(entity_names: string, value: int, exp: bool) is empty;

   // Turns coverage data collection and display on or off for specified items or events.
   set_cover(entity_names_or_events: string, exp: bool) is empty;

   // Disables or enables coverage data collection for specified modules or file.
   set_cover_block(module_wc: string, enable: bool) is empty;

   // Turns coverage data collection and display on or off for specified check or expect items.
   set_cover_check(check_name: string, enable: bool) is empty;

   // Enable/disable coverage data collection for each relevant unit instance of a coverage group with a per_instance item.
   set_cross_instance_collection(inst_wc: string, path_wc: string, enable: bool) is empty;

   // Collect coverage data for structs in a unit.
   set_per_inst_for_struct(struct_type: string, unit_type: string) is empty;

   // Change the instance path of all coverage instances of a unit instance.
   set_unicov_hier(inst: any_unit, path: string) is empty;

   // Specify the coverage grading weight of a group or item.
   set_weight(entity_names: string, value: int, exp: bool) is empty;

   // Write the coverage results during a test.
   write_cover_file() is empty;

};

'>

<'

// @non_standard
struct csv_file like sn_struct {
   // @non_standard
   age: int;
   // @non_standard
   current_line_num: int;
   // @non_standard
   file: file;
   // @non_standard
   file_name: string;
   // @non_standard
   full_file_name: string;
   // @non_standard
   is_fully_parsed: bool;
   // @non_standard
   name: string;
   // @non_standard
   orig_excel_file_name: string;
   // @non_standard
   orig_excel_sheet_name: string;
   // @non_standard
   parsed_tables: list (key: tag) of table;

   // @non_standard
   clean_tables() is empty;
   // @non_standard
   close() is empty;
   // @non_standard
   get_excel_file_name(): string is empty;
   // @non_standard
   get_next_line(line: string): int is empty;
   // @non_standard
   get_source_file_info_for_error(): string is empty;
   // @non_standard
   is_reported_as_excel(): bool is empty;
   // @non_standard
   open() is empty;
};

'>

<'

// Each instance of a cvl_connection struct controls a particular CVL I/O connection.
// You must explicitly declare a cvl_connection field for each struct that uses CVL.
struct cvl_connection {

   // Synchronizes closing a CVL connection.
   event connection_closed;

   // Synchronizes opening a CVL connection.
   event connection_opened;

   // Closes a CVL connection.
   close() is empty;
};

'>

<'

// This struct establishes new CVL connections with external software.
struct cvl_manager {

   // Closes all opened CVL connections.
   close_all() is empty;

   // Establishes a new CVL connection with an external process.
   get_connection(struct_instance: any_struct, connection_name: string): cvl_connection is empty;

   // Returns TCP/IP port number Specman uses.
   get_port(): uint is empty;

   // Sets TCP/IP port number Specman uses.
   set_port(port_number : uint) is empty;

   // Spawns a UNIX process and establishes a new CVL connection with it.
   spawn_cvl_connected_process(struct_instance: any_struct, command: string, connection_name: string): cvl_connection is empty;

   // Sets CVL trace mode on and off for all the processes that will be spawned using cvl_manager.spawn_cvl_connected_process().
   spawn_trace_mode(trace_mode : bool) is empty;

};

'>

<'

//@non_standard
struct display_window like sn_struct {
};

//@non_standard
struct sn_display {
	//@non_standard
    on : bool;
	//@non_standard
    show_info_dialog(msg: string) is empty;
	//@non_standard
    windows:list of display_window;
	//@non_standard
    specman_command(cmd: string) is empty;
};


'>

<'

//@non_standard
struct do_request like driver_request {

   // @non_standard
   abort(item_not_sent: bool) is empty;

   // @non_standard
   do_granted() is empty;

   // @non_standard
   do_print_full_form() is empty;

   // @non_standard
   get_parent(): any_sequence is empty;

   // @non_standard
   is_aborted(): bool is empty;

   // @non_standard
   is_descendant_of(prod: base_struct): bool is empty;
   // NOTE prod is actually item_producer, leave it for now

   // @non_standard
   is_waiting_for_item(): bool is empty;

   // @non_standard
   item_done_received() is empty;

};

'>

<'

//@non_standard
struct driver_request {

   // @non_standard
   is_relevant(): bool is empty;

};

'>

<'

// Define DUT error response.
struct dut_error_struct {

   message : string;

   // Returns the check effect of that DUT check, for example, ERROR_AUTOMATIC.
   check_effect(): check_effect is empty;

   // @non_standard
   compose_dut_msg():string is empty;

   // Returns the additional text created by the optional action block.
   // If this dut_error has no action block, it returns an empty list.
   get_action_block_text(): list of string is empty;

   // Returns the name of the check in which this dut_error resides.
   // If there is no check action, or if the check is unnamed, it returns an empty string.
   get_check_name(): string is empty;

   // Returns the message that was defined by the temporal or data DUT check and is printed by dut_error_struct.write().
   get_message(): string is empty;
   
   // @non_standard
   get_name(): string is empty;
   
   // @non_standard
   issue_the_dut() is empty;

   // The first method that is called when a DUT error occurs, unless the check effect is IGNORE.
   // This method is defined as empty, unless extended by the user.
   // Extending this method lets you modify error handling for a particular instance or set of instances of a DUT error.
   pre_error() is empty;

   // Sets the check effect in this instance of the dut_error_struct.
   // You can call this method from pre_error() to change the check effect of selected checks.
   set_check_effect(effect: check_effect) is empty;

   //  Returns a reference to the struct where the temporal or data DUT check is defined.
   source_location(): string is empty;

   // Returns a string giving the name of the method containing the DUT data check, for example, 'done()'.
   source_method_name(): string is empty;

   // Returns the message that was defined by the temporal or data DUT check and is printed by dut_error_struct.write().
   source_struct(): any_struct is empty;

   // Returns a string giving the name of the source struct, for example, 'packet'.
   source_struct_name(): string is empty;

   // The method that is called after dut_error_struct.pre_error() is called when a DUT error happens.
   // This method causes the DUT message to be displayed, unless the check effect is IGNORE.
   // You can extend this method to perform additional actions.
   write() is empty;

};

'>

<'
// e Linting with HAL - 2.1 APIs for Specman Standalone and HAL Usage

// The predefined struct entity_reference is used to represent entity references in the code. An entity reference is any reference in the source code to an entity that has been declared elsewhere in the code. Such entities are represented in the reflection API by rf_named_entity objects. An entity_reference object provides information on what entity is being referenced, in what source module, and at which source line. Some entity_reference objects also provide the exact context of the reference--that is, inside which definition element (represented by rf_definition_element reflection object) the reference occurs.
// For example, if a field access takes place inside some method, it will be represented by an entity_reference object which provides the rf_method representation of the called method, the source module and line in which the field access takes place, and the rf_method_layer representation of the layer inside which the field access takes place.
// In addition, some entity references are extensions. For example, when a method is extended by is only or is also, this is also considered an entity reference. In this case, the corresponding entity_reference object will provide the information that the reference is an extension.
struct entity_reference {


   // Returns the entity being referenced. For example, for a field access the reflection representation of the field (of type rf_field) is returned.
   get_entity(): rf_named_entity is empty;


   // Returns the definition element in the context of which the reference takes place. For example, for a field access that takes place inside a method body, the reflection representation of the corresponding method layer (of type rf_method_layer) is returned.
   // Not all references have a corresponding context definition element. In some cases get_context() returns NULL. The table below, in particular, specifies which kinds of references have a context in their entity_reference representation and which do not.
   get_context(): rf_definition_element is empty;


   // Returns the source module in which the reference appears.
   get_source_module(): rf_module is empty;


   // Returns the source line in which the reference appears.
   get_source_line_num(): int is empty;


   // Returns TRUE if the reference is an extension (e.g., a method extension); otherwise, FALSE (e.g., a method call).
   is_extension(): bool is empty;

};

'>

<'

// @non_standard
unit foreign_component_proxy {

};

'>

<'

// @non_standard
struct handle_info like any_struct {

   // @non_standard
   kind: epi_uvm_object_type;

   // @non_standard
   full_path: string;

   // @non_standard
   item: any_struct;

   // @non_standard
   name: string;

   // @non_standard
   registers_children: list of uint;

};

'>

<'

// The hdl_assertion struct provides methods that let you specify, query, and control HDL assertion instances.
// An instance of this struct represents a single assertion.
// <br>The hdl_assertion struct is the base class for any HDL assertions on which you want to register a callback.
// Multiple callbacks can be registered to an hdl_assertion.
// You create assertion instances of type hdl_assertion by using the methods of assert_mgr,
//  a predefined instance of the hdl_assertions_mgr struct.
struct hdl_assertion {

   // Disables assertion checking in the simulator for this OVL_V2 assertion.
   // This method is not supported for OVL_V1 assertions.
   disable_assertion() is empty;

   // An hdl_assertion instance method; enables assertion checking in the simulator for this OVL_V2 assertion.
   // This method is not supported for OVL_V1 assertions.
   enable_assertion() is empty;

   // Returns ANY, SUCCESS, or FAILURE.
   // <br><b>Note</b>: For OVL, only the FAILURE reason is supported.
   get_cb_reason(): HDL_ASSERTION_CB_REASON is empty;

   // Returns 1 when the assertion is enabled, or 0 if the assertion is disabled.
   get_enable(): bool is empty;

   // Returns the integer number of failures that have occurred for this assertion at the current simulation time.
   get_failure_count(): int is empty;

   // Returns the name of the file in which the assertion is defined.
   get_file_name(): string is empty;

   // Returns NONE, ANY_LANG, OVL_V1 (Open Verification Language Version 1.x), OVL_V2 (Open Verification Language Version 2.x), SVA, or PSL.
   // It can also return OVL, for OVL_V1 and/or OVL_V2.
   get_hdl_lang(): HDL_ASSERTION_LANGUAGE is empty;

   // Returns the instance name of the assertion.
   get_instance_name(): string is empty;

   // Returns the exact instance name of the assertion as an HDL hierarchical path. For example:
   // <br>top.memtest1.mem8x256.ovl_always
   get_instance_path(): string is empty;

   // Returns the number of the line on which the assertion is defined.
   get_line_number(): int is empty;

   // Returns the assertion associated text.
   // <br><b>Note</b>: For SVA and PSL, this value is always NULL.
   get_msg(): string is empty;

   // Returns the assertion associated text.
   // <br><b>Note</b>: For SVA and PSL, this value is always NULL.
   get_severity_level(): HDL_ASSERTION_SEVERITY_LEVEL is empty;

   // Returns the number of times this assertion completed successfully, as of the current simulation time.
   // <br><b>Note</b>: Supported for SVA and PSL.
   get_success_count(): int is empty;

   // Registers this assertion with the assert_cb instance for reason = FAILURE.
   register_cb(assert_cb: hdl_assertion_cb) is empty;

   // Registers this assertion with the assert_cb instance, and executes the callback when the assertion enters a specific state:
   // <br>SVA--The supported reasons are SUCCESS, FAILURE, and ANY.
   // <br>PSL--The supported reasons are SUCCESS, FAILURE, and ANY.
   // <br>OVL--The supported reason is FAILURE.
   register_cb_reason(assert_cb: hdl_assertion_cb, reason: HDL_ASSERTION_CB_REASON) is empty;

   // A method of hdl_assertion. Removes the callback registration for the specified assertion.
   remove_all_cb() is empty;

   // A method of hdl_assertion. Removes the callback registration of the assert_cb instance from the specified assertion.
   remove_cb(assert_cb: hdl_assertion_cb) is empty;

   // @non_standard
   get_cb_handles() : list of hdl_assertion_cb is empty;
   // @non_standard
   get_is_occurred_in_this_cycle() : bool is empty;
   // @non_standard
   set_is_occurred_in_this_this_cycle() is empty;
   // @non_standard
   get_current_reason() : HDL_ASSERTION_CB_REASON is empty;
   // @non_standard
   set_current_reason(current_reason : HDL_ASSERTION_CB_REASON) is empty;
   // @non_standard
   get_adapter_id() : int is empty;
   // @non_standard
   get_type() : HDL_ASSERTION_TYPE is empty;
   // @non_standard
   emit_cb() is empty;
   // @non_standard
   emit_async_cb(async_cbs : list of hdl_assertion_cb) is empty;
   // @non_standard
   has_callbacks() : bool is empty;
   // @non_standard
   has_reason_cb(reason : HDL_ASSERTION_CB_REASON) : bool is empty;
   // @non_standard
   get_reason_cb() : HDL_ASSERTION_CB_REASON is empty;
   // @non_standard
   is_cb_exists(cb : hdl_assertion_cb) : bool is empty;
   // @non_standard
   check_exists_and_remove(cb : hdl_assertion_cb) : bool is empty;
   // @non_standard
   remove_reason_cb(reason : HDL_ASSERTION_CB_REASON) is empty;
   // @non_standard
   remove_the_cb(cb_to_remove : hdl_assertion_cb, remove_from_cb_list : bool) is empty;
   // @non_standard
   remove_assertion_cb(reason : HDL_ASSERTION_CB_REASON) is empty;
   // @non_standard
   restore_assertion() is empty;
   // @non_standard
   set_cbs_to_be_fired_in_this_cycle() is empty;

};

// An abstract struct called hdl_assertion_cb provides a method that you can use to define a function
//  that executes when an assertion instance fires. You derive your callback struct from hdl_assertion_cb,
//  and implement a callback method that will be executed whenever an assertion fires.
struct hdl_assertion_cb {

   // Specifies the callback method to execute when HDL assertion instances fire.
   // The assert_insts value is the assertion registered to this callback.
   // You can get the reason for the callback by calling assertion.get_cb_reason().
   callback(assert_insts: hdl_assertion) is empty;

   // Removes all hdl_assertion instances that were registered with the specified callback.
   remove_cb() is empty;

   //@non_standard
   set_should_fire_in_this_cycle(assert : hdl_assertion, should_fire_in_this_cycle : bool) is empty;
   //@non_standard
   get_associatied_assertions() : list of hdl_assertion is empty;
   //@non_standard
   get_should_fire_in_this_cycle(assert : hdl_assertion) : bool is empty;
   //@non_standard
   get_register_reason() : HDL_ASSERTION_CB_REASON is empty;
   //@non_standard
   set_register_reason(register_reason : HDL_ASSERTION_CB_REASON) is empty;
   //@non_standard
   set_sync_mode(sync_mode : HDL_ASSERTION_CB_SYNC_MODE) is empty;
   //@non_standard
   is_sync() : bool is empty;
   //@non_standard
   is_async() : bool is empty;
   //@non_standard
   add_assertion(assertion : hdl_assertion) is empty;

//FIXME@non_standard
//   get_cb_assert_by_assert(assert : hdl_assertion) : cb_assertion is empty;

};

// The assert_mgr instance of the hdl_assertions_mgr struct provides methods that let you define assertion instances as hdl_assertion types,
//  and register callbacks on them.
struct hdl_assertions_mgr {

   // Registers a callback with the assertions that match the asserts input string.
   // Returns the number of matching assertions.
   // This method looks for assertions in any supported language.
   // <br><b>Note</b>: This method registers a callback for assertion failures only.
   // To register a callback for a specific reason, use register_regexp_cb().
   add_cb(asserts: string, cb_instance: hdl_assertion_cb) : int is empty;

   // Registers a value change callback with an assertion list.
   // Takes a list of assertions--for example, the return value of find_assertions()--and registers them to a single callback instance.
   // <br>asserts is a list of hdl_assertion instances.
   // <br>cb_instance is the instance of a callback struct that inherits from the hdl_assertion_cb struct.
   // <br>A callback instance can be registered only once on an assertion.
   // <br><b>Note</b>: This method registers a callback for assertion failures only.
   // To register a callback for a specific reason, use register_asserts_cb().
   add_cb_to_assertions(asserts: list of hdl_assertion, cb_instance: hdl_assertion_cb) is empty;

   // An assert_mgr method; disables all of the assertions in the list.
   disable_assertions(asserts: list of hdl_assertion) is empty;

   // Returns all of the assertions that have been found in the design so far.
   // It contains the results of any of the find_* methods that have been used in the current run.
   get_assertions() : list of hdl_assertion is empty;

   // Enables all of the assertions in the list.
   enable_assertions(asserts: list of hdl_assertion) is empty;

   // The find_assertions method can use either a specific instance name or a regular expression to find a group of assertions.
   // When this method is called, Specman traverses the DUT and looks for matching assertion instances.
   // <br>inst-or-exp is either an assertion instance name, or an AWK- or Specman-style regular expression.
   // If no matching assertions are found, the list is empty.
   // If the input string is NULL or *, the list will contain an hdl_assertion for every supported assertion in the design.
   // <br>This method looks for assertion for any supported language.
   // If there is more than one assertion language in the design, it finds them all.
   // If you want to find a specific assertion language, use the find_lang_assertions() method.
   // <br><b>Tip</b>:Because this method accesses the design to search for matching assertions,
   //  it might traverse the entire design when you give it a regular expression.
   // For better performance, it is best to minimize usage of regular expressions, and to call this method before starting the simulation run.
   find_assertions(inst_or_exp: string) : list of hdl_assertion is empty;

   // Finds a group of assertions written in a specific language. HDL_ASSERTION_LANGUAGE can be ANY_LANG, OVL_V1, OVL_V2, OVL
   //  (either OVL_V1 and/or OVL_V2), PSL, or SVA.
   // When this method is called, Specman traverses the DUT and looks for matching assertion instances.
   find_lang_assertions(assert_lang: HDL_ASSERTION_LANGUAGE, inst_or_exp: string): list of hdl_assertion is empty;

   // Registers a value change callback with the assertions that match the asserts input list and that fire for the given reason.
   // <br>HDL_ASSERT_CB_REASON--FAILURE for OVL, SUCCESS, FAILURE, or ANY for SVA and PSL.
   register_asserts_cb(asserts: list of hdl_assertion, cb_instance: hdl_assertion_cb, reason: HDL_ASSERTION_CB_REASON) is empty;

   // Registers this assertion with the assert_cb instance for reason = FAILURE.
   register_cb(assert_cb: hdl_assertion_cb) is empty;

   // Registers this assertion with the assert_cb instance, and executes the callback when the assertion enters a specific state:
   //  SVA—The supported reasons are SUCCESS, FAILURE, and ANY.
   // PSL—The supported reasons are SUCCESS, FAILURE, and ANY.
   // OVL—The supported reason is FAILURE.
   register_cb_reason(assert_cb: hdl_assertion_cb, reason: HDL_ASSERTION_CB_REASON) is empty;

   // Registers a callback with the assertions that match the reg-exp-asserts input string and the specified assertion language,
   //  and that fire for the given reason. Returns the number of matching assertions.
   // <br>HDL_ASSERT_CB_REASON--FAILURE for OVL, SUCCESS, FAILURE, or ANY for SVA or PSL.
   // <br>HDL_ASSERTION_LANG--ANY_LANG, OVL_V1, OVL_V2, OVL, SVA, or PSL.
   register_regexp_cb(regexp_asserts: string, cb_instance: hdl_assertion_cb, reason: HDL_ASSERTION_CB_REASON, language: HDL_ASSERTION_LANGUAGE) : int is empty;

   //@non_standard
   has_callbacks(assertion : hdl_assertion, reason : HDL_ASSERTION_CB_REASON) : bool is empty;
   //@non_standard
   get_callbacks_reason(assertion : hdl_assertion) : HDL_ASSERTION_CB_REASON is empty;
   //@non_standard
   assert_cb_occurred(assert_handle : external_pointer, reason : HDL_ASSERTION_CB_REASON) is empty;
   //@non_standard
   disable_enable_assert_cb_occurred(assert_handle : external_pointer, enable : bool) is empty;
   //@non_standard
   is_match_reg_exp(instance_path : string, reg_exp : string) : bool is empty;
   //@non_standard
   is_str_reg_exp(str : string) : bool is empty;
   //@non_standard
   get_assert_by_name(instance_full_path : string) : hdl_assertion is empty;
   //@non_standard
   get_assert_by_handle(assert_handle : external_pointer) : hdl_assertion is empty;
   //@non_standard
   add_assertion_no_check(assertion : hdl_assertion) is empty;
   //@non_standard
   emit_pending_assertions() is empty;
   //@non_standard
   search_assert_supported_adapters() is empty;
   //@non_standard
   get_adapter_assertions(adapter_id : int) : list of hdl_assertion is empty;
   //@non_standard
   restore_hdl_assertions() is empty;
   //@non_standard
   restore_handle_list(assertion : hdl_assertion) is empty;

//FIXME@non_standard
//   remove_assertions_cb(adapter : sn_adapter_bridge) is empty;

};

'>

<'

// ---
// Files
// ---

struct file {

   // @non_standard
   mode: string;

   // Name of the file.
   name : string;

   // @non_standard
   position: uint;

   // @non_standard
   role: string;

   // @non_standard
   was_restored: bool;
   
   // @non_standard
   cfile: C_file;

};

// The global struct named files contains predefined routines for working with files.
struct files {

   // [files routine] Returns a string holding the file name.
   add_file_type(file_name: string, file_ext: string, exists: bool): string is empty;

   // [files routine] Close a file.
   close(file_handle : file) is empty;

   // @non_standard
   curr_full_dir() : string is empty;

   // @non_standard
   dir_exists(dir_name: string): bool is empty;

   // [files routine] Get a file’s modification date.
   file_age(file_name: string): int is empty;

   // [files routine] Append files.
   file_append(from_file_name: string, to_file_name: string) is empty;

   // @non_standard
   file_basename(file_name: string): string is empty;

   // [files routine] Create a copy of a file.
   file_copy(from_file_name: string, to_file_name: string) is empty;

   // [files routine] Delete a file.
   file_delete(file_name: string) is empty;

   // [files routine] Check if a file exists.
   file_exists(file_name: string): bool is empty;

   // [files routine] Get the extension of a file.
   file_extension(file_name: string): string is empty;

   // [files routine] Check if a file is a directory.
   file_is_dir(file_name: string): bool is empty;

   // [files routine] Check if a file is a symbolic link.
   file_is_link(file_name: string): bool is empty;

   // [files routine] Check if a file is readable.
   file_is_readable(file_name: string): bool is empty;

   // [files routine] Check if a file is a regular file (not a directory or link).
   file_is_regular(file_name: string): bool is empty;

   // [files routine] Check if a file is a temporary file.
   file_is_temp(file_name: string): bool is empty;

   // [files routine] Check if a file is a text file.
   file_is_text(file_name: string): bool is empty;

   // [files routine] Rename a file.
   file_rename(from_file_name: string, to_file_name: string) is empty;

   // [files routine] Get the size of a file.
   file_size(file_name: string): int is empty;

   // @non_standard
   files_matching(pattern: string): list of string is empty;

   // @non_standard
   find_full_name_in_snpath(fname: string, should_exist: bool): string is empty;

   // [files routine] Flush file buffers.
   flush(file_handle: file) is empty;

   // [files routine] This method looks for an existing log file by the given name, and flushes that file to the disk, much like the file.flush() method.
   // If no such log file exists, nothing is done.
   flush_log_file(file_name: string) is empty;
   
   // @non_standard
   get_date_time(): string is empty;

   // @non_standard
   get_temp_dir(): string is empty;

   // Reads lines from a text file from first line specified until the last line specified and returns the lines as a list of string after removing the final "\n".
   get_text_lines(file_name: string, first: int, last: int): list of string is empty;

   // @non_standard
   make_dir(dir_name: string, b: bool): uint is empty;

   // [files routine] Create a unique temporary file name.
   new_temp_file(): string is empty;

   // [files routine] Open a file for reading or writing or both.
   open(file_name: string, mode: string, file_role: string): file is empty;

   // [files routine] Read an ASCII line from a file.
   read(file_handle: file, string_var: *string): bool is empty;

   // [files routine] Read ASCII file data into a struct.
   read_ascii_struct(file_name: string, struct_name: string): base_struct is empty;

   // [files routine] Read the contents of a binary file into a struct.
   read_binary_struct(file_name: string, struct_name: string, check_version: bool): base_struct is empty;

   // [files routine] Reads data from a binary file into a list of bits and puts the bits into the list passed as a parameter.
   read_into_lob(file_handle: file, size_in_bits: int, result_list: list of bit) is empty;

   // [files routine] Read from a binary file into a list of bits.
   read_lob(file_handle: file, size_in_bits: int): list of bit is empty;

   // [files routine] Write a string to file.
   write(file_handle: file, text: string) is empty;

   // [files routine] Write the contents of a struct to a file in ASCII format.
   write_ascii_struct(file_name: string, struct_instance: base_struct, comment: string, indent: bool, depth: int, max_list_items: int) is empty;

   // [files routine] Write the contents of a struct to a file in binary format.
   write_binary_struct(file_name: string, struct_instance: base_struct) is empty;

   // [files routine] Write a list of strings to a file.
   write_compressed_string_list(file_name: string, strings: list of string) is empty;

   // [files routine] Write a list of bits to a binary file.
   write_lob(file_handle: file, bit_list: list of bit) is empty;

   // [files routine] Write a list of strings to a file.
   write_string_list(file_name: string, strings: list of string) is empty;

   // [files routine] writef(file_handle: file, format: string, item:exp, ...)
   // Write to a file in a specified format.
   writef(file_handle: file, format: string, __dvt_variable_nof_args) is empty;

};

'>

<'

// @non_standard
unit foreign_component_proxy {

};

'>

<'

// A global singleton object, which encapsulates the functionality of performing user-defined linting analysis and reporting.
struct lint_manager {

   // You can extend this predefined method to perform the actual linting analysis and reporting.
   // This method is automatically called by Specman at the end of compilation, when running in HAL or lint mode.
   // In order to report detected issues, the other API methods, described below, should be called from within this method extension.
   user_analysis() is empty;


   // This method should be called within the user_analysis() method in order to produce the actual messages in HAL to report about a detected issue.
   // The provided source_obj is used in order to add the correct source file and line information to the message.
   // This parameter is optional with the default value NULL.
   // Therefore, if the message does not contain source information, it needs not to be passed.
   notify(
      // The rule id to appear in the message
      id: lint_rule_id,
      // The string text to appear in the message
      message: string,
      // A reflection object, used to extract the source line and module information for the message
      source_obj: rf_definition_element = NULL
   ) is empty;


   // This method is similar to notify(), except that it gets the source file name and line number directly, not through a reflection object.
   // It is recommended to use notify(), where applicable. notify_at() should be used in situations when a reflection object is unavailable.
   // For example, the user analysis is not done using reflection but directly on the source file text,
   //  or when the analysis is done on a file which is not an e module (for example, a PACKAGE_README.txt file).
   // Using notify_at() where notify() is applicable has certain limitations.
   // For example, notify_at() does not allow the macro filtering to work properly on the message if:
   // * the reflection object that triggers the message is defined in a macro
   // * the macro definition file is filtered out (see Using the Design Information File section in e Linting with HAL for the details about macro filtering).
   // The message filters only when the reflection object is passed directly to notify().
   notify_at(
      // The rule id to appear in the message
      id: lint_rule_id,
      // The string text to appear in the message
      message: string,
      // A string containing the full source file name to be reported in the message
      source_file: string,
      // The source line number to be reported in the message
      source_line: int) is empty;



   // Returns the string value of the parameter of the given linting rule.
   // If the rule has no associated parameter with the given name, an error message is produced.
   // However, it is not mandatory for the parameter to have been defined directly in e code (using the lint_rule_param statement)
   // if it is defined in the HAL rules file.
   // A parameter definition or change done in the HAL rules file overrides the change done directly in e.
   get_param_value(
      // The linting rule id
      id: lint_rule_id,
      // The name of a linting rule parameter
      param_name: string)
   : string is empty;


   // This method is used when a linting rule parameter value needs to be treated as a number rather than as a string.
   // It is similar to get_param_value(), except that the string value is automatically converted to an integer.
   // If the string does not contain an integer value, an error message is produced.
   get_param_numeric_value(
      // The linting rule id
      id: lint_rule_id,
      // The name of a linting rule parameter
      param_name: string)
   : int is empty;
   
   
   // This method returns all the entity references that take place in the currently loaded and compiled code, that conform to the filtering criteria specified by the method parameters.
   // When no parameters are specified, no filtering is applied and all entity references are returned.
   // Entity references from encrypted modules (except those encrypted in visible mode) are not included.
   get_all_entity_references(
      // Only references to the specified kinds of entities will be returned.
      // By default, when kinds is an empty list, all entity kinds are considered.
      kinds: list of entity_kind = {},
      // Only references to entities whose names match the pattern will be returned.
      // By default, when name_pattern is an empty string, all entities are considered.
      name_pattern: string = "",
      // Only references that take place in modules whose names match the pattern will be returned.
      // By default, when module_pattern is an empty string, all modules are considered.
      module_pattern: string = "",
      // By default, include_extensions is TRUE, all references will be returned, including extensions.
      // When include_extensions is FALSE, only non-extension references will be returned.
      include_extensions: bool = TRUE)
   : list of entity_reference is empty;
 
 
   // This method returns all the entity references to the specified entity that take place in the currently loaded and compiled code, that conform to the filtering criteria specified by the method parameters.
   // When no parameters other than the entity are specified, no filtering is applied and all references to the entity are returned.
   // Entity references from encrypted modules (except those encrypted in visible mode) are not included.
   // If entity is NULL, an empty list is returned.
   get_entity_references(
      // References to this entity will be returned.
      // This parameter should be the reflection representation of the entity.
      // For example, if references to a field are needed, the entity parameter should be of type rf_field.
      entity: rf_named_entity,
      // Only references that take place in modules whose names match the pattern will be returned.
      // By default, when module_pattern is an empty string, all modules are considered.
      module_pattern: string = "",
      // By default, include_extensions is TRUE, all references will be returned, including extensions.
      // When include_extensions is FALSE, only non-extension references will be returned.
      include_extensions: bool = TRUE)
   : list of entity_reference is empty;


   // This method returns all the entity references to the specified entity that take place in the specified context, for example inside the specified method layer body.
   // If entity or context is NULL, an empty list is returned.
   // Only reference kinds for which a context is included in the entity_reference object (according to the table above) are considered.
   // For example, if the entity is a field, only field access expressions are considered.
   // Other field references are not considered even if they happen to appear inside the same context.
   get_entity_references_in_context(
      // A context definition element.
      // This parameter should be the reflection representation of the context layer inside which the needed entity references take place.
      // For example, if references that takes place inside a given method layer are needed, the context parameter should be of type rf_method_layer.
      context: rf_definition_element,
      // References to this entity will be returned.
      // This parameter should be the reflection representation of the entity.
      // For example, if references to a field are needed, the entity parameter should be of type rf_field.
      entity: rf_named_entity)
   : list of entity_reference is empty;


   // This method returns all the entity references that take place in the specified context (for example inside the specified method layer body) to entities of the specified kinds.
   // If the kinds list is empty, all entity kinds are considered.
   // If context is NULL, an empty list is returned.
   // Only reference kinds for which a context is included in the entity_reference object (according to the table above) are considered.
   // For example, for field entities, only field access expressions are considered.
   // Other field references are not considered even if they happen to appear inside the same context.
   get_all_entity_references_in_context (
      // A context definition element.
      // This parameter should be the reflection representation of the context layer inside which the needed entity references take place.
      // For example, if references that takes place inside a given method layer are needed, the context parameter should be of type rf_method_layer.
      context: rf_definition_element,
      // Only references to the specified kinds of entities will be returned.
      // By default, when kinds is an empty list, all entity kinds are considered.
      kinds: list of entity_kind = {})
   : list of entity_reference is empty;
   
};

'>

<'

// ---
// Locker
// ---

// A locker is useful when a single entity needs to prevent others from a shared resource.
// lock() and free() must be issued by the same entity.
// You could implement the locker functionality with a semaphore by initializing the semaphore count to 1,
//  then changing all locker.lock() to semaphore.down() and all locker.free() to semaphore.up().
struct locker {

   // @non_standard
   cur_locker_id: int;

   // @non_standard
   locking_counter: uint;

   // The first TCM to call the lock() method of a field of type locker gets the lock and can continue execution.
   // The execution of the other TCMs is blocked.
   lock() is empty;

   // When a TCM that has the lock calls free(), control goes to the next TCM serviced by the scheduler that is waiting on the locker.
   // The order in which the lock is granted is by a FIFO (First In First Out) order of client lock() requests.
   free() is empty;

   // @non_standard
   release() is empty;

   // @non_standard
   unlock() is empty;

};

'>

<'

// ---
// Message Logger
// ---

// The instances of this type represent message actions that occur at run time.
// They provide information on the message action through the methods described above.
// It is useful when you extend the predefined "create_formatted_message()" method.
struct message_action like base_struct {

   // Returns the format being used for this message.
   get_format() : message_format is empty;

   // Returns the unique number identifying this message action.
   get_id() : int is empty;

   // Returns the method layer in which this message action resides.
   get_source_method_layer() : rf_method_layer is empty;

   // Returns the line number in which this message action resides.
   get_source_line_num() : int is empty;

   // Returns the actual struct instance that issued the message.
   get_source_struct() : any_struct is empty;

   // Returns the current style setting for this message.
   get_style() : vt::vt_style is empty;

   // Returns the tag of this message.
   get_tag() : message_tag is empty;

   // Returns a properly formatted string for the current value of sys.time.
   get_time() : string is empty;

   // Returns the verbosity of this message.
   get_verbosity() : message_verbosity is empty;

};

// A message logger is a predefined unit, whose job is to manage the output from message actions
// (filtering it, formatting it, and sending it to one or more destinations).
unit message_logger {

   //@non_standard
   actions: list of sn_message_action;

   // Sets the base unit.
   base_unit: any_unit;

   format: message_format;

   // @non_standard
   flush_frequency: int;

   // The modules wildcard for selecting the actions for the logger.
   modules: string;

   // Name of the message logger.
   name:string;

   // The pattern to match against the string in the message action.
   string_pattern: string;

   // The message tags for selecting the actions for this logger.
   tags: list of message_tag;

   // The file name to which the logger writes (or none if the setting is " ").
   // Default extension for the file name is ".elog".
   to_file: string;

   // When set to TRUE, the logger also writes any output to the screen.
   to_screen: bool;

   // The verbosity for selecting the actions for the logger.
   verbosity: message_verbosity;

   // [message_logger hook routine] Return TRUE if the current message should be enabled. By default returns TRUE, but you can set it to FALSE when you want to ignore the logger
   // messages and block all of the logger destinations.
   accept_message():bool is empty;

   // Specifies the tags to be allocated to the specified logger(s).
   allocate_tags(new_tag: list of message_tag) is empty;

   configure_according_to_fields() is empty;

   // [message_logger hook routine] Returns the list of string, which will be sent as-is to the file or screen (Specman will add a '\n' at the end of each string when printing
   // them to the file/screen). If you want an extra empty line at the end, add a '\n' to the last string. By default, this method obeys the current
   // format as described in the manual, but you can add more formats or change the meaning of the existing formats.
   format_message():list of string is empty;

   // Return the vt_style for the current message action.
   get_action_style(): vt::vt_style is empty;

   // Get message’s format.
   get_format():message_format is empty;

   // Get the current raw message.
   get_message():list of string is empty;

   // Get the message ID.
   get_message_action_id():int is empty;

   // Get a message’s tag.
   get_tag():message_tag is empty;

   // Returns the tags currently recognized by the logger.
   get_tags(): list of message_tag is empty;

   // @non_standard
   get_time(): string is empty;

   // Get a message’s verbosity.
   get_verbosity():message_verbosity is empty;

   // Ignore the specified tags.
   ignore_tags(tags:list of message_tag) is empty;

   // Add, remove, or replace the specified actions for the logger.
   set_actions(verbosity: message_verbosity, tags: list of message_tag, modules: string, text: string, op: message_operation) is empty;

   // Add a file to or remove a file from the specified logger.
   set_file(fname: string, verbosity_switch: message_on_off) is empty;

   // @non_standard @deprecated
   // Set the message flushing frequency of each message output file associated with the logger.
   set_flush_frequency(flush_frequency: int) is empty;

   // Set the format for messages associated with the message logger.
   set_format(format: message_format) is empty;

   // Set the specified messages’ actions as leaders or non-leaders.
   set_leader(verbosity: message_verbosity, tags: list of message_tag, modules: string, text: string, status: message_on_off) is empty;

   // Enable or disable the logger from writing to the screen.
   set_screen(verbosity_switch: message_on_off) is empty;

   // Sets the specified actions to the requested style (for example, green).
   set_style(verbosity: message_verbosity, tags: list of message_tag, modules: string, text: string, style: vt::vt_style) is empty;

   set_trans(verbosity_switch: message_on_off) is empty;

   // Set the unit tree under a specified unit to be on or off for the message logger.
   set_units(root: any_unit, verbosity_switch: message_on_off) is empty;

   //@non_standard
   set_wave_db(status: message_on_off, filename: string = "") is empty;

   // This method shows information for the specified logger(s).
   show_message(all: bool, full: bool) is empty;

   // This method shows all message actions matching filter (default: all message actions).
   show_actions(verbosity: message_verbosity, tags: list of message_tag, modules: string, text: string) is empty;

   // This method shows as a tree all unit instances under exp (default: all unit instances).
   show_units(root: any_unit) is empty;

   // Get the message’s location.
   source_location():string is empty;

   // Get the method name for the current message.
   source_method_name():string is empty;

   // Get the message’s source struct.
   source_struct():any_struct is empty;

   // Get a message’s struct type-name.
   source_struct_name():string is empty;

};

// Contains methods that are used for modifying message settings and formats.
struct message_manager like base_struct {

   // This method belongs to the message_manager predefined type. It modifies messages that will/will not be sent to log files.
   // This method selects which messages from the unit and its subtree with the specified tag will be sent to the specified log files.
   // The selection is done according to the verbosity, modules, and text-pattern parameters.
   set_file_messages(
      // Log file to which the new setting will be applied.
      file_name: string,
      // Unit to which the new setting will be applied.
      root_unit : any_unit,
      // Message tag to which the new setting applies. The new setting will only affect messages of the specified tag.
      tag : message_tag,
      // Highest verbosity level for messages. A given message is issued to the transaction only if its verbosity is equal to or lower than the specified verbosity.
      // Valid values are: NONE, LOW, MEDIUM, HIGH, and FULL.
      verbosity : message_verbosity,
      // String pattern used for matching module names (wild cards permitted).
      // A given message is issued to the transaction only if it is defined in the specified module(s).
      // Default value is "*" which matches any module name.
      modules : string = "*",
      // String pattern used for matching the message text (default = "..." which matches any string)
      // A given message is issued to the transaction only if its message string matches the specified text-pattern string.
      // For SDMs, the ID string is considered as the message string for this purpose.
      text_pattern : string = "...",
      // Recursion indicator (default = TRUE):<br>
      // * If TRUE, the new setting will apply to all units in the unit subtree under the given unit.<br>
      // * If FALSE, the new setting will apply to the given unit instance only, and will not apply to other units in its unit subtree.
      rec : bool = TRUE) is empty;

   // This method belongs to the message_manager predefined type. It modifies messages that will/will not be sent to log files.
   // This method disables the sending of messages with the specified tag to the log files.
   set_file_messages_off(
      // Log file to which the new setting will be applied.
      file_name: string,
      // Unit to which the new setting will be applied.
      root_unit : any_unit,
      // Message tag to which the new setting applies. The new setting will only affect messages of the specified tag.
      tag : message_tag,
      // Recursion indicator (default = TRUE):<br>
      // * If TRUE, the new setting will apply to all units in the unit subtree under the given unit.<br>
      // * If FALSE, the new setting will apply to the given unit instance only, and will not apply to other units in its unit subtree.
      rec : bool = TRUE) is empty;

   // Sets the flush frequency for the specified message file.
   set_flush_frequency(
      // Name of an existing message file. If no extension is given, the extension .elog is appended automatically.
      file_name: string,
      // New flush frequency. This value must be a positive number.
      new_frequency: int) is empty;

   // This method belongs to the message_manager predefined type.
   // It modifies the format of messages with the specified tag when sending them to the specified text destination(s) by the specified unit or unit subtree.
   set_message_format(
      // Unit to which the new format setting will be applied.
      root_unit : any_unit,
      // Message tag to which the new format setting applies. The new setting will only affect messages of the specified tag.
      tag : message_tag,
      // List of file names to which the new format settings will be applied. An empty string in the list denotes the screen. If the entire list is empty, the new settings will be applied to all text destinations.
      file_names : list of string,
      // Format to be used for messages. Valid predefined values: none, short, and long. You can also specify a user-defined value that was added by extending the message_format type.
      format : message_format,
      // Recursion indicator (default = TRUE):<br>
      // * If TRUE, the new setting will apply to all units in the unit subtree under the given unit.<br>
      // * If FALSE, the new setting will apply to the given unit instance only, and will not apply to other units in its unit subtree.
      rec : bool = TRUE) is empty;

   // This method belongs to the message_manager predefined type.
   // It modifies the text color of messages, when they are sent to screen.
   // This setting is done globally on the selected message actions, and not per unit instance or subtree.
   set_message_style(
      // Color name to be applied to the selected messages.
      style : vt::vt_style,
      // Message tag of the messages to which the new color setting will be applied.
      tag : message_tag,
      // Highest verbosity level for application of the new color setting. The new color setting will be applied to selected messages having the specified verbosity level or lower.
      // Default = FULL.Valid values are LOW, MEDIUM, HIGH, and FULL.
      verbosity : message_verbosity = FULL,
      // Module name(s). Can be a string pattern with wild cards.
      // The new color setting will be applied only to selected messages residing in the specified module(s).
      // Default value is "*" which matches any module name.
      modules : string = "*",
      // String pattern used for matching the message text (default = "..." which matches any string).
      // The new color setting will be applied only to selected messages whose text contains a match to the specified string pattern.
      // For SDMs, the ID string is considered as the message string for this purpose.
      text_pattern : string = "...") is empty;

   // This method belongs to the message_manager predefined type. It modifies messages that will/will not be sent to the screen (and the main log file).
   // This method selects which messages from the unit and its subtree with the specified tag will be sent to the screen (and main log file).
   // The selection is done according to the verbosity, modules, and text-pattern parameters.
   set_screen_messages(
      // Unit to which the new setting will be applied.
      root_unit : any_unit,
      // Message tag to which the new setting applies. The new setting will only affect messages of the specified tag.
      tag : message_tag,
      // Highest verbosity level for messages. A given message is issued to the screen only if its verbosity is equal to or lower than the specified verbosity.
      // Valid values are: NONE, LOW, MEDIUM, HIGH, and FULL.
      verbosity : message_verbosity,
      // String pattern used for matching module names (wild cards permitted).
      // A given message is issued to the screen only if it is defined in the specified module(s).
      // Default value is "*" which matches any module name.
      modules : string = "*",
      // String pattern used for matching the message text (default = "..." which matches any string).
      // A given message is issued to the screen only if its message string matches the specified text-pattern string.
      // For SDMs, the ID string is considered as the message string for this purpose.
      text_pattern : string = "...",
      // Recursion indicator (default = TRUE):<br>
      // * If TRUE, the new setting will apply to all units in the unit subtree under the given unit.<br>
      // * If FALSE, the new setting will apply to the given unit instance only, and will not apply to other units in its unit subtree.
      rec : bool = TRUE) is empty;

   // This method belongs to the message_manager predefined type. It modifies messages that will/will not be sent to the screen (and the main log file).
   // This method disable the sending of messages with the specified tag to the screen (and main log file).
   set_screen_messages_off(
      // Unit to which the new setting will be applied.
      root_unit : any_unit,
      // Message tag to which the new setting applies. The new setting will only affect messages of the specified tag.
      tag : message_tag,
      // Recursion indicator (default = TRUE):<br>
      // * If TRUE, the new setting will apply to all units in the unit subtree under the given unit.<br>
      // * If FALSE, the new setting will apply to the given unit instance only, and will not apply to other units in its unit subtree.
      rec : bool = TRUE) is empty;

   // This method belongs to the message_manager predefined type. It modifies messages that will/will not be recorded in the simulation database. It affects only certain kinds of SDMs.
   // This method selects which SDM transaction messages from the unit and its subtree with the specified tag will be sent to the simulation database.
   // The selection is done according to the verbosity, modules, and text-pattern parameters.
   set_transaction_messages(
      // Unit to which the new setting will be applied.
      root_unit : any_unit,
      // Message tag to which the new setting applies. The new setting will only affect messages of the specified tag.
      tag : message_tag,
      // Highest verbosity level for messages. A given message is issued to the transaction only if its verbosity is equal to or lower than the specified verbosity.
      // Valid values are: NONE, LOW, MEDIUM, HIGH, and FULL.
      verbosity : message_verbosity,
      // String pattern used for matching module names (wild cards permitted).
      // A given message is issued to the transaction only if it is defined in the specified module(s).
      // Default value is "*" which matches any module name.
      modules : string = "*",
      // String pattern used for matching the message text (default = "..." which matches any string)
      // A given message is issued to the transaction only if its message string matches the specified text-pattern string.
      // For SDMs, the ID string is considered as the message string for this purpose.
      text_pattern : string = "...",
      // Recursion indicator (default = TRUE):<br>
      // * If TRUE, the new setting will apply to all units in the unit subtree under the given unit.<br>
      // * If FALSE, the new setting will apply to the given unit instance only, and will not apply to other units in its unit subtree.
      rec : bool = TRUE) is empty;

   // This method belongs to the message_manager predefined type. It modifies messages that will/will not be recorded in the simulation database. It affects only certain kinds of SDMs.
   // This method disables the sending of messages with the specified tag to the simulation database.
   set_transaction_messages_off(
      // Unit to which the new setting will be applied.
      root_unit : any_unit,
      // Message tag to which the new setting applies. The new setting will only affect messages of the specified tag.
      tag : message_tag,
      // Recursion indicator (default = TRUE):<br>
      // * If TRUE, the new setting will apply to all units in the unit subtree under the given unit.<br>
      // * If FALSE, the new setting will apply to the given unit instance only, and will not apply to other units in its unit subtree.
      rec : bool = TRUE) is empty;

};

'>

<'

// @non_standard
struct ml_uvm {
    // Language-neutral connection of TLM ports in a multi-language environment.
    static connect_names(port_path: string, export_path: string) is empty;
};

//@non_standard
struct ml_ovm_config like any_struct {
    //@non_standard
    tlm_pass_field(field: rf_field) : bool is empty;
};

//@non_standard
struct ml_uvm_config like any_struct {
    //@non_standard
    tlm_pass_field(field: rf_field) : bool is empty;
};

'>

<'

// ---
// Packing
// ---

// To customize packing options, you can create an instance of the pack_options struct,
//   modify one or more of its fields, and pass the struct instance as the first parameter to pack(), unpack(),do_pack(), or do_unpack().
struct pack_options {

   // @non_standard
   level: pack_level;

   // If this flag is set to be FALSE, the fields in a struct are packed in the order they appear in the struct declaration;
   //  if TRUE, they are packed in reverse order. The default is FALSE.
   reverse_fields: bool;

   // If this flag is set to be FALSE, the items in a list are packed in ascending order;
   //  if TRUE, they are packed in descending order. The default is FALSE.
   reverse_list_items: bool;

   // You can perform one or more swap() operations on each scalar before packing using the scalar_reorder field.
   // The list in the scalar_reorder field must include an even number of items.
   // Each pair of items in the list is the parameter list of a swap() operation (see swap()).
   // By entering multiple pairs of parameters, you can perform multiple swaps, using each pair of parameters as a pair of swap parameters.
   // Unlike swap(), if the large parameter is not a factor of the number of bits in the list, scalar_reorder ignores it, while swap() gives an error.
   scalar_reorder: list of int;

   // After packing each element in the packing expression you can perform final swapping on the resulting bit stream, using the final_reorder field.
   // The list in the final_reorder field must include an even number of items.
   // Each pair of items in the list is the parameter list of a swap() operation (see swap()).
   // By entering multiple pairs of parameters, you can perform multiple swaps, using each pair of parameters as a pair of swap parameters.
   // Unlike swap(), if the large parameter is not a factor of the number of bits in the list, final_reorder ignores it, while swap() gives an error.");
   final_reorder: list of int;

};

// Packing and unpacking are controlled using a struct under global named packing.
// There are six predefined instances of the pack_options struct that you can use with or without modification
//  to control the way packing or unpacking is performed.
struct packing {

   // This pack_options instance traverses the source fields or variables in the order they appear in code,
   //  placing the least significant bit of the first field or list item at index [0] in the resulting list of bit.
   // The most significant bit of the last field or list item is placed at the highest index in the resulting list of bit.
   low: pack_options;

   // This pack_options instance, like packing.low, traverses the source fields or variables in the order they appear in code.
   // In addition, for every scalar field or variable, it swaps every byte in each pair of bytes and swaps every two bytes in each 32-bit word.
   // Note: If the scalar's width is not a multiple of 16, no swapping is performed.
   low_big_endian: pack_options;

   // This pack_options instance traverses the source fields or variables in the reverse order from the order in which they appear in code,
   //  placing the least significant bit of the last field or list item at index [0] in the resulting list of bit.
   // The most significant bit of the first field or list item is placed at the highest index in the resulting list of bit.
   high: pack_options;

   // This pack_options instance, like packing.high, traverses the source fields or variables in the reverse order from the order in which they appear in code.
   // In addition, for every scalar field or variable, it swaps every byte in each pair of bytes and swaps every two bytes in each 32-bit word.
   // Note: If the scalar's width is not a multiple of 16, no swapping is performed.
   high_big_endian: pack_options;

   // This pack_options instance, like packing.low, traverses the source fields or variables in the order they appear in code.
   // In addition, for every scalar field or variable, it swaps every byte in each pair of bytes and swaps every two bytes in each 32-bit word.
   // Note: If the scalar's width is not a multiple of 16, no swapping is performed.
   network: pack_options;

   // This pack_options instance is used when the first parameter of pack(), unpack(), do_pack(), or do_unpack() is NULL.
   // It has the same flags as packing.low.
   global_default: pack_options;
};

'>

<'

// @non_standard
struct params like sn_struct {

   // @non_standard
   seed: uint;

   // @non_standard
   random_policy: random_policy;

};

'>

<'

// @non_standard
unit parent_component_proxy like foreign_component_proxy {

};

'>

<'

// The recording_config struct encapsulates transaction recording configuration for a unit or for numerous units at once.
// The configuration is determined procedurally through API calls.
// The initialization of config objects and their assignment to units is typically performed before simulation starts
//  and remains constant throughout the run, but nothing in any of the API methods precludes changing the configuration dynamically.
struct recording_config like base_struct {

   // Defines all user-defined public fields to be recorded as transactions attributes for data-items of the specified type.
   // <br><b>Note:</b> Different sets of fields may be recorded for instances of different when/like subtypes of type_name.
   register_all_field_attributes(
      // Any struct type name, including "when" subtypes and template instances
      type_name: string
   ) is empty;

   // Defines an attribute for transactions of the specified type,
   //  the value of which is determined dynamically by the unit hook method "tr_get_attribute_value()".
   // Whenever a transaction of the given type needs to be sampled the hook method is invoked and the attribute name is written
   //  along with the returned value.
   // <br><b>Note:</b> The callback function must be implemented for every type in which such a message is called.
   // For example, assume it is implemented in the frame_monitor.
   // If an SDM with frame is called in a scoreboard, it would need to be implemented in the scoreboard as well.
   register_callback_attribute(
      // Any struct type name, including "when" subtypes and template instances
      type_name: string,
      // A list of field names declared for the struct
      attr_name: string
   ) is empty;

   // Defines a set of callback attributes for transactions of the specified type.
   // Calling this method is equivalent to calling "register_field_attribute()" for each of the given field names.
   register_callback_attributes(
      // Any struct type name, including "when" subtypes and template instances
      type_name : string,
      // A list of attributes names to be associated with the struct
      attr_names : list of string
   ) is empty;

   // Defines a state variable, the value of which is determined dynamically by the unit hook method "tr_get_state_var_value()" .
   // The value is sampled by calling the hook method upon the execution of msg_changed() when the scope unit is of the specified type.
   // Both name and the returned value are written to the message destination.
   // <br><b>Note:</b>Text destinations (screen and log files) require explicit additional setting to show the attribute (see "set_text_state_var()" ).
   register_callback_state_var(
      // A name of a unit type (including "when" subtypes and template instances).
      unit_name: string,
      // A legal identifier that will figure as the attribute name in the destination.
      var_name: string
   ) is empty;

   // Defines a mapping between messages with the specified id as argument and the waveform fiber name in which the resulting transactions should figure.
   // <br><b>Notes</b>
   // <br>* If no mapping for a given id is registered the id string itself is used as the waveform fiber name.
   // <br>* If multiple mapping rules are registered for the same id the one registered latest applies.
   // <br>* It is legal to map multiple id values to the same fiber name.
   register_fiber_mapping(
      // A string value that is used as id argument in structured messages.
      id_str: string,
      // The intended name for the waveform fiber.
      fiber_name: string,
      // A boolean value that controls whether transactions are to be shown with time overlaps on the given fiber. The default value for overlap is TRUE. If you call register_fiber_mapping() passing only two parameters (id_string and fiber_name), then overlap automatically takes the default value. Therefore, a transaction opened by msg_started() is not closed by default without a corresponding msg_ended() being emitted. This is very useful when recording information of transactions occurring in parallel, such as pipelined protocols. When the value is set to FALSE, transaction overlaps are not created, and the open transactions automatically end when the next msg_started() is called for the same fiber even if no msg_ended() has been emitted prior to that.
      overlap: bool = true
   ) is empty;

   // Defines the specified data item field to be recorded as a transaction attribute.
   // The field is sampled upon the execution of structured messages of certain kinds when given data-items of the specified type as parameters.
   // Both name and value of the attribute are written to the message destination.
   // By default this happens upon msg_started(), but other sampling points may be designated for a given attribute using the API call "set_text_attribute()".
   // <br><b>Note:</b> Text destinations (screen and log files) require explicit additional setting to show the attribute (see "set_attribute_sampling()" ).
   register_field_attribute(
      // Any struct type name, including "when" subtypes and template instances
      type_name: string,
      // A name of a field declared for the struct
      field_name: string
   ) is empty;

   // Defines a set of field attributes for transactions of the specified type.
   // Calling this method is equivalent to calling "register_field_attribute()" for each of the given field names.
   register_field_attributes(
      // Any struct type name, including "when" subtypes and template instances
      type_name: string,
      // A list of field names declared for the struct
      field_names: list of string
   ) is empty;


   // Defines the specified field to be recorded as a state variable.
   // The field is sampled upon the execution of msg_changed() when the scope unit is of the specified type.
   // Both name and value of the state variable are written to the message destination.
   // <br><b>Note:</b> Text destinations (screen and log files) require explicit additional setting to show the attribute (see "set_text_state_var()" ).
   register_field_state_var(
      // A name of a unit type (including "when" subtypes and template instances).
      unit_name: string,
      // A name of a field declared for the struct.
      field_name: string
   ) is empty;

   // Defines an attribute for transactions of the specified type, the value of which is determined dynamically
   //  by calling the specified hook method of the data item struct type.
   // Whenever a transaction of the given type needs to be sampled, the hook method is called on the data item type.
   // The attribute name is written along with the returned value.
   register_method_attribute(
      //Any struct type name, including "when" subtypes and template instances
      type_name: string,
      // Name of an existing method of the struct type
      method_name: string
   ) is empty;

   // Defines a state variable, the value of which is determined dynamically by calling the specified hook method of the unit type.
   // The value is sampled by calling the hook method upon the execution of "msg_changed()" when the scope unit is of the specified type.
   // Both name and the returned value are written to the message destination.
   register_method_state_var(
      // Name of a unit type (including "when" subtypes and template instances).
      unit_name: string,
      // Name of an existing method of the unit type.
      method_name: string
   ) is empty;

   // Determines that an already registered attribute or state variable will be converted to a string using the specified format string.
   set_attribute_format(
      // Any struct type name, including "when" subtypes and template instances.
      struct_name: string,
      // Registered attribute name for the given struct type.
      attr_name: string,
      // Format string to be used.
      format: string
   ) is empty;

   // Determines that an already registered attribute is to be sampled and recorded at the specified sampling points.
   // If there is no attribute by that name currently registered within this recording_config object an error is issued.
   // The sampling points correspond to different roles of the data item within structured messages.
   // The setting for the specified attribute overrides the previous setting.
   // <br><b>Note:</b> The default setting for all attributes is the one element list {STARTED}.
   set_attribute_sampling(
      // Any struct type name, including "when" subtypes and template instances.
      struct_name: string,
      // A registered attribute name for the given struct type.
      attr_name: string,
      // A list of zero or more values representing structured message sampling points (See "Type tr_sampling_point_t" ).
      points: list of tr_sampling_point_t
   ) is empty;

   // Sets an already registered attribute as the SST2 label for transaction of the given type.
   // If there is no attribute by that name currently registered within this recording_config object an error is issued.
   // <br><b>Notes</b>
   // <br>* This setting does not affect destinations other than SST2.
   // <br>* The attribute is recorded only as an SST2 transaction label and not as an SST2 transaction attribute. Thus, the attribute name is not captured in SST2.
   // <br>* If no label attributes applies to a given data item the default label is used, which is the instance name in the form type-@inst-id.
   // <br>* When multiple label attributes apply to the same data item the last registered attribute is used.
   // <br>* A label attribute is always sampled upon msg_started(). An error is issued if a label attribute is assigned a sampling point other than STARTED.
   set_label_attribute(
      // Any struct type name, including "when" subtypes and template instances.
      type_name : string,
      // A registered attribute name for the given struct type.
      attr_name : string
   ) is empty;

   // Determines that an already registered attribute is to be written also to text destinations (screen and log files).
   // If there is no attribute by that name currently registered within this recording_config object an error is issued.
   // <br><b>Note:</b> This setting does not affect destinations other than screen and log files.
   set_text_attribute(
      // Any struct type name, including "when" subtypes and template instances.
      type_name: string,
      // A registered attribute name for the given struct type.
      attr_name: string
   ) is empty;

   // Determines that an already registered state variable is to be written to also text destinations (screen and log files).
   // If there is no state variable by that name currently registered within this recording_config object an error is issued.
   // <br><b>Note:</b> This setting does not affect destinations other than screen and log files.
   set_text_state_var(
      // Any struct type name, including "when" subtypes and template instances.
      unit_name: string,
      // A registered attribute name for the given struct type.
      var_name: string
   ) is empty;

//register_field_attribute_internal(rfs : rf_struct, field_name : string, sampling : list of tr_sampling_point_t) is empty;
//clear_field_attributes(struct_name : string) is empty;
//clear_all_field_attributes() is empty;
//get_attribute(struct_name : string, attr_name : string) : tr_attribute is empty;
//get_attribute_sampling(struct_name : string, attr_name : string) : list of tr_sampling_point_t is empty;
//set_visualization_link_attribute(struct_name : string, attr_name : string) is empty;
//collect_attribute_values(scope : any_unit, inst : any_struct, sp : tr_sampling_point_t, names : list of string, values : list of string, include_non_text : bool, include_label : bool, ignore_sampling_point : bool) is empty;
//get_tr_label(scope : any_unit, inst : any_struct) : string is empty;
//get_tr_vis_link(scope : any_unit, inst : any_struct) : string is empty;

};

'>

<'

struct scheduler {

   // @non_standard
   current_thread: thread_handle;

   // @non_standard
   tick_counter: int;

   // Returns the handle of the currently running TCM
   get_current_handle():thread_handle is empty;

   // Returns a list of handles of all started TCMs of the specified name associated with the specified struct instance.
   get_handles_by_name(struct_inst: any_struct, method_name: string): list of thread_handle is empty;

   // Returns handles to all TCMs associated with the specified struct type.
   get_handles_by_type(struct_name: string, method_name: string): list of thread_handle is empty;

   // @non_standard
   get_thread_name_by_handle(th: thread_handle, tcm_name: string, struct_name: string) is empty;

   // Kills a started TCM (a thread) and any TCMs that it has called (its subthreads).
   kill(handle: thread_handle) is empty;

   // This method can be used only within a first of action to terminate the branch. When a branch is terminated using this method, the rest of the branches within the first of action remain active.
   terminate_branch() is empty;

   // Terminates the current thread immediately, not at the end of the current tick. To terminate the current thread at the end of the current tick, use quit().
   terminate_thread() is empty;

};

'>

<'

// ---
// Semaphore
// ---

// Typical semaphore. The maximum value ranges between 1 and MAX_INT.
// By default, it is MAX_INT, and the initial value (number of available resources) is 0.
struct semaphore {

   // Decrements the semaphore's value. Blocks if the value is already 0.
   down() is empty;

   // Returns the maximum possible value.
   get_max_value(): uint is empty;

   // Returns the current value of the semaphore.
   get_value(): uint is empty;

   // Sets an upper limit to the possible value of the semaphore.
   set_max_value(value: uint) is empty;

   // Sets the initial value of the semaphore.
   set_value(value: uint) is empty;

   // Increments the semaphore's value. If the value is already the maximum possible, returns without blocking.
   try_up() is empty;

   // Decrements the semaphore's value. If the value is already 0, returns without blocking.
   try_down() is empty;

   // Increments the semaphore's value. Blocks if the value is already the maximum possible.
   up() is empty;

};

'>

<'

// The session struct holds the status of the current simulator session, related information, and events.
// You can print the session struct to see the types of information that are stored in this struct by typing the following at the Specman prompt:
//  'print session'.
struct session like base_struct {

   // This field is of Boolean type, and is set TRUE after every check, if the check succeeds. Otherwise, it is set to FALSE.
   // This field allows you to extend checking of a behavior without the need to duplicate the if clause.
   check_ok : bool;

   // @non_standard
   end_of_test : bool;
   
   // @non_standard
   longTime: sn_long_time;

   num_of_errors: uint;

   // Number of DUT errors during test.
   num_of_dut_errors: uint;

   // Number of DUT warnings during test.
   num_of_dut_warnings: uint;

   // @non_standard
   run_tick_max: uint;

   // This field help you determine the memory used in the current session.
   specman_memory: uint;

   // This field help you determine the system time the current session was started.
   system_time: uint;

   // Number of total Specman ticks.
   tick_counter: uint;

   // This field help you determine the user time the current session was started.
   user_time: time;

   event call;
   event check;
   event cvl_call;
   event cvl_return;
   event dut_error;
   event dut_err;

   // Emitted once at test end.
   event end_of_test;
   event events;
   event interactive_coverage;
   event line;
   event output;
   event return;
   event sim_read;
   event sim_write;

   // Emitted once at test start.
   event start_of_test;

   event tcm_call;
   event tcm_end;
   event tcm_return;
   event tcm_start;
   event tcm_state;
   event tcm_wait;

   cover events is {};
   cover start_of_test is {};
   cover end_of_test is {};

   // @non_standard
   simulator_exists(): bool is empty;

   // Synchronize Specman with the simulation time.
   update_sys_time() is empty;

};

'>

<'

// Expressions of the e type set evaluate to a defined set of integer values.
struct set like __dvt_null_parent {

   // Puts all continuous ranges of the set in a buffer list that can be reused.
   collect_all_ranges(buff: list of set) is empty;

   // Subtract one set from another.
   diff(set2: set): set is empty;

   // Returns a list of all continuous ranges of the set.
   get_all_ranges(): list of set is empty;

   // If a specified number is in a set, returns the continuous range that contains the number.
   get_range(num: int): set is empty;

   // Returns the continuous range that contains the specified number,
   //  or (if no range contains the number) returns the closest range containing numbers greater than the specified number
   get_range_above(num: int): set is empty;

   // Returns the continuous range that contains the specified number,
   // or (if no range contains the number) returns the closest range containing numbers less than the specified number.
   get_range_below(num: int): set is empty;

   // Return the maximum value of set as int.
   int_max(): int is empty;

   // Return the minimum value of set as int.
   int_min(): int is empty;

   // Returns the set of all of the members that belong to both of two sets of integers.
   intersect(set2: set): set is empty;

   // Return the minimum value of set as an integer of unlimited size.
   min(): int(bits:*) is empty;

   // Return the maximum value of set as an integer of unlimited size.
   max(): int(bits:*) is empty;

   // Indicates if it is safe to use set.int_max().
   max_is_int(): bool is empty;

   // Indicates if it is safe to use set.uint_max().
   max_is_uint(): bool is empty;

   // Indicates if it is safe to use set.int_min().
   min_is_int(): bool is empty;

   // Indicates if it is safe to use set.uint_min().
   min_is_uint(): bool is empty;

   // Return the size of the set as an unbound integer.
   size(): int(bits:*) is empty;

   // Indicates if it is safe to use set.uint_size().
   size_is_uint(): bool is empty;

   // Returns the string representation.
   to_string(): string is empty;

   // Return the maximum value of set as uint.
   uint_max(): int is empty;

   // Return the minimum value of set as uint.
   uint_min(): int is empty;

   // Return the size of the set as an uint.
   uint_size(): uint is empty;

   // Returns the set containing all of the members that belong to either of two sets of integers.
   union(set2: set): set is empty;

};

'>

<'

struct simulator {

   // @non_standard
   exists : bool;

   // @non_standard
   ml_lib_adapter : sn_ML_LIB_adapter;
   
   // Get the value of a Verilog define.
   get_define(macro: string): string is empty;

   // Returns the size of a given valid HDL path. The size is given in bits.
   get_hdl_path_size(agent: string, path: string): uint is empty;
   
   // @non_standard
   is_wait_for_ml_phase_notification(domain_name : string, next_phase : string) : bool is {};
   
   // @non_standard
   ml_lib_mode_active() : bool is {};
   
   // @non_standard
   ml_lib_unilang_active() : bool is {};
   
   // Returns TRUE if the given path exists for the given agent name.
   // This routine returns TRUE if the given HDL path exists or FALSE if it does not exist.
   // @param agent - The simulator agent name, as described in the agent() unit attribute.
   // @param path - The full HDL path to the signal.
   path_exists(agent: string, path: string) : bool is {};
   
};

'>

<'

// The sn_double_matrix type is a proxy to a MATLAB double-precision two-dimensional matrix.
// An object of this type can not be accessed without a MATLAB adapter.
// You must have at least one unit whose agent is MATLAB.
struct sn_double_matrix like any_struct {

   // Returns the number of columns in the matrix.
   columns(): int is empty;

   // Returns the element in the given row and column of the matrix as an e object of type real.
   // Indices start at zero as in e.
   // It cannot be called before the matrix is initialized, either by a call to set_dimensions() or by an assignment from a port.
   get_element(row: int, column: int): real is empty;

   // Returns the whole matrix as a two-dimensional list of type real.
   get_matrix(): list of list of real is empty;

   // Sets the element in the given row and column of the matrix to the given real value.
   // Indices start at zero as in e.
   // It cannot be called before the matrix is initialized, either by a call to set_dimensions() or by an assignment from a port.
   put_element(value: real, row: int, column: int) is empty;

   // Sets the whole matrix with the values of the two-dimensional list of type real passed as a parameter.
   // The number of elements in all the sub-lists must be the same; otherwise an error is issued.
   put_matrix(value: list of list of real) is empty;

   // Returns the number of rows in the matrix.
   rows(): int is empty;

   // Sets the dimensions of the matrix. This initializes the matrix with the given size.
   // All elements are set to zero. The parameters must be positive integers.
   set_dimensions(rows: int, columns: int) is empty;

};

'>

<'

// The sn_denali type has some public interface methods and data fields.
// There is a single instance of sn_denali that is a field of global, also named sn_denali.
struct sn_denali {

   // Turn on memory access notification to Specman.
   enable_cb(trace_mode: bool) is empty;

   // Turn off memory access notification to Specman.
   disable_cb(trace_mode: bool) is empty;

   // Increase the limit on Specman memory for callback data information.
   set_cb_data_max(num: uint) is empty;

   // Show the current Specman memory limit for callback data items.
   get_cb_data_max(): uint is empty;

};

'>

<'

// Because of limitations of like inheritance, you cannot add data fields directly to the sn_denali_unit type.
// However, sn_denali_unit contains an instance of a struct named sn_denali_add_on, which you can extend by adding fields.
// The sn_denali_add_on instance in the sn_denali_unit type is named 'add_on'.
// Initially, the sn_denali_add_on struct is empty.
// Data fields you add to it can be used for storage when working with sn_denali_unit.
struct sn_denali_add_on {
};

'>

<'

// The sn_denali_unit type is an abstract unit type.
// It does not contain built-in read and write methods, so you do not use it directly.
// Instead, you create a subtype that inherits from it, for which you specify the data bus width of your memory model.
// The sn_denali_unit type has an 'add_on' capability so that you can add fields to the type in extensions.
unit sn_denali_unit {

   // Because of limitations of like inheritance, you cannot add data fields directly to the sn_denali_unit type.
   // However, sn_denali_unit contains an instance of a struct named sn_denali_add_on, which you can extend by adding fields.
   // The sn_denali_add_on instance in the sn_denali_unit type is named 'add_on'. Initially, the sn_denali_add_on struct is empty.
   // Data fields you add to it can be used for storage when working with sn_denali_unit.
   add_on : sn_denali_add_on;

   // If this field is set to TRUE, the dot before the component of the unit's full HDL path is removed during conversion of the full HDL path to the memory model internal name.
   memory_subinstance: bool;

   // There is a predefined event named access_event in sn_denali_unit.
   // That event is automatically emitted at the beginning of the next Specman tick after any simulation cycle in which the corresponding memory model instance was accessed.
   // There may be numerous instances of this event—one for each memory instance.
   // This Specman event happens at the same simulation time as the DUT memory access event.
   // Thus, it may be compared to a Specman event emitted due to an @sim temporal expression.
   // Memory accesses from Specman itself do not emit access_event.
   // The events are emitted according to the rules similar to those for the signal value change callback events used with @sim.
   // In order to process these events you must write your own TCMs.
   event access_event;

   // Get the Denali memory type.
   get_type() : string is empty;

   // Get the data bus width in bits.
   get_width() : uint is empty;

   // Get the data bus width in 32-bit words.
   get_word_width() : uint is empty;

   // Get the size of the Denali address space.
   get_depth() : uint is empty;

   // Get the Denali memory instance ID.
   get_id() : uint is empty;

   // Get the contents of a memory address, setting unknown bits to 0.
   read(address: uint): uint is empty;

   // Get the contents of a memory address, setting unknown bits to 0.
   read_64(address: uint): uint is empty;

   // Get the contents of a memory address, setting unknown bits to 1 in a mask named unknown.
   read_unk(address: uint, data: *uint, unknown: *uint) is empty;

   // Get the contents of a memory address, setting unknown bits to 1 in a mask named unknown.
   read_unk_64(address: uint, data: *uint, unknown: *uint) is empty;

   // Set the contents of a memory address.
   write(address: uint, data: uint) is empty;

   // Set the contents of a memory address.
   write_64(address: uint, data: uint) is empty;

   // Set the contents of a memory address.
   write_unk(address: uint, data: uint, unknown: uint) is empty;

   // Set the contents of a memory address.
   write_unk_64(address: uint, data: uint, unknown: uint) is empty;

   // Load a memory format file into a memory instance.
   load(filename: string) is empty;

   // Save the contents of a memory instance in a text file.
   save(filename: string) is empty;

   // Get the number of callback data items from the last cycle.
   cb_data_size(): uint is undefined;

   // Get a data item from the callback list.
   get_cb_data_item(i: uint, addr: *uint, data: *uint, access: *sn_denali_access_type) is empty;

   // Get a data item from the callback list.
   get_cb_data_item_64(i: uint, addr: *uint, data: *uint, access: *sn_denali_access_type) is empty;

   // Empty predefined method to be extended with user-defined code for immediate processing upon a callback.
   access_cb_immediate(address: uint, data: uint, access: sn_denali_access_type) is empty;

   // Empty predefined method to be extended with user-defined code for immediate processing upon a callback using a mask.
   access_cb_immediate_with_mask(address: uint, data: uint, access: sn_denali_access_type, mask: uint) is empty;

   // Empty predefined method to be extended with user-defined code for immediate processing upon a callback using a mask.
   access_cb_immediate_with_mask_64(address: uint, data: uint, access: sn_denali_access_type, mask: uint) is empty;

   // Enable or disable immediate processing upon a callback.
   set_immediate_callback(state: bool) is empty;

   // Enable or disable immediate processing upon a callback function that includes masked data.
   set_immediate_callback_with_mask(state: bool) is empty;

   // Check whether immediate callback processing is enabled or disabled.
   immediate_callback_enabled(): bool is empty;

   // Check whether immediate callback with mask processing is enabled or disabled.
   immediate_callback_enabled_with_mask() is empty;

};

'>

<'

//@non_standard
struct sn_evc_util like sn_struct {
   //@non_standard
   show_full_banner(env: any_env) is empty;
};

'>

<'

// @non_standard @deprecated
// The SDI-e interface is based on the global struct global.external_trace, whose methods you use to define the transactions you want to trace.
struct sn_external_trace like sn_struct {

   // Check environment for transaction recording.
   is_enabled(b_verbose: bool) : bool is empty;

   // Start a new transaction.
   new_transaction(unit: any_unit, fiber_name : string, trans_type : string, transaction_label : string) : bool is empty;

   // Start a new transaction at a specific time.
   new_transaction_at(unit: any_unit, fiber_name : string, trans_type : string, transaction_label : string, begin_time: time) : bool is empty;

   // Close a transaction.
   close_transaction(unit: any_unit, fiber_name : string, trans_type : string) : bool is empty;

   // Define a transaction attribute.
   set_transaction_attribute(unit: any_unit, fiber_name : string, trans_type : string, attr_name : string, attr_value : string) is empty;

};

'>

<'

// Function-Level Interface
struct sn_fli_shlibs like sn_struct {

   // Returns the library name associated with a FLI import subroutine
   get_import_library_name(struct_type: string, import_name: string): string is empty;

   // Return the C routine name associated with a FLI import subroutine
   get_import_routine_name(struct_type: string, import_name: string): string is empty;

   // Associates the FLI import subroutine with a library name
   set_import_library_name(struct_type: string, import_name: string, lib_name: string) is empty;

   // Associates the FLI import subroutine with a C routine name
   set_import_routine_name(struct_type: string, import_name: string, routine_name: string) is empty;

};

'>

<'

//@non_standard
struct sn_long_time {
	low: uint;//@non_standard
	high: uint;//@non_standard
	tmp_time: time;//@non_standard
	scale_time: time;//@non_standard
	has_time_knowledge: bool;//@non_standard
	new_time: bool;//@non_standard
};

'>

<'

//@non_standard
struct sn_message_action {
   verbosity: message_verbosity;
};

'>

<'

// You can use the predefined methods of the shlibs struct to interface procedurally with dynamic C routines.
struct sn_shlibs like sn_struct {

   // Attempts to find the specified library.
   check_library_exists(shlib_name : string) : bool is empty;

   // Return the library name associated with a dynamic C routine.
   get_dynamic_library_name(struct_type: base_struct, dynamic_name: string): string is empty;

   // Return the routine name associated with a dynamic C routine.
   get_dynamic_routine_name(struct_type: base_struct, dynamic_name: string): string is empty;
   
   // @non_standard
   get_lib(shlib_name: string, shlib_type: string): sn_library is empty;
   
   // @non_standard
   open(shlib_name: string, shlib_type: string, resolve: sn_lib_resolve_mode, scope: sn_lib_scope_mode): sn_library is empty;
   
   // @non_standard
   open_all() is empty;

   // Resolve a C routine reference.
   resolve_dynamic(struct_type: base_struct, dynamic_name: string) is empty;

   // Returns TRUE if C routine reference is resolved
   safe_resolve_dynamic(struct_type: base_struct, dynamic_name: string): bool is empty;

   // Associate a dynamic C routine with a library name.
   set_dynamic_library_name(struct_type: base_struct, dynamic_name: string, lib_name: string) is empty;

   // @non_standard
   set_dynamic_symbol(__dvt_ignore_args) is empty;

   // Associate a dynamic C routine with a routine name.
   set_dynamic_routine_name(struct_type: base_struct, dynamic_name: string, routine_name: string) is empty;

   // Define library modes.
   set_library_modes(shlib_name: string, scope: sn_lib_scope_mode, resolve: sn_lib_resolve_mode) is empty;

};

'>

<'

//@non_standard
struct sn_stripe_info {

   container_name: string;

   do_location: string;

   end_time: time;

   expanded: bool;

   fake: bool;

   global_index: uint;

   idx: int;

   start_time: time;
};

'>

<'

// @non_standard
struct sn_struct like base_struct {

   // @non_standard
   check_consistency () is empty;

   // @non_standard
   get_unit () :any_unit is empty;

   // @non_standard
   recursive_free() is empty;

   // @non_standard
   sn_gc_finalize () is empty;

   // @non_standard
   sn_recycle_fields () is empty;

   // @non_standard
   visualize () is empty;

};

'>

<'

// @non_standard
struct sn_table like sn_struct {
   // @non_standard
   add_filled_row(row: sn_table_row) is empty;

   // @non_standard
   add_row() is empty;

   // @non_standard
   check_row_index(i: int, for_insert: bool) is empty;

   // @non_standard
   copy_with_rows(): sn_table is empty;

   // @non_standard
   delete_column(i: int) is empty;

   // @non_standard
   delete_row(i: int) is empty;

   // @non_standard
   get_csv_file_name(): string is empty;

   // @non_standard
   get_column_index_by_name(name: string): int is empty;

   // @non_standard
   get_column_name(i: int): string is empty;

   // @non_standard
   get_columns_num(): int is empty;

   // @non_standard
   get_excel_file_name(): string is empty;

   // @non_standard
   get_excel_sheet_name(): string is empty;

   // @non_standard
   get_header_row(): sn_table_row is empty;

   // @non_standard
   get_row(i: int): sn_table_row is empty;

   // @non_standard
   get_rows_num(): int is empty;

   // @non_standard
   insert_filled_row(i: int, row: sn_table_row) is empty;

   // @non_standard
   insert_row(i: int) is empty;

   // @non_standard
   set_column_name(i: int, name: string) is empty;

   // @non_standard
   replace_header_row(new_header_row: sn_table_row) is empty;

   // @non_standard
   replace_row(i: int, row: sn_table_row) is empty;
};

// @non_standard
struct sn_table_row like sn_struct {
   // @non_standard
   check_item_index(i: int) is empty;

   // @non_standard
   check_unchangeable() is empty;

   // @non_standard
   copy_source_info_from(other: sn_table_row) is empty;

   // @non_standard
   get_csv_file_name(): string is empty;

   // @non_standard
   get_csv_line_num(): int is empty;

   // @non_standard
   get_data(i: int): string is empty;

   // @non_standard
   get_excel_file_name(): string is empty;

   // @non_standard
   get_excel_sheet_name(): string is empty;

   // @non_standard
   get_size(): int is empty;

   // @non_standard
   set_data(i: int, data: string) is empty;
};

'>

<'

// @non_standard
struct sn_util {

   // @non_standard
   get_util_version(): string is empty;

};

'>

<'

// @non_standard
struct sn_uvm_simvision_interface like sn_struct {

   // @non_standard
   base_config: rf_like_struct;

   // @non_standard
   base_uvm_base: rf_like_struct;

   // @non_standard
   base_phase_manager: rf_like_struct;

   // @non_standard
   handles: list (key: item) of handle_info;

   // @non_standard
   add_handle(item: any_struct, kind: epi_uvm_object_type, name: string) is empty;
   // @non_standard
   break_specman_check() is empty;
   // @non_standard
   break_specman_generate() is empty;
   // @non_standard
   break_specman_elaborate() is empty;
   // @non_standard
   break_specman_extract() is empty;
   // @non_standard
   break_specman_finalize() is empty;
   // @non_standard
   break_specman_run() is empty;
   // @non_standard
   check_child_exists(handle : int, children : list of uint, num : uint) : bool is empty;
   // @non_standard
   check_handle_exists(handle : int) : bool is empty;
   // @non_standard
   e_packages_loaded() is empty;
   // @non_standard
   e_packages_on_disk() is empty;
   // @non_standard
   fill_children(handle : int) is empty;
   // @non_standard
   format_units_list(u : any_unit, depth : int, env_only : bool) : list of string is empty;
   // @non_standard
   init_base_types() is empty;
   // @non_standard
   init_table() is empty;
   // @non_standard
   is_a_message_logger(rfs : rf_struct) : bool is empty;
   // @non_standard
   is_a_sequence_type(rfs : rf_struct) : bool is empty;
   // @non_standard
   is_a_uvm_base_type(rfs : rf_struct) : bool is empty;
   // @non_standard
   is_a_uvm_phase_manager_type(rfs : rf_struct) : bool is empty;
   // @non_standard
   is_a_uvm_top_type(rfs : rf_struct) : bool is empty;
   // @non_standard
   is_a_vr_ad_type(rfs : rf_struct) : bool is empty;
   // @non_standard
   is_of_type(rfs : rf_struct, base_type : epi_uvm_object_type): bool is empty;
   // @non_standard
   list_uvm_components() is empty;
   // @non_standard
   list_uvm_top_components() is empty;
   // @non_standard
   run_to_end_of_generation() is empty;
   // @non_standard
   run_to_end_of_elaboration() is empty;
   // @non_standard
   run_to_next_specman_phase() is empty;
   // @non_standard
   set_messages_verbosity(verbosity : message_verbosity) is empty;
   // @non_standard
   show_uvm_messages() is empty;
   // @non_standard
   uvm_get_child(type : epi_uvm_object_type, handle : int, num : uint) : int is empty;
   // @non_standard
   uvm_get_children_number(type : epi_uvm_object_type, handle : int) : uint is empty;
   // @non_standard
   uvm_get_handle_kind(handle : int) : epi_uvm_object_type is empty;
   // @non_standard
   uvm_get_property_uint(property : epi_uvm_int_property, handle : int) : uint is empty;
   // @non_standard
   uvm_get_property_string(property : epi_uvm_str_property, handle : int) : string is empty;
   // @non_standard
   uvm_get_top_number(type : epi_uvm_object_type) : uint is empty;
   // @non_standard
   uvm_package_present(package_name : epi_uvm_package_name) : bool is empty;
};

'>

<'

// The data returned by the get_strength() and get_strength_list() port pseudo-methods is stored in the predefined "strength_val" struct.
// This struct holds the logic value and the strength value information for the Verilog net bound to the simple port.
struct strength_val like any_struct {

   // The logic value (0, 1, Z, X) of the Verilog net.
   logic : mvl;

   // The logic 0 strength value for the Verilog net.
   s0 : int;

   // The logic 1 strength value for the Verilog net.
   s1 : int;

};

'>

<'

// See the split() list pseudo-method.
// The struct_list_holder type is a struct with a single field, "value: list of any-struct;".
struct struct_list_holder like sn_struct {

   // See the split() list pseudo-method.
   // A list of items of the original input-list type.
   value: list of any_struct;

};

'>

<'

// @non_standard
struct symtab like sn_struct {

   // @non_standard
   current_module: module;

   // @non_standard
   last_sn_module: int;

   // @non_standard
   modules: list (key: name) of module;
   
   // @non_standard
   cast_type(to_type : type_descriptor, from_type : type_descriptor) : cast is empty;

};

'>

<'

// ---
// sys
// ---

// The system unit is instantiated under global as sys.
// All fields and structs in sys not marked by an exclamation point (!) are generated automatically during the generate_test phase.
unit sys like any_unit {

   // By default, only LOW verbosity messages go to screen.
   // If end users just want messages at some verbosity, they can use <b>sys.logger</b>.
   // For example, they might issue the following command:
   //   set message -verbosity=MEDIUM.
   // Of course, they could achieve the same thing via a constraint as follows:
   //   extend sys {keep soft logger.verbosity == MEDIUM};.
   logger: message_logger is instance;

   // Current system time.
   realtime: real;

   // Current simulation time.
   time : time;

   // Emitted on every Specman tick.
   event any;

   // In stand-alone operation (no simulator), this event is emitted on every sys.any event.
   // When a simulator is being used, this event is emitted every time a callback occurs,
   //  if the attached simulator's time has changed since the previous callback.");
   event new_time;

   // Emitted at the end of every Specman tick.
   event tick_end;

   // Emitted at the start of every Specman tick.
   event tick_start;

   // Defines actions to be preformed immediately before the execution of a save command.Extend the pre_save() method using is also to add the actions.
   // This method is invoked automatically by the save command; do not call it explicitly.
   pre_save(state_name: string, save_dir: string) is empty;
   
   // A hook method used to create stub code for e units instantiated under a foreign language.
   pre_stub_generation() is empty;

   // Defines actions to be preformed immediately before the execution of a restore command. Extend the pre_restore() method using is also to add the actions.
   // This method is invoked automatically by the restore command; do not call it explicitly.
   pre_restore(state_name: string, save_dir: string) is empty;

   // Defines actions to be preformed immediately after the execution of a restore command. Extend the post_restore() method using is also to add the actions.
   // This method is invoked automatically by the restore command; do not call it explicitly.
   post_restore(state_name: string, save_dir: string) is empty;

   // You can use the remap_tick_access() method to create customized mapping rules for renaming 'tick' access HDL paths.
   // This includes access (at run time) and static statements (for example, verilog variable, and verilog task).
   remap_tick_access(name : string) : string is empty;

   // When you issue a test, start, generate or setup command from the Specman command line, the global.setup_test() method is called.
   // This method in turn calls the sys.setup() method to initialize test parameters,
   //  such as the initial seed for random generation, in preparation for running a test.
   // You can extend this method to set configuration options.
   setup() is empty;

   // Creates a snapshot of the current simulation state. The snapshot includes both the simulator and Specman states. The save takes affect after tick_end, which means that Specman runs until tick_end.
   // Then,control is passed to the simulator, and the simulator performs the save. If several calls are done in the same tick, all of them are executed.
   simulator_save(snapshot_name : string, overwrite : bool = TRUE, continue_run: bool = FALSE, with_log: bool = FALSE, snapshot_path: string = "") is empty;

   // When you issue a test, start, generate or setup command from the Specman command line, the global.setup_test() method is called.
   // This method in turn calls sys.wave_setup() method.
   // You can extend this method by adding calls to the set_config() method to initialize waveform viewer configuration parameters.
   // This method is initially empty and is meant to be extended.
   // It is automatically called before the stubs file is generated, and is therefore the place to set configuration options that affect the stubs file.
   wave_setup() is empty;

};

'>

<'

// A rendezvous semaphore is a semaphore with no resources.
// It requires the meeting of a producer and a consumer for either to proceed.
// When they finally proceed, the down() thread always runs first, followed immediately by the up()
struct rdv_semaphore like semaphore {

};

'>

<'

// @non_standard
struct table_manager {
   // @non_standard
   check_column_name(name: string) is empty;
   // @non_standard
   check_column_names(names: list of string) is empty;
   // @non_standard
   create_empty_table(): table is empty;
   // @non_standard
   create_row(size: int): table_row is empty;
   // @non_standard
   create_row_with_data(data: list of string): table_row is empty;
   // @non_standard
   create_table(column_names: list of string): table is empty;
   // @non_standard
   create_table_without_column_names(row_size: int): table is empty;
   // @non_standard
   csv_check_col_exists(fname: string, table_name: string, col_name: string): list of list of string is empty;
   // @non_standard
   csv_check_condition(fname: string, table_name: string, column_name: string, equal: bool, value: string): list of list of string is empty;
   // @non_standard
   csv_check_empty(fname: string, table_name: string): list of list of string is empty;
   // @non_standard
   csv_check_empty_condition(fname: string, table_name: string, column_name: string, equal: bool, value: string): list of list of string is empty;
   // @non_standard
   csv_check_exist(fname: string, table_name: string): table is empty;
   // @non_standard
   read_all_tables_from_csv(fname: string): list (key: tag) of table is empty;
   // @non_standard
   read_all_tables_from_excel(fname: string, sheet_name: string): list (key: tag) of table is empty;
   // @non_standard
   read_table_from_csv(fname: string, tag: string, error_if_none: bool): table is empty;
   // @non_standard
   read_table_from_excel(fname: string, sheet_name: string, tag: string, error_if_none: bool): table is empty;
   // @non_standard
   reload_csv_file(fname: string) is empty;
   // @non_standard
   reload_excel_sheet(fname: string, sheet_name: string) is empty;
};

// @non_standard
struct table like sn_struct {
   // @non_standard
   csv_file: csv_file;
   // @non_standard
   header_row: table_row;
   // @non_standard
   row_size: int;
   // @non_standard
   rows: list of table_row;
   // @non_standard
   tag: string;

   // @non_standard
   add_filled_row(row: table_row) is empty;
   // @non_standard
   add_row() is empty;
   // @non_standard
   check_row_index(i: int, for_insert: bool) is empty;
   // @non_standard
   check_unchangeable() is empty;
   // @non_standard
   copy_with_rows(): table is empty;
   // @non_standard
   delete_column(i: int) is empty;
   // @non_standard
   delete_row(i: int) is empty;
   // @non_standard
   get_column_index_by_name(name: string): int is empty;
   // @non_standard
   get_column_name(i: int): string is empty;
   // @non_standard
   get_columns_num(): int is empty;
   // @non_standard
   get_csv_file_name(): string is empty;
   // @non_standard
   get_excel_file_name(): string is empty;
   // @non_standard
   get_excel_sheet_name(): string is empty;
   // @non_standard
   get_header_row(): table_row is empty;
   // @non_standard
   get_row(i: int): table_row is empty;
   // @non_standard
   get_rows_num(): int is empty;
   // @non_standard
   insert_filled_row(i: int, row: table_row) is empty;
   // @non_standard
   insert_row(i: int) is empty;
   // @non_standard
   replace_header_row(new_header_row: table_row) is empty;
   // @non_standard
   replace_row(i: int, row: table_row) is empty;
   // @non_standard
   set_column_name(i: int, name: string) is empty;
};

// @non_standard
struct table_row like sn_struct {
   // @non_standard
   is_header: bool;
   // @non_standard
   items: list of string;
   // @non_standard
   sref: table_source_ref;

   // @non_standard
   check_item_index(i: int) is empty;
   // @non_standard
   check_unchangeable() is empty;
   // @non_standard
   copy_source_info_from(other: table_row) is empty;
   // @non_standard
   get_csv_file_name(): string is empty;
   // @non_standard
   get_csv_line_num(): int is empty;
   // @non_standard
   get_data(i: int): string is empty;
   // @non_standard
   get_excel_file_name(): string is empty;
   // @non_standard
   get_excel_sheet_name(): string is empty;
   // @non_standard
   get_size(): int is empty;
   // @non_standard
   set_data(i: int, data: string) is empty;
};

// @non_standard
struct table_source_ref like sn_struct {
   // @non_standard
   prev_table_sref: table_source_ref;

   // @non_standard
   error_message_source_line(in_file_format: bool): string is empty;
   // @non_standard
   is_equal(other_tsr: table_source_ref): bool is empty;
   // @non_standard
   is_same_line(other_tsr: table_source_ref): bool is empty;
   // @non_standard
   table_definition_source_dual(in_file_format: bool): string is empty;
};

'>

<'

struct thread_handle {

};

'>

<'

// ---
// User Cover Struct
// ---

// Struct to extend in order to implement a customized analysis using the coverage API.
struct user_cover_struct {

   // The number of samples required to fill the bucket.
   at_least: int;

   // The overall grade for all coverage items, calculated by calling the scan_cover() method with *.*.* as the item parameter
   // The default is UNDEF.
   all_grade: int;

   // The name of the current bucket.
   bucket_name: string;

   // The bucket's grade.
   bucket_grade: int;

   // The bucket's weight for grading.
   bucket_weight: int;

   // The number of samples in this bucket.
   count: int;

   // For cross coverage, ranging from 0 to sub_items.size()-1,
   cross_level: index;

   // A list of all of the bucket sets in the coverage hierarchy
   // This information is needed for grading cross items and transition items.
   // The last element in the list is the name of the current bucket set or bucket.
   full_bucket_name: list of string;

   // The group's grade.
   group_grade: int;

   // The name of the group.
   group_name: string;

   // The text specified using the text= option in the group definition, or NULL if the option is not used.
   group_text: string;

   // The group's weight for grading.
   group_weight: int;

   // Meaningful if is_string is FALSE, and the value in this bucket is an integer.
   // If the bucket is a range of values, this is the highest integer value within the range.
   hi_int_value: int;

   // Modified whenever a new instance is scanned.
   instance_name: string;

   // If per instance coverage is used, this is the field to look at, rather than group_grade
   instance_grade: int;

   // Meaningful if is_string is FALSE: the value of this bucket as an integer.
   // For range buckets: the lowest value within the range.
   int_value: int;

   // TRUE if this is a string bucket; if TRUE, the string is the bucket name.
   is_string: bool;

   // The value of the at_least option in the item definition.
   item_at_least: int;

   // The expression string, if the item was defined using type=exp, or NULL if type=exp was not specified.
   item_exp_string: string;

   // The item's grade.
   item_grade: int;

   // The name of the current item.
   item_name: string;

   // The number of tests in which the item appears.
   item_no_of_tests: int;

   // The struct subtype under which the item is defined, for example 'packet' or 'small tx packet'.
   item_when_string: string;

   // The text specified using the text= option in the item definition, or NULL if the option is not used.
   item_text: string;

   // The item's weight for grading.
   item_weight: int;

   // The number of tests that sample the bucket.
   no_of_tests: int;

   // @non_standard Bucket's percentage of item's total samples.
   percent: int;

   // The total number of samples for the item in the coverage files.
   samples: int;

   // Whether the bucket is illegal, normal, or hole.
   status: bucket_status;

   // The struct in which the item resides.
   struct_name: string;

   // For a simple item - contains a (single) item name.
   // For a cross item - contains names of all cross-covered items.
   // For a transition item - repeats the name twice.
   sub_items: list of string;

   // Process coverage bucket information according to user preferences.
   scan_bucket() is empty;

   // Activate the Coverage API and specify items to cover.
   scan_cover(entity_names: string): int is empty;

   // Process coverage group information according to user preferences.
   start_group() is empty;

   // Process coverage instance information according to user preferences.
   start_instance() is empty;

   // Process coverage item information according to user preferences.
   start_item() is empty;

   // Report end of group coverage information according to user preferences.
   end_group() is empty;

   // Process end of instance coverage information according to user preferences.
   end_instance() is empty;

   // Report end of item coverage information according to user preferences.
   end_item() is empty;

};

'>

<'

// Singleton struct uvm_ml.
struct uvm_ml like sn_struct {
    // Connect any ports or sockets in any framework in a UVM-ML OA environment.
    connect_names(initiator_path : string, target_path : string) : bool is empty;
    // Connect two TLM 2.0 sockets across languages.
    ml_tlm2_connect(initiator_socket_name: string, target_socket_name: string, map_transactions: bool = TRUE) is empty;
    // Define synchronization between a UVM- e Testflow run-time phase and a run-time phase in another framework.
    synchronize_runtime_phases(specman_phase_domain: string, specman_phase_name: string, other_framework_name: string, other_phase_domain: string, other_phase_name: string) is empty;
};

// You can override the default serialization for e code to control which fields are to be de/serialized by extending the tlm_pass_field () method of uvm_ml_config.
struct uvm_ml_config like any_struct {
    // Control which fields of a struct will be passed via TLM communication or e configuration.
    tlm_pass_field(field: rf_field): bool is empty;
};

'>

<'

// @non_standard
struct sn_adapter_manager like sn_struct {
	// @non_standard
    get_argv_make_recursive(flag : bool) is empty;
	// @non_standard
    get_argv() : list of string is empty;
};
'>

<'
// @non_standard
type cast : [none, numtype2numtype, numtype2double, numtype2long, numtype2longuint, numtype2longint, numtype2uint, numtype2int, double2numtype, double2double, double2long, double2longuint, double2longint, double2uint, double2int, long2numtype, long2double, long2long, long2longuint, long2longint, long2uint, long2int, longuint2numtype, longuint2double, longuint2long, longuint2longuint, longuint2longint, longuint2uint, longuint2int, longint2numtype, longint2double, longint2long, longint2longuint, longint2longint, longint2uint, longint2int, uint2numtype, uint2double, uint2long, uint2longuint, uint2longint, uint2uint, uint2int, int2numtype, int2double, int2long, int2longuint, int2longint, int2uint, int2int];

// @non_standard
struct rf_range_generated_field like rf_field {
	// @non_standard
    get_range(instance : any_struct) : set is empty;
};


'>


<'
// @non_standard
type po_radix : [DEC, HEX, BIN];
'>


<'
// @non_standard
struct debug like sn_struct {
};
'>

<'
extend any_sequence_driver {
	// @non_standard
    get_pending_do_reqs() : list of do_request is empty;
};

'>


<'

struct annotation like base_struct {
	// By default, an annotation type can be attached to any type or struct member definition.
	// However, by extending this hook method, it is possible to restrict an annotation to be attached only to particular entities.
	// By default, this method returns TRUE. It can be extended to return FALSE when an annotation is non-applicable to a given element.
	is_applicable(entity : rf_definition_element) : bool is empty;
	// Given an annotation, this method returns the definition element to which this annotation is attached.
	get_definition_element() : rf_definition_element is empty;
	// This predefined static method is automatically added to each non-repeatable annotation type, and can be used to get annotations attached to a given entity.
	// It returns an annotation object of the given type attached to the given definition element. If no annotation of this type is attached to the given element, returns NULL. If NULL is passed as parameter, returns NULL.
	// Given an annotation object, it can be examined by checking its fields, which are actually fields of the corresponding annotation type. All annotation fields are constant, so they can only be queried but not modified.
	// @param entity_exp Expression that represents a definition entity in the program.
	// @return Existing non-repeatable annotation type name, possibly with a package qualifier.
	static get_attached_annotation(entity_exp: rf_definition_element): annotation is empty;
	// This predefined static method is automatically added to each annotation type, and can be used to get annotations attached to a given entity.
	// Returns the list of annotation objects of the given type attached to the given definition element. If the annotation type is non-repeatable, the returned list will never have more than one item. If no annotations of this type are attached to the given element, an empty list is returned. If NULL is passed as parameter, an empty list is returned.
	// Given an annotation object, it can be examined by checking its fields, which are actually fields of the corresponding annotation type. All annotation fields are constant, so they can only be queried but not modified.
	// @param entity_exp Expression that represents a definition entity in the program.
	// @return Existing annotation type name, possibly with a package qualifier.
	static get_attached_annotations_list(entity_exp: rf_definition_element): list of annotation is empty;
	// This static method returns the list of all annotations. It includes all kinds of annotations in the loaded and compiled code, (attached to all entities).
	static get_all_annotations() : list of annotation is empty;
};


'>


<'

// Facilitates generic traversal over unit and/or struct instances,
// and execution of some common checks or actions on them.
// It can go over the entire unit tree of a unit and visit every unit instance inside the tree,
// starting from the given root object instance, and visit all object instances under the root object.
// The traversal is done in DFS (depth-first search) order – that is,
// traversing a field of a given object is started only after a previous field is fully traversed.
struct instance_iterator {
   
   // Starts a new traversal from the given root object.
   // After a call to start(), the root object itself (and the corresponding path item)
   // is already considered to be the currently visited instance,
   // available via get_current_instance() and other methods.
   start(root: any_struct) is empty;
   
   // Starts a new global traversal, normally starting from sys.(and thus normally equivalent to start(sys).
   // However, in a UVM-ML environment that might have multiple e unit trees (under different trees in other languages), all trees are traversed. In this case, it is still guaranteed that no object will be visited more than once, even if references to an object exist in different trees.
   start_all() is empty;
   
   // Finishes the current traversal, even if not all objects has been visited.
   finish() is empty;
   
   // Advances to the next instance in the traversal order.
   // Returns TRUE if the next instance is reached, or FALSE if there are no more instances and the traversal is finished.
   // If the traversal has not been started yet (start() was not called),
   // or if it was finished explicitly (by calling finish()),
   // or if it was finished by having visited all objects, it returns FALSE.
   next(): bool is empty;
   
   // Returns the currently visited instance, or NULL if the traversal has not been started or has been finished.
   get_current_instance(): any_struct is empty;
   
   // Returns the number of items in the current traversal path starting from root
   // (excluding root itself), or UNDEF if the traversal has not been started or has been finished.
   get_current_depth(): int is empty;
   
   // Returns the current traversal path, starting from root.
   get_current_path(): list of instance_path_item is empty;
   
   // Returns the item in the current traversal path by the given index.
   // The index of root is 0. If the traversal has not been started or has been finished, or if the given index is greater than or equal to the current path length, it returns NULL.
   get_path_item_by_index(i: int): instance_path_item is empty;
   
   // Returns the last item in the current traversal path, which represents the currently visited object.
   // If the traversal has not been started or has been finished, it returns NULL.
   get_current_path_item(): instance_path_item is empty;
   
   // Returns the string representation of the current traversal path, prefixed with the given prefix.
   // Items in the path are separated by dots. Each item is represented by its field name,
   // or in the case of a list field, the appended list index or indices enclosed in square brackets. In principle, an expression parsed from this string should be a valid expression whose value represents the currently visited instance.
   get_current_path_string(prefix: string = ""): string is empty;
   
   
   /// Hook Methods of instance_iterator ///
   
   
   
   // This method determines whether the given field should be skipped during traversal. 
   // By default it returns FALSE, and the user can extend it to return TRUE on certain fields and/or under certain conditions.
   // This method is called automatically prior to visiting each field, and if it returns TRUE, the field is completely skipped.
   skip_field(f: rf_field): bool is empty;
   
   // This method determines whether the current object instance should be skipped during traversal.
   // By default it returns FALSE, and the user can extend it to return TRUE under certain conditions. 
   // At the time this method runs, the current path already contains the instance,
   // and it can be queried using the API methods.
   // This method is called automatically upon visiting each instance, and if it returns TRUE,
   // visiting the current instance is rejected, and the next instance is tried.
   skip_instance(): bool is empty;

   // If this method returns TRUE, traversal also visits port instances (in addition to struct and unit instances).
   // By default, it returns FALSE, and the user may extend it.
   // This method is called automatically when the iterator object is created,
   // so as to determine the visiting policy, so its effect should be global,
   // and it cannot depend on the current traversal state.
   with_ports(): bool is empty;
   
};

struct instance_path_item {
   // Returns the object instance that was reached during the traversal.
   get_instance(): any_struct is empty;
   
   // Returns the field of the upper struct in which the relevant object was reached during the traversal.
   // Returns NULL for the first item in the path, which represents the traversal root.
   get_field(): rf_field is empty;
   
   // If the field in which the object was reached is a list field, returns the corresponding list index.
   // Otherwise, returns UNDEF. If the list is multi-dimensional, returns the index of the first dimension.
   get_list_index(): int is empty;
   
   // If the field in which the object was reached is a list field, returns the list of list indices for each list dimension.
   // (In case of a single-dimensional list, the resulting list has one element.) Otherwise, returns an empty list.
   // For example, assume the field 'f' is of type "list of list of list of my_struct",
   // and the current object was reached via f[2][5][1]. In this case, this method will return the list {2;5;1}.
   get_list_indices(): list of int is empty;
   
};

// Visits unit instances only, and skips structs.
// Using the start() method with a non-unit struct instance leads to a run-time error.
struct unit_instance_iterator like instance_iterator {};

// Visits port instances only, and does not visit unit instances or structs.
// As opposed to the general principle of skipping fields, in this case unit instances are not visited;
// however it does not cause their inner port instances to be skipped.
// The with_ports() method has no effect.
// After calling start(), there is not yet a current instance.
// After each call to next(), the current instance is the next port instance,
// and the current path includes only the port instance itself,
//without any unit instances between the root and the port.
struct port_instance_iterator like instance_iterator {};

// Visits unit and port instances. It is similar to unit_instance_iterator
// except that it ignores the with_ports() method and always visits port instances, too.
struct unit_and_port_instance_iterator like instance_iterator {};


'>

