<' // Mathematical Constants

// e
define SN_M_E 2.71828;

// Logarithm base 2 of e
define SN_M_LOG2E 1.4427;

// Logarithm base 10 of e
define SN_M_LOG10E 0.434294;

// Natural logarithm of 2
define SN_M_LN2 0.693147;

// Natural logarithm of 10
define SN_M_LN10 2.30259;

// PI
define SN_M_PI 3.14159;

// 2*PI
define SN_M_TWO_PI 2*SN_M_PI;

// PI/2
define SN_M_PI_2 SN_M_PI/2;

// PI/4
define SN_M_PI_4 SN_M_PI/4;

// 1/PI
define SN_M_1_PI 1/SN_M_PI;

// 2/PI
define SN_M_2_PI 2/SN_M_PI;

// 2/sqrt(PI)
define SN_M_2_SQRTPI 2/sqrt(SN_M_PI);

// sqrt(2)
define SN_M_SQRT2 sqrt(2);

// sqrt(1/2)
define SN_M_SQRT1_2 sqrt(1/2);

'>

<' // Physical Constants

// Charge of electron in coulombs
define SN_P_Q 1.60219e-19;

// Speed of light in vacuum in meters/sec
define SN_P_C 2.99792e+08;

// Boltzmann's constant in joules/kelvin
define SN_P_K 1.38062e-23;

// Planck's constant in joules*sec
define SN_P_H 6.62608e-34;

// Permittivity of vacuum in farads/meter
define SN_P_EPS0 8.85419e-12;

// Permeability of vacuum in henrys/meter
define SN_P_U0 1.25664e-06;

// Zero Celsius in kelvin
define SN_P_CELSIUS0 273.15;

'>

<' // Statements

// @non_standard
define <__etools__DEPR_LOAD'statement> "##DEPR_LOAD## <name>" as {
   import <name>
};

// This statement creates a new linting rule with the given id and adds the id to the list of items of the predefined type lint_rule_id.
// The rule id must be a sequence of alphanumeric characters, starting with a letter. By convention, it should be a sequence of six upper-case letters and the choice of letters should map with some important keywords in the rule.
// Note: Each linting rule must also be defined in the HAL rules file. In particular, the rules file can specify the category to which the rule belongs and its severity. By default, the rule does not belong to any category (and therefore, will not be actually reported, unless the disable_unclassified_rules HAL parameter is set to no), and its severity is WARNING.
//
// Parameters:
//  rule_id - the id of the new rule
//  description - a general description for the rule
define <__etools__LINT_RULE'statement> as "lint_rule <rule_id'name> <description'string>" as {};


// This statement associates a new parameter with the given rule id and specifies the default value for it. The default value expression is treated as a string.
// The rule id must be previously defined with lint_rule.
// The parameter name must be a sequence of alphanumeric characters, starting with a letter.
// If the rule already has an associated parameter with the given name, the default value of parameter is replaced with the new value. However, it is recommended to change the default value of a parameter using the HAL rules file.
// Not defining a parameter directly in e (with a lint_rule_param statement) is acceptable if the parameter is defined in the HAL rules file. However, if a parameter is not defined either way (neither in e, nor in the HAL rules file), an error is reported if this parameter is being inquired during execution of the user_analysis() method.
// If a parameter is defined both in e and in the HAL rules file, the latter overrides the former.
//
// Parameters:
//  id - a rule id
//  param_name - the name to be used for the new parameter
//  default_value - the default value expression for the new parameter
define <__etools__LINT_RULE_PARAM'statement> as "lint_rule_param <id'name> <param_name'name> <default_value'exp>" as {};

// @non_standard
define <__etools__ML_UVM_TYPE_MATCH'statement> "ml_uvm_type_match <s1'string> <s2'string>" as {};

// @non_standard
define <__etools__ML_OVM_TYPE_MATCH'statement> "ml_ovm_type_match <s1'string> <s2'string>" as {};

// @non_standard
define <__etools__SN_DEFINE_NOTIFY'statement> "sn_define_notify <name'id> <severity'id> <message'string>" as {};

// @non_standard
// The way to create a subtype of the sn_denali_unit type is with a Specman template macro named SN_DENALI_MEMORY_UNIT.
// When you call the macro, you specify the desired bus width.
define <SN_DENALI_MEMORY_UNIT'statement> "SN_DENALI_MEMORY_UNIT <name> using width[ ]=[ ]<exp>" as {
   unit <name> like sn_denali_unit {};
};

// Force an e struct to be mapped to SystemVerilog packed struct when it is being passed during configuration.
define <__etools__UVM_ML_PACKED_STRUCT'statement> "uvm_ml_packed_struct <name>" as {};

'>


<' // Actions

// @non_standard
define <__etools__DOLLAR_DISPLAY'action> "$display<etools_WS>\(<any>\)" as {};

// Identify a significant state change taking place in this scope.
define <__etools__MSG_CHANGED'action> "msg_changed\(<any>\)[[ ]<block>]" as {};

// Issues a message marking the end of processing for a given transaction.
define <__etools__MSG_ENDED'action> "msg_ended\(<any>\)[[ ]<block>]" as {};

// Reports a significant event in the environment, that occurs at a certain point in time, possibly related to
//  the provided data items or items, and which is not applicable to the other kinds of structured debug messages.
define <__etools__MSG_INFO'action> "msg_info\(<any>\)[[ ]<block>]" as {};

// Issues a message marking the start of a new transaction.
define <__etools__MSG_STARTED'action> "msg_started\(<any>\)[[ ]<block>]" as {};

// Issue a message marking the transformation of existing data item(s) or the outcome of a relationship between data items.
define <__etools__MSG_TRANSFORMED'action> "msg_transformed\(<any>\)[[ ]<block>]" as {};

// @non_standard
define <__etools__api__VR_EVC_ASSERT'action> "VR_EVC_ASSERT <cond'exp>[ <err_msg'exp>]" as {};

'>

<' // Expressions

// @non_standard
define <__etools__api__SN_SAFE_NEW'exp> "SN_SAFE_NEW <exp>" as {
   <exp>
};

'>

<'// Types

// Defines and instantiates e TLM 2.0 sockets.
define <__etools__TLM2_SOCKETS_INITIATOR'type> "tlm_initiator_socket[ of <id1'id>][ using (prefix[ ]=[ ]<prefix'id>|suffix[ ]=[ ]<suffix'id>)]" as {
   out any_tlm_socket of tlm_initiator_implementor of tlm_generic_payload
};

define <__etools__TLM2_SOCKETS_TARGET'type> "tlm_target_socket[ of <id1'id>][ using (prefix[ ]=[ ]<prefix'id>|suffix[ ]=[ ]<suffix'id>)]" as {
   in any_tlm_socket of tlm_target_implementor of tlm_generic_payload
};

'>

<' // Other Constants

define MAX_RANDOM_COUNT 10;

define MAX_RANDOM_DEPTH 4;

'>

<'
define <__etools__IF_SPECMAN_VERSION'statement> "#IF_SPECMAN_VERSION\(<version'name>,...\) <b'block>" as computed {

	var block := str_expand_dots(<b'block>);
	var version_names := <version'names>;
	var specman_version := rf_manager.get_specman_version();
	
	if specman_version == NULL or str_empty(specman_version) {
		return "";
	};
	
	for each (version_name) in version_names {
	
		specman_version = str_replace(specman_version, "/\.|-|[a-z]/", "");
		version_name = str_replace(version_name, "/\.|-|[a-z]/", "");
		
		if specman_version == version_name {
			return block;
		};
	};
	
	return "";

};
'>
