<'

// ---
// Enums
// ---

type analog_kind_t: [
    unset,
    potential,
    flow
];

// Specifies the way the driver and the BFM interact with each other.
// Possible options are PULL_MODE (the default) and PUSH_MODE. It can be constrained.
type bfm_interaction_mode_t : [ PULL_MODE, PUSH_MODE ];

// Type defining the simulator behavior when DUT error is encountered.
// ERROR - Specman issues an error message, increases num_of_dut_errors, halts the run immediately, and returns to the simulator prompt or exits.
// ERROR_BREAK_RUN - Specman issues an error message, increases num_of_dut_errors, breaks the run at the next cycle boundary and updates the simulation GUI with the latest values, and returns to the simulator prompt or exits.
// ERROR_AUTOMATIC - Specman issues an error message, increases num_of_dut_errors, breaks the run at the next cycle boundary, and performs the end of test checking and finalization of test data that is normally performed when stop_run() is called, and returns to the simulator prompt or exits.
// ERROR_CONTINUE - Specman issues an error message, increases num_of_dut_errors, and continues execution.
// WARNING -Specman issues a warning, increases num_of_dut_warnings and continues execution.
// IGNORE - Specman issues no messages, does not increase num_of_dut_errors or num_of_dut_warnings, and continues execution.
type check_effect : [ERROR, ERROR_BREAK_RUN, ERROR_AUTOMATIC, ERROR_CONTINUE, WARNING, IGNORE];

// The predefined enumerated type e_time_units defines eight time unit designators: fs, ps, ns, us, ms, sec, min, hr.
type e_time_units: [ fs, ps, ns, us, ms, sec, min, hr ];

// @deprecated
// Indicates whether an agent is ACTIVE or PASSIVE.
type erm_active_passive_t : [ ACTIVE, PASSIVE ];

// @non_standard
type gen_technology_t: [ IntelliGen, Pgen];

// ANY, FAILURE, SUCCESS, NONE
type HDL_ASSERTION_CB_REASON : [ANY, FAILURE, SUCCESS, NONE];

// NONE, OVL_V1, OVL_V2, OVL, SVA, PSL, ANY_LANG
type HDL_ASSERTION_LANGUAGE : [NONE, OVL_V1, OVL_V2, OVL, SVA, PSL, ANY_LANG];

// NONE, FATAL, ERROR, WARNING, INFO
type HDL_ASSERTION_SEVERITY_LEVEL : [NONE, FATAL, ERROR, WARNING, INFO];

// @non_standard
type HDL_ASSERTION_TYPE : [NONE, IMMEDIATE, ASSERT, ASSUME, COVER, RESTRICT, NOT_SET];

// @non_standard
type HDL_ASSERTION_CB_SYNC_MODE : [SYNC, ASYNC, BOTH];

// Enumerated type that contains the unique identifiers for each linting rule.
type lint_rule_id : [DEFAULT];

// Messages format style.
type message_format : [ short, long, none ];

// Message to on/off.
type message_on_off : [on, off];

// Message operation.
type message_operation : [replace, add, remove];

// Message tags are used for associating specific message actions with a message logger.
type message_tag : [NORMAL, TRACE_SERIALIZATION, TRACE_SEQUENCE, TRACE_OBJECTION, GSA_TRACE, GSA, GSA_MESSAGE, TRACE_PORTS];

//
type message_verbosity : [NONE, LOW, MEDIUM, HIGH, FULL];

// Predefined multi-value logic data type.
// To read and write multi-value logic (MVL) data to simple ports whose data type is not mvl or list of mvl, you must use the simple port MVL methods.
// For ports of type mvl or list of mvl, you can use the simple port access operator (simple_port$), or you can use the MVL methods, or a mixture of both.
type mvl : [ MVL_U, MVL_X, MVL_0, MVL_1, MVL_Z, MVL_W, MVL_L, MVL_H, MVL_N ];

// The predefined enum type objection_kind contains all topics for which the objection mechanism is needed.
// Initially, it contains the single value TEST_DONE.
type objection_kind : [ TEST_DONE ];

// @non_standard
type pack_level: [
    physical,
    svtp,
    mltp,
    full,
    tlm2,
    sp
];

// @non_standard
type random_policy: [
    flat,
    lowest,
    highest,
    jumping
];

// Predefined radix type.
// For items of type int or uint, specifies the radix used to print the values.
type radix : [ DEC, HEX, BIN, OCT ];

// Whether bucket is illegal, normal, or hole.
type bucket_status : [ illegal, normal, hole, ignore, invalid ];

// @non_standard
type sn_cfg_cover_mode : [
    default,
    off,
    on,
    on_interactive
];

// The predefined enumerated type sn_denali_access_type lists names used for predefined access type events.
// The sn_denali_access_type must be used so that callback event kinds can be recognized.
type sn_denali_access_type : [
    sn_denali_read
    , sn_denali_read_unk
    , sn_denali_write
    , sn_denali_write_unk
    , sn_denali_write_mask
    , sn_denali_write_masked_unk
    , sn_denali_ei
    , sn_denali_ei_unk
    , sn_denali_ei_mask
    , sn_denali_ei_masked_unk
    , sn_denali_load
    , sn_denali_load_done
    , sn_denali_reset
];

// The edge on which to generate the event
type event_port_edge : [
    // Equivalent to the behavior of @sim temporal expressions.
    // This means that transitions between x and 0, z and 1 are not detected, x to 1 is considered a rise, z to 0 a fall, and so on.
    change,
    // Equivalent to the behavior of @sim temporal expressions.
    // This means that transitions between x and 0, z and 1 are not detected, x to 1 is considered a rise, z to 0 a fall, and so on.
    rise,
    // Equivalent to the behavior of @sim temporal expressions.
    // This means that transitions between x and 0, z and 1 are not detected, x to 1 is considered a rise, z to 0 a fall, and so on.
    fall,
    // Any change within the supported MVL values is detected, including transitions from x to 0 and 1 to z.
    any_change,
    // Transitions from 0 to 1 only.
    MVL_0_to_1,
    // Transitions from 1 to 0 only.
    MVL_1_to_0,
    // Transitions from X to 0 only.
    MVL_X_to_0,
    // Transitions from 0 to X only.
    MVL_0_to_X,
    // Transitions from Z to 1 only.
    MVL_Z_to_1,
    // Transitions from 1 to Z only.
    MVL_1_to_Z
];

type sn_event_port_edge : event_port_edge; 

type sn_lib_scope_mode: [
    dont_care,
    global,
    local
];

type sn_lib_resolve_mode: [
    dont_care,
    lazy,
    now
];

type sn_per_inst_cover_t: [
    DEFAULT,
    YES,
    NO
];

type sn_port_direction: [
    undef,
    in,
    out,
    inout,
    export
];

// When an e input method port is called from the SystemC object, the synchronization of this call depends on the sync_mode() value for the port.
type sn_sync_options: [
    // The call is executed at the beginning of the next Specman tick.
    sync_call,
    // The e method is invoked immediately, regardless of the status of the simulation cycle.
    async_call,
    // A Specman tick is created immediately, regardless of the status
    async_tick_call
];

// The VHDL delay mode of an external out port.
// This attribute specifies whether pulses whose period is shorter than the delay specified by the
//  driver_delay() attribute are propagated through the driver.
type sn_vhdl_delay_mode_option: [
    // TRANSPORT specifies that all pulses, regardless of length, are propagated.
    TRANSPORT,
    // INERTIAL specifies that such pulses are not propagated.
    INERTIAL
];

// The values of this enumerated type represent possible points of sampling for data item attributes.
// <br>STARTED - the data-item argument of msg_started()
// <br>ENDED - the data-item argument of msg_ended()
// <br>TRANSFORMED_FROM - the from-item (first) argument of msg_transformed()
// <br>TRANSFORMED_TO - the to-item (second) argument of msg_transformed()
// <br>It serves to determine the sampling policy for specific attributes using "set_attribute_sampling()" .
type tr_sampling_point_t : [ STARTED, CHANGED, INFO, ENDED, TRANSFORMED, SAMPLED_COVER ];


'>
