<'

extend global {

    // @non_standard
	adapter_manager: sn_adapter_manager;
	
    // The global singleton object which provides methods that let you define assertion instances as hdl_assertion types, and register callbacks on them.
    assert_mgr : hdl_assertions_mgr;

    // The global singleton object which contains coverage related API.
    covers;

    // The global singleton object which contains CVL related API.
    cvl_manager;

    // @non_standard
    display : sn_display;

    // @non_standard @deprecated
    // The global singleton object which contains API to define the transactions you want to trace.
    external_trace: sn_external_trace;

    // The global singleton object which contains predefined routines for working with files.
    files;

    // The global singleton object that enables runtime control of C routine names and libraries of Function-Level Interface (abbreviated FLI) import subroutines (TCMs or methods).
    fli_shlibs : sn_fli_shlibs;

    // The global singleton object which encapsulates the functionality of performing user-defined linting analysis and reporting.
    lint_manager;

    // The global singleton object which contains methods that are used for modifying message settings and formats.
    message_manager;

    // The global singleton object which contains packing and unpacking related API.
    packing;

    // @non_standard
    params;
    
    // Global operations on port callbacks are done using methods of global object port_cb_manager.
    port_cb_manager;

    // @non_standard
    run_flow_notify: bool;

    // The global singleton object which contains reflection related API.
    rf_manager;

    // The global singleton object which contains methods that let you access active TCMs and terminate them.
    scheduler;

    // The global singleton object which contains the status of the current simulator session, related information, and events.
    session;

    // The global singleton object which contains API to interface procedurally with dynamic C routines.
    shlibs: sn_shlibs;

    // The global singleton object which contains simulator related API.
    simulator;

    // @non_standard
    sequence_manager: sn_sequence_manager;

    // The global singleton object which contains sn_denali related API.
    sn_denali;

    // @non_standard
    sn_table_manager: table_manager;

    // @non_standard
    sn_uvm_simvision_interface;

    // @non_standard
    symtab;

    // @non_standard
    table_manager;

    // @non_standard;
    util: sn_util;

    // The system unit.
    sys;

    // @non_standard
    vt: vt::sn_vt;

    // @non_standard
    vt_util: vt::vt_util;

    // @non_standard
    rf_type (exp: untyped) : rf_type is empty;
    // SIMI: Should change it to macro and compute the type of the argument expression

};

'>

<'

extend global {
    
    // @non_standard
    check_for_control_c() is empty;

    // Runs check() for every struct under sys.
    // This method is called when you issue a test or check command from the Specman command line.
    // It is also called under the following conditions:
    //  When a run is stopped by a call to stop_run().
    //  When a run is stopped by a simulator exit command.
    //  When a DUT error occurs and the check effect is ERROR_AUTOMATIC.
    check_test() is empty;

    // @non_standard
    current_source_ref(): source_ref is empty;

    // @non_standard
    dbg_out(__dvt_ignore_args) is empty;

    // Collects data from the DUT before the post-run checking is performed.
    // This method is called when you issue a test or check command from the Specman command line.
    // It is also called under the following conditions:
    //  When a run is stopped by a call to stop_run().
    //  When a run is stopped by a simulator exit command.
    //  When a DUT error occurs and the check effect is ERROR_AUTOMATIC.
    extract_test() is undefined;

    // Finalizes the test data, including the emitting of the session.end_of_test event and the writing of coverage information.
    finalize_test() is empty;

    // Performs pre-run generation by calling sys.generate() and the following predefined methods of every struct under sys:
    //  struct.init(), struct.pre_generate(), struct.post_generate().
    // This method is called when you issue a test, start, or generate command from the Specman command line.
    generate_test() is empty;

    // @non_standard
    get_specman_os(): string is empty;

    // Returns the current Specman timescale.
    get_time_scale() : string is empty;

    // @non_standard
    // Returns the current Specman timescale.
    get_timescale() : string is empty;

    // @non_standard
    get_uvc_msi_mode(): string is empty;

    // @non_standard
    internal_post_generate_test() is empty;

    // Identifies whether Specman is in GUI mode.
    is_gui(): bool is empty;

    // @non_standard
    post_restore_actions(file:string) is empty;

    // Method that that is called by global.stop_run() before calling any_struct.quit() method.
    pre_quit() is empty;

    // @non_standard
    pre_restore_actions(file:string) is empty;

    // Print the current user stack trace to the Specman log file.
    print_stack_trace() is empty;

    // Executes sys.run() and for every struct or unit under sys in depth-first field order, executes the struct's run() method.
    // This method is called when you issue a test or run command from the Specman command line.
    run_test() is empty;

    // @non_standard
    rnd(low: int, high: int, text: string) : uint is empty;

    // Initializes test parameters, such as the initial seed for random generation.
    // This method is called automatically when you issue a test, start, generate or setup command from the Specman command line.
    // In turn, it invokes sys.wave_setup() and sys.setup().
    setup_test() is empty;

    // Identify whether a simulator is available to work with Specman.
    simulator_exists() is empty;

    // @non_standard
    SN_ASSERT(exp: bool) is empty;

    // @non_standard
    sn_err(__dvt_ignore_args) is empty;

    // @non_standard
    sn_notify(__dvt_ignore_args) is empty;

    // Determines if a particular argument is a +plusarg argument on the command line
    //  (that is, an argument being passed to the e program via the command line).
    sn_plusarg_exists(arg : string) : bool is empty;

    // Returns the value of a particular +plusarg argument on the command line
    //  (that is, an argument being passed to the e program via the command line).
    sn_plusarg_value(arg : string) : string is empty;

    // @non_standard
    sn_uint_rnd(from: int, to: int) : uint is empty;

    // @non_standard
    sn_version(): string is empty;

    // @non_standard
    sn_version_string(): string is empty;

    // @non_standard
    sn_warnf(__dvt_ignore_args) is empty;

    // Prepares Specman to start the simulation run.
    // This method is called when you issue a test or start command from the Specman command line.
    start_test() is empty;

    // Stop a simulation run cleanly.
    stop_run() is empty;

};

'>

<'
// ---
// Pseudo Methods
// ---

extend global {

    // [pseudo method] Get source reference string.
    source_location(): string is empty;

    // [pseudo method] Get name of executing method.
    source_method(): string is empty;

    // [pseudo method] writef(file_handle: file, format: string, item:exp, ...)
    // Write to a file in a specified format, with no new line at the end.
    writef(file_handle: file, format: string, __dvt_variable_nof_args) is empty;

};


'>

<'
// ---
// Macro Related Routines
// ---

extend global {

    // [macro related routine] Return current line number from a macro call.
    get_current_line_num(): int is empty;

    // [macro related routine] Return the current module from a macro call.
    get_current_module() : rf_module is empty;

    get_context_type() : rf_structural_element is empty;

    // [macro related routine] Restrict the syntax specified by a macro match expression.
    reject_match() is empty;

    // [macro related routine] Expand strings shortened by the parser.
    str_expand_dots(str: string): string is empty;

    // [macro related routine] @non_standard
    str_expand_top_level_dots(str: string, b: bool): string is empty;

};

'>

<'
// ---
// Packing Routines
// ---

extend global {
	
    // [packing routine] pack(option:pack option, item: exp, ...): list of bit
    // Perform concatenation and type conversion.
    pack(options: pack_options, __dvt_variable_nof_args): list of bit is empty;

    // [packing routine] unpack(option: pack option, value: exp, target1: exp [, target2: exp, ...])
    // Unpack a bit stream into one or more expressions
    unpack(options: pack_options, __dvt_variable_nof_args) is empty;
};

'>

<'
// ---
// DUT Error Routines
// ---

extend global {

    // Set check severity of check action or expect/assume struct member.
    set_check(static_match: string, check_effect: check_effect
        , root_unit: any_unit = NULL, recursive: bool =TRUE) is empty;

    // Set check severity of named check action or expect/assume struct member.
    set_check_by_name(struct_name: string, check_name: string, check_effect: check_effect
        , root_unit: any_unit = NULL, recursive: bool = TRUE
        , all_layers: bool = FALSE) is empty;

	// Set check severity of illegal/instance_illegal cover item option
	set_check_by_cover_item(struct_name: string, group_name: string
		, item_name: string, check_effect: check_effect, root_unit: any_unit=NULL
		, recursive: bool=TRUE, all_layers: bool=FALSE) is empty;
	
};


'>

<'
// ---
// Error Routines
// ---

extend global {

    // [error routine] error(message: string, ...)
    // Issues the specified error message, halts all methods being currently run, and returns to the Specman prompt.
    // The only exception to this is if the error action appears inside the first action block given in a try action.
    // In that case, Specman jumps to the else action block within the try action and continues running.
    error(__dvt_variable_nof_args) is empty;

    // [error routine] fatal(message: string, ...)
    // Issues the specified error message, halts all activity, exits Specman immediately, and returns to the UNIX prompt.
    // (If you are working in Specview, a dialog box appears before you are returned to the UNIX prompt.)
    // fatal() returns a non-zero status to the UNIX shell.
    fatal(__dvt_variable_nof_args) is empty;

    // [error routine] warning(message: string, ...)
    // Issues the specified warning error message.
    // Does not halt the methods being currently run.
    warning(__dvt_variable_nof_args) is empty;

};

'>

<'

extend global {

    // @deprecated
    // Turns coverage data collection and display on or off for specified items or events.
    set_cover(wildcards: string, on: bool) is empty;

};

'>

<'
// -------------------------
// Struct ID Routine
// -------------------------

extend global {

    // Returns a unique ID for the given struct instance.
    sn_unique_id_for_struct(instance : base_struct): int is empty;

};

'>

<'
// -------------------------
// Deep Copy and Deep Compare Routines
// -------------------------

extend global {

    // [copy routine] Make a recursive copy of a struct and its descendants.
    deep_copy(struct_instance: any_struct): any_struct is empty;
    // FIXME deep_copy() should be a macro as return type is not fixed. See also autocomplete.

    // [compare routine] Perform a recursive comparison of two struct instances.
    deep_compare(struct_instance1: any_struct, struct_instance2: any_struct, max_diffs: int): list of string is empty;

    // [compare routine] Perform a recursive comparison of the physical fields of two struct instances.
    deep_compare_physical(struct_instance1: any_struct, struct_instance2: any_struct, max_diffs: int): list of string is empty;

    // [generation routine] Specify generation order with unidirectional propagation.
    // Specifies that, within the context of a constraint, the fields inside the read_only() (the source fields)
    // are considered as inputs or pre-conditions for selecting the values for the other fields (the dependent fields).
    read_only(item: exp): exp is empty;

    // [generation routine] Specify generation order with unidirectional propagation.
    // This generates values for any data items that are contained in the expression and returns the value of the
    // expression. This method affects generation order and also makes the constraint unidirectional.
    value(item: exp): exp is empty;
    
    // [pseudo routine] Access all values of a scalar type.
    all_values(scalar_type): list of scalar_type is empty;
    
    // [pseudo routine] Access the set of all legal values of a type.
    set_of_values(scalar_type): set is empty;
    
    // [pseudo routine] Access the set of all possible legal and illegal values of a type.
    full_set_of_values(scalar_type): set is empty;
    
};

'>

<'
// --------------
// Arithmetic Routines
// --------------
// NOTE: Argument type is not fixed...

extend global {

    // [arithmetic routine] min(x: numeric_type, y: numeric_type)
    // Get the minimum of two numeric values.
    min(x: int, y: int): int is empty;

    // [arithmetic routine] max(x: numeric_type, y: numeric_type)
    // Get the maximum of two numeric values.
    max(x: int, y: int): int is empty;

    // [arithmetic routine] abs(x: numeric_type)
    // Get the absolute value.
    abs(x: int): int is empty;

    // [arithmetic routine] Check if an integer is odd.
    odd(x: int): bool is empty;

    // [arithmetic routine] Check if an integer is even.
    even(x: int): bool is empty;

    // [arithmetic routine] ilog(x: numeric_type): int
    // @non_standard
    ilog(x: int): int is empty;

    // [arithmetic routine] ilog2(x: numeric_type): int
    // Get the base-2 logarithm.
    ilog2(x: int): int is empty;

    // [arithmetic routine] ilog10(x: numeric_type): int
    // Get the base-10 logarithm.
    ilog10(x: int): int is empty;

    // [arithmetic routine] ipow(x: numeric_type, y: numeric_type): numeric_type
    // Raise to a power.
    ipow(x: int, y: int): int is empty;

    // [arithmetic routine] isqrt(x: numeric_type): int is empty;
    // Get the square root.
    isqrt(x: int): int is empty;

    // [arithmetic routine] Division rounded up.
    div_round_up(x: int, y: int): int is empty;

    // @non_standard
    // [arithmetic routine] log2(x: real_type): real
    // Get the base-2 logarithm.
    log2(x: real): real is empty;

};

'>

<'
// ---
// Routines for Random Distribution of Numbers
// ---

extend global {

    // Returns a random integer that is in the range specified by from to to, using a uniform distribution.
    dist_uniform(from: int, to: int): int is empty;

    // Returns a random integer that is in the range specified by from to to, using a normal distribution.
    dist_normal(from: int, to: int, mean: int, deviation: int): int is empty;

    // Returns a random real number that is in the range specified by from to to, using a uniform distribution.
    rdist_uniform(from: real, to: real): real is empty;

    // Returns a random real number that is in the range specified by from to to, using a normal distribution.
    rdist_normal(from: real, to: real, mean: real, deviation: real): real is empty;

    // Randomizes the values of the current range for gen-item as per the given normal distribution, thus allowing a non-uniform distribution of values.
    normal(mean: real, deviation: real) : real is empty;
    
};

'>

<'
// ---------------------------
// Routines Supporting the Real Types
// ---------------------------

extend global {

    // [arithmetic routine for real type] Returns the largest integer that is less than or equal to the parameter.
    floor(x: real): real is empty;

    // [arithmetic routine for real type] Returns the smallest integer that is greater than or equal to the parameter.
    ceil(x: real): real is empty;

    // Returns the closest integer to the parameter.
    // [arithmetic routine for real type] In the case of a tie then it returns the integer with the higher absolute value.
    round(x: real): real is empty;

    // [arithmetic routine for real type] Returns the natural logarithm of the parameter.
    log(x: real): real is empty;

    // [arithmetic routine for real type] Returns the base-10 logarithm of parameter.
    log10(x: real): real is empty;

    // [arithmetic routine for real type] Returns the value of the first parameter raised to the power of second one.
    pow(x: real, pow: real): real is empty;

    // [arithmetic routine for real type] Returns the square root of the parameter.
    sqrt(x: real): real is empty;

    // [arithmetic routine for real type] Returns the value of e raised to the power of the parameter.
    exp(x: real): real is empty;

    // [arithmetic routine for real type] Returns the sine of the parameter given in radians.
    sin(x: real): real is empty;

    // [arithmetic routine for real type] Returns the cosine of the parameter given in radians.
    cos(x: real): real is empty;

    // [arithmetic routine for real type] Returns the tangent of the parameter given in radians.
    tan(x: real): real is empty;

    // [arithmetic routine for real type] Returns the arc sine of the parameter.
    asin(x: real): real is empty;

    // [arithmetic routine for real type] Returns the arc cosine of the parameter.
    acos(x: real): real is empty;

    // [arithmetic routine for real type] Returns the arc tangent of the parameter.
    atan(x: real): real is empty;

    // [arithmetic routine for real type] Returns the hyperbolic sine of the parameter.
    sinh(x: real): real is empty;

    // [arithmetic routine for real type] Returns the hyperbolic cosine of the parameter.
    cosh(x: real): real is empty;

    // [arithmetic routine for real type] Returns the hyperbolic tangent of the parameter.
    tanh(x: real): real is empty;

    // [arithmetic routine for real type] Returns the inverse hyperbolic sine of the parameter.
    asinh(x: real): real is empty;

    // [arithmetic routine for real type] Returns the inverse hyperbolic cosine of the parameter.
    acosh(x: real): real is empty;

    // [arithmetic routine for real type] Returns the inverse hyperbolic tangent of the parameter.
    atanh(x: real): real is empty;

    // [arithmetic routine for real type] Returns the arc tangent of the two parameters.
    atan2(x: real, y: real): real is empty;

    // [arithmetic routine for real type] Returns the distance of the point defined by the two parameters from the origin.
    hypot(x: real, y: real): real is empty;

    // [arithmetic routine for real type] Returns TRUE if the parameter’s value is Not-a-Number (NaN).
    is_nan(x: real): bool is empty;

    // [arithmetic routine for real type] Returns TRUE if the parameter’s value is a finite real value that is, it is not infinity, negative infinity, or NaN).
    is_finite(x: real): bool is empty;

};

'>

<'
// -----------
// Bitwise Routines
// -----------

extend global {

    // [bitwise routine] Boolean AND of all bits.
    bitwise_and(exp: int): bit is empty;

    // [bitwise routine] Boolean OR of all bits.
    bitwise_or(exp: int): bit is empty;

    // [bitwise routine] Boolean XOR of all bits.
    bitwise_xor(exp: int): bit is empty;

    // [bitwise routine] !bitwise_and().
    bitwise_nand(exp: int): bit is empty;

    // [bitwise routine] !bitwise_or().
    bitwise_nor(exp: int): bit is empty;

    // [bitwise routine] !bitwise_xor().
    bitwise_xnor(exp: int): bit is empty;

};

'>

<'
// ----------
// String Routines
// ----------

extend global {

    // [string routine] append(item: exp, ...): string
    // Concatenate expressions into a string.
    append(__dvt_variable_nof_args): string is empty;

    // [string routine]  appendf(format: string, item: exp, ...): string
    // Concatenate expressions into a string according to a given format.
    appendf(format: string, __dvt_variable_nof_args): string is empty;

    // [string routine] bin(item: exp, ...): string
    // Concatenate expressions into string, using binary representation for numeric types.
    bin(__dvt_variable_nof_args): string is empty;

    // [string routine] dec(item: exp, ...): string
    // Concatenate expressions into string, using decimal representation for numeric types.
    dec(__dvt_variable_nof_args): string is empty;

    // [string routine] hex(item: exp, ...): string
    // Concatenate expressions into string, using hexadecimal representation for numeric types.
    hex(__dvt_variable_nof_args): string is empty;

    // [string routine] Enclose a string in double quotes.
    quote(text: string): string is empty;

    // [string routine] @non_standard
    unquote(__dvt_ignore_args): string is empty;

    // @non_standard
    str_bin(__dvt_ignore_args): string is empty;

    // [string routine] Chop the tail of a string.
    str_chop(str: string, length: int): string is empty;

    // @non_standard
    str_dec(__dvt_ignore_args): string is empty;

    // [string routine] Check if a string is empty.
    str_empty(str: string): bool is empty;

    // [string routine] Get a string with exact length.
    str_exactly(str: string, length: int): string is empty;

    // @non_standard
    str_hex(__dvt_ignore_args): string is empty;

    // [string routine] Get a case-insensitive AWK-style regular expression.
    str_insensitive(regular_exp: string): string is empty;

    // [string routine] Concatenate a list of strings.
    str_join(list: list of string, separator: string): string is empty;

    // [string routine] Get string length.
    str_len(str: string): int is empty;

    // [string routine] Convert string to lowercase.
    str_lower(str: string): string is empty;

    // [string routine] Match strings.
    str_match(str: string, regular_exp: string): bool is empty;

    // [string routine] Pad string with blanks.
    str_pad(str: string, length: int): string is empty;

    // [string routine] Repeat string.
    str_repeat(str: string, nof: uint): string is empty;

    // [string routine] Replace a substring in a string with another string.
    str_replace(str: string, regular_exp: string, replacement: string): string is empty;

    // [string routine] Split a string to substrings.
    str_split(str: string, regular_exp: string): list of string is empty;

    // [string routine] Split a string to substrings, including separators.
    str_split_all(str: string, regular_exp: string): list of string is empty;

    // [string routine] Extract a substring from a string.
    str_sub(str: string, start_position: int, length: int): string is empty;

    // [string routine] Removes any leading and trailing whitespace characters from the string.
    str_trim(str: string): string is empty;

    // [string routine] Convert a string to uppercase.
    str_upper(str: string): string is empty;

};

'>

<'
// ----------
// Output Routines
// ----------

extend global {

    // [output routine] out(item: exp, ...): string
    // Print expressions to output, with a newline at the end.
    out(__dvt_variable_nof_args) is empty;

    // [output routine] outf(format: string, item: exp, ...): string
    // Print formatted expressions to output, with no newline at the end.
    outf(format: string, __dvt_variable_nof_args) is empty;

};

'>

<'
// -----------------
// Configuration Routines
// -----------------

extend global {

    // [configuration routine] get_config(category: exp, option: exp)
    // Get the configuration option settings.
    get_config(__dvt_ignore_args) : untyped is empty;

    // [configuration routine] Retrieve the value of the retain state mode.
    get_retain_state(): bool is empty;

    // [configuration routine] Read configuration options from a file.
    read_config(filename: string) is empty;

    // [configuration routine] set_config(category: keyword, option: keyword, value: exp [, option: keyword, value: exp...])
    // Set values of global configuration parameters.
    set_config(__dvt_ignore_args) is empty;

    // [configuration routine] set_config(category: keyword, option: keyword, value: exp [, option: keyword, value: exp...])
    // Increase values of numeric global configuration parameters.
    set_config_max(__dvt_ignore_args) is empty;

    // [configuration routine] Set or reset the retain state mode.
    set_retain_state(exp: bool) is empty;

    // [configuration routine] Save configuration options in a file.
    write_config(filename: string) is empty;

};

'>

<'
// -----------------
// Specman Command Routine
// -----------------

extend global {

    // [command routine] specman(command: string, ...)
    // Send Specman commands from within actions.
    specman(__dvt_variable_nof_args) is empty;

};

'>

<'
// ------------------------------
// OS Interface Routines
// ------------------------------

extend global {

    // [OS interface routine] spawn(command: string, ...)
    // Send commands to the OS.
    spawn(__dvt_variable_nof_args) is empty;

    // [OS interface routine] Send a command to the OS and report error.
    spawn_check(command: string) is empty;

    // [OS interface routine] Send a command to the OS.
    system(command: string): int is empty;

    // [OS interface routine] Collect the results of a system call.
    output_from(command: string): list of string is empty;

    // [OS interface routine] Collect the results of a system call and check for errors.
    output_from_check(command: string): list of string is empty;

    // [OS interface routine] Get UNIX environment variable.
    get_symbol(env_variable: string): string is empty;

    // [OS interface routine] Retrieve current date and time.
    date_time(): string is empty;

    // [OS interface routine] Retrieve process ID.
    getpid(): int is empty;

};

'>

<'
// ---
// Memory-Related Routines
// ---

extend global {

    // [memory routine] Perform on-the-fly garbage collection.
    do_otf_gc() is empty;

    // [memory routine] Collect all the zombie structs.
    get_zombies(): list of any_struct is empty;

};

'>


<'
// ---
// Time Conversion Routines
// ---

extend global {

    // [time conversion routine] Convert a real expression to a specified timescale return value is also real expression.
    double_from_specman_scale(exp: real, time_unit: e_time_units): real is empty;

    // [time conversion routine] Convert a real expression to the Specman timescale and return a real expression.
    double_to_specman_scale(exp: real, time_unit: e_time_units): real is empty;

    // [time conversion routine] Convert a time expression to a specified timescale.
    from_specman_scale(exp: time, time_unit: e_time_units): time is empty;

    // [time conversion routine] Convert a real expression to a specified timescale, and return a time expression.
    from_real_specman_scale(exp: real, time_unit: e_time_units): time is empty;

    // [time conversion routine] Convert a time expression to a specified timescale and return a boolean value indicating whether a truncation took place.
    from_specman_scale_trunc(exp: time, time_unit: e_time_units, res: *time): bool is empty;

    // [time conversion routine] Convert a time expression to the Specman timescale, and return the result as real (nothing is truncated).
    to_real_specman_scale(exp: time, time_unit: e_time_units): real is empty;

    // [time conversion routine] Convert a time expression to the Specman timescale.
    to_specman_scale(exp: time, time_unit: e_time_units): time is empty;

    // [time conversion routine] Convert a time expression to the Specman timescale and return a boolean value indicating whether a truncation took place.
    to_specman_scale_trunc(exp: time, time_unit: e_time_units, res: *time): bool is empty;

};

'>

<'
// ---
// MVL Conversion Routines
// ---

extend global {

    // [MVL conversion routine] Convert a list of bits to a list of mvl values.
    bits_to_mvl(value : list of bit, mask : mvl): list of mvl is empty;

    // [MVL conversion routine] Convert a list of mvl values to a list of 4-value logic subset values.
    // This method is similar to mvl_list_to_mvl4_list().
    // However, instead of creating a new list, it change the existing list provided by user.
    convert_mvl_list_to_mvl4_list(value : list of mvl) is empty;

    // [MVL conversion routine] Convert an integer value to a list of mvl values.
    int_to_mvl(value : uint, mask : mvl): list of mvl is empty;

    // [MVL conversion routine] Convert a list of mvl values to a list of 4-value logic subset values.
    mvl_list_to_mvl4_list(value : list of mvl): list of mvl is empty;

    // [MVL conversion routine] Convert a list of mvl values to a list of bits.
    mvl_to_bits(value : list of mvl, mask : list of mvl): list of bit is empty;

    // [MVL conversion routine] Convert an mvl value to an integer.
    mvl_to_int(value : list of mvl, mask : list of mvl): uint is empty;

    // [MVL conversion routine] Convert an mvl value to a 4-value logic value.
    mvl_to_mvl4(value : mvl): mvl is empty;

    // [MVL conversion routine] Convert a list of mvl values to a string.
    mvl_to_string(l : list of mvl, radix : radix): string is empty;

    // [MVL conversion routine] Convert a string to a list of mvl values.
    string_to_mvl(s : string): list of mvl is empty;

    // [MVL conversion routine] Convert a string to a list of 4-value logic mvl subset values.
    string_to_mvl4 (s : string): list of mvl is empty;

};

'>

<'
// ---
// Port Binding Routines
// ---

extend global {

    // [port binding routine] bind(port-exp1, port-exp2, | empty | undefined | external)
    // You can use the bind() routine in a keep constraint to create a declarative binding that connects a port to another e port or to an external simulated object.
    // Ports can also be defined explicitly as disconnected with empty or undefined.
    bind(__dvt_ignore_args): bool is empty;

    // [port binding routine] do_bind(port-exp1, port-exp2[,...] | empty | undefined | external)
    // By calling the do_bind() routine, you procedurally connect a port to one or more e ports or to one or more external simulated object.
    // Ports can also be left explicitly disconnected with empty or undefined.
    // The do_bind() method can only be called during the connect_ports() sub-phase. Calling it at any other time results in an error message.
    do_bind(__dvt_ignore_args) is empty;


    // [port binding routine] do_bind_unit(port-exp1, unit-exp1, unit-exp2[, explicit-mappings] | empty | undefined | external)
    // Defines all port instances in a unit in one of the following ways:
    //  - As bound by name to the port instances in a second unit
    //  - As bound by explicit mapping to the port instances in a second unit
    //  - As bound to external objects
    //  - As disconnected
    do_bind_unit(__dvt_ignore_args) is empty;

};

'>

<'
// ---
// Simulation-Related Routines
// ---

extend global {

    // Issue a simulator command from e code. The command returns no value. The output of the command is sent to standard output and to the log file.
    simulator_command(command: string) is empty;

};

'>

<'

extend global {

    // [generation constraint] keep [soft] uvm_config_get(field-or-attribute);
    // Gets configuration values from the configuration database.
    // Used to retrieve e configuration values that are set natively or by another framework.
    uvm_config_get(__dvt_ignore_args) is empty;

    // [generation constraint] keep uvm_config_set(inst-name, field-name, value);
    // Sets UVM-ML OA configuration values to be propagated to all frameworks.
    uvm_config_set(__dvt_ignore_args) is empty;
    
    // Create a unit of a user-defined parent proxy type.
    uvm_ml_create_stub_unit(parent_proxy_type_name: string, target_e_path: string) is empty;
    
    // Singleton struct uvm_ml.
    uvm_ml;
    
    // @non_standard
    ml_uvm;
    
};

'>

<'

extend global {

	//@non_standard
	sn_get_td_by_id(i : int) : type_descriptor is empty;
	
	//@non_standard
	sn_eval_cast(a1:int, a2:cast, a3:int) : string is empty;
	
	//@non_standard
	any_to_string(a1:string, a2:int) : string is empty;

};

'>

<'

extend global {
	//@non_standard
	debug;
};

'>
