<'


// ----------------------------------------
// TBA - Transaction Based Acceleration API
// ----------------------------------------


// @non_standard
// [TBA unit] Global configuration unit.
unit tba_unit {

   // @non_standard
   // [tba_unit routine] Sets the channel associated with the specified port to reactive mode. This mode is the default.
   set_reactive_mode(p: any_buffer_port) is empty;

   // @non_standard
   // [tba_unit routine] Sets the channel associated with the specified port to batching mode.
   // In this mode, BFM activities are independent of activities on the hardware.
   set_batching_mode(p: any_buffer_port) is empty;

   // @non_standard
   // [tba_unit routine] Sets all buffer ports to reactive mode.
   set_global_reactive_mode() is empty;

   // @non_standard
   // [tba_unit routine] Sets all buffer ports to batching mode.
   set_global_batching_mode() is empty;

   // @non_standard
   // [tba_unit routine] Locks the reactivity setting of the specified port.
   lock_port(p: any_buffer_port) is empty;

   // @non_standard
   // [tba_unit routine] Unlocks the reactivity setting of the specified port.
   unlock_port(p: any_buffer_port) is empty;

   // @non_standard
   // [tba_unit routine] Does a global flush() of the transaction data in all TBA output ports.
   // Blocks until all existing transactions are consumed.
   global_flush() is empty;

   // @non_standard
   // [tba_unit routine] Places the beginning time stamp of the last received transaction into “timestamp”.
   get_begin_time(p: any_buffer_port, timestamp: *time) is empty;

   // @non_standard
   // [tba_unit routine] Places the ending time stamp of the last received transaction into “timestamp”.
   get_end_time(p: any_buffer_port, timestamp: *time) is empty;

};

'>

<'

// --------
// Misc API Extensions - eRM Customizing Visualization
// --------

extend any_sequence_item {
   // @non_standard
   // Adds user-defined data items (for example, monitor items) to a list of items that can be shown as stripes. The particular list is determined by the given name. If the name is empty, the caller e_path() or to_string() is treated as the name.
   // Also, updates an internal field that can later be shown as the start time of the stripe.
   create_visual_stripe(caller: any_struct, name: string, t: time) is empty;

   // @non_standard
   // Calls get_stripe_prefix(), get_stripe_body(), and get_stripe_suffix() to convert data item info into stripe info.
   stripe(s: vt_stripe) is empty;

   // @non_standard
   // Updates the end time for the stripe.
   end_visual_stripe(t: time) is empty;

   // @non_standard
   // Adds default implementation for stripe prefix.
   get_stripe_prefix(s: vt_stripe) is empty;

   // @non_standard
   // Extended by the user to customize the stripe chart. By default, this method is empty.
   get_stripe_body(s: vt_stripe) is empty;

   // @non_standard
   // Adds default implementation for stripe suffix.
   get_stripe_suffix(s: vt_stripe) is empty;

   // @non_standard
   // Returns the list of items or sequences that were directly called by the sequence.
   get_trace_list(): list of any_sequence_item is empty;
};

extend any_env {
   // @non_standard
   // Shows basic information in the Env window.
   get_env_basic_info(): list of string is empty;

   // @non_standard
   // Shows unit tree in the Env window.
   get_env_detailed_info(): list of string is empty;

   // @non_standard
   // Shows stripe chart information in the Env window.
   get_env_stripe_chart_info(): list of string is empty;
};

'>

<'

// @non_standard
extend sn_struct {

   // @non_standard
   print_line (struct_descriptor : struct_descriptor) is undefined;

   // @non_standard
   print_struct_line (struct_descriptor : struct_descriptor) is undefined;

};

type sn_stripe_indent_mode: [
   DEPTH,
   RELATIVE_DEPTH,
   MULTI_DRIVERS,
   NONE
];

type sn_stripe_mode: [
   DRIVERS,
   SEQUENCERS
];

// @non_standard
struct sn_sequence_manager like sn_struct {

   // @non_standard
   rflow_notify_get_item(driver: any_sequence_driver, item: any_sequence_item) is empty;

};

// @non_standard
struct sn_stripe_viewer like sn_struct {

   // @non_standard
   names : list of string;

   // @non_standard
   start_tm : time;

   // @non_standard
   end_tm : time;

   // @non_standard
   cur_idx : int;

   // @non_standard
   num_of_items : int;

   // @non_standard
   stripe_list : list of any_sequence_item;

   // @non_standard
   indent_mode : sn_stripe_indent_mode;

   // @non_standard
   use_choose_seq_option : bool;

   // @non_standard
   use_stream_prefix : bool;

   // @non_standard
   relative_depth : uint;

   // @non_standard
   stripe_mode : sn_stripe_mode;

   // @non_standard
   stripes_to_show : list of any_sequence_item;

   // @non_standard
   names_indentation : list of string;

   // @non_standard
   !cur_window : vt::vt_window;

   // @non_standard
   header_text : string;

   // @non_standard
   inst_lnk_text : string;

   // @non_standard
   inst_lnk_tooltip : string;

   // @non_standard
   instance : any_struct;

   // @non_standard
   get_title() : string is undefined;

   // @non_standard
   show_stripe() is undefined;

   // @non_standard
   show_stripe_chart_control() : list of string is undefined;

   // @non_standard
   update_and_show(t : time,num : uint,show : bool) is undefined;

   // @non_standard
   get_legend() : list of string is undefined;

   // @non_standard
   get_stripe_chart() : list of string is undefined;

   // @non_standard
   lnk_anchor(anchor_name : string, mark : bool, text_to_mark : string, link : string) : string is undefined;

   // @non_standard
   get_stripe(i : any_sequence_item) : vt::vt_stripe is undefined;

   // @non_standard
   add_and_show_sequence_command(i : any_sequence_item) is undefined;

   // @non_standard
   expand_sequence_command(i : any_sequence_item) is undefined;

   // @non_standard
   get_expand_tree(i : any_sequence_item) : list of any_sequence_item is undefined;

   // @non_standard
   create_and_show_sequence_command(i : any_sequence_item) is undefined;

   // @non_standard
   get_depth(s : any_sequence_item) : uint is undefined;

   // @non_standard
   me2vt() : string is undefined;

};

'>

<'

//@non_standard - rf_numeric
type sn_vec : uint;

//@non_standard
struct interval_set like sn_struct {
	//@non_standard
	get_interval_left_boundary_as_int(idx: int): int is empty;

	//@non_standard
	get_interval_left_boundary_as_long(idx: int): int (bits: *) is empty;

	//@non_standard
	get_interval_left_boundary_as_longint(idx: int): longint is empty;

	//@non_standard
	get_interval_left_boundary_as_longuint(idx: int): longuint is empty;

	//@non_standard
	get_interval_left_boundary_as_uint(idx: int): uint is empty;

	//@non_standard
	get_interval_right_boundary_as_int(idx: int): int is empty;

	//@non_standard
	get_interval_right_boundary_as_long(idx: int): int (bits: *) is empty;

	//@non_standard
	get_interval_right_boundary_as_longint(idx: int): longint is empty;

	//@non_standard
	get_interval_right_boundary_as_longuint(idx: int): longuint is empty;

	//@non_standard
	get_interval_right_boundary_as_uint(idx: int): uint is empty;

	//@non_standard
	get_left_boundary_as_int(): int is empty;

	//@non_standard
	get_left_boundary_as_int_unsafe(): int is empty;

	//@non_standard
	get_left_boundary_as_long(): int (bits: *) is empty;

	//@non_standard
	get_left_boundary_as_longint(): longint is empty;

	//@non_standard
	get_left_boundary_as_longuint(): longuint is empty;

	//@non_standard
	get_left_boundary_as_uint(): uint is empty;

	//@non_standard
	get_list_of_values(buffer: list of string) is empty;

	//@non_standard
	get_num_of_intervals(): int is empty;

	//@non_standard
    int_in_set(val : int) : bool is empty;

	//@non_standard
    uint_in_set(val : uint) : bool is empty;

	//@non_standard
    long_in_set(val : sn_vec) : bool is empty;

	//@non_standard
    longint_in_set(val : longint) : bool is empty;

	//@non_standard
    longuint_in_set(val : longuint) : bool is empty;

	//@non_standard
    double_in_set(val : real) : bool is empty;

	//@non_standard
    to_string_internal(unlimited : bool, with_note : bool, type_id : int) : string is empty;

    ////// START methods might not belong to interval_set //////

	//@non_standard
    interval_set___get_interval_str(from: longuint, to: longuint, interval_idx: int, size: int, type_id: int): string is empty;

	//@non_standard
    get_possible_set() : interval_set is empty;

    ////// END methods might not belong to interval_set //////

};


//@non_standard
struct longuint_interval_set like interval_set {};

//@non_standard
type type_descriptor_sref : int;

//@non_standard
struct uint_interval_set like interval_set {

	//@non_standard
    type_id:type_descriptor_sref;
};

//@non_standard
struct longint_interval_set like interval_set {};

//@non_standard
struct long_interval_set like interval_set {};

//@non_standard
struct int_interval_set like interval_set {};

'>

<'

//@non_standard
struct seed_domain like sn_struct {

   name_id : int;
   current_seed : uint;
   state_s1 : int;
   state_s2 : int;

   result_is (value : int, low : int, high : int, name : string) is undefined;
   recorded_result (value : int) :bool is undefined;
   int_result_is (value : int, low : int, high : int) is undefined;
   int_recorded_result (value : int) :bool is undefined;
   uint_result_is (value : uint, low : uint, high : uint) is undefined;
   uint_recorded_result (value : uint) :bool is undefined;
   int_rnd (from : int, to : int) :int is undefined;
   uint_rnd (from : uint, to : uint) :uint is undefined;
   long_rnd (from : sn_vec, to : sn_vec) :sn_vec is undefined;
   real_rnd (from : real, to : real) :real is undefined;
   reinit_state (newpolicy : bool) is undefined;
   reinit (newpolicy : bool) is undefined;
};

'>

<'

//@non_standard
struct any_rl like sn_struct {

   rl_do_print () is undefined;
   rl_copy () :any_rl is undefined;
   rl_to_string (short : bool) :string is undefined;
   rl_to_string_typed (short : bool, t : type_descriptor) :string is undefined;
   rl_boundary_to_string (left : bool) :string is undefined;
   rl_clear () is undefined;
   rl_recycle_fields () is undefined;
   rl_intersect (r : any_rl) is undefined;
   rl_full_intersect (r : any_rl) is undefined;
   rl_union (r : any_rl) is undefined;
   rl_diff (r : any_rl) is undefined;
   rl_eq (r : any_rl) :bool is undefined;
   rl_disjoint (r : any_rl) :bool is undefined;
   rl_subset_of (r : any_rl) :bool is undefined;
   rl_universal () is undefined;
   rl_is_universal () :bool is undefined;
   rl_empty () is undefined;
   rl_is_empty () :bool is undefined;
   rl_complement () is undefined;
   rl_is_any () :bool is undefined;
   rl_is_finite () :bool is undefined;
   rl_is_one_value () :bool is undefined;
   rl_to_edges () is undefined;
   rl_is_continuous () :bool is undefined;
   rl_to_struct_rl () :struct_rl is undefined;
   rl_to_string_rl () :string_rl is undefined;
   rl_to_double_rl () :double_rl is undefined;
   rl_to_int_rl () :int_rl is undefined;
   rl_to_uint_rl () :uint_rl is undefined;
   rl_to_long_rl () :long_rl is undefined;
   rl_size () :int (bits: *) is undefined;
   rl_rnd (domain : seed_domain) is undefined;
   rl_rnd_int (domain : seed_domain) :int is undefined;
   rl_rnd_uint (domain : seed_domain) :uint is undefined;
   rl_rnd_long (domain : seed_domain) :sn_vec is undefined;
   rl_get_value_unsafe () :untyped is undefined;
   rl_deep_eq (r : any_rl) :bool is undefined;
   rl_cut_le (r : any_rl) is undefined;
   rl_cut_lt (r : any_rl) is undefined;
   rl_cut_ge (r : any_rl) is undefined;
   rl_cut_gt (r : any_rl) is undefined;
   rl_interval_for_int (from : int, to : int) is undefined;
   rl_interval_for_uint (from : uint, to : uint) is undefined;
   rl_interval_for_long (from : sn_vec, to : sn_vec) is undefined;
   rl_interval_for_double (from : real, to : real) is undefined;
   rl_add_interval_int (from : int, to : int) is undefined;
   rl_add_interval_uint (from : uint, to : uint) is undefined;
   rl_add_interval_long (from : sn_vec, to : sn_vec) is undefined;
   rl_add_interval_double (from : real, to : real) is undefined;
   rl_singleton_for_int (val : int) is undefined;
   rl_in_for_int (val : int) :bool is undefined;
   rl_boundary_for_int_rl (left : bool) :int is undefined;
   rl_set_to_for_int (l : list of int) is undefined;
   rl_singleton_for_uint (val : uint) is undefined;
   rl_in_for_uint (val : uint) :bool is undefined;
   rl_boundary_for_uint_rl (left : bool) :uint is undefined;
   rl_set_to_for_uint (l : list of uint) is undefined;
   rl_singleton_for_long (val : sn_vec) is undefined;
   rl_in_for_long (val : sn_vec) :bool is undefined;
   rl_boundary_for_long_rl (left : bool) :sn_vec is undefined;
   rl_set_to_for_long (l : list of sn_vec) is undefined;
   rl_singleton_for_double (val : real) is undefined;
   rl_in_for_double (val : real) :bool is undefined;
   rl_boundary_for_double_rl (left : bool) :real is undefined;
   rl_set_to_for_double (l : list of real) is undefined;
   rl_singleton_for_string (val : string) is undefined;
   rl_in_for_string (val : string) :bool is undefined;
   rl_boundary_for_string_rl (left : bool) :string is undefined;
   rl_set_to_for_string (l : list of string) is undefined;
   rl_singleton_for_struct (val : base_struct) is undefined;
   rl_in_for_struct (val : base_struct) :bool is undefined;
   rl_boundary_for_struct_rl (left : bool) :base_struct is undefined;
   rl_set_to_for_struct (l : list of base_struct) is undefined;
   rl_get_width () :uint is undefined;
   rl_set_width (w : uint) is undefined;
   rl_intersect_slice (i : uint, j : uint, slice : scalar_rl) is undefined;
   rl_intersect_by_slice (i : uint, j : uint, slice : scalar_rl) is undefined;
   rl_get_slice_as_int (i : uint, j : uint) :int_bit_rl is undefined;
   rl_get_slice_as_uint (i : uint, j : uint) :uint_bit_rl is undefined;
   rl_get_slice_as_long (i : uint, j : uint) :long_bit_rl is undefined;
   rl_get_slice_as_ulong (i : uint, j : uint) :ulong_bit_rl is undefined;
   rl_eq_bit (r : any_rl) :bool is undefined;
   rl_to_bit_rl (w : uint) :scalar_rl is undefined;
   rl_to_ulong_bit_rl (w : uint) :scalar_rl is undefined;
   rl_to_ulong_bit_rl_for_list (w : uint) is undefined;
   rl_to_bit_rl_for_list (w : uint) is undefined;
   rl_is_bit () :bool is undefined;
   to_set () :interval_set is undefined;
   rl_mult_by_me (r : any_rl) :any_rl is undefined;
   rl_div_by_me (r : any_rl, exact : bool) :any_rl is undefined;
   rl_div_by_int_rl (r : any_rl, exact : bool) :any_rl is undefined;
   rl_div_by_uint_rl (r : any_rl, exact : bool) :any_rl is undefined;
   rl_div_by_long_rl (r : any_rl, exact : bool) :any_rl is undefined;
   rl_mult_by_int_rl (r : any_rl) :any_rl is undefined;
   rl_mult_by_uint_rl (r : any_rl) :any_rl is undefined;
   rl_mult_by_long_rl (r : any_rl) :any_rl is undefined;
   get_type () :enum_descriptor is undefined;
   get_type_id () :int is undefined;
   rl_eq2int_rl (other : int_rl) :bool is undefined;
   rl_eq2uint_rl (other : uint_rl) :bool is undefined;
   rl_eq2long_rl (other : long_rl) :bool is undefined;
   rl_disjoint_for_int (other : int_rl) :bool is undefined;
   rl_disjoint_for_uint (other : uint_rl) :bool is undefined;
   rl_disjoint_for_long (other : long_rl) :bool is undefined;
   rl_struct_is_a (sd : struct_descriptor, inverted : bool) :bool is undefined;
   rl_singleton_to_untyped () :untyped is undefined;
   rl_eq_bit_to_me (r : any_rl) :bool is undefined;
   rl_to_string_rf_type (rt : rf_type) :string is undefined;
   rl_single_value_to_string (rt : rf_type) :string is undefined;
   rl_to_bit_list () :list of uint (bits: 1) is undefined;
   rl_span () :uint is undefined;
   to_condensed_str (td : type_descriptor) :string is undefined;
   get_single_value () :int is undefined;
   to_abs_range_props (td : type_descriptor) :abs_range_props is undefined;
   abs_to_lines (td : type_descriptor) :string is undefined;
   eb_to_uint_rl () :uint_rl is undefined;
   rl_size_uint () :uint is undefined;
   to_user_for_gend (rt : rf_type) :string is undefined;
   rl_mult_by_rl (r : any_rl) :any_rl is undefined;
   rl_div_by_rl (r : any_rl, exact : bool) :any_rl is undefined;
   rl_isqrt () :any_rl is undefined;
   rl_mod_by_rl (r : any_rl) :any_rl is undefined;
   rl_mod_by_me (r : any_rl) :any_rl is undefined;
   rl_mod_by_int_rl (r : any_rl) :any_rl is undefined;
   rl_mod_by_uint_rl (r : any_rl) :any_rl is undefined;
   rl_mod_by_long_rl (r : any_rl) :any_rl is undefined;
   rl_boundaries () :any_rl is undefined;
   get_residue_rl () :scalar_rl is undefined;
};

//@non_standard
struct double_rl like any_rl {

};

//@non_standard
struct int_bit_rl like any_rl {

};

//@non_standard
struct int_rl like any_rl {

};

//@non_standard
struct long_bit_rl like any_rl {

};

//@non_standard
struct long_rl like any_rl {

};

//@non_standard
struct scalar_rl like any_rl {

   rl_in_unsafe (x : untyped) :bool is also{};
   rl_disjoint_fdor_long (other : long_rl) :bool is also{};
   rl_intersect_with_int (other : int_rl) is also{};
   rl_intersect_with_uint (other : uint_rl) is also{};
   rl_intersect_with_long (other : long_rl) is also{};
   rl_union_with_int (other : int_rl) is also{};
   rl_union_with_uint (other : uint_rl) is also{};
   rl_union_with_long (other : long_rl) is also{};
   rl_diff_with_int (other : int_rl) is also{};
   rl_diff_with_uint (other : uint_rl) is also{};
   rl_diff_with_long (other : long_rl) is also{};
   rl_contains_with_int (other : int_rl) :bool is also{};
   rl_contains_with_uint (other : uint_rl) :bool is also{};
   rl_contains_with_long (other : long_rl) :bool is also{};
   rl_plus (r : scalar_rl) :scalar_rl is also{};
   rl_minus (r : scalar_rl) :scalar_rl is also{};
   rl_sqr () :scalar_rl is also{};
   rl_sqrt () :scalar_rl is also{};
   rl_plus_int (r : int_rl) :scalar_rl is also{};
   rl_plus_uint (r : uint_rl) :scalar_rl is also{};
   rl_plus_long (r : long_rl) :scalar_rl is also{};
   rl_minus_int (r : int_rl) :scalar_rl is also{};
   rl_minus_uint (r : uint_rl) :scalar_rl is also{};
   rl_minus_long (r : long_rl) :scalar_rl is also{};
   rl_mult_by (r : scalar_rl) :scalar_rl is also{};
   rl_div_by (r : scalar_rl) :scalar_rl is also{};
   rl_extend () :scalar_rl is also{};
   rl_abs () :scalar_rl is also{};
   rl_unabs () :scalar_rl is also{};
   rl_mult_by_int (r : int_rl) :scalar_rl is also{};
   rl_mult_by_uint (r : uint_rl) :scalar_rl is also{};
   rl_mult_by_long (r : long_rl) :scalar_rl is also{};
   rl_div_by_int (r : int_rl) :scalar_rl is also{};
   rl_div_by_uint (r : uint_rl) :scalar_rl is also{};
   rl_div_by_long (r : long_rl) :scalar_rl is also{};
   rl_narrow_to_min () is also{};
   rl_narrow_to_max () is also{};
   rl_narrow_to_edges () is also{};
   get_left_boundary_as_int () :int is also{};
   get_left_boundary_as_uint () :uint is also{};
   get_left_boundary_as_long () :sn_vec is also{};
   get_right_boundary_as_int () :int is also{};
   get_right_boundary_as_uint () :uint is also{};
   get_right_boundary_as_long () :sn_vec is also{};
   has_left_boundary () :bool is also{};
   has_right_boundary () :bool is also{};
   rl_valid () :bool is also{};
   rl_alter_intervals () is also{};
   rl_setup_bits_for_bit_rl (r : scalar_rl) is also{};
   rl_get_num_of_cuts_by_n (n : uint) :int is also{};
   rl_get_me_or_right_neighbor_unsafe (value : untyped, result : val_and_index) is also{};
   rl_get_me_or_left_neighbor_unsafe (value : untyped, result : val_and_index) is also{};
   sub_rl_to_string_typed (from_ind : int, to_ind : int, fron_val : untyped, to_val : untyped, short : bool, t : type_descriptor) :string is also{};
   cut_every_n (n : uint, max : uint) :list of scalar_rl is also{};
   get_representor_of_every_n (n : uint, max : uint) :list of untyped is also{};
   get_interval_lo_str (i : index, td : type_descriptor) :string is also{};
   get_interval_hi_str (i : index, td : type_descriptor) :string is also{};
   is_signed () :bool is also{};
   rl_to_bdd (bit_vars : list of sn_bdd, mng : sn_bdd_manager) :sn_bdd is also{};
   rl_to_string_list_typed (all : bool, t : type_descriptor) :list of string is also{};
   get_int_rl_list_for_unicov () :list of int is also{};
   is_zero () :bool is also{};
   rl_is_before (r : scalar_rl, strict : bool) :bool is also{};
   rl_is_after_for_int (r : int_rl, strict : bool) :bool is also{};
   rl_is_after_for_uint (r : uint_rl, strict : bool) :bool is also{};
   rl_is_after_for_long (r : long_rl, strict : bool) :bool is also{};
   rl_boundary_uint (left : bool) :uint is also{};
   get_fixed_bit_width () :uint is also{};
   is_short_type () :bool is also{};
   get_bit_width () :uint is also{};
   rl_to_unsigned_rl (width : uint) :scalar_rl is also{};
   rl_to_signed_rl (width : uint) :scalar_rl is also{};
   rl_has_negatives () :bool is also{};
   rl_extract_bits (j : uint, i : uint) :scalar_rl is also{};
   rl_extract_bits_to_rl (j : uint, i : uint, sz : uint) :scalar_rl is also{};
   rl_insert_bits_into_rl (y : scalar_rl, j : uint, i : uint) :scalar_rl is also{};
   rl_insert_bits_from_me_into_uint_rl (rl1 : uint_rl, j : uint, i : uint) :uint_rl is also{};
   rl_insert_bits_from_me_into_long_rl (rl1 : long_rl, j : uint, i : uint) :long_rl is also{};
   rl_insert_bits_from_me_into_int_rl (rl1 : int_rl, j : uint, i : uint) :int_rl is also{};
   rl_remove_single_value (j : uint, i : uint) :scalar_rl is also{};
   get_bit_size_rl (sz : uint) :uint_rl is also{};
   rl_is_zero_one () :bool is also{};
   rl_is_false () :bool is also{};
   rl_is_true () :bool is also{};
   rl_set_false () is also{};
   rl_set_true () is also{};
   rl_is_le (r : scalar_rl) :bool is also{};
   rl_is_lt (r : scalar_rl) :bool is also{};
   rl_is_ge (r : scalar_rl) :bool is also{};
   rl_is_gt (r : scalar_rl) :bool is also{};
   rl_below_for_int (x : int, strict : bool) :bool is also{};
   rl_below_for_uint (x : uint, strict : bool) :bool is also{};
   rl_below_for_long (x : int (bits: *), strict : bool) :bool is also{};
   rl_above_for_int (x : int, strict : bool) :bool is also{};
   rl_above_for_uint (x : uint, strict : bool) :bool is also{};
   rl_above_for_long (x : int (bits: *), strict : bool) :bool is also{};
   minmax_changed (r : scalar_rl) :bool is also{};
   minmax_changed_for_int (r : int_rl) :bool is also{};
   minmax_changed_for_uint (r : uint_rl) :bool is also{};
   minmax_changed_for_long (r : long_rl) :bool is also{};
   min_changed (r : scalar_rl) :bool is also{};
   min_changed_for_int (r : int_rl) :bool is also{};
   min_changed_for_uint (r : uint_rl) :bool is also{};
   min_changed_for_long (r : long_rl) :bool is also{};
   max_changed (r : scalar_rl) :bool is also{};
   max_changed_for_int (r : int_rl) :bool is also{};
   max_changed_for_uint (r : uint_rl) :bool is also{};
   max_changed_for_long (r : long_rl) :bool is also{};
};

//@non_standard
struct string_rl like any_rl {

};

//@non_standard
struct struct_rl like any_rl {

};

//@non_standard
struct uint_rl like any_rl {

};

//@non_standard
struct ulong_bit_rl like any_rl {

};

//@non_standard
struct pgen3 like sn_struct {
   long_max_width : uint;
   rnd_policy : rnd_policy;
   user_domain : seed_domain;
   user_seed : uint;
   warn : bool;
   errors_during_static_analysis : bool;
   has_list_constraint : bool;
   pgen3_debug : pgen3_debug;
   temp_fl : field_holder;
   max_depth : count;
   max_num_of_structs : count;
   bits_uni_directional : bool;
   list_constraint_ids : list (key: it) of index;
   flags : pgen_flags;
   reorder_fields : bool;
   sa_on_demand : bool;
   last_analysis_stamp : count;
   gen_prof_field : field;
   gen_prof_role_id : index;
   gen_prof_reachable_struct : index;
   gen_prof_gc_index : index;
   max_structs : count;
   default_max_structs : count;
   alloc_types : list of count;
   alloc_struct_count : count;
   current_phase : gen_phase;
   gen_status : [started, completed, failed];
   gotf_source_ref : source_ref;
   skip_contradiction : bool;
   no_of_contradictions : count;
   sis : list of source_item;
   related_gc : gen_constraint;
   deb : pgen3_debug;
   use_visual_deb : bool;
   debug : bool;
   visual_deb_level : [none, skeleton, full];
   om : gen_order_manager;
   tmp_abs_path_type : sn_type_role_path;
   tmp_abs_path_suffix : sn_suffix_fields_role_path;
   tmp_abs_path_gotf : sn_gotf_fields_role_path;
   gen_static_phase : gen_static_phase;
   role_manager : role_manager;
   static_order : static_order;
   error_occured_during_gen : bool;
   yolka_inhibitor : yolka_inhibitor;
   when_opt : bool;
   opt_sa_mem : bool;
   related_fgr : field_gen_role;
   role_counts : list (key: role_str) of role_count;
   gotf_infos : list of gotf_info;
   gotf_counts : list (key: gotf_id) of gotf_count;
   rhb_type : uint;
   rhb_type_gotf : uint;
   rhb_field : uint;
   do_static_checks : bool;
   ffin : final_fgr_info_none;
   role_to_order : a_role;
   static_om_fields : list of static_om_f;
   fast_gen_level : [none, all_subtypes_no_dets, all_subtypes_all_dets, as_specified];
   default_list_size_rl : uint_rl;
   default_min_list_size : count;
   default_max_list_size : count;
   tmps_candidates : list of sn_me_cpi;
   tmps_needed_tmps : list of sn_me_cpi;
   tmps_tmps : list of sn_me_cpi;
   curr_spis : list of struct_path_item;
   tmp_cpis : list of sn_cpi;
   accessible_outputs : list of field_node;
   ci_outputs : list of field_node;
   ci_inputs : list of field_node;
   last_frame_id : list of index;
   collect_items : bool;
   deb_was_on : bool;
   curr_gen_frame : gen_frame;
   gen_debugger : sn_gen_debugger;
   in_list_temps : bool;
   temps_list : list_path_item;
   event_browser_is_on : bool;
   start_spe : sn_start_preorder_event;
   n_ordered_fields : count;
   ptes : list of sn_preorder_top_event;
   sees : list of sn_static_edge_event;
   all_field_nodes : list of field_node;
   pending_list_items : list of the_item'the_wr field_node;
   csss : list of sn_compute_select_struct;
   current_css : sn_compute_select_struct;
   in_all_iterations_stack : uint;
   alloc_for_iter : any_struct;
   last_warn_msg : string;
   stats_struct_name : list of string;
   stats_table : list of struct_status;


   default_pre_generate (any_struct : any_struct) is undefined;
   default_generate (any_struct : any_struct) is undefined;
   default_post_generate (any_struct : any_struct) is undefined;
   init_user_domain () is undefined;
   init_user_domain_if_needed () is undefined;
   msg_warn () is undefined;
   err_no_gen (type_name : string, sr : source_ref) is undefined;
   err_keeping_context (sref : source_ref) is undefined;
   err_keep_context (sref : source_ref) is undefined;
   err_no_interactive_gen () is undefined;
   err_no_gen_items (gc : gen_constraint, is_gotf : bool) is undefined;
   err_gen_static_anal_after_error () is undefined;
   err_gen_static_all_alts (gc : gen_constraint) is undefined;
   err_gen_unknown_test_param (p : string) is undefined;
   err_gen_nested_select (ns : string, s : string) is undefined;
   err_cannot_generate_type (f : field, str : string) is undefined;
   err_allocated_structs_exceed (ms : uint) is undefined;
   err_gc_on_non_relevant_field (gc : gen_constraint) is undefined;
   warn_gen_before_in_or (gc : gen_constraint) is undefined;
   err_or_left_with_non_generatable (gc : gen_constraint, is_gotf : bool) is undefined;
   process_list_constraint_id_list () is undefined;
   turn_off_list_constraint () is undefined;
   turn_on_list_constraint () is undefined;
   build_or_with_and_constraints (g1 : gen_constraint, g2 : gen_constraint) :gen_constraint is undefined;
   msg_start_static () is undefined;
   msg_end_static () is undefined;
   setup () is undefined;
   inform_allocated (d_index : index) is undefined;
   report_allocated () is undefined;
   init_generation (sr : source_ref) is undefined;
   vis_deb_is_skeleton_or_more () :bool is undefined;
   end_generation () is undefined;
   report_header () is undefined;
   set_related_gc (gc : gen_constraint) is undefined;
   report_status () is undefined;
   show_constraints_mode (struct_name : string, field_name : string, module_name : string, string_expr : string, mode : sh_cons_mode_t) is undefined;
   print_paths (context_struct : string, paths : list of string, counter : index) is undefined;
   get_all_gen_constraints (struct_pattern : string, field_pattern : string, module_pattern : string) :list of simple_gen_constraint is undefined;
   get_matching_modules (module_pattern : string) :list of module is undefined;
   get_matching_constraints (struct_pattern : string, field_pattern : string) :list of simple_gen_constraint is undefined;
   has_trace_gen_requests () :bool is undefined;
   is_in_all_iterations () :bool is undefined;
   set_vis_deb_to_skeleton () is undefined;
   vis_ever_collected () :bool is undefined;
   vis_deb_set_on () :bool is undefined;
   vis_deb_is_full () :bool is undefined;
   vis_deb_is_on () :bool is undefined;
   open_gui_on_gen_error () is undefined;
   open_gen_debugger_window (static : bool, err : bool) is undefined;
   msg_start_gen (si : source_item, holder : base_struct, path : string) is undefined;
   msg_end_gen (si : source_item, holder : base_struct, path : string) is undefined;
   msg_stat_initial_range (a_role : a_role, fs : string, range : string, td : type_descriptor) is undefined;
   msg_set_value (holder : base_struct, fs : string, value : string, from_range : any_rl, td : type_descriptor) is undefined;
   msg_set_struct (role : a_role, holder : base_struct, fs : string, struct_value : base_struct, from_range : string, struct_path : string, is_gotf_path_only : bool) is undefined;
   msg_end_struct (value : base_struct) is undefined;
   msg_set_role (st : base_struct, role : a_role) is undefined;
   msg_eval_struct (holder : base_struct, fs : string, value : base_struct, from_range : string, struct_path : string, is_gotf_path_only : bool) is undefined;
   msg_create_edge (soft : bool, reason : om_edge_reason, si : source_item, dynamic : bool, holder : base_struct, fs1 : string, fs2 : string) is undefined;
   msg_reduction (gc : gen_constraint, items : list of gendb_item, or_alternative : int, or_status : sn_gen_status_type) is undefined;
   msg_break_cycle (holder : base_struct) is undefined;
   msg_start_preorder (r : a_role) is undefined;
   msg_end_preorder (r : a_role) is undefined;
   msg_preorder_top (r : a_role, fs : string) is undefined;
   msg_set_final_holder (final_holder : base_struct, final_holder_path : string) is undefined;
   msg_dropped_iteration (holder : base_struct, fs : string, value : base_struct, struct_path : string) is undefined;
   err_contradiction (gc : gen_constraint, items : list of gendb_item, contradiction_index : index, or_simplification : gendb_or_simplification, kind : sn_contradiction_kind) is undefined;
   set_config () is undefined;
   get_role_key (st : composite_descriptor, fls : list of field_holder, last_field : index, gi : index) :sn_role_path is undefined;
   get_om_item_str (i : index) :string is undefined;
   mark_wds () is undefined;
   err_mgr_contradiction (curr : field_gen_role, curr_s : string, curr_rl_s : string, mgr_s : string, mgr_rl_s : string, is_gotf_role : bool) is undefined;
   set_related_role (fgr : field_gen_role) is undefined;
   find_role_count (rs : string) :count is undefined;
   get_role (role_id : index) :a_role is undefined;
   get_role_by_key (key : sn_role_path) :a_role is undefined;
   next_role_id () :index is undefined;
   create_new_role (key : sn_role_path) :a_role is undefined;
   find_and_create_role (key : sn_role_path) :a_role is undefined;
   find_role (key : sn_role_path) :a_role is undefined;
   reloc_temps () is undefined;
   gen_items_static_check () is undefined;
   enforceable_constraints_static_check () is undefined;
   should_create_edges_for_kfe_paths (constraint_paths : list of constraint_path, for_each_list : constraint_path) :bool is undefined;
   mark_ordered_field (r : a_role, f : field) is undefined;
   mark_ordered_edge (reason : om_edge_reason, source_item : source_item, r : a_role, bidir : bool, f1 : field, f2 : field) is undefined;
   should_create_edge (f_from : field, f_to : field, bidir : bool, soft : bool, explicit : bool, is_tmp_clos : bool) :bool is undefined;
   is_ordered (i : index) :bool is undefined;
   clear_sofs () is undefined;
   alloc_sof (i : index) :static_om_f is undefined;
   set_sof (i : index, e : om_edge, ei : index) is undefined;
   mark_ordered_sof (i : index) is undefined;
   field_index_to_om_id (i : index) :index is undefined;
   om_id_to_field_index (i : index) :index is undefined;
   get_stats () is undefined;
   print_stats () is undefined;
   clear_sa_lists () is undefined;
   clear_sa_lists_on_demand (r : a_role) is undefined;
   clean_iterate (r : a_role) :bool is undefined;
   should_do_static_analysis () :bool is undefined;
   id_to_field_node (id : int) :field_node is undefined;
   err_om_cycle (cycle_ids : list of int) is undefined;
   warn_om_cycle (field_id : int) is undefined;
   err_constrained_instance (f : field, field_name : string) is undefined;
   err_gen_active_ci_check (mci : sn_constraint_instance, spi : struct_path_item) is undefined;
   warn_active_ci_check_with_gotf (mci : sn_constraint_instance, spi : struct_path_item) is undefined;
   err_gen_ignored_ci_with_valid_cpis (ci : sn_constraint_instance) is undefined;
   err_gen_ignored_and_ci_with_valid_alts (aci : sn_constraint_instance) is undefined;
   err_gen_ignored_or_ci_with_valid_alts (oci : sn_constraint_instance) is undefined;
   warn_mci_ignore (mci : sn_constraint_instance) is undefined;
   err_empty_range (f : field_node) is undefined;
   err_empty_item_range (f : field_node, i : index) is undefined;
   err_empty_some_item_range (f : field_node) is undefined;
   err_list_tmps_without_it (mpi : scalar_list_path_item) is undefined;
   err_all_iter_constrained_size (f : field) is undefined;
   err_space_too_large (gc : gen_constraint) is undefined;
   err_all_iter_no_solutions (gc : gen_constraint) is undefined;
   err_all_iter_contradiction (gc : gen_constraint) is undefined;
   err_all_iter_size_contradiction (mpi : major_path_item) is undefined;
   warn_dropped_ci (spi : struct_path_item, gc : gen_constraint) is undefined;
   err_show_gen_bad_option (str : string) is undefined;
   err_show_gen_bad_specifier (str : string) is undefined;
   err_show_gen_no_gen_info () is undefined;
   err_show_gen_last_other_options () is undefined;
   err_show_gen_null_path (path : string, spec : string) is undefined;
   show_gen_error_not_exist () is undefined;
   err_cant_display_no_collect () is undefined;
   err_cant_start_trace_gen_collected () is undefined;
   err_vis_illegal_show_gen (s : string) is undefined;
   err_cant_start_collect_with_trace_gen () is undefined;
   err_max_depth_exceed (mpi : major_path_item) is undefined;
   err_list_too_long (fn : field_node, size : uint) is undefined;
   err_cannot_access_path (ci : sn_constraint_instance, cpi : sn_cpi) is undefined;
   err_max_gotf_depth_exceed () is undefined;
   err_null_path_in_gotf (cp : constraint_path, the_field : field) is undefined;
   err_cannot_gen_unit (path_str : string, is_port : bool) is undefined;
   err_gen_before_test (sr : source_ref) is undefined;
   warn_gen_select_weight_0 (gc : gen_constraint) is undefined;
   err_gen_select_weight_is_negative (gc : gen_constraint) is undefined;
   warn_gen_edge_with_non_generatable (gc : gen_constraint) is undefined;
   warn_constraint_created_after_parameters_evaluation (cpi : sn_simple_constraint_instance) is undefined;
   warn_ignored_ci_on_item (ci : sn_constraint_instance, i : index, list_name : string) is undefined;
   get_curr_unit () :any_unit is undefined;
   om_is_a_temp (i : index) :bool is undefined;
   free_ci (ci : sn_constraint_instance) is undefined;
   create_ci (gc : gen_constraint, spi : struct_path_item) :sn_constraint_instance is undefined;
   get_current_me () :any_struct is undefined;
   get_current_ar () :activation_record is undefined;
   get_or_new_cpi (cp : constraint_path, ci : sn_simple_constraint_instance, ind : index) :sn_cpi is undefined;
   free_cpi (cpi : sn_cpi) is undefined;
   push_spi (spi : struct_path_item) :index is undefined;
   pop_upto_spi (i : index) is undefined;
   curr_spi () :struct_path_item is undefined;
   check_edge_nodes (p_from : field_node, p_to : field_node, bidir : bool) :bool is undefined;
   create_edge_if_needed (p_from : field_node, p_to : field_node, bidir : bool, soft : bool, reason : om_edge_reason, si : source_item, dynamic : bool, holder : base_struct, debug_it : bool, ci : sn_simple_constraint_instance) is undefined;
   vis_reactivate_all () is undefined;
   enter_scalar_list () is undefined;
   exit_scalar_list () is undefined;
   get_gotf_field () :field is undefined;
   set_temps_list (tl : list_path_item) is undefined;
   in_list_temps () :bool is undefined;
   get_temps_list () :list_path_item is undefined;
   sn_get_list_index () :index is undefined;
   set_collect_all (value : bool) is undefined;
   vis_deb_end_collecting () is undefined;
   vis_deb_start_collecting (collect_all : bool) is undefined;
   restore_collect_gen () is undefined;
   clean_debug_information () is undefined;
   vis_display_gen_debugger (ascii : bool, static : bool) is undefined;
   vis_display_gen_debugger_with_target (the_exp : any_struct, field_name : string) is undefined;
   err_gen_debugger_no_gen_info (item : string) is undefined;
   start_order (r : a_role) is undefined;
   end_order (r : a_role, with_last : bool) is undefined;
   save_collect_all_status_before_restore () is undefined;
   restore_collect_all_status_after_restore () is undefined;
   get_collect_all_status_file () :string is undefined;
   new_field_node (f : field, fgr : field_gen_role, has_cons : bool, wr : which_rl, is_list : bool) :field_node is undefined;
   push_curr_unit (curr_unit : any_unit) is undefined;
   pop_curr_unit () is undefined;
   gen_prepare (gen_index : int, sd : struct_descriptor, gen_path : fields_constraint_path, m : method, sr : source_ref) is undefined;
   copy_ar (ar : activation_record) :method_frame is undefined;
   gen_on_the_fly (ar : activation_record, gen_path : fields_constraint_path, gen_index : index, the_struct : any_struct, id : index, local_indirect : bool, is_global_path : bool, is_implicit_mixed_gotf : bool, source_ref : source_ref) :untyped is undefined;
   get_or_create_css (gc : gen_constraint_general) :sn_compute_select_struct is undefined;
   field_sts (type_index : int, rs : list of any_rl) :list of bool is undefined;
   field_ranges (type_index : int, rs : list of any_rl) :list of any_rl is undefined;
   gen_one_struct (type_index : int, rs : list of any_rl, iterate : list of bool, item_mpj : struct_item_path_item, item_index : index, gen_index : index) :any_struct is undefined;
   all_iterations (type_index : int, rs : list of any_rl, iterate : list of bool, item_mpj : struct_item_path_item, gc : gen_constraint) :list of base_struct is undefined;
   gen_stats (type_names : list of string) is undefined;
   print_statistics_header () is undefined;
   get_roles_list (name : string) :list of a_role is undefined;
   count_executed_roles () is undefined;
   phase_stat (sn : string) :phase_status is undefined;
   role_get_field_rl (role_str : string, field_str : string, int_limit : count, all_values_in_list : bool, values : list of string, is_string : bool) :any_rl is undefined;
   eb_get_the_role (s : string, start : index) :a_role is undefined;
   write_static_analysis_info (file : file) is undefined;
   write_runtime_info (file : file) is undefined;
   write_current_phase (file : file) is undefined;
   c_save_0param (file : file, arg : string) is undefined;
   c_save_1param (file : file, arg : string, name : string) is undefined;
   c_save_1param_int (file : file, arg : string, name : index) is undefined;
   c_save_2param (file : file, arg : string, name1 : string, name2 : string) is undefined;
   c_save_srcref (file : file, arg : string, srcref : source_ref) is undefined;
   c_save_sa_phase (file : file, arg : string, phase : gen_static_phase) is undefined;
   write_struct_descriptor (file : file) is undefined;
   write_current_role_name (file : file) is undefined;
   write_fh (file : file, fh : field_holder) is undefined;
   write_role_path (file : file, role_id : int) is undefined;
   write_gen_action (file : file) is undefined;
   write_runtime_gc (file : file) is undefined;
   write_gc_from_sa (file : file) is undefined;
   write_field_name (file : file, generating : bool) is undefined;
};

'>

<'

// --------
// Misc API
// --------

type pass_field_config_t:[DEFAULT, YES, NO, NO_WHEN];
type sv_param_dir_t:[DEFAULT, REF, INOUT, INPUT, OUTPUT];
type make_field_protected_config_t:[DEFAULT, YES, NO];
type make_field_static_config_t:[DEFAULT, YES, NO];
type field_access_specifier_config_t:[DEFAULT, PUBLIC, PROTECTED, PRIVATE, STATIC];
type ovm_object_kind_t:[DEFAULT, OBJECT, TRANSACTION, SEQUENCE_ITEM, SEQUENCE, ML_SEQUENCE];
type uvm_object_kind_t:[DEFAULT, OBJECT, TRANSACTION, SEQUENCE_ITEM, SEQUENCE, ML_SEQUENCE];
type ovm_field_macro_flag_t:[DEFAULT, ALL_ON, COPY, NOCOPY, COMPARE, NOCOMPARE, PRINT, NOPRINT, NODEFPRINT, PACK, NOPACK, PHYSICAL, ABSTRACT, READONLY, BIN, DEC, UNSIGNED, OCT, HEX, STRING, TIME, NORADIX];
type uvm_field_macro_flag_t:[DEFAULT, ALL_ON, COPY, NOCOPY, COMPARE, NOCOMPARE, PRINT, NOPRINT, NODEFPRINT, PACK, NOPACK, PHYSICAL, ABSTRACT, READONLY, BIN, DEC, UNSIGNED, OCT, HEX, STRING, TIME, NORADIX];
type sv_numeric_order_t:[DEFAULT, MSB_IS_ZERO, LSB_IS_ZERO];
//@non_standard
type export_list_as_queue_config_t:[DEFAULT, YES, NO];

unit any_adapter_unit like any_unit {

   // Whether this instance is disabled. The default is FALSE (the instance is enabled).
   disabled : bool;

   is_disabled () :bool is undefined;
   is_enabled () :bool is undefined;

};

unit sv_adapter_unit like any_adapter_unit {
   // The name of package this instance refers to. The default is an empty string, meaning all packages.
   package_name:string;
   
   added_types:list (key: e_type) of sv_exported_type;
   added_svh_code:list of string;

   is_master() : bool is undefined;
   // Sets the SystemVerilog name of the type. The default is the type name prefixed with sn_.
   get_type_name(cur_type : rf_type) : string is undefined;
   // Sets the SystemVerilog package name in which the current type has to be defined. The default package is specman_types.
   get_package_name(cur_type : rf_type) : string is undefined;
   // Sets the external name of the enumerated item. The default is the enum type name concatenated to the SystemVerilog type name with two underscores (__).
   get_enum_item_name(cur_item : rf_enum_item) : string is undefined;
   // Sets the name of the field in the SystemVerilog class. The default is the same name as in e for like structs, and the C interface name for fields defined under when subtypes.
   get_field_name(cur_field : rf_field) : string is undefined;
   // Returns whether to add this field to the SystemVerilog class. By default, physical fields and fields that are determinants of when subtypes are always passed.
   pass_field(cur_field : rf_field) : pass_field_config_t is undefined;
   // Controls whether the current field is declared as randomized. By default, fields are not declared as rand.
   randomize_field(cur_field : rf_field) : bool is undefined;
   export_enum(cur_enum : rf_enum) : bool is undefined;
   export_numeric(cur_numeric : rf_numeric) : bool is undefined;
   create_new_function(cur_struct : rf_struct) : bool is undefined;
   // Sets the direction that is used when this type is used as a parameter to a function/task.
   get_parameter_direction_for_type(cur_type : rf_type) : sv_param_dir_t is undefined;
   get_parameter_direction(cur_param : rf_parameter, cur_method : rf_method) : sv_param_dir_t is undefined;
   // If you define the method keep_old_class_instance() to return TRUE, new instances are not created and the old instance is used. (This is similar to packing in e.)
   keep_old_class_instance(cur_struct : rf_struct) : bool is undefined;
   make_field_protected(cur_field : rf_field) : make_field_protected_config_t is undefined;
   // Returns the access specifier of an exported field. A field may be defined as PUBLIC, PRIVATE or PROTECTED.
   get_field_access_specifier(cur_field : rf_field) : field_access_specifier_config_t is undefined;
   make_field_static(cur_field : rf_field) : make_field_static_config_t is undefined;
   when_subtype_hierarchy(cur_struct : rf_like_struct) : sv_when_hierarchy is undefined;
   get_ovm_object_kind(cur_struct : rf_struct) : ovm_object_kind_t is undefined;
   // Sets the UVM object type of the exported struct.
   get_uvm_object_kind(cur_struct : rf_struct) : uvm_object_kind_t is undefined;
   get_ovm_new_function_code(cur_struct : rf_struct) : list of string is undefined;
   // Defines additional code to create in the new function of the exported class.
   get_uvm_new_function_code(cur_struct : rf_struct) : list of string is undefined;
   get_ovm_field_macro_flags(cur_field : rf_field) : list of ovm_field_macro_flag_t is undefined;
   get_uvm_field_macro_flags(cur_field : rf_field) : list of uvm_field_macro_flag_t is undefined;
   remove_ovm_field_macro(cur_field : rf_field) : bool is undefined;
   remove_uvm_field_macro(cur_field : rf_field) : bool is undefined;
   // Sets the default value of the field.
   get_field_default_value(cur_field : rf_field) : string is undefined;
   convert_struct_to_class(cur_struct : rf_struct) : bool is undefined;
   // Defines additional code to create before or after the declarations in the exported class.
   get_pre_declaration_code(cur_struct : rf_struct) : list of string is undefined;
   // Defines additional code to create before or after the declarations in the exported class.
   get_post_declaration_code(cur_struct : rf_struct) : list of string is undefined;
   get_user_method_declaration(cur_struct : rf_struct) : list of string is undefined;
   get_internal_method_declaration(cur_struct : rf_struct) : list of string is undefined;
   get_method_implementation(cur_struct : rf_struct) : list of string is undefined;
   // Defines the SV type packed dimension range.
   get_type_range(cur_type : rf_type) : string is undefined;
   remove_access_methods(cur_field : rf_field) : bool is undefined;
   get_numeric_bit_order(cur_num : rf_numeric) : sv_numeric_order_t is undefined;
   add_svh_code() is undefined;
   remove_like_subtype(cur_struct : rf_struct) : bool is undefined;
   remove_field_declaration(cur_field : rf_field) : bool is undefined;
   get_field_setter(cur_field : rf_field) : string is undefined;
   get_field_getter(cur_field : rf_field) : string is undefined;
   make_class_virtual(cur_struct : rf_struct) : bool is undefined;
   add_mlc_pragma(cur_struct : rf_struct) : bool is undefined;
   remove_packing_methods(cur_struct : rf_struct) : bool is undefined;
   get_sequencer_type_name(cur_struct : rf_struct) : string is undefined;
   add_documentation_comments(cur_type : rf_type) : bool is undefined;
   get_enum_item_value(cur_item : rf_enum_item) : int is undefined;
   get_post_randomize_code(cur_struct : rf_struct) : list of string is undefined;
   export_list_as_queue(cur_field : rf_field) : export_list_as_queue_config_t is undefined;
   get_ovm_build_code(cur_struct : rf_struct) : list of string is undefined;
   get_ovm_connect_code(cur_struct : rf_struct) : list of string is undefined;
   get_ovm_post_build_code(cur_struct : rf_struct) : list of string is undefined;
   get_uvm_build_code(cur_struct : rf_struct) : list of string is undefined;
   get_uvm_connect_code(cur_struct : rf_struct) : list of string is undefined;
   get_uvm_post_build_code(cur_struct : rf_struct) : list of string is undefined;
   remove_type_from_svh(cur_type : rf_type) : bool is undefined;
   remove_type_declaration(cur_type : rf_type) : bool is undefined;
   get_undeclared_type_name(cur_type : rf_type) : string is undefined;
   get_undeclared_type_package_name(cur_type : rf_type) : string is undefined;
   get_stub_define_code() : list of string is undefined;
   get_stub_include_code() : list of string is undefined;
   get_supertype_name_for_struct(cur_struct : rf_struct) : string is undefined;
   use_ovm_field_macro(cur_field : rf_field) : bool is undefined;
   use_uvm_field_macro(cur_field : rf_field) : bool is undefined;
   get_added_types() : list (key: e_type) of sv_exported_type is undefined;
   do_add_exported_type(type_name : string, ext_type_name : string) is undefined;
   get_added_exported_types() : list of rf_type is undefined;
   do_add_preexisting_type(type_name : string, ext_type_name : string) is undefined;
   get_added_preexisting_types() : list of rf_type is undefined;
   get_added_preexisting_sv_struct_types() : list of rf_struct is undefined;
   get_all_added_preexisting_types() : list of rf_type is undefined;
   add_code(code : list of string) is undefined;
   get_added_svh_code() : list of string is undefined;
   clear_added_svh_code() is undefined;
   add_exported_type_with_fields(type_name : string, ext_type_name : string, fields : list of string) : sv_exported_type is undefined;
   add_preexisting_type_with_fields(type_name : string, ext_type_name : string, fields : list of string, is_sv_struct : bool) is undefined;
   associate_type(e_name : string, sv_name : string) is undefined;
   associate_enum(e_name : string, sv_name : string) is undefined;
   associate_sequence(e_name : string, sv_name : string, fields : list of string) is undefined;
   associate_class(e_name : string, sv_name : string, fields : list of string) is undefined;
   associate_struct(e_name : string, sv_name : string, fields : list of string) is undefined;
   export_type(e_name : string, sv_name : string) is undefined;
   export_enum_type(e_name : string, sv_name : string) is undefined;
   export_sequence(e_name : string, sv_name : string, fields : list of string) is undefined;
   export_class(e_name : string, sv_name : string, fields : list of string) is undefined;
   verify_sequence(e_name : string) is undefined;
   get_exported_sequences() : list of rf_struct is undefined;
   get_exported_seq_holders() : list of sv_exported_type is undefined;
};


struct sv_exported_type like sn_struct {

   e_type : rf_type;
   type_name : string;
   scope_name : string;
   package_name : string;
   inc_fields : list of string;
   exc_fields : list of string;
   exported : bool;
   sv_hierarchy : sv_when_hierarchy;

   is_seq () :bool is undefined;
   get_sv_type_name () :string is undefined;
   get_sv_package_name () :string is undefined;
   get_sv_qualified_name () :string is undefined;
   get_sv_full_type_name () :string is undefined;
   get_sv_full_scope_name () :string is undefined;
   build (e_type : rf_type, sv_name : string, exported : bool) is undefined;
};

struct sv_when_hierarchy like sn_struct {

   hierarchy_base : rf_like_struct;
   subtypes : list of rf_when_subtype;
   parents : list of rf_struct;
   flattened_when_fields : list of rf_field;

   set_hierarchy_base_and_flattened_when_fields (base_name : string, flattened_fields : list of string) is undefined;
   set_hierarchy_base (base_name : string) is undefined;
   add_flattened_fields (lf : list of rf_field) is undefined;
   add_flattened_field (f : rf_field) is undefined;
   add_subtype (added_wst : string, parent_name : string) is undefined;
   get_subtypes () :list of rf_when_subtype is undefined;
   get_base () :rf_like_struct is undefined;
   get_parents () :list of rf_struct is undefined;
   get_subtype_parent (wst : rf_when_subtype) :rf_struct is undefined;
   set_rf_base (rfs : rf_like_struct) is undefined;
   get_all_subtypes_of_struct (parent : rf_struct) :list of rf_when_subtype is undefined;
   get_flattened_fields () :list of rf_field is undefined;
};

'>

<'

//@non_standard
struct parse {
   // @non_standard
   pre_post_load() is {};
};

//@non_standard
struct ntv like reparse_source_item{
//    x: ntv_extra;
};

////@non_standard
//struct ntv_extra like sn_struct{
//    //@non_standard
//    str: string;
//};


//@non_standard
struct reparse_source_item like source_item{
	//@non_standard
	source_module(): module is empty;
};

//@non_standard
struct sn_wave_signal_database_manager like sn_struct{

};

'>

<'

type name_qualification_t : [upon_ambiguity, never, always];

// @non_standard
struct enum_descriptor like primitive_descriptor {

   // @non_standard
   add_item(name : string, sr : source_ref, set_type_layer_id : bool) is {};
   // @non_standard
   add_item_with_value(name : string, value : uint, sr : source_ref) is {};
   // @non_standard
   init_set() is {};
   // @non_standard
   // @non_standard
   add_value_to_set(value : uint) is {};
   // @non_standard
   add_item_to_size_modifications(ei : enum_item) is {};
   // @non_standard
   // @non_standard
   is_legal(ei : enum_item) is {};
   // @non_standard
   item_by_value(value : int) : enum_item is {};
   // @non_standard
   item_by_name(name : string) : enum_item is {};
   // @non_standard
   c_code_by_name(name : string) : string is {};
   // @non_standard
   // @non_standard
   c_code_by_value(value : int) : string is {};
   // @non_standard
   incontiguous() : bool is {};
   // @non_standard
   is_fast_gen_extended() : bool is {};
   // @non_standard
   compare_modifiers_enum(size : int, set : interval_set, range_modified : bool) : bool is {};
   // @non_standard
   is_legal_for_size(ei : enum_item, size : int) is {};
   // @non_standard
   str2value(s : string) : int is {};
   // @non_standard
   items_to_rl() : uint_rl is {};
   // @non_standard
   get_max_item() : index is {};
   // @non_standard
   expected_uint_rl_size() : uint is {};
};

// @non_standard
struct primitive_descriptor like type_descriptor {
};

// @non_standard
struct bool_descriptor like primitive_descriptor {
};

// @non_standard
struct type_descriptor like source_item {

    // @non_standard
    get_size_in_bytes() : int is empty;

    // @non_standard
    d_index:int;
    
    // @non_standard
    get_possible_set() : interval_set is empty;
};

// @non_standard
struct enum_item like source_item {
};

// @non_standard
struct source_item like sn_struct {
	// @non_standard
	source_ref : int; // int because source_ref breaks as computed
	// @non_standard
	source_full(): string is empty;
    // @non_standard
    location_and_text(): string is empty;
};

// @non_standard
struct struct_descriptor like composite_descriptor {

   // @non_standard
   name : string;

   get_name() : string is empty;

   get_rf_struct() : rf_like_struct is empty;

};

// @non_standard
struct composite_descriptor like type_descriptor {
};

// @non_standard
struct list_descriptor like composite_descriptor {
};

// @non_standard
struct module like source_item {

   // @non_standard
   file_name: string;

   // @non_standard
   full_file_name: string;

   // @non_standard
   lines_number: int;

   // @non_standard
   module_num: int;

   // @non_standard
   name: string;

   // @non_standard
   relative_path: string;

};

//@non_standard
type epi_uvm_object_type : [
   epi_uvm_unknown,
   epi_uvm_sys,
   epi_uvm_top_component,
   epi_uvm_component,
   epi_uvm_register,
   epi_uvm_phase_manager,
   epi_uvm_sequence,
   epi_uvm_tlm_connectivity,
   epi_uvm_message_logger,
   epi_uvm_any_unit,
   epi_uvm_all
];

//@non_standard
type epi_uvm_int_property : [
   epi_uvm_prop_reg_addr,
   epi_uvm_prop_reg_value,
   epi_uvm_prop_objection_ctr_s,
   epi_uvm_prop_objection_ctr_t,
   epi_uvm_prop_reg_field_width
];

//@non_standard
type epi_uvm_str_property : [
   epi_uvm_prop_name,
   epi_uvm_prop_instance_path,
   epi_uvm_prop_phasing_domain,
   epi_uvm_prop_object_type,
   epi_uvm_prop_reg_field_path,
   epi_uvm_prop_reg_acces_policy,
   epi_uvm_prop_phase_name,
   epi_uvm_prop_objection_kind,
   epi_uvm_prop_reg_addr_s,
   epi_uvm_prop_reg_value_s,
   epi_uvm_prop_reg_field_type_s
];

//@non_standard
type epi_uvm_package_name : [
   epi_uvm_uvm_e,
   epi_uvm_vr_ad,
   epi_uvm_uvm_scbd,
   epi_uvm_uvm_accel,
   epi_uvm_uvm_lp
];

-- BEGIN: DVT-5587 Add eUnit predefined API



unit eu_testsuite like any_unit {
   run_unit_test(t : eu_testcase) is {};
};

unit eu_testlauncher like any_unit {
   report_abnormal_end() is {};
};

struct eu_testcase like any_struct {
   setup() is {};
   run_test() is undefined;
   watchdog() is undefined;
};

extend sys {
   //By default, the code creator parses the Method Under Test, and all the methods it calls are mocked-up. If you want to consider more than one method as under test, then mark them using parse_sub_methods
   eu_parse_sub_methods(m_names : list of string) is {};
   //Creates a test suite for the feature implemented in the method 'unit_name.method_name'
   eu_create_code_for_method(feature_name : string, unit_name : string, method_name : string, file_suffix : string) is {};
   //Creates a test suite for the feature implemented in the enumerated TLM ports in the unit 'unit_name'
   eu_create_code_for_ports(feature_name : string, unit_name : string, ports_name : list of string, file_suffix : string) is {};
   //To create a test suite for the features in eunit/examples, source the script eunit/examples/create.sh. The script loads the examples and calls the method sys.eu_gen_code().
   eu_gen_code() is {};
   eu_dummy_get_enclosing_unit(unit_type : string) : any_unit is {};
   eu_dummy_try_enclosing_unit(nit_type : string) : any_unit is {};
};

struct sn_external_trace like sn_struct {

-- add_transition_to_variable_in_database(u : any_unit, variable_name : string, value_holder : rf_value_holder, value_undef : bool) is {};

   //Begins the definition of a new transaction that is recorded in the SimVision transaction database for Specman, sn_tr_db.
   //If a transaction with the same parameters (unit, fiber_name, trans_type) is already begun, it is closed before the new transaction begins.
   new_transaction(u : any_unit, fiber_name : string, trans_type : string, transaction_label : string) : bool is {};

   //Begins the definition of a new transaction that is recorded in the SimVision transaction database for Specman, sn_tr_db. The transaction begins at the specified time.
   //This method is for use with protocols in which an event occurs when a transaction should end, but no event occurs when a transaction should start. You can use the time of the ending event to calculate when the transaction should have started. You can then write e code that includes both new_transaction_at() as well as close_transaction(), to execute when the ending event occurs.
   //If a transaction with the same parameters (unit, fiber_name, trans_type) is already begun, it is closed before the new transaction begins.
   new_transaction_at(u : any_unit, fiber_name : string, trans_type : string, transaction_label : string, t : time) : bool is {};

   //Defines an attribute of a new transaction that is recorded in the SimVision transaction database for Specman, sn_tr_db.
   set_transaction_attribute(u : any_unit, fiber_name : string, trans_type : string, attr_name : string, attr_value : string) is {};

   //Ends the definition of a new transaction that is recorded in the SimVision transaction database for Specman, sn_tr_db.
   //An attempt to close a transaction on a fiber that does not exist results in the creation of the fiber.
   close_transaction(u : any_unit, fiber_name : string, trans_type : string) is {};

   //Checks that the run-time environment supports transaction recording. The method returns TRUE if the ncsim executable is available.
   is_enabled(b_verbose : bool) : bool is {};

-- // private get_transactions_info() : transactions_info is {};
-- pre_end_external_trace_actions() is {};
-- trace_external_pre_restore() is {};
-- trace_external_post_restore() is {};
-- close_all_dbs() is {};
-- reset_all_dbs() is {};
-- flush_all_dbs() is {};
-- // package get_name_chain(u : any_unit) : string is {};
-- get_db_name() : string is {};
-- // package is_deprecated_sdi_e_method(method : method) : bool is {};
-- get_dwapi_lib_ptr(dwapi_lib_name : string) : external_pointer is {};
-- get_sdiBeginEnd() : int is {};
-- get_sdiBeginNoParent() : int is {};
-- get_sdi_string_type() : int is {};
-- get_sdi_format_string() : string is {};
-- get_symbol_c(faddr : external_pointer) : int is {};
-- tr_set_time_c(faddr : external_pointer, dbase : external_pointer, t : time) : bool is {};
-- sdi_transaction_with_time_c(faddr : external_pointer, specifier : int, handle : external_pointer, type : string, label : string, description : string, t : time) : external_pointer is {};
-- get_feature_version(feature_name : string) : int is {};
-- sdi_transaction(specifier : int, tr_fiber_h : external_pointer, tr_type : string, tr_label : string, description : string) : external_pointer is {};
-- sdi_set_attribute(handle : external_pointer, name : string, value : string, datatype : int, format : string, position : int) is {};
-- sdi_set_attribute_hidden(handle : external_pointer, name : string, value : string, datatype : int, format : string, position : int) is {};
-- sdi_end_transaction(tr_transaction_h : external_pointer) is {};
-- sdi_link_transaction(source : external_pointer, destination : external_pointer, relationName : string) is {};
-- sdi_free_transaction_handle(tr_transaction_h : external_pointer) is {};
-- sdi_close_database(dbase : external_pointer) is {};
-- sdi_start_of_reset(dbase : external_pointer) is {};
-- sdi_end_of_reset(dbase : external_pointer) is {};
-- sdi_simulation_paused(dbase : external_pointer) is {};
-- get_libsdi2c_api_symbols_under_global() : list of string is {};
-- get_libsdi2c_api_symbols_under_trace() : list of string is {};
-- get_libdwapi_symbols() : list of string is {};
-- get_sdi_error_cb_ptr() : external_pointer is {};
-- sdi_error_cb(msg : string) is {};
-- get_cds_lib_dir_name() : string is {};
-- get_libsdi2c_full_name() : string is {};
-- get_cds_sst2_lib() : string is {};
-- // private get_sdi_c_lib_plat_extension() : string is {};
-- // private get_sdi_lib_plat_extension() : string is {};
-- get_dxapi_lib(lib_name_1 : string) : string is {};
-- get_dcapi_lib_name() : string is {};
-- get_dwapi_lib_name() : string is {};
-- ensure_dwapi_lib_open() : bool is {};
-- init_sv_transrec_libs() : bool is {};
-- close_sv_transrec_libs() is {};
-- close_lib_safe(name : string) is {};
-- unregister_dwapi_lib() is {};
-- get_db_time_units() : e_time_units is {};
-- get_db_time_units_int() : int is {};
-- get_db_time_units_factor() : int is {};
-- tr_set_time(transaction_db_h : external_pointer) : bool is {};
-- sdi_transaction_with_time(specifier : int, tr_fiber_h : external_pointer, tr_type : string, tr_label : string, description : string, t : time) :
-- external_pointer is {};
-- get_overlapping_supported() : bool is {};
-- set_overlapping_supported() is {};
-- overlapping_supported() : bool is {};
-- get_sdi_feature_version(name : string) : sn_sdi_feature is {};
-- does_feature_exist(name : string, min_version : int, max_version : int) :
-- bool is {};
-- handle_checkpoint_restart() is {};
-- set_wave_signal_database_manager() is {};
-- get_wave_signal_database_manager() : sn_wave_signal_database_manager is {};
-- // package get_trace_lines() : list of string is {};
-- is_port_tracing_enabled(b_verbose : bool) : bool is {};
-- // package add_trace_cmd(cmd : string) is {};
-- // package clear_trace_cmds() is {};
-- get_ports_transaction_db() : transaction_db_handle is {};
-- set_sdm_db_name(filename : string) is {};
-- check_sdm_db_open_for_write() is {};
-- trace_external_pre_quit() is {};
-- open_smartlog(db_path : string) is {};
};

-- END: DVT-5587 Add eUnit predefined API

'>

<'

type pipe_direction_t : [UNSET,OUTPUT,INPUT];

unit uvm_accel_pipe_proxy_base {

   // Sets the autoflush semantics of the pipe. Enable==TRUE turns autoflush on for all subsequent messages,
   // and enable==FALSE turns it off for subsequent messages. Can be called at anytime during the test.
   set_autoflush(enable : bool) is {};
   // Returns the autoflush setting of the pipe.
   get_pipe_autoflush() : bool is {};
   // Returns the full path of the SCE-MI pipe.
   get_pipe_full_path() : string is {};
   // Return the number of bytes for an element in the SCE-MI pipe.
   // This is the value of BYTES_PER_ELEMENT parameter.
   get_pipe_bytes_per_element() : uint is {};
   // Returns the pipe direction.
   get_direction(): pipe_direction_t is {};

};

template unit uvm_accel_input_pipe_proxy of <type> like uvm_accel_pipe_proxy_base {
   m_in : interface_imp of tlm_put of <type> is instance;
};

template unit uvm_accel_output_pipe_proxy of <type> like uvm_accel_pipe_proxy_base {
   m_out : interface_imp of tlm_get of <type> is instance;
};


'>

<'

// e Linting with HAL - 2.2 Adding User-defined Linting Checks for e to HAL


// The sn_double_matrix type is a proxy to a MATLAB double-precision two-dimensional matrix. An object of this type can not be accessed without a MATLAB adapter. You must have at least one unit whose agent is MATLAB.
struct sn_double_matrix {

   // Returns the number of rows in the matrix
   rows():int is empty;

   // Returns the number of columns in the matrix
   columns():int is empty;

   // Returns the element in the given row and column of the matrix as an e object of type real. Indices start at zero as in e. It cannot be called before the matrix is initialized, either by a call to set_dimensions() or by an assignment from a port.
   get_element(row:int, column:int): real is empty;

   // Sets the dimensions of the matrix. This initializes the matrix with the given size. All elements are set to zero. The parameters must be positive integers.
   set_dimensions(rows:int, columns: int) is empty;

   // Sets the element in the given row and column of the matrix to the given real value. Indices start at zero as in e. It cannot be called before the matrix is initialized, either by a call to set_dimensions() or by an assignment from a port.
   put_element(value:real, row:int, column:int) is empty;

   // Returns the whole matrix as a two-dimensional list of type real.
   get_matrix(): list of list of real is empty;

   // Sets the whole matrix with the values of the two-dimensional list of type real passed as a parameter.
   // The number of elements in all the sub-lists must be the same; otherwise an error is issued.
   put_matrix(value: list of list of real) is empty;

};

'>

<'

//@non_standard
type uvm_ml_phase_action : [PHASE_STARTED, PHASE_EXECUTING, PHASE_READY_TO_END, PHASE_ENDED];

//@non_standard
struct sn_ABSTRACT_adapter like any_struct {
	
};

//@non_standard
struct sn_adapter_struct like sn_ABSTRACT_adapter {
	
};

//@non_standard
struct sn_ML_LIB_adapter like sn_adapter_struct {
	
	//@non_standard
	notify_phase_done(phase_group : string, phase_name : string, b_is_runtime_phase : bool, b_next_runtime_phase_exist : bool, next_runtime_phase_name : string) is {};
	
	//@non_standard
	sn_ml_notify_runtime_phase(phase_group : string, phase_name : string, phase_action : uvm_ml_phase_action, is_other_frmw_phase_sync : bool, this_frmw_phase_group : string, this_frmw_phase_name : string) : int is {};
	
};

'>