<'

// ---
// Ports
// ---

//@non_standard
type any_port_outside: [undefined, true, false];

// Reference a port instance.
unit any_port like any_unit {

	// FIXME: Simi - need Cristian review on connect moved here from any_interface...

	// The real type of outside is called any_port'outside but it may generate some errors and unexpected behavior

	// @non_standard
	outside: any_port_outside;

    // [pseudo method] connect(port-exp2 | empty | undefined | external_uvm_path)
    // Create an outbound connection from an e TLM interface port.
    connect(__dvt_ignore_args) is empty;

    // @non_standard
    direction(): sn_port_direction is empty;

    // Disconnect a port from its bound set.
    // Calling this pseudo-method of a port disconnects this port from the bound set it belongs to, and returns it to its initial, dangling state.
    // The rest of the bound set remains intact.
    disconnect() is empty;

    // Disconnect all ports in the bound set of a port.
    // Calling this pseudo-routine of a port disconnects all the ports in the bound set of this port, and sets the status of all of them to be dangling.
    disconnect_bound_set() is empty;

    // ATTRIBUTE Identifies the type for an external simulator object that is being driven by Specman.
    external_type(): string is empty;

    // @non_standard
    external_ovm(): bool is empty;

    // ATTRIBUTE Identifies the method port as an UVM method port.
    external_uvm(): bool is empty;
    
    // Returns a list of all IDs of all callbacks registered to a given port.
    get_all_cbs() : list of int is empty;

    // Returns the bound set of a port. Returns the set of ports connected to that port, including itself.
    // Calling get_bound_set() on a disconnected port returns only the port itself.
    get_bound_set(): list of any_port is empty;
    
    // Returns a list of all IDs of all callbacks registered to a given port with the given reason.
    get_all_cbs_of_reason(reason: cb_reason) : list of int is empty;
    
    // Returns the callback object registered with the given ID. If there is no such callback obect registered to the port, NULL is returned.
    get_cb_by_id(callback_id : uint) : any_port_cb is empty;
    
    // Returns the callback reason of the callback registered with the given ID. If there is no such callback registered to the port, INVALID_ID is returned.
    get_cb_reason_by_id(callback_id : uint) : cb_reason is empty;

    // Returns the size of the HDL object bound to a port.
    get_hdl_size(): int is empty;

    // Print the reason why a stubs file is required for the current port.
    get_stub_reason(): string is empty;

    // ATTRIBUTE Specifies user-defined convertors for external output method ports.
    hdl_convertor(): string is empty;

    // ATTRIBUTE Associate port instance with a  foreign language (Verilog,...) expression.
    hdl_expression(): string is empty;

    // Returns TRUE if a port is a member of a bound set.
    is_connected(): bool is empty;

    // Identify whether a stubs file is required for the current port.
    is_stub_required(): bool is empty;

    // ATTRIBUTE When an e in or inout external simple port of struct is used to read a SystemVerilog object, the type of the struct instance that will be created in e can be determined by using the read_type() port attribute.
    // The e type-name should be the type of the declared struct of the port or one of its derived types.
    // If not, an error is generated during Specman elaboration phase.
    read_type(): string is empty;
    
    // Registers the callback struct callback for reason reason. Returns the callback ID or UNDEF if registration fails.
    register_cb(callback: any_port_cb, reason: cb_reason) : int is empty;

    // Change the external object to which a port instance is bound.
    // To access an external, simulated object, you must provide a path to the object with the hdl_path() attribute.
    // The remap_hdl_path() pseudo-method lets you change the value of the HDL path.
    remap_hdl_path(value: string) is empty;
    
    // Removes the callback with the ID callback_id.
    remove_cb(callback_id: uint) is empty;
    
    // Removes all registered callbacks from the port.
    remove_all_cbs() is empty;
    
    // Removes all callbacks which were explicitly registered with the reason reason for this port.
    remove_all_cbs_of_reason(reason: cb_reason) is empty;
};

// Reference a simple port instance.
template unit any_simple_port of <type> like any_port {

	name() : string is empty;

    // ATTRIBUTE Forces a given value without the need to explicitly write the force action or one of the MVL force-related access methods, such as force_mvl().
    always_force(): bool is empty;

    // ATTRIBUTE You can connect an analog expression to a simple input port (a read operation) or an output port (a write operation).
    analog(): bool is empty;

    // ATTRIBUTE Simple ports of real type can be connected to analog named branches.
    // A port connected to a named branch can read either the voltage or the current of the branch, as specified by the port attribute analog_kind().
    analog_kind(): analog_kind_t is empty;

    // ATTRIBUTE Specify the bit width of a multi-bit external object.
    declared_range(): string is empty;

    // ATTRIBUTE Declare the size of a foreign language object.
    declared_size(): uint is empty;

    // ATTRIBUTE Specify immediate or delayed propagation of new values.
    delayed(): bool is empty;

    // ATTRIBUTE Create a resolved driver for an external object.
    driver(): bool is empty;

    // ATTRIBUTE Specify the delay for assignments to a port.
    driver_delay(): time is empty;

    // ATTRIBUTE Specify an initial value for an HDL object.
    driver_initial_value(): list of mvl is empty;
    
    // Get a list of MVL values from a port of a non-MVL type.
    // Similar to get_mvl_list(), except that it uses an existing buffer list instead of creating new list.
    fill_mvl_list(mvl_list: list of mvl) is empty;
    
    // Get a list of MVL values from a port of a non-MVL type.
    // Similar to get_mvl4_list(), except that it uses an existing buffer list instead of creating new list.
    fill_mvl4_list(mvl_list: list of mvl) is empty;

    // Force mvl data on a port of a non-mvl type.
    force_mvl(value: mvl) is empty;

    // Force a list of mvl values on a port of a non-mvl type.
    force_mvl_list(values: list of mvl) is empty;

    // Forces a string representing a list of mvl values to the specified output or inout simple port.
    force_mvl_string(value: string) is empty;

    // Force mvl data to a bit slice of a port.
    force_mvl_to_bit_slice(high: int, low: int, value: list of mvl) is empty;

    // Read mvl data from a port of a non-mvl type.
    get_mvl(): mvl is empty;

    // Get a list of mvl values from a port of a non-mvl type.
    get_mvl_list(): list of mvl is empty;

    // Get a value in form of a string from a port of a non-mvl type.
    get_mvl_string(radix): string is empty;

    // Get an mvl value from a port, converting 9-value logic to 4-value logic.
    get_mvl4(): mvl is empty;

    // Get a list of mvl values from a port, converting from 9-value logic to 4-value logic.
    get_mvl4_list(): list of mvl is empty;

    // Get a 4-state value in form of a string from a port of a non-mvl type.
    get_mvl4_string(radix): string is empty;

    // Returns the logic signal value and strength values for a scalar Verilog net or register.
    get_strength(): strength_val is empty;

    // Returns the logic signal values and strength values for a vector Verilog net or register.
    get_strength_list(): list of strength_val is empty;

    //Determine if port has a given MVL value.
    has_mvl_value(value: mvl): bool is empty;

    // Determine if port has U.
    has_unknown(): bool is empty;

    // Determine if port has X.
    has_x(): bool is empty;

    // Determine if port has Z.
    has_z(): bool is empty;

    // Access an indexed port.
    index(__dvt_variable_nof_args): any_simple_port of <type> is empty;

    // ATTRIBUTE Use this attribute to get or put the inverse value of a simple port.
    inverse(): bool is empty;

    // ATTRIBUTE Specify how composite data is transferred by internal ports.
    pass_by_pointer(): bool is empty;

    // ATTRIBUTE Setting pli_access() to TRUE for simple or simple indexed ports bound to Verilog or SystemVerilog objects
    // lets you avoid having to create or regenerate a stubs file for the ports making the access.
    pli_access(): bool is empty;

    // ATTRIBUTE You can use the pli_field_access() attribute with indexed simple ports to access a specific field of a packed or unpacked SystemVerilog structure or union.
    // You do so by setting the value of the attribute to the name of the field to be accessed.
    pli_field_access(): string is empty;

    // Put an mvl data on a port of a non-mvl type.
    put_mvl(value: mvl) is empty;

    // Put a list of mvl values on a port of a non-mvl type.
    put_mvl_list(values: list of mvl) is empty;

    // Put an mvl value on a port of a non-mvl type when a value is represented as a string.
    put_mvl_string(value: string) is empty;

    // Write mvl data to a bit slice of a port
    put_mvl_to_bit_slice(high: int, low: int, value: list of mvl) is empty;
    
    // @non_standard
    release() is empty;

    // ATTRIBUTE Identifies SystemC class fields and global variables to Specman.
    sc_variable(): bool is empty;

    // ATTRIBUTE Specify that an @sim event can be defined for this simple e port.
    sensitive(): bool is empty;

    // Set the default value for a simple port or a bound set of simple ports.
    set_default_mvl_value(mvl_list: list of mvl) is empty;

    // Set the default value for a simple port or a bound set of simple ports.
    set_default_value(value: <type>) is empty;

    // ATTRIBUTE Make an event port sensitive to an analog event expression.
    vams(): bool is empty;

    // ATTRIBUTE Require sampling of old value.
    verilog_delta_delay(): bool is empty;

    // ATTRIBUTE Specify timing control for data driven to the Verilog object.
    verilog_drive(): string is empty;

    // ATTRIBUTE Specify when to set the port to Z.
    verilog_drive_hold(): string is empty;

    // ATTRIBUTE Specifies that a Verilog object can be forced.
    verilog_forcible(): bool is empty;

    // ATTRIBUTE Specify the sampling event for a Verilog object.
    verilog_strobe(): string is empty;

    // ATTRIBUTE Create a single driver for a port (or multiple ports).
    verilog_wire(): bool is empty;

    // ATTRIBUTE Specify whether short pulses are propagated through driver.
    vhdl_delay_mode(): sn_vhdl_delay_mode_option is empty;

    // ATTRIBUTE Specify value to apply on Specman restore.
    vhdl_disconnect_value(): list of mvl is empty;

    // ATTRIBUTE Create a resolved driver for an external object.
    vhdl_driver(): bool is empty;

};

// Reference a buffer port instance.
template unit any_buffer_port of <type> like any_port {

    // ATTRIBUTE Specify the size of a buffer port queue.
    buffer_size(): uint is empty;

    // Clears the port queue.
    clear_buffer() is empty;

    // Read and remove data from an input buffer port queue.
    get(): <type> is empty;

    // Check if an input buffer port queue is empty.
    is_empty(): bool is empty;

    // Check if an output buffer port queue is full.
    is_full(): bool is empty;

    // Read and remove data from an input buffer port queue without blocking.
    nb_get(value: <type>): bool is empty;

    // Inserts a new item of value-type into the out buffer port queue at the given index location. Applies the value to the new item. All items in the queue to the right of the inserted item move one place right.
    // This method returns TRUE if it succeeds. The method returns FALSE if it fails, for example because the buffer queue is already full or because the insertion would cause the queue to be larger than the value set by the buffer_size() attribute.
    // This method applies for out e buffer ports only
    nb_insert(index: uint, value: <type>) : bool is empty;

    // Gets the given value to the item at the specified index location in the buffer queue and does not delete the item.
    // This method returns TRUE if it succeeds. The method returns FALSE if it fails, for example if no item exists at the given index location.
    // This method applies for in e buffer ports only.
    nb_peek(index: uint, value: <type>) : bool is empty;

    // Write data to an output buffer port queue without blocking.
    nb_put(value: <type>): bool is empty;

    // Removes the given item from the buffer queue and assigns the given value to the given parameter. All items in the queue to the right of the deleted item move one place left.
    // This method returns TRUE if it succeeds. The method returns FALSE if it fails, for example because the buffer queue was empty or because the index location did not contain an item.
    // This method applies for in or out e buffer ports.
    nb_remove(index: uint, value: <type>) : bool is empty;

    // Read data from an input buffer port queue without blocking.
    nb_top(value: <type>): bool is empty;

    // Get the number of current data items in the buffer queue.
    number_of_elements(): uint is empty;

    // Get the number of data items that can be written to the buffer queue, before the queue becomes full.
    number_of_free_elements(): uint is empty;

    // ATTRIBUTE Specify how composite data is transferred by internal ports.
    pass_by_pointer(): bool is empty;

    // Write data to an output buffer port queue.
    put(value: <type>) is empty;

    // Read data from an input buffer port queue without removing it.
    top(): <type> is empty;

};

// Reference a method port instance.
template unit any_method_port of <type> like any_port {
    // Access an indexed port.
    index(): <type> is empty;

    // ATTRIBUTE Use an external out method port to call a time-consuming external function from e code.
    static_sensitivity(): string is empty;

    // ATTRIBUTE Synchronize an e input method port call from an external simulator object.
    sync_mode(): sn_sync_options is empty;
};

// Reference an event port instance.
template unit any_event_port of <type> like any_port {

    // Deactivates the external input event port.
    disable() is empty;

    // ATTRIBUTE Specify the edge on which an event is generated.
    // The edge() attribute is meaningful only when the input event port is bound to a SystemC signal or port.
    edge(): event_port_edge is empty;

    // Activates or reactivates the external input event port.
    enable() is empty;

};

// Transfer transactions between e units or with an external component
template unit any_interface_port of <type> like any_port {

// TODO this is not actually used, see any_interface below

};

unit any_interface like any_port {

    // TODO 1 inherit from any port to get any_port methods

    // TODO 2 the API below should go into any_interface_port once we re-design interface ports

	// TODO 3 see FIXME in any_port... moved because of doug reported issue #DVT-9632

//    // [pseudo method] connect(port-exp2 | empty | undefined | external_uvm_path)
//    // Create an outbound connection from an e TLM interface port.
//    connect(__dvt_ignore_args) is empty;

    // Return the set of all the e2e ports to which the specified e TLM interface port has
    //  direct or indirect outbound connections.
    get_outbound_set() is empty;

    // Return the set of all the e2e ports to which the specified e TLM interface port has
    //  direct or indirect inbound connections.
    get_inbound_set() is empty;

    // Return the set of all the e2e ports to which the specified e TLM interface port has
    //  direct outbound connections.
    get_direct_outbound_set() is empty;

    // Return the set of all the e2e ports to which the specified e TLM interface port has
    //  direct inbound connections.
    get_direct_inbound_set() is empty;

    // Return the set of all external port paths to which the specified e TLM interface port has
    //  direct outbound connections.
    get_outbound_external_set() is empty;

    // Return the set of all external port paths to which the specified e TLM interface port has
    //  direct inbound connections.
    get_inbound_external_set() is empty;

    // This method prints the connection network starting from the specified e TLM interface port.
    // This method also prints the complete direct inbound set of ports (external and e2e) connected to the specified e TLM interface port.
    print_hierarchical_bindings() is empty;

    // Change the external UVM TLM interface port to which an e TLM interface port instance is connected.
    remap_external_uvm_path(external_uvm_path: string) is empty;

};

'>

<'

// Callback base struct
struct any_transaction_cb like any_struct {
    // Once the activity indicated by the reason is performed, the callback() method of the registered instance is called.
    callback(info: cb_data) is empty;
};

// Port callback struct
struct any_port_cb like any_transaction_cb {
};

// Tick callback struct
struct any_tick_cb like any_transaction_cb {
};

type cb_reason : [
    // When used in registration, causes a callback to be invoked when there is a read action from the external entity associated with the port that results in a change to the port value.
    // When returned by a query, tells you that the callback was caused by read from the external entity associated with the port and that the port value has changed with respect to the previous one
    READ_EXTERNAL_CHANGE,
    // When used in registration, causes a callback to be invoked when there is a read action from the external entity associated with the port or tick.
    // When returned by a query, tells you that the callback was caused by read from the external entity associated with the port or tick. For port callbacks, the value has not changed as a result of the read (otherwise the reason would be READ_EXTERNAL_CHANGE).
    READ_EXTERNAL,
    // When used in registration, causes a callback to be invoked when there is a write action to the external entity associated with the port or tick.
    // When returned by a query, tells you that the callback was caused by write to the external entity associated with the port or tick.
    WRITE_EXTERNAL,
    // When used in registration, causes a callback to be invoked when a read from or write to the external entity associated with the port or tick occurs.
    EXTERNAL,
    // When used in registration, causes a callback to be invoked whenever the port value changes as a result of a write or force action.
    // When returned by a query, tells you that the callback was caused by change in the port value as a result of a write or force action.
    E2E_CHANGE,
    // When used in registration, causes a callback to be invoked for any change--emission of event port or an e2e port value change (CHANGE_E2E) or a port value change due to an external read (READ_EXTERNAL_CHANGE).
    // When returned by a query, tells you that the callback was caused by the emission of an event. (This reason cannot be an invocation reason for simple ports.)
    CHANGE,
    // When used in registration, causes a callback to be invoked whenever the port value is updated as a result of a write or force action.
    // When returned by a query, tells you that the callback was caused by an update to (but not a change to) the port value as a result of a write or force action. (If the value changed, the reason would be CHANGE_E2E.)
    E2E_ACTIVE,
    // When used in registration, causes a callback to be invoked when a release action is performed.
    // When returned by a query, tells you that the callback was caused by release action.
    RELEASE,
    // When used in registration, causes a callback to be invoked for any reason that is applicable for this tick.
    ANY_TCB_REASON,
    // When used in registration, causes a callback to be invoked for any reason that is applicable for this port.
    ANY_REASON,
    INVALID_ID
];

// The cb_data object holds the information for the current operation using references.
// Moreover, to save time and memory usage, Specman may reuse these objects.
// Because of this, you cannot save the cb_data object directly for post run analysis.
struct cb_data like any_struct {
    // Returns the Specman time of the transaction.
    get_cb_time(): time is empty;

    // Returns the reason for this callback invocation.
    get_reason(): cb_reason is empty;

    // Returns a clone of the object that can be saved (does not use references for the values).
    get_saved(): cb_data is empty;

    // Returns the places in the code that contributed to this transaction.
    get_source_refs(): list of string is empty;

    // @non_standard
    transaction_dump() is empty;
};

struct cb_data_tick like cb_data {
    // @non_standard
    bit_mask: list of bit;
    // @non_standard
    event_cb: bool;
    // @non_standard
    force_op: bool;
    // @non_standard
    reason: cb_reason;
    // @non_standard
    rf_val: rf_value_holder;
    // @non_standard
    sig_size: uint;

    // Returns the bit mask as a list of bit where 1 represents touched bits.
    get_bit_mask(): list of bit is empty;

    // @non_standard
    get_id(): int is empty;

    // Returns the new value as a list of mvl.
    get_mvl_value(): list of mvl is empty;

    // Returns the tick name.
    get_tick(): string is empty;

    // Returns the new value as a string.
    get_value_as_string(): string is empty;

    // Returns value type information (that is, the type that is used for keeping the value in this cb_data_tick instance).
    get_value_type(): rf_type is empty;

    // Returns the new value as untyped.
    get_value_unsafe(): untyped is empty;

    // Returns TRUE if the operation is done for writing with a bit preserve.
    is_bit_slice_operation(): bool is empty;

    // Returns TRUE if this cb_data is caused by emitting a tick notation event.
    is_event_cb(): bool is empty;

    // Returns TRUE if the operation is done as the result of force.
    is_force_operation(): bool is empty;

    // Returns TRUE if the operation uses MVL values.
    is_mvl_operation(): bool is empty;

    // Returns the new value inside rf_value_holder.
    sn_get_value_as_rf_holder(): rf_value_holder is empty;
};

struct cb_data_port like cb_data {
    // @non_standard
    cb_port: any_port;

    // Returns the whole bound set of ports.
    get_bound_set(): list of any_port is empty;

    // Returns the registered port.
    get_port(): any_port is empty;

    // Returns the reflection data from rf_port.
    get_port_rf(): rf_port is empty;

    // @non_standard
    set_port(p: any_port) is empty;

    // @non_standard
    transaction_dump_attributes() is empty;
};

struct cb_data_simple like cb_data_port {
    // @non_standard
    reason: cb_reason;

    // Returns the bit mask as a list of bit where 1 represents touched bits.
    get_bit_mask(): list of bit is empty;

    // Returns the new value as a list of mvl, similar to get_mvl_list().
    get_mvl_value(): list of mvl is empty;

    // Returns the new value as a string.
    get_value_as_string(): string is empty;

    // Returns the new value as untyped.
    get_value_unsafe(): untyped is empty;

    // Returns TRUE if the operation is done for writing with a bit slice.
    is_bit_slice_operation(): bool is empty;

    // Returns TRUE if the operation is done as the result of force.
    is_force_operation(): bool is empty;

    // Returns TRUE if the operation (either propagation or external) is using the MVL interface of the port
    is_mvl_operation(): bool is empty;

    // @non_standard
    is_undef_value(): bool is empty;

    // @non_standard
    sn_get_simple_holder(): sn_simple_holder is empty;

    // Returns the new value inside rf_value_holder.
    sn_get_value_as_rf_holder(): rf_value_holder is empty;

    // @non_standard
    sn_get_value_copy_as_rf_holder(): rf_value_holder is empty;

    // @non_standard
    sn_get_value_copy_unsafe(): untyped is empty;
};

struct cb_data_event like cb_data_port {
};

// Global operations on port callbacks are done using methods of global object port_cb_manager.
struct port_cb_manager like any_struct {
    // @non_standard
    global_tcb_reason_mask: uint;
    // @non_standard
    sn_event_cb_depth: uint;
    // @non_standard
    sn_event_cbd: unsaved_cb_data_event;
    // @non_standard
    sn_global_port_cb_list: list of any_port_cb_list_item;
    // @non_standard
    sn_global_tick_cb_list: list (key: cb) of any_tick_cb_list_item;
    // @non_standard
    sn_next_port_cb_key: uint;
    // @non_standard
    sn_simple_cb_depth: uint;
    // @non_standard
    sn_simple_cbd: unsaved_cb_data_simple;

    // Returns the callback object registered with the given ID. If there is no such callback obect, NULL is returned.
    get_cb_by_id(cb_id: uint): any_port_cb is empty;

    // Returns the callback reason of the callback registered with the given ID. If there is no such callback, INVALID_ID is returned.
    get_cb_reason_by_id(cb_id: uint): cb_reason is empty;

    // Returns a list of reasons that will invoke this tick-callback. The list includes the actual reasons, for example EXTERNAL_READ, EXTERNAL_WRITE, and RELEASE, but does not include reasons that represent a union of lower-level reasons, for example EXTERNAL.
    get_reasons_for_tick_cb(tcb: any_tick_cb): list of cb_reason is empty;

    // Returns a list of all callbacks that are invoked when an action of tick-callback-reason type is performed.
    get_tick_cbs_by_reason(reason: cb_reason): list of any_tick_cb is empty;

    // @non_standard
    is_external_cb_reason(cbr: cb_reason): bool is empty;

    // @non_standard
    is_internal_cb_reason(cbr: cb_reason): bool is empty;

    // @non_standard
    is_read_from_external_cb_reason(cbr: cb_reason): bool is empty;

    // @non_standard
    is_tick_cb_reason(cbr: cb_reason): bool is empty;

    // @non_standard
    is_write_cb_reason(cbr: cb_reason): bool is empty;

    // @non_standard
    notify_in_method_port(mp: any_method_port) is empty;

    // @non_standard
    notify_out_method_port(mp: any_method_port) is empty;

    // Enables invocation of tick-callback.callback() when a tick activity of reason reason is executed.
    register_tick_cb(tcb: any_tick_cb, reason: cb_reason) is empty;

    // Removes all callbacks.
    remove_all_cbs() is empty;

    // Removes all callbacks that were registered with the given reason.
    remove_all_cbs_of_reason(cbr: cb_reason) is empty;

    // Removes the callback with the ID callback_id.
    remove_cb(id: uint) is empty;

    // @non_standard
    sn_elaborate_cbs() is empty;

    // @non_standard
    sn_get_next_cb_key(): uint is empty;

    // @non_standard
    sn_global_cb_list_empty(): bool is empty;

    // @non_standard
    sn_has_cbs_ports(): list of any_port is empty;

    // @non_standard
    sn_invoke_event_tick_cb(g_tick_port: any_port) is empty;

    // @non_standard
    sn_invoke_non_esi_read_tick_cb(cdt: cb_data_tick) is empty;

    // @non_standard
    sn_invoke_non_esi_release_tick_cb(cdt: cb_data_tick) is empty;

    // @non_standard
    sn_invoke_non_esi_write_tick_cb(cdt: cb_data_tick) is empty;

    // @non_standard
    sn_invoke_read_tick_cb(g_tick_port: any_port, size: uint, val: rf_value_holder) is empty;

    // @non_standard
    sn_invoke_release_tick_cb(g_tick_port: any_port) is empty;

    // @non_standard
    sn_invoke_write_tick_cb(g_tick_port: any_port, val: rf_value_holder, b_mask: list of bit, is_force: bool) is empty;

    // @non_standard
    sn_read_tick_cbs_exist(): bool is empty;

    // @non_standard
    sn_release_tick_cbs_exist(): bool is empty;

    // @non_standard
    sn_update_global_tcb_reason_mask() is empty;

    // @non_standard
    sn_write_tick_cbs_exist(): bool is empty;

    // Disables invocation of tick-callback.callback() when tick action of reason tick-callback-reason is executed.
    unregister_tick_cb(tcb: any_tick_cb, reason: cb_reason) is empty;
};

'>

