<'

// -----------------------
// Reflection API
// -----------------------

type rf_deep_attr: [
   normal,
   reference,
   ignore
];

// Method layer extension mode.
type rf_extension_mode: [
   empty,
   undefined,
   also,
   first,
   only,
   is
];

struct rf_bfm_sequence like rf_sequence {

   // Returns the item type for this sequence type.
   get_item_struct () : rf_struct is empty;

};

// Boolean types in e are the predefined type bool and its (possibly user defined) with derivatives such as bool (bits:8).
// Boolean types have no special features others than those declared for rf_scalar.
struct rf_bool like rf_scalar {

};

// Buffer port.
struct rf_buffer_port like rf_port {

};

struct rf_check like rf_struct_member {

   //Returns a list of all check actions which are the layers of this check.
   //The list is ordered according to the load order of their source.
   //For unnamed checks, the list always has exactly one element.
   get_check_actions () : list of rf_check_action is empty;

   //Returns a list of all check actions which are the layers of this check,
   //and which apply to the struct given as parameter.
   //If the parameter struct does not have this check (that is, it is not contained
   //in the struct that declared this check), an empty list is returned.
   get_relevant_check_actions (s : rf_struct) is empty;

   //Returns TRUE if this 'check' action has a condition being checked, that is,
   //it is not a plain 'dut_error' action.
   has_condition () : bool is empty;

};

struct rf_check_action like rf_check_layer {

   //Returns the method layer in which this 'check' action resides.
   get_containing_method_layer () : rf_method_layer is empty;

   //Returns TRUE if this 'check' action has a condition being checked, that is,
   //it is not a plain 'dut_error' action.
   has_condition () : bool is empty;

};

struct rf_check_layer like rf_struct_member_layer {

   //Returns the text string of this check action or expect layer, which is produced
   //as the error message when the check condition does not hold.
   get_text () : string is empty;

};

struct rf_constraint like rf_struct_member {

   //Returns the string that represents the condition expression of this constraint declaration.
   //If it is a named constraint and it has extension, the string of the original declaration is returned.
   //To avoid confusion, for named constraints it is recommended to use rf_constraint_layer.get_constraint_string().
   get_declaration_string () : string is empty;

   //Returns a list of all layers of this constraint, in all struct types where it is defined (that is,
   //declared or extended). The list is ordered according to the load order of their source.
   get_layers () : list of rf_constraint_layer is empty;

   //Returns the active layer of this constraint which is relevant to the struct given
   //as parameter. The active layer is the last defined layer relevant to this struct,
   //because every layer overwrites the previous relevant layer of the constraint,
   //that is, replaces its condition expression with a new one.
   //If the parameter struct does not have this constraint (that is, it is not contained
   //in the struct that declared this event), NULL is returned.
   get_relevant_layer (s : rf_struct) : rf_constraint_layer is empty;

   //Returns TRUE if the constraint is satisfied in the given struct instance.
   //For soft constraint, the result is always TRUE.
   is_satisfied (obj : any_struct) : bool is empty;

   transform_contradiction_constraint() : string is empty;
};

struct rf_constraint_layer like rf_struct_member_layer {

   //Returns the string that represents the condition expression of this constraint layer.
   get_constraint_string () : string is empty;

};

// Piece of a named entity definition.
struct rf_definition_element like rf_source_item {

   // Returns the named entity that is being defined by this definition element.
   // In other words, this element is part of the definition of the returned named entity.
   get_defined_entity(): rf_named_entity is empty;

   // Returns the inline documentation of this definition element.
   // Inline documentation is the comment in the consecutive lines directly preceding the definition in the source files.
   // Note that this method involves opening and reading the source file.
   // If the source file is not found (according to the standard file search algorithm) an empty string is returned.
   get_documentation(): string is empty;

   // Returns the inline documentation of this definition element as a list of strings separated by new-line characters in the source file.
   // If the source file is not found (according to the standard file search algorithm) an empty list is returned.
   get_documentation_lines(): list of string is empty;

   // Returns the module in which this definition element appears.
   get_module(): rf_module is empty;
   
   // Returns the total number of lines of the clause in the source file.
   // Currently supported for struct member declarations and layers only.
   get_source_lines_count(): int is empty;

   // Returns the line number of the beginning of the clause in the source file.
   get_source_line_no(): int is empty;

   // Returns the line number of the beginning of the clause in the source file.
   get_source_line_num(): uint is empty;

   // Returns TRUE if this definition element appears before the one given as parameter in the load order. This is a full order relation on definition elements, which is defined as the ordinal number of modules and then the line number in the file (a definition element is not before itself).
   is_before(other: rf_definition_element): bool is empty;

};

// Enum scalar.
struct rf_enum like rf_scalar {

   // Returns the set of named values for this type.
   // Note that the legal values of an enum type are not restricted by a range declaration.
   // For example, the type introduced by the statement "type my_color: color [red..blue]" has the same items as type color.
   // Such declaration affects only generation properties of the type.
   get_items(): list of rf_enum_item is empty;

   // Returns the named value object for the given name, or NULL if no value by such name exists in this type's range.
   get_item_by_name(name: string): rf_enum_item is empty;

   // Returns the named value object for the given value, or NULL if no such value exists in this type's range.
   get_item_by_value(val: int): rf_enum_item is empty;

   // Returns all enum layers that constitute this enum type.
   get_layers(): list of rf_enum_layer is empty;

};

// Type scalar.
struct rf_type like rf_named_entity {

};

// Enum items are pairs of identifier-integer, which are the possible values of a variable of that enum type.
// The integer values of enum items are the numbers assigned to them explicitly in the declaration (such as ‘[red = 3, green = 17]’)
//  or the default (consecutive) numbers.
struct rf_enum_item like rf_named_entity {

   //Returns the enum type in which this item was introduced.
   get_defining_type () : rf_enum is empty;

   // Returns the integer value associated with this item.
   get_value(): int is empty;

};

// Enum type layer.
struct rf_enum_layer like rf_type_layer {

   // Returns the named values that are added by this enum layer.
   get_added_items(): list of rf_enum_item is empty;

};

// @non_standard
struct rf_erm_package like rf_structural_element {

   // @non_standard
   get_version(): string is empty;

};

// Event struct member.
struct rf_event like rf_struct_member {

   //Returns a list of all layers of this event, in all struct types where it is defined (that is,
   //declared or extended). The list is ordered according to the load order of their source.
   get_layers () : list of rf_event_layer is empty;

   //Returns the active layer of this event which is relevant to the struct given
   //as parameter. The active layer is the last defined layer relevant to this struct,
   //because every layer overwrites the previous relevant layer of the event,
   //that is, replaces its temporal expression with a new one.
   //If the parameter struct does not have this event (that is, it is not contained
   //in the struct that declared this event), NULL is returned.
   get_relevant_layer (s : rf_struct) : rf_event_layer is empty;

};

struct rf_event_layer like rf_struct_member_layer {

};

struct rf_event_port like rf_port {

};

struct rf_expect like rf_struct_member {

   //Returns a list of all layers of this expect or assume, in all struct types where it is defined (that is,
   //declared or extended). The list is ordered according to the load order of their source.
   get_layers () : list of rf_expect_layer is empty;

   //Returns the active layer of this expect or assume which is relevant to the struct given as parameter.
   get_relevant_layer (s : rf_struct) : rf_expect_layer is empty;

   rerun() is empty;

   stop() is empty;

};

struct rf_expect_layer like rf_check_layer {

};

// Field struct member.
struct rf_field like rf_struct_member {

   // @non_standard
   get_consistent_gen_set(instance: base_struct) : rf_set is empty;

   get_declared_list_size(): int is empty;

   get_declared_list_sizes(): list of int is empty;

   get_deep_compare_attr(s: rf_struct): rf_deep_attr is empty;

   get_deep_compare_physical_attr(s: rf_struct): rf_deep_attr is empty;

   get_deep_copy_attr(s: rf_struct): rf_deep_attr is empty;

   // Returns the field type.
   get_type(): rf_type is empty;

   // Returns the value of this field in the struct instance given as parameter.
   // If the struct type of the instance does not have this field an exception is thrown.
   get_value(instance: base_struct): rf_value_holder is empty;

   // Returns the value of this field in the struct instance given as parameter.
   // If the struct type of the instance does not have this field the behavior is undefined.
   get_value_unsafe(instance: base_struct): untyped is empty;

   // Returns TRUE if the field is consistent with the field declaration.
   // For example, if the header field is declared as "header : DATA header",
   //  the header field is checked to be of kind DATA.
   is_consistent(obj: any_struct): bool is empty;

   // Returns TRUE if the field is declared constant (that is, with the 'const' modifier).
   // Constant fields are immutable after the initialization of the struct.
   is_const(): bool is empty;

   // Returns TRUE if the field is declared physical (that is, with '%' modifier).
   // Physical fields are the ones packed when the struct is packed.
   is_physical(): bool is empty;

   // Returns TRUE if the field is an instance of a port type declared as 'is instance'.
   is_port_instance(): bool is empty;

   // Returns TRUE if the field is declared as ungenerated (that is, with '!' modifier).
   // Ungenerated fields are not generated automatically when the struct is generated.
   is_ungenerated(): bool is empty;

   // Returns TRUE if the field is an instance of a unit type (declared as 'is instance').
   is_unit_instance(): bool is empty;

   // Sets the value of this field in the struct instance given as parameter to the new value.
   // If the struct type of the instance does not have this field an exception is thrown.
   set_value(instance: base_struct, value: rf_value_holder) is empty;

   // Sets the value of this field in the struct instance given as parameter to the new value.
   // If the struct type of the instance does not have this field the behavior is undefined.
   set_value_unsafe(instance: base_struct, value: untyped) is empty;

};

struct rf_interface_port like rf_port {

};

// Keyed list.
struct rf_keyed_list like rf_list {

   // Returns the field by which the list is mapped, or NULL if the key is the object itself (i.e when the list is defined as "(key: it)").
   get_key_field(): rf_field is empty;

};

// Like struct type.
struct rf_like_struct like rf_struct {

   // Returns the set of all subtypes of this struct in the like struct hierarchy.
   get_all_like_subtypes(): list of rf_like_struct is empty;

   // Returns the set of immediate subtypes of this struct in the like struct hierarchy.
   get_direct_like_subtypes(): list of rf_like_struct is empty;

   // Returns all struct layers that constitute this struct type.
   get_layers(): list of rf_struct_layer is empty;

   // Returns the immediate like supertype of this struct.
   get_supertype(): rf_like_struct is empty;

   // Returns the set of all defined subtypes in the when struct family for this struct.
   // If this struct is not a leaf in the like hierarchy (that is, it has like subtypes), the method returns an empty list.
   get_when_subtypes(): list of rf_when_subtype is empty;

};

// Lists are multi purpose containers in e.
// The different list types are all instances of a generic definition similar to a parameterized type (template) in other OO languages.
// Any non-list type (scalars, strings or structs) can serve as the element type of a list.
struct rf_list like rf_type {

   // Returns the element type of this list. For example, the element type of list of big packet is big packet.
   get_element_type(): rf_type is empty;

   // Returns TRUE if this list is packed (lists with element type whose size in bits is 16 or less are packed).
   is_packed(): bool is empty;

};

struct rf_macro like rf_type {

   // Returns the name of the syntactic category to which this macro belongs.
   get_category () : string is empty;

   get_package(): rf_package is empty;

   // Returns the match expression.
   get_match_expression(): string is empty;

   //Returns TRUE if this macro is a define-as-computed macro.
   is_computed () : bool is empty;

};

// A name defined using a #define preprocessor directive.
struct rf_defined_name like rf_named_entity {
   // Returns the replacement string, or an empty string if no replacement was defined.
   get_value() : string is {};
};

extend rf_manager {

   // @non_standard
   get_specman_version() : string is empty;

   // @non_standard
   eval_exp_string(exp_str: string): rf_value_holder is empty;

   // @non_standard
   get_all_defines(): list of rf_macro is empty;

   // Returns all sequences.
   get_all_sequences() : rf_sequence is empty;

   // Returns a list of all units instantiated directly or indirectly under the root unit instance given as parameter.
   // For example, by calling this method with 'sys; as a parameter, one gets all of the units instantiated in the environment (except 'sys' itself).
   get_all_unit_instances(root: any_unit): list of any_unit is empty;

   // @non_standard
   get_erm_package_by_name(name: string): rf_erm_package is empty;

   // @non_standard
   get_define(name: string): rf_define is empty;

   // Returns the package with the name given as parameter, or NULL if no package by this name is currently loaded.
   get_package_by_name(name: string): rf_package is empty;

   // Returns the type of the instance given as parameter.
   // The returned meta-object represents the most specific significant type that applies to the instance given as parameter,
   //   that is the one that contains all other types that apply to the instance.
   // For example, if the parameter is a packet, which has the defined subtypes big packet and corrupt packet,
   //  and assume this packet happens to be both corrupt and big.
   // In this case the returned type would be corrupt big packet, even though it is not a defined subtype.
   // Note that the static type of a field, for example, can be in some cases more specific than the exact subtype of the object
   //  which is the field’s actual value.
   // This happens when the static type is an insignificant when subtype.
   get_exact_subtype_of_instance(instance: base_struct): rf_struct is empty;

   // Returns the value of the given list at the given index.
   // If the value is not a list or the index is out of bound an exception is thrown.
   get_list_element(list: rf_value_holder, index: int): rf_value_holder is empty;

   // Returns the value of the given list at the given index.
   // If the value is not a list or the index is out of bound the behavior is undefined.
   get_list_element_unsafe(list: untyped, index: int): untyped is empty;

   // Returns the number of elements currently in the given list.
   // If the value is not a list an exception is thrown.
   get_list_size(list: rf_value_holder): int is empty;

   // Returns the number of elements currently in the given list.
   // If the value is not a list the behavior is undefined.
   get_list_size_unsafe(list: untyped): int is empty;

   // Returns the macro with the name given as parameter, or NULL if no macro by that name exists in the system.
   get_macro_by_name(name: string): rf_macro is empty;

   //Returns the list of all the macros of a given syntactic category.
   get_macros_by_category (cat : string) : list of rf_macro is empty;

   // Returns the module with the given ordinal number in the load order.
   get_module_by_index(index: int): rf_module is empty;

   // Returns the module with the name given as parameter, or NULL if no module by this name is currently loaded.
   get_module_by_name(name: string): rf_module is empty;

   //Returns the routine with the name given as parameter, or NULL if no routine by this name exists in the system.
   get_routine_by_name (name : string) : rf_routine is empty;

   //Returns the struct with the name given as parameter, or NULL if no struct by this name exists in the system.
   //If the name is unqualified, the usual type name resolution rules are used, and in the case if an ambiguity NULL is returned.
   get_struct_by_name (name : string) : rf_struct is empty;

   // Returns the most specific like struct of the struct instance given as parameter and disregards any when variants,
   //  even if they apply to the instance. To query for the specific when subtype of an object use get_exact_subtype_of_instance().
   get_struct_of_instance(instance: base_struct): rf_like_struct is empty;

   //Returns the template type with the name given as parameter, or NULL if no template by this name exists in the system.
   //If the name is unqualified, the usual type name resolution rules are used, and in the case if an ambiguity NULL is returned.
   get_template_by_name (name : string) : rf_template is empty;

   // Returns the type with the name given as parameter, or NULL if no type by that name exists in the system.
   get_type_by_name(name: string): rf_type is empty;
   
   // Returns the list of all names defined using #define preprocessor directives in user modules.
   get_user_defined_names(): list of rf_defined_name is empty;

   // Returns a list of all the macros that are declared in user modules.
   get_user_macros(): list of rf_macro is empty;

   // Returns a list of all user modules that are currently loaded.
   get_user_modules(): list of rf_module is empty;

   //Returns the list of all the routine that are declared in user modules with 'routine' statements.
   get_user_routines () : list of rf_routine is empty;

   //Returns the list of all the templates that are declared in user modules.
   get_user_templates () : list of rf_template is empty;

   // Returns a list of all the types that are declared in user modules.
   get_user_types(): list of rf_type is empty;

   // Sets the value of the given list at the given index.
   // If the first parameter is not a list, the index is out of bound or the new value is not of an instance of the list’s element type
   //  an exception is thrown.
   set_list_element(list: rf_value_holder, index: int, new_val: rf_value_holder) is empty;

   // Sets the value of the given list at the given index.
   // If the value is not a list, the index is out of bound or the new value is not of an instance of the list’s element type
   //  the behavior is undefined.
   set_list_element_unsafe(list: untyped, index: int, new_val: untyped) is empty;

   // Returns the name define using a #define preprocessor directive.	
   get_defined_name (name : string) : rf_defined_name is empty;

};

// Method struct member.
struct rf_method like rf_struct_member {

   // Returns a list of all layers of this method in all struct-types where it is defined.
   // The returned list is ordered by load order from early to late.
   get_layers(): list of rf_method_layer is empty;

   // Returns a list of all layers of this method that apply to the struct-type given as parameter.
   // If the parameter struct-type does not have this method at all an empty list is returned.
   // For example, method to_string() is defined for every struct in e, so get_layers() would return all extensions of this method in the system
   //  (including Specman internal). However calling get_relevant_layer() for struct packet would return only the extensions of to_string()
   //  defined in the context of struct packet and its subtypes.
   get_relevant_layers(s: rf_struct): list of rf_method_layer is empty;

   // Returns the object that represents the result type of this method, or NULL if the method does not return any value.
   get_result_type(): rf_type is empty;

   // Returns a list of formal parameters of this method. If the method has no parameters the list is empty.
   get_parameters(): list of rf_parameter is empty;

   // Returns the object that represents the default sampling event in case this method is a TCM, or NULL otherwise.
   get_sampling_event(): rf_event is empty;

   // Invokes this method on the instance given as a parameter.
   // If the struct type of the instance does not declare this method, an error is issued.
   // Similarly, if the given parameters are not of the types in the order required by this method, an error is issued.
   // If this method does not have a return value, NULL is returned.
   // Note that methods which take parameters by reference (parameters marked with the '*' modifier) cannot be invoked in this way.
   invoke(instance: base_struct, params: list of rf_value_holder): rf_value_holder is empty;

   // Invokes this method on the instance given as a parameter.
   // If the struct type of the instance does not declare this method or if the given parameters are not of the types in the order required by this method, the behavior is undefined.
   // If this method does not have a return value, the returned value is undefined.
   // Note that methods which take parameters by reference (parameters marked with the '*' modifier) cannot be invoked in this way.
   invoke_unsafe(instance: base_struct, params: list of untyped): untyped is empty;

   //Returns TRUE if the method is declared as 'final'.
   is_final () : bool is empty;

   // Returns TRUE if the method is declared as inline.
   is_inline(): bool is empty;

   // Returns TRUE if this method is time consuming, that is, if it has a sampling event.
   is_tcm(): bool is empty;

   // Starts this TCM on the instance given as a parameter.
   // If the struct type of the instance does not declare this TCM, an error is issued.
   // Similarly, if the given parameters are not of the types in the order required by this TCM or this is not a TCM, an error is issued.
   start_tcm(instance: any_struct, params: list of rf_value_holder) is empty;

   // Starts this TCM on the instance given as a parameter.
   // If the struct type of the instance does not declare this TCM (or its subtype) or if the given parameters are not of the types in the order required by this TCM, the behavior is undefined.
   // If this is not a TCM, an error is issued.
   start_tcm_unsafe(instance: any_struct, params: list of untyped) is empty;

};

// A method in e, once declared for some struct, is never replaced by a different method in a subtype or a later extension.
// Rather, all later modifications of the definition, in all three modes—also, first and only,
//  in extensions as well as in when subtypes and like heirs, are definition elements of the same method, they are method layers.
struct rf_method_layer like rf_struct_member_layer {

   // Returns the struct layer in which this method layer appears.
   get_context_layer(): rf_struct_layer is empty;

   // Returns the struct in the scope of which this method layer appears (including the exact when subtype).
   get_defining_struct(): rf_struct is empty;

   // Returns the method layer extension mode (is also, is empty ...)
   get_extension_mode(): rf_extension_mode is empty;

   //Returns TRUE if this method layer is a C routine.
   is_c_routine () : bool is empty;

};

struct rf_method_port like rf_port {

};

// Modules are simply e files.
// However, with the ability to extend structs and in this way to separate different concerns or crosscuts of a system,
//  they play an important role in organizing the program.
// If struct may be considered the vertical encapsulation principle then modules are the horizontal.
// A struct consists of a number of related layers of definition in different modules,
//  and symmetrically the module consists of a number of related layers of different structs—it can be though of as a layer of the entire system.
// Modules are represented in reflection API and can be queried for their overall contribution to the structure of a system.
struct rf_module like rf_structural_element {

   // Returns the module that was actually responsible for loading this module.
   // The actual importer is typically the first module in a load cluster that directly imports this module.
   // In cases of cyclic import the actual importer is the first module that imported the whole cycle,
   //  not necessarily each of the individual files.
   get_actual_importer(): rf_module is empty;

   // Returns the list of modules that are directly or indirectly imported by this module.
   // This includes all the modules referred to in 'import' statements in this module,
   //  as well as modules imported by other modules which are imported by this module.
   get_all_imports () : list of rf_module is empty;

   //Returns the list of modules that are directly imported by this module.
   //This includes all the modules referred to in 'import' statements in this module.
   get_direct_imports () : list of rf_module is empty;

   // @non_standard
   get_file_name(): string is empty;

   // Returns the full name of the file as registered in the file system—that is, the name of the e file
   //  prefixed by a UNIX-style absolute path and ending with the file extension ".e".
   get_full_file_name(): string is empty;

   // Returns this module's ordinal number in the load order.
   get_index(): int is empty;

   //Returns the number of lines in the source file of this module.
   get_lines_num () : int is empty;

   // Returns the name of this module—basically the name of the e file without the file extension '.e'.
   get_name(): string is empty;

   // Returns the e package with which this module is associated.
   // Note that modules that are not explicitly associated with some package (with package statement) are implicitly part of package main.
   get_package(): rf_package is empty;

   // Returns a list of all the type layers defined in this module.
   // A module's overall contribution to the structure of a system is the set of declarations of new types and extensions of existing types.
   get_type_layers(): list of rf_type_layer is empty;

   // Returns TRUE if this module was compiled rather than just loaded.
   is_compiled(): bool is empty;

   // Returns TRUE if the module is encrypted.
   is_encrypted(): bool is empty;

   is_enc_invisible () : bool is empty;

   // Returns TRUE if this module was initially loaded or compiled directly, as opposed to being imported by another module.
   is_top_module(): bool is empty;

   // Returns TRUE if the module is added by the user.
   is_user_module(): bool is empty;

   // @non_standard
   sn_get_module(): module is empty;

};

// Named entities are types and struct members.
// Both kinds are entities that, once declared, become part of the lexicon of the language.
// All named entities have a name (string), and all are either visible or hidden.
struct rf_named_entity like rf_structural_element {

   //Returns the module in which this named entity is declared first.
   //If this entity does not have a declaration (for example, it is an implicitly created type), NULL is returned.
   get_declaration_module () : rf_module is empty;

   //Returns the line number in a module in which this named entity is declared first.
   //If this entity does not have a declaration (for example, it is an implicitly created type), the result is undefined.
   get_declaration_source_line_num () : int is empty;

   // Returns the name of this entity.
   get_name() : string is empty;

   // Returns TRUE if this entity is public.
   is_public(): bool is empty;

   // Returns TRUE if this entity is visible.
   // Invisible named entities are Specman internal entities, including fields and methods of user defined structs, that are not shown in printing and visualization tools.
   is_visible() : bool is empty;

   // Returns the declaration (first definition element) of this entity.
   // Note that every explicitly defined named entity has exactly one declaration.
   // Types that are defined implicitly as variants of existing types do not have a declaration.
   // In these cases NULL is returned.
   get_declaration(): rf_definition_element is empty;

   //@non_standard
   accessed(e_module:rf_module, line_num:int, extended:bool) is empty;

};

// Numeric scalar.
struct rf_numeric like rf_scalar {

   get_full_set_of_values(): set is empty;

   get_set_of_values(): set is empty;
   
   is_external_pointer() : bool is {};
   
   is_long() : bool is {};
   
   is_longint(): bool is empty;

   is_mltypemap_typedef() : bool is {};

   is_signed(): bool is empty;
   
   is_perspec_pointer(): bool is empty;

};

// A package is a set of one or more e modules that together implement some closely related functionality.
// It defines a scope to which the access of named entities can be restricted.
struct rf_package like rf_structural_element {

   // Returns the set of modules that are associated with this package.
   get_modules(): list of rf_module is empty;

   // Returns the name of this package.
   get_name(): string is empty;

};

// Method parameter.
struct rf_parameter like rf_structural_element {

   // Returns a string representing the expression used as the default value for this parameter.
   // If this parameter does not have a default value, returns an empty string.
   get_default_value_string () : string is empty;

   // Returns the name given to this parameter in the declaration method.
   get_name() : string is empty;

   // Returns the type of this parameter.
   get_type(): rf_type is empty;

   // Returns TRUE if this parameter is passed by reference (that is, declared with '*').
   is_by_reference(): bool is empty;

};

// Ports in e are special purpose objects that serve to bind different units in the verification environment,
//  and specifically to interconnect with the design under test.
// Each port is an instance of one of the four port types.
// There are three kinds of parameterized port types: simple_port, buffer_port, and method_port.
// There is a single kind of non-parameterized event port: event_port.
struct rf_port like rf_type {

   // Returns the element type of this port type. For event ports, which do not have element type, returns NULL.
   get_element_type(): rf_type is empty;

   // Returns TRUE if this port type is declared as input, either with the "in" or the "inout" specifier.
   is_input(): bool is empty;

   // Returns TRUE if this port type is declared as output, either with the "out" or the "inout" specifier
   is_output(): bool is empty;

};

// Real numbers in e are represented as floating point values.
// They are all instances of the predefined type real, and users cannot define others.
// Therefore, the meta-type rf_real is a singleton.
// It does not have features other than those declared for rf_scalar. Its packed size in bits is 64.
struct rf_real like rf_scalar {

};

struct rf_routine like rf_named_entity {

   //Returns a list of formal parameters of this routine. If the routine has no parameters the list is empty.
   get_parameters () : list of rf_parameter is empty;

   //Returns the routine's result type, or NULL if the routine does not return a value.
   get_result_type () : rf_type is empty;

};

// Scalars in e have value semantics in assignment, parameter passing, equivalence operator, and so on.
// They are either enumerated, numeric, real or boolean types.
struct rf_scalar like rf_type {

   // Returns a string representation of the scalar range of values in the format of range modifiers (for example, the string "[1..4,7,9..10]").
   // Note that range modification of types does not affect type checking. It is rather a generation constraint on all instances of the type.
   get_range_string(): string is empty;

   // Returns the size of this scalar type in bits.
   get_size_in_bits(): int is empty;
   
   // Returns a set that contains all the legal numeric values in this scalar type, similarly to using the set_of_values() operator.
   // If this type is an unbounded integer type without a range restriction, the 'real' type, or a custom numeric type, an exception is thrown.
   get_set_of_values () : set is empty;
   
   // Returns a set that contains all the possible numeric values in this scalar type, similarly to using the full_set_of_values() operator.
   // If this type is an unbounded integer type, the 'real' type, or a custom numeric type, an exception is thrown.
   get_full_set_of_values () : set is empty;

   // Returns the scalar type based on this type with the given size in bits.
   // If this type is real, longint, longuint, or a custom numeric type, or if bit_size is 0 or greater than MAX_INT, returns NULL.
   // If this type is not numeric (boolean or enumerated) and bit_size is greater than 32, returns NULL.
   // If this type is signed numeric and bit_size is MAX_INT, returns the unbounded integer type such as int(bits: *).
   // If this type is unsigned numeric and bit_size is MAX_INT, returns NULL.
   get_bit_size_modified (bit_size : uint) : rf_scalar is empty;
};

// The 'set' type. There is only one set type, and thus the meta-type 'rf_set' is a singleton.
// It does not have any special features other than those of 'rf_type'.
struct rf_set like rf_type {
	//@non_standard
	size(): int is empty;
};

struct rf_sequence like rf_like_struct {

   //Returns the sequence driver struct for this sequence type.
   get_driver_struct () : rf_struct is empty;

   //Returns the kind enumerated type for this sequence type.
   get_kind () : rf_enum is empty;

};

// Simple port.
struct rf_simple_port like rf_port {

};

//@non_standard
struct rf_source_item like rf_structural_element {

};

// Strings in e are instances of a special built in type, which is neither scalar, nor compound (struct or list).
// Unlike the other three kinds, there is only one string type, and thus the meta-type rf_string is a singleton.
// It does not have any special features other than those declared for rf_type.
struct rf_string like rf_type {

};

// Structs in e are equivalent to classes in other OO languages.
// Struct types have three kinds of members—fields, method and events, which are represented in Reflection API as named entities.
// There are other kinds of struct members in e, like constraints, cover-groups, expects and more, which are currently not reflected in the interface (it is a possible future enhancement of the API).
struct rf_struct like rf_type {

   get_check(name : string): rf_check is empty;

   get_checks(): list of rf_check is empty;

   get_constraint(name : string): rf_constraint is empty;

   get_constraints(): list of rf_constraint is empty;

   get_declared_checks(): list of rf_check is empty;

   // Returns the list of constraints declared by this struct.
   // This includes both named and unnamed constraints.
   get_declared_constraints(): list of rf_constraint is empty;

   // Returns a list of all events declared in the context of this struct (a subset of rf_struct.get_events()).
   // Note that events that are declared by a supertype and overridden in the context of this struct are not returned.
   get_declared_events(): list of rf_event is empty;

   // Returns the list of expects and assumes declared by this struct.
   // This includes both named and unnamed expects and assumes.
   get_declared_expects(): list of rf_expect is empty;

   // Returns a list containing all fields declared in the context of this struct (a subset of rf_struct.get_fields()).
   get_declared_fields(): list of rf_field is empty;

   // Returns a list containing all methods declared in the context of this struct (a subset of rf_struct.get_methods()).
   get_declared_methods(): list of rf_method is empty;

   // Returns the event of this struct with the name given as parameter, or NULL if no such event exists. Note that event names are unique in the context of a struct.
   get_event(name: string): rf_event is empty;

   // Returns a list of all events of this struct (declared by it or inherited form its supertype).
   get_events(): list of rf_event is empty;

   // Returns the named 'expect' or 'assume' of this struct with the given name, or NULL if no such expect or assume exists.
   // Unnamed expects/assumes are not considered, and if an empty string is given as parameter, NULL is returned.
   get_expect(name : string): rf_expect is empty;

   // Returns the list of all 'expects' and 'assumes' of this struct, declared by it or inherited from its supertype.
   // This includes both named and unnamed expects and assumes.
   get_expects(): list of rf_expect is empty;

   // Returns the field of this struct with the name given as parameter, or NULL if no such field exists.
   // Note that field names are unique in the context of a struct.
   get_field(name: string): rf_field is empty;

   // Returns a list containing all fields of this struct (declared by it or inherited from its supertype).
   get_fields(): list of rf_field is empty;

   // Returns the method of this struct with the name given as parameter, or NULL if no such method exists.
   // Note that method names are unique in the context of a struct.
   get_method(name: string): rf_method is empty;

   // Returns a list containing all methods of this struct (declared by it or inherited from its supertypes).
   get_methods(): list of rf_method is empty;

   // Returns the struct which is the base of the 'when' struct family.
   // This struct itself is returned if it is not a 'rf_when_subtype' (regardless of whether it actually has when subtypes).
   get_when_base () : rf_like_struct is empty;

   // Returns TRUE if every instance of this struct is necessarily an instance of the struct given as parameter.
   // For 'like' structs, it means that this struct is a subtype of the other struct.
   // For 'when' subtypes, it means that this subtype is more specific than the other.
   is_contained_in (other : rf_struct) : bool is empty;

   // Returns TRUE if this struct and the struct given as parameter are mutually exclusive, that is, no object can be an instance of both.
   is_disjoint (other : rf_struct) : bool is empty;

   // Returns TRUE if an instance of this struct is possibly but not necessarily an instance of the struct given as parameter.
   // This relation holds only between two 'when' subtypes of the same struct that are neither contained nor mutually exclusive.
   is_independent (other : rf_struct) : bool is empty;

   // @non_standard
   is_instance (instance : base_struct) : bool is empty;

   // Returns TRUE if the instance given as parameter is an instance of this struct.
   is_instance_of_me (instance : base_struct) : bool is empty;

   // Returns TRUE if this struct is a unit.
   // This is the only indication that this meta-object represents a unit rather than a regular struct type.
   is_unit(): bool is empty;

   //@non_standard
   make_new_instance(): base_struct is empty;

};

// Struct type layer.
struct rf_struct_layer like rf_type_layer {

   // Returns the field declarations that are added to the struct by this struct layer.
   get_field_declarations(): list of rf_definition_element is empty;

   // Returns the method layers that are added to the struct by this struct layer.
   get_method_layers(): list of rf_method_layer is empty;

};

// Struct members are represented by instances of the meta-types rf_field, rf method and rf_event.
// Each member is introduced for the first time in the context of some struct—its declaring struct.
// Its access rights (one of package, protected, private or the default—public) are assigned to it upon its declaration/
struct rf_struct_member like rf_named_entity {

   // Returns TRUE if this struct member applies to instances of the struct given as parameter,
   //  that is, if it was declared by that struct or by a different struct that contains it.
   applies_to(rf_struct): bool is empty;

   // Returns the struct in which this member was introduced.
   // This applies also to empty definition of methods or declarations of undefined methods.
   get_declaring_struct(): rf_struct is empty;

   // Returns TRUE if this struct member was declared with package access modifier,
   //  which means it is accessible only within the context of the package in which it was declared.
   is_package_private(): bool is empty;

   // Returns TRUE if this struct member was declared with private access modifier,
   //  which means it is accessible only within the context of both its package and its declaring struct or its subtypes.
   is_private(): bool is empty;

   // Returns TRUE if this struct member was declared with protected access modifier,
   //  which means it is accessible only within the context of the declaring struct or its subtypes.
   is_protected(): bool is empty;

   // Returns TRUE if this struct member was declared without an access modifier, that is, its access is not restricted.
   is_public(): bool is empty;

};

struct rf_struct_member_layer like rf_definition_element {

   //Returs the struct layer in which this layer appears.
   get_context_layer () : rf_struct_layer is empty;

   //Returns the struct in the scope of which this layer appears (including the exact 'when' subtype).
   get_defining_struct () : rf_struct is empty;

};

// @non_standard
struct rf_structural_element like base_struct {

};

struct rf_template like rf_named_entity {

   //Returns all the existing instances of this template. This includes all instances referred to at least once in the currently loaded or compiled code.
   get_all_instances () : list of rf_template_instance is empty;

   get_layers(): list of rf_template_layer is empty;

   //Returns the package to which this template belongs.
   get_package () : rf_package is empty;

   //Returns the fully qualified name of the template. The qualified name is the declaring package name followed by the :: operator and the actual name of the template.
   get_qualified_name () : string is empty;

   //Returns the struct which is the supertype of this template, that is, the supertype of its isntances.
   //If the supertype specified in the template declaration is parameterized by the template parameters,
   //which means that each template isntance has a different supertype, then NULL is returned.
   get_supertype () : rf_like_struct is empty;

   //Returns TRUE if this template is not declared with 'package' modifier, that is, it has unrestricted access.
   is_public () : bool is empty;

   //Returns TRUE if this template is a unit template, that is, its instances are units.
   //Such template is declared with a 'template unit ...' statement.
   is_unit () : bool is empty;

   //Returns the number of parameters of this template.
   num_of_params () : int is empty;

};

struct rf_template_instance like rf_like_struct {

   //Returns the template of which this type is an instance.
   get_template () : rf_template is empty;

   //Returns the list of types on which the template was parameterized to create this template instance.
   //If the default value was used for some of the template parameters, their representation of the corresponding type is used in the returned list.
   get_template_parameters () : list of rf_type is empty;
   
   //Returns the list of actual parameters used to create this template struct instance.
   //If the default type or value was used for some of the template parameters, their representation is used in the returned list.
   //For example, if a template is declared with:
   //|template struct my_template of (<first'type>, <second'type>=int) { ... }
   //then get_template_parameters() for 'my_template of string' returns a list with two elements representing
   //the types 'string' and 'int'.
   get_parameters() : list of rf_template_instance_parameter is {};
   

};

struct rf_template_instance_layer like rf_struct_layer {

   get_template_layer(): rf_template_layer is empty;

};

struct rf_template_layer like rf_definition_element {

   get_instance_layers(): list of rf_template_instance_layer is empty;

};

struct rf_template_parameter like rf_structural_element {
	
};

struct rf_template_instance_parameter like rf_structural_element {
    
	get_template_parameter() : rf_template_parameter is {};
	
};

struct rf_type_template_instance_parameter like rf_template_instance_parameter {
    
	get_type() : rf_type is {};
	
};

struct rf_value_template_instance_parameter like rf_template_instance_parameter {

	get_value() : untyped is {};
	
};

// A TLM socket type.
struct rf_tlm_socket like rf_port {

};

// Each value that is manipulated during the run of a program is an instance of some type.
// A type is either built in or user defined, explicitly defined or implicitly inferred.
// Types in e are divided into three categories—scalar-types, list-types, and struct-types.
extend rf_type {

   // Returns a value holder of this type for the value given as parameter. The value must be an instance of this type (or of a subtype in case it is a struct type). Very simple sanity checks are being performed on the value, and if they fail an exception is thrown. These checks are by no means exhaustive, and it is the user’s responsibility to create the right holder for a value.
   create_holder(value: untyped): rf_value_holder is empty;

   get_base_list_elem_type (): rf_type is empty;

   //Returns the package to which this type belongs.
   get_package () : rf_package is empty;

   // Returns the fully qualified name of the type (that is, with the declaring package name followed by the :: operator).
   get_qualified_name() : string is empty;

   //Returns TRUE if this type is a method_type, that is, declared with a 'method_type' statement.
   is_method_type () : bool is empty;

   // Returns TRUE if this type is not declared with package modifier, that is, it has unrestricted access.
   is_public() : bool is empty;

   // Returns TRUE if the two instances given as operands are equivalent or identical (same semantics as that of the operator '==s'). The behavior is not defined if one of the two values is not of this type.
   value_is_equal(val1: untyped, val2: untyped): bool is empty;

   // Returns a string representation of the value (same as to_string() operator). The behavior is not defined if the value is not of this type.
   value_to_string(value: untyped): string is empty;

};

// Structs and enums are extensible entities—they are defined in layers.
// Struct and enum layers are both type layers.
// This abstraction does not have features of its own but is used by other services (see rf_module.get_type_layers()).
struct rf_type_layer like rf_definition_element {

};

// When dealing with values in a generic way (meta-programming),
//  there must be some safe way to refer to values of all types—struct-instances, lists, strings, and scalars.
// Since these values are very different in their semantics and there is no abstract type common to all,
//  reflection API wraps values of all types with an object called rf_value_holder.
// This object holds a value together with its type, and guarantees its consistency and continuity when the original variable goes out of scope,
//   and across garbage collections.
// Value holders are returned from value queries or explicitly created by the user.
// They are used in setting values or calling methods.
// Actual uses of the value itself, however, must involve passing through an untyped value and brute casting, which is not type-safe.
// Two operators are implemented generically for all values—equating and getting a string representation.
struct rf_value_holder like base_struct {

   // Returns the type of this value.
   // Note that in case the value is a struct instance, the type of the holder is not necessarily the most specific subtype of that instance (for example, a legal value holder whose type is any_struct can hold an instance of packet).
   get_type(): rf_type is empty;

   // Enables (with the use of ‘unsafe()’ operator) assignment of the value into a typed variable.
   // The variable should be of a type to which this value is assignable according to e cast rules.
   // However, this cannot be enforced, and is the responsibility of the user. Note that the value should never be held by an untyped variable (this is what value holders are for).
   get_value(): untyped is empty;
   
   // @non_standard
   get_value_unsafe(): untyped is empty;
};

struct rf_virtual_sequence like rf_sequence {

};

// When struct type.
struct rf_when_subtype like rf_struct {

   // Returns the set of subtypes that contribute to the definition of this subtype,
   // that is all the explicit subtypes in which this subtype is contained, and possibly itself in case it is explicitly defined itself.
   get_contributors(): list of rf_when_subtype is empty;

   //Returns a list of the determinant fields for this 'when' subtype, that is, the fields whose values constitute this specific subtype.
   get_determinant_fields () : list of rf_field is empty;

   //Returns a list of the determinant values for this 'when' subtype, that is, the values of the determinant fields that constitute this specific subtype.
   //The order of the values in the resulting list is according to the order of the determinant fields in the list returned by 'get_determinant_fields()'. These value are automatically converted to the type 'int', as follows.
   //For determinant fields of an enumerated type, the numeric value of the corresponding enum item.
   //For determinant fields of a boolean type, the numeric value is 0 for FALSE and 1 for TRUE.
   get_determinant_values () : list of int is empty;

   // Returns a short version of the canonical name, that is, without determinant qualification unless ambiguity requires.
   // For example, a type whose canonical name is "corrupt’TRUE big’size packet" would (normally) have the short name "corrupt big packet".
   // Qualified determinants appear in the short name in case the same value name is a possible value of more than one field.
   get_short_name(): string is empty;

   // Returns TRUE if this 'when' subtype is explicitly defined in the program (by a ‘when’ or an ‘extend’ construct).
   // FALSE is returned both for significant and insignificant subtypes.
   is_explicit(): bool is empty;

};

struct rf_define {

	// @non_standard
	get_name(): string is empty;

	// @non_standard
	get_value(): string is empty;

};

'>

ANNOTATIONS API

<'

// An annotation type.
struct rf_annotation like rf_like_struct {
	// Returns the list of all annotations of this type attached to the definition element given as parameter.
	// In case of a non-repeatable annotation type, the resulting list has no more than one element.
	get_attached_annotations_list (element : rf_definition_element) : list of annotation is empty;
};

// A non-repeatable annotation type.
struct rf_non_repeatable_annotation like rf_annotation {
	// Returns the annotation of this type attached to the definition element given as parameter,
	// or NULL if no such annotation is attached.
	get_attached_annotation (element : rf_definition_element) : annotation is empty;
}; 

// A repeatable annotation type.
struct rf_repeatable_annotation like rf_annotation {
};


'>
