<'

package tlm;

// The TLM functions return this struct. The user code for an input port calls tlm_event.notify() when it is ready to accept a next transaction
struct tlm_event like any_interface {
    // Trigger event emitted by call of tlm_event.notify() method
    event trigger;
    // The user code for an input port calls tlm_event.notify() when it is ready to accept a next transaction
    notify() is undefined;
};

// TLM analysis interface
template unit tlm_analysis of <type> like any_interface {
    // TLM analysis tlm_analysis.write() method
    write(value: <type>) is undefined;
};

// Blocking unidirectional get interface
template unit tlm_blocking_get of <type> like any_interface {
    // TLM blocking unidirectional tlm_blocking_get.get(value: <i>*type<i>) TCM
    get(value: <type>)@sys.any is undefined;
};

// Blocking unidirectional get, peek interface
template unit tlm_blocking_get_peek of <type> like any_interface {
    // TLM blocking unidirectional tlm_blocking_get_peek.peek(value: <i>*type<i>) TCM
    peek(value: <type>)@sys.any is undefined;
    // TLM blocking unidirectional tlm_blocking_get_peek.get(value: <i>*type<i>) TCM
    get(value: <type>)@sys.any is undefined;
};

// Blocking unidirectional peek interface
template unit tlm_blocking_peek of <type> like any_interface {
    // TLM blocking unidirectional tlm_blocking_peek.peek(value: <i>*type<i>) TCM
    peek(value: <type>)@sys.any is undefined;
};

// Blocking unidirectional put interface
template unit tlm_blocking_put of <type> like any_interface {
    // TLM blocking unidirectional tlm_blocking_put.put(value: <i>*type<i>) TCM
    put(value: <type>)@sys.any is undefined;
};

// Blocking bidirectional master interface
template unit tlm_blocking_master of (<req'type>, <rsp'type>) like any_interface {
    // TLM blocking unidirectional tlm_blocking_master.put(value: <i>*req'type<i>) TCM
    put(value: <req'type>)@sys.any is undefined;
    // TLM blocking unidirectional tlm_blocking_master.peek(value: <i>*rsp'type<i>) TCM
    peek(value: <rsp'type>)@sys.any is undefined;
    // TLM blocking unidirectional tlm_blocking_master.get(value: <i>*rsp'type<i>) TCM
    get(value: <rsp'type>)@sys.any is undefined;
};

// Blocking bidirectional slave interface
template unit tlm_blocking_slave of (<req'type>, <rsp'type>) like any_interface {
    // TLM blocking unidirectional tlm_blocking_slave.put(value: <i>*rsp'type<i>) TCM
    put(value: <rsp'type>)@sys.any is undefined;
    // TLM blocking unidirectional tlm_blocking_slave.peek(value: <i>*req'type<i>) TCM
    peek(value: <req'type>)@sys.any is undefined;
    // TLM blocking unidirectional tlm_blocking_slave.get(value: <i>*req'type<i>) TCM
    get(value: <req'type>)@sys.any is undefined;
};

// Blocking bidirectional transport interface
template unit tlm_blocking_transport of (<req'type>, <rsp'type>) like any_interface {
    // TLM blocking bidirectional tlm_blocking_transport.transport(req: <i>req'type<i>, rsp: <i>*rsp'type<i>) TCM
    transport(req: <req'type>, rsp: <rsp'type>)@sys.any is undefined;
};

// Blocking/Non-Blocking unidirectional get interface
template unit tlm_get of <type> like any_interface {
    // TLM blocking/non-blocking unidirectional tlm_get.get(value: <i>*type<i>) TCM
    get(value: <type>)@sys.any is undefined;
    // TLM blocking/non-blocking unidirectional tlm_get.try_get(value: <i>*type<i>) TCM
    try_get(value: <type>)@sys.any is undefined;
    // TLM blocking/non-blocking unidirectional tlm_get.can_get() method
    can_get(): bool is undefined;
    // TLM blocking/non-blocking unidirectional tlm_get.ok_to_get() method
    ok_to_get(): tlm_event is undefined;
};

// Blocking/Non-Blocking unidirectional get, peek interface
template unit tlm_get_peek of <type> like any_interface {
    // TLM blocking/non-blocking unidirectional tlm_get_peek.get(value: <i>*type<i>) TCM
     get(value: <type>)@sys.any is undefined;
    // TLM blocking/non-blocking unidirectional tlm_get_peek.try_get(value: <i>*type<i>) TCM
     try_get(value: <type>)@sys.any is undefined;
    // TLM blocking/non-blocking unidirectional tlm_get_peek.can_get() method
     can_get(): bool is undefined;
    // TLM blocking/non-blocking unidirectional tlm_get_peek.ok_to_get() method
     ok_to_get(): tlm_event is undefined;
    // TLM blocking/non-blocking unidirectional tlm_get_peek.peek(value: <i>*type<i>) TCM
     peek(value: <type>)@sys.any is undefined;
    // TLM blocking/non-blocking unidirectional tlm_get_peek.try_peek(value: <i>*type<i>) TCM
     try_peek(value: <type>)@sys.any is undefined;
    // TLM blocking/non-blocking unidirectional tlm_get_peek.can_peek() method
     can_peek(): bool is undefined;
    // TLM blocking/non-blocking unidirectional tlm_get_peek.ok_to_peek() method
     ok_to_peek(): tlm_event is undefined;
};

// Blocking/Non-Blocking bidirectional master interface
template unit tlm_master of (<req'type>, <rsp'type>) like any_interface {
    // TLM blocking bidirectional tlm_master.put(value: <i>req'type<i>) TCM
    put(value: <req'type>)@sys.any is undefined;
    // TLM blocking bidirectional tlm_master.get(value: <i>*rsp'type<i>) TCM
    get(value: <rsp'type>)@sys.any is undefined;
    // TLM blocking bidirectional tlm_master.peek(value: <i>*rsp'type<i>) TCM
    peek(value: <rsp'type>)@sys.any is undefined;
    // TLM non-blocking bidirectional tlm_master.try_put(value: <i>req'type<i>) TCM
    try_put(value: <req'type>)@sys.any is undefined;
    // TLM non-blocking bidirectional tlm_master.can_put() method
    can_put(): bool is undefined;
    // TLM non-blocking bidirectional tlm_master.ok_to_put() method
    ok_to_put(): tlm_event is undefined;
    // TLM non-blocking bidirectional tlm_master.try_get(value: <i>*rsp'type<i>) TCM
    try_get(value: <rsp'type>)@sys.any is undefined;
    // TLM non-blocking bidirectional tlm_master.can_get() method
    can_get(): bool is undefined;
    // TLM non-blocking bidirectional tlm_master.ok_to_get() method
    ok_to_get(): tlm_event is undefined;
    // TLM non-blocking bidirectional tlm_master.try_peek(value: <i>*rsp'type<i>) TCM
    try_peek(value: <rsp'type>)@sys.any is undefined;
    // TLM non-blocking bidirectional tlm_master.can_peek() method
    can_peek(): bool is undefined;
    // TLM non-blocking bidirectional tlm_master.ok_to_peek() method
    ok_to_peek(): tlm_event is undefined;
};

// Blocking/Non-Blocking unidirectional peek interface
template unit tlm_peek of <type> like any_interface {
    // TLM blocking/non-blocking unidirectional tlm_peek.peek(value: <i>*type<i>) TCM
    peek(value: <type>)@sys.any is undefined;
    // TLM blocking/non-blocking unidirectional tlm_peek.try_peek(value: <i>*type<i>) TCM
    try_peek(value: <type>)@sys.any is undefined;
    // TLM blocking/non-blocking unidirectional tlm_peek.can_peek() method
    can_peek(): bool is undefined;
    // TLM blocking/non-blocking unidirectional tlm_peek.ok_to_peek() method
    ok_to_peek(): tlm_event is undefined;
};

// Blocking/Non-Blocking unidirectional put interface
template unit tlm_put of <type> like any_interface {
    // TLM blocking/non-blocking unidirectional tlm_put.put(value: <i>type<i>) TCM
    put(value: <type>)@sys.any is undefined;
    // TLM blocking/non-blocking unidirectional tlm_put.try_put(value: <i>type<i>) TCM
    try_put(value: <type>)@sys.any is undefined;
    // TLM blocking/non-blocking unidirectional tlm_put.can_put() method
    can_put(): bool is undefined;
    // TLM blocking/non-blocking unidirectional tlm_put.ok_to_put() method
    ok_to_put(): tlm_event is undefined;
};

// Blocking/Non-Blocking bidirectional slave interface
template unit tlm_slave of (<req'type>, <rsp'type>) like any_interface {
    // TLM blocking bidirectional tlm_slave.put(value: <i>rsp'type<i>) TCM
    put(value: <rsp'type>)@sys.any is undefined;
    // TLM blocking bidirectional tlm_slave.get(value: <i>*req'type<i>) TCM
    get(value: <req'type>)@sys.any is undefined;
    // TLM blocking bidirectional tlm_slave.peek(value: <i>*req'type<i>) TCM
    peek(value: <req'type>)@sys.any is undefined;
    // TLM non-blocking bidirectional tlm_slave.try_put(value: <i>rsp'type<i>) TCM
    try_put(value: <rsp'type>)@sys.any is undefined;
    // TLM non-blocking bidirectional tlm_slave.can_put() method
    can_put(): bool is undefined;
    // TLM non-blocking bidirectional tlm_slave.ok_to_put() method
    ok_to_put(): tlm_event is undefined;
    // TLM non-blocking bidirectional tlm_slave.try_get(value: <i>*req'type<i>) TCM
    try_get(value: <req'type>)@sys.any is undefined;
    // TLM non-blocking bidirectional tlm_slave.can_get() method
    can_get(): bool is undefined;
    // TLM non-blocking bidirectional tlm_slave.ok_to_get() method
    ok_to_get(): tlm_event is undefined;
    // TLM non-blocking bidirectional tlm_slave.try_peek(value: <i>*req'type<i>) TCM
    try_peek(value: <req'type>)@sys.any is undefined;
    // TLM non-blocking bidirectional tlm_slave.can_peek() method
    can_peek(): bool is undefined;
    // TLM non-blocking bidirectional tlm_slave.ok_to_peek() method
    ok_to_peek(): tlm_event is undefined;
};


// Blocking/Non-Blocking bidirectional transport interface
template unit tlm_transport of (<req'type>, <rsp'type>) like any_interface {
    // TLM blocking bidirectional tlm_transport.transport(req: <i>req'type<i>, rsp: <i>*rsp'type<i>) TCM
    transport(req: <req'type>, rsp: *<rsp'type>)@sys.any is undefined;
    // TLM non-blocking bidirectional tlm_transport.nb_transport(req: <i>req'type<i>, rsp: <i>*rsp'type<i>) TCM
    nb_transport(req: <req'type>, rsp: *<rsp'type>)@sys.any is undefined;
};

// Non-Blocking unidirectional get interface
template unit tlm_nonblocking_get of <type> like any_interface {
    //TLM non-blocking unidirectional tlm_nonblocking_get.try_get(value: <i>*type<i>) TCM
    try_get(value: <type>)@sys.any is undefined;
    //TLM non-blocking unidirectional tlm_nonblocking_get.can_get() method
    can_get(): bool is undefined;
    //TLM non-blocking unidirectional tlm_nonblocking_get.ok_to_get() method
    ok_to_get(): tlm_event is undefined;
};

// Non-Blocking unidirectional get, peek interface
template unit tlm_nonblocking_get_peek of <type> like any_interface {
    //TLM non-blocking unidirectional tlm_nonblocking_get_peek.try_peek(value: <i>*type<i>) TCM
    try_peek(value: <type>)@sys.any is undefined;
    //TLM non-blocking unidirectional tlm_nonblocking_get_peek.can_peek() method
    can_peek(): bool is undefined;
    //TLM non-blocking unidirectional tlm_nonblocking_get_peek.ok_to_peek() method
    ok_to_peek(): tlm_event is undefined;
    //TLM non-blocking unidirectional tlm_nonblocking_get_peek.try_get(value: <i>*type<i>) TCM
    try_get(value: <type>)@sys.any is undefined;
    //TLM non-blocking unidirectional tlm_nonblocking_get_peek.can_get() method
    can_get(): bool is undefined;
    //TLM non-blocking unidirectional tlm_nonblocking_get_peek.ok_to_get() method
    ok_to_get(): tlm_event is undefined;
};

// Non-Blocking unidirectional peek interface
template unit tlm_nonblocking_peek of <type> like any_interface {
    //TLM non-blocking unidirectional tlm_nonblocking_peek.try_peek(value: <i>*type<i>) TCM
    try_peek(value: <type>)@sys.any is undefined;
    //TLM non-blocking unidirectional tlm_nonblocking_peek.can_peek() method
    can_peek(): bool is undefined;
    //TLM non-blocking unidirectional tlm_nonblocking_peek.ok_to_peek() method
    ok_to_peek(): tlm_event is undefined;
};

// Non-Blocking unidirectional put interface
template unit tlm_nonblocking_put of <type> like any_interface {
    //TLM non-blocking unidirectional tlm_nonblocking_put.try_put(value: <i>type<i>) TCM
    try_put(value: <type>)@sys.any is undefined;
    //TLM non-blocking unidirectional tlm_nonblocking_put.can_put() method
    can_put(): bool is undefined;
    //TLM non-blocking unidirectional tlm_nonblocking_put.ok_to_put() method
    ok_to_put(): tlm_event is undefined;
};

// Non-Blocking bidirectional master interface
template unit tlm_nonblocking_master of (<req'type>, <rsp'type>) like any_interface {
    //TLM non-blocking bidirectional tlm_nonblocking_master.try_put(value: <i>req'type<i>) TCM
    try_put(value: <req'type>)@sys.any is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_master.can_put() method
    can_put(): bool is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_master.ok_to_put() method
    ok_to_put(): tlm_event is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_master.try_get(value: <i>*rsp'type<i>) TCM
    try_get(value: <rsp'type>)@sys.any is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_master.can_get() method
    can_get(): bool is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_master.ok_to_get() method
    ok_to_get(): tlm_event is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_master.try_peek(value: <i>*rsp'type<i>) TCM
    try_peek(value: <rsp'type>)@sys.any is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_master.can_peek() method
    can_peek(): bool is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_master.ok_to_peek() method
    ok_to_peek(): tlm_event is undefined;
};

// Non-Blocking bidirectional slave interface
template unit tlm_nonblocking_slave of (<req'type>, <rsp'type>) like any_interface {
    //TLM non-blocking bidirectional tlm_nonblocking_slave.try_put(value: <i>rsp'type<i>) TCM
    try_put(value: <rsp'type>)@sys.any is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_slave.can_put() method
    can_put(): bool is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_slave.ok_to_put() method
    ok_to_put(): tlm_event is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_slave.try_get(value: <i>*req'type<i>) TCM
    try_get(value: <req'type>)@sys.any is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_slave.can_get() method
    can_get(): bool is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_slave.ok_to_get() method
    ok_to_get(): tlm_event is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_slave.try_peek(value: <i>*req'type<i>) TCM
    try_peek(value: <req'type>)@sys.any is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_slave.can_peek() method
    can_peek(): bool is undefined;
    //TLM non-blocking bidirectional tlm_nonblocking_slave.ok_to_peek() method
    ok_to_peek(): tlm_event is undefined;
};

// Non-Blocking bidirectional transport interface
template unit tlm_nonblocking_transport of (<req'type>, <rsp'type>) like any_interface {
    //TLM non-blocking bidirectional tlm_nonblocking_transport.nb_transport(req: <i>req'type<i>, rsp: <i>*rsp'type<i>) TCM
    nb_transport(req: <req'type>, rsp: *<rsp'type>)@sys.any is undefined;
};


// The generic payload is the class type offered by the TLM-2.0 standard for transaction objects passed through the core interfaces.
unit tlm_generic_payload like any_sequence_item {
	//Transaction base address (byte addressing).
	%m_address: uint(bits:64);
	
	//Type of transaction. Three values are supported: TLM_WRITE_COMMAND, TLM_READ_COMMAND, TLM_IGNORE_COMMAND
	%m_command: tlm_command;
	
	//When m_command = TLM_WRITE_COMMAND contains a pointer to the data to be written in the target.
	//When m_command = TLM_READ_COMMAND contains a pointer where to copy the data read from the target.
	%m_data: list of byte;
	
	//Total number of bytes of the transaction.
	%m_length: uint;
	
	//Indicates whether an error has occurred during the transaction. Values supported are: TLM_OK_RESP, TLM_INCOMPLETE_RESP, TLM_GENERIC_ERROR_RESP, TLM_ADDRESS_ERROR_RESP, TLM_COMMAND_ERROR_RESP, TLM_BURST_ERROR_RESP, TLM_BYTE_ENABLE_ERROR_RESP
	%m_response_status: tlm_response_status;
	
	//For a read or a write command, the target interprets the byte enable length attribute as the number of elements in the bytes enable array.
	%m_byte_enable_length: uint;
	
	//Used to create burst transfers where the address increment between each beat is greater than the word length of each beat, or to place words in selected byte lanes of a bus.
	%m_byte_enable: list of byte;
	
	//Width of streaming data pulse
	%m_streaming_width: uint;
	
	//This list is empty by default. To add extensions, use set extension().
	%m_extensions: list of tlm_extension;
	
	//Adds the specified extension to the generic payload's extension list. Returns the previous value of this extension type, if one existed; otherwise, returns NULL.
	set_extension(ext: tlm_extension) : tlm_extension is empty;
	
	//FIXME This pseudo-method returns the current value of the specified extension type if such an extension was previously added to the list; otherwise, returns NULL.
	get_extension(extension_type_name) : tlm_extension is empty;
	
	//Returns the list of extensions.
	get_extensions() : list of tlm_extension is empty;
};

struct tlm_extension like any_struct{

};

//------------------------------
//TLM2 specific enumerated types
//------------------------------

// TLM phase state
type tlm_phase_enum : [UNINITIALIZED_PHASE=0, BEGIN_REQ=1, END_REQ, BEGIN_RESP, END_RESP];

// TLM sychronization state
type tlm_sync_enum : [ TLM_ACCEPTED, TLM_UPDATED, TLM_COMPLETED];

type tlm_command : [ TLM_READ_COMMAND, TLM_WRITE_COMMAND, TLM_IGNORE_COMMAND];

type tlm_response_status : [ TLM_OK_RESPONSE = 1, TLM_INCOMPLETE_RESPONSE = 0, TLM_GENERIC_ERROR_RESPONSE = -1, TLM_ADDRESS_ERROR_RESPONSE = -2, TLM_COMMAND_ERROR_RESPONSE = -3, TLM_BURST_ERROR_RESPONSE = -4, TLM_BYTE_ENABLE_ERROR_RESPONSE = -5];

type tlm_endianness : [TLM_UNKNOWN_ENDIAN, TLM_LITTLE_ENDIAN, TLM_BIG_ENDIAN ];


template struct tlm_target_implementor of <type> like tlm_target_implementor_base {
};

template struct tlm_initiator_implementor of <type> like tlm_initiator_implementor_base {
};

struct tlm_implementor_base like any_struct {

    get_tlm_gp_type () :rf_like_struct is undefined;
    check_tlm_gp_type (trans : tlm_generic_payload)  is undefined;
    check_data_length (trans : tlm_generic_payload, in_data_size : int, hook_name : string)  is undefined;
    
    // Sets the bus width for the current socket.
    set_bus_width(nn : uint) is empty;
    
    // Get the bus width for the current socket.
    get_bus_width() : uint is empty;

};

struct tlm_initiator_implementor_base like tlm_implementor_base {

	//Non-blocking backward transport method, where:
	//trans is a transaction of the type declared for the socket payload (which is derived from tlm_generic_payload)
	//phase is the phase for the transaction (of type tlm_phase_enum, which is passed by reference)
	//time is the time for the transaction (of type time, which is passed by reference)
	//This method returns the status of the transaction. The unit instantiating an initiator socket must implement this method.
    nb_transport_bw (trans : tlm_generic_payload, phase : tlm_phase_enum, t : time) :tlm_sync_enum is undefined;

	//Non-blocking forward transport method, where:
	//trans is the transaction type declared for the socket payload (which is derived from tlm_generic_payload);
	//phase is the phase for the transaction (of type tlm_phase_enum, which is passed by reference);
	//time is the time for the transaction (of type time, which is passed by reference);
	//This method returns the status of the transaction.To call this method, the $ notation (port$) must be used.	
    nb_transport_fw (trans : tlm_generic_payload, phase : tlm_phase_enum, t : time) :tlm_sync_enum is undefined;

	//Blocking transport TCM, where:
	//trans is a transaction of the type declared for the socket payload (which is derived from tlm_generic_payload)
	//time is the time for the transaction (of type time, which is passed by reference)
	//This method is a time consuming method. To call this method, the $ notation (port$) must be used.
    b_transport (trans : tlm_generic_payload, t : time)  is undefined;

	//Non-blocking debug interface method, where trans is a transaction of the type declared for the socket payload (which is derived from tlm_generic_payload).
	//To call this method, the $ notation (port$) must be used.
    transport_dbg (trans : tlm_generic_payload) :uint is undefined;
    
};

struct tlm_target_implementor_base like tlm_implementor_base {

	//Non-blocking forward transport method, where:
	//trans is the transaction type declared for the socket payload (which is derived from tlm_generic_payload);
	//phase is the phase for the transaction (of type tlm_phase_enum, which is passed by reference);
	//time is the time for the transaction (of type time, which is passed by reference);
	//This method returns the status of the transaction.To call this method, the $ notation (port$) must be used.	
    nb_transport_fw (trans : tlm_generic_payload, phase : tlm_phase_enum, t : time) :tlm_sync_enum is undefined;

	//Non-blocking debug interface method, where trans is a transaction of the type declared for the socket payload (which is derived from tlm_generic_payload).
	//To call this method, the $ notation (port$) must be used.
    transport_dbg (trans : tlm_generic_payload) :uint is undefined;

	//Non-blocking backward transport method, where:
	//trans is a transaction of the type declared for the socket payload (which is derived from tlm_generic_payload)
	//phase is the phase for the transaction (of type tlm_phase_enum, which is passed by reference)
	//time is the time for the transaction (of type time, which is passed by reference)
	//This method returns the status of the transaction. The unit instantiating an initiator socket must implement this method.
    nb_transport_bw (trans : tlm_generic_payload, phase : tlm_phase_enum, t : time) :tlm_sync_enum is undefined;

	//Blocking transport TCM, where:
	//trans is a transaction of the type declared for the socket payload (which is derived from tlm_generic_payload)
	//time is the time for the transaction (of type time, which is passed by reference)
	//This method is a time consuming method. To call this method, the $ notation (port$) must be used.
    b_transport (trans : tlm_generic_payload, t : time)  is undefined;
};

'>

