<'

package vt;

// --------------------------
// VT - Vizualization Toolkit
// --------------------------

// @non_standard
// VT Styles is a predefined mixture of background and foreground colors. VT Styles can be
// used to print colorized text in the GUI console.
//@deprecated
type vt_style: [
   LIGHT_GRAY,
   LIGHT_RED,
   LIGHT_ORANGE,
   LIGHT_YELLOW,
   LIGHT_GREEN,
   LIGHT_CYAN,
   LIGHT_BLUE,
   LIGHT_MAGENTA,
   LIGHT_PURPLE,
   GRAY,
   RED,
   ORANGE,
   YELLOW,
   GREEN,
   CYAN,
   BLUE,
   MAGENTA,
   PURPLE,
   DARK_GRAY,
   DARK_RED,
   DARK_ORANGE,
   DARK_YELLOW,
   DARK_GREEN,
   DARK_CYAN,
   DARK_BLUE,
   DARK_MAGENTA,
   DARK_PURPLE,
   BLACK,
   WHITE,
   VERY_LIGHT_GRAY
];

// @non_standard
// VT Color enumerated type
type vt_color : [
   BLACK                ,
   DARK_BLUE            ,
   BLUE                 ,
   DARK_GREEN           ,
   DARK_CYAN            ,
   GREEN                ,
   CYAN                 ,
   DARK_GRAY            ,
   DARK_RED             ,
   DARK_MAGENTA         ,
   DARK_PURPLE          ,
   DARK_YELLOW          ,
   GRAY                 ,
   PURPLE               ,
   LIGHT_GRAY           ,
   LIGHT_BLUE           ,
   LIGHT_GREEN          ,
   LIGHT_CYAN           ,
   LIGHT_PURPLE         ,
   VERY_LIGHT_BLUE      ,
   VERY_LIGHT_GREEN     ,
   VERY_LIGHT_CYAN      ,
   VERY_LIGHT_GRAY      ,
   VERY_LIGHT_PURPLE    ,
   RED                  ,
   MAGENTA              ,
   DARK_ORANGE          ,
   ORANGE               ,
   LIGHT_RED            ,
   LIGHT_MAGENTA        ,
   LIGHT_ORANGE         ,
   VERY_LIGHT_RED       ,
   VERY_LIGHT_MAGENTA   ,
   VERY_LIGHT_ORANGE    ,
   YELLOW               ,
   LIGHT_YELLOW         ,
   TABLE_MESSAGE_BG     ,
   TABLE_BG             ,
   VERY_LIGHT_YELLOW    ,
   WHITE                ,
   DEFAULT_COLOR        ,
   UNDEFINED_COLOR
];

// @non_standard
// VT page type.
type vt_page_kind : [ANY_PAGE];

// @non_standard
// VT window type.
type vt_window_kind : [ANY_WINDOW];

// @non_standard
// [VT struct] VT basic struct.
struct vt_struct {
};

// @non_standard
struct sn_vt like vt_struct {

   // Convert an HTML template to an HTML file.
   template_to_html(template_file : string): string is {};

   // @non_standard
   element_factory: vt_element_factory;

   // @non_standard
   filter_style(text: string): string is empty;

   // @non_standard
   get_html_prefix(title: string, bg: vt_color): list of string is empty;

   // -------------------------------------
   // VT Manager API for Opening VT Windows
   // -------------------------------------


   // @non_standard
   // [VT Manager routine] Create a default VT page and display it.
   show_page(file_name: string, window_kind: vt_window_kind) is empty;

   // @non_standard
   // [VT Manager routine] Create a default VT page and display it.
   show_page_with_title(file_name: string, window_kind: vt_window_kind, title: string) is empty;

   // @non_standard
   // [VT Manager routine] Create a default VT page and return a pointer to it.
   open_page(file_name: string, window_kind: vt_window_kind): vt_page is empty;

   // @non_standard
   // [VT Manager routine] Create a default VT page and return a pointer to it.
   open_page_with_title(file_name: string, window_kind: vt_window_kind, title: string): vt_page is empty;

   // @non_standard
   // [VT Manager routine] Open a VT window for a search result.
   show_search(file_wildcard: string, search_string: string) is empty;


   // --------------------------------------
   // VT Manager API for Creating HTML Files
   // --------------------------------------


   //    // @non_standard
   //    // [VT Manager Method] Convert an HTML template to an HTML file.
   //    template_to_html(template_file): string is empty;
   //    // FIXME: template_to_html takes as argument the name of a template.
   //
   //    // @non_standard
   //    // [VT Manager Method] Convert an HTML template to HTML code.
   //    template_to_list(template_file): list of string is empty;
   //    // FIXME: template_to_list takes as argument the name of a template.

   // @non_standard
   // [VT Manager Method] Convert HTML code to an HTML file.
   list_to_html(lines: list of string): string is empty;


   // ------------------------------------
   // VT Manager API - HTML Helper Methods
   // ------------------------------------


   // @non_standard
   // [VT field] Inserts a new line in HTML.
   HTML_NEWLINE: string;

   // @non_standard
   // [VT field] Inserts a space in HTML.
   HTML_SPACE: string;

   // @non_standard
   // [VT field] Inserts a horizontal space in HTML.
   HTML_HORIZONTAL_LINE: string;


   // ----------------------------------
   // VT Manager API - Hyperlink Methods
   // ----------------------------------


   // @non_standard
   // [VT Hyperlink Method] Make a hyperlink that executes a Specman command.
   lnk_command(command: string, text: string): string is empty;

   // @non_standard
   // [VT Hyperlink Method] Make a hyperlink that performs a text search.
   lnk_search(file_wildcard: string, search_string: string, text: string): string is empty;

   // @non_standard
   // [VT Hyperlink Method] Make a hyperlink that shows a URL in an external browser.
   lnk_url_in_browser(url: string, text: string): string is empty;

   // @non_standard
   // [VT Hyperlink Method] Make a hyperlink that opens the Data Browser for a struct or unit instance.
   lnk_instance(instance: any_struct, title: string): string is empty;

   // @non_standard
   // [VT Hyperlink Method] Create HTML code for a link to a VT page.
   lnk_page(file_name: string, kind: vt_window_kind, text: string): string is empty;

   // @non_standard
   // [VT Hyperlink Method] Create HTML code for a link to a VT page.
   lnk_page_with_title(file_name: string, kind: vt_window_kind, title: string, text: string): string is empty;

   // @non_standard
   // [VT Hyperlink Method] Create an anchor that can be referenced by other links.
   html_anchor(name: string, text: string): string is empty;

   // @non_standard
   // [VT Hyperlink Method] Make a hyperlink that jumps to an anchor when clicked.
   lnk_anchor(anchor_name: string, text: string, tooltip: string): string is empty;


   // ------------------------------------
   // VT Manager API - HTML Widget Methods
   // ------------------------------------


   // @non_standard
   // [VT - HTML Widget Method] Make a button.
   btn_command(command: string, label: string): string is empty;

   // @non_standard
   // [VT - HTML Widget Method] Make a button to perform a text search.
   btn_search(files: string, search_string: string, text: string): string is empty;

   // @non_standard
   // [VT - HTML Widget Method] Make a button to show a URL in a browser.
   btn_url_in_browser(url: string, text: string): string is empty;

   // @non_standard
   // [VT - HTML Widget Method] Make a button to open an instance in the Data Browser.
   btn_instance(instance: any_struct, title: string): string is empty;

   // @non_standard
   // [VT - HTML Widget Method] Make a button that opens a VT page.
   btn_page(file_name: string, kind: vt_window_kind, text: string): string is empty;

   // @non_standard
   // [VT - HTML Widget Method] Create HTML code for a button to a VT page.
   btn_page_with_title(file_name: string, kind: vt_window_kind, title: string, text: string): string is empty;

   // @non_standard
   // [VT - HTML Widget Method] Create a single-line text box.
   inp_textfield(name: string, initial_value: string, len: int): string is empty;

   // @non_standard
   // [VT - HTML Widget Method] Create a multi-line text box.
   inp_textarea(name: string, initial_value: string, len: int, lines: int): string is empty;

   // @non_standard
   // [VT - HTML Widget Method] Create a combo box.
   inp_combobox(name: string, choices: list of string, initial_value: string): list of string is empty;

   // @non_standard
   // [VT - HTML Widget Method] Create a list box.
   inp_listbox(name: string, command: string, values: list of string, initial_value: string, visible_rows: int, width: int, multiple_selection: bool, tooltip: string): list of string is empty;

   // @non_standard
   // [VT - HTML Widget Method] Create a check box.
   inp_checkbox(name: string, initially_selected: bool): string is empty;

   // @non_standard
   // [VT - HTML Widget Method] Create a group of check boxes.
   inp_member(name: string, value: string, initially_selected: bool): string is empty;

   // @non_standard
   // [VT - HTML Widget Method] Create a hidden control.
   inp_hidden(name: string, value: string): string is empty;


   // ---------------------------------
   // VT Manager API - Advanced Methods
   // ---------------------------------


   // @non_standard
   // [VT - Advanced Method] Create HTML code to show a stripe.
   html_stripe(stripe: vt_stripe, indent: int): list of string is empty;

   // @non_standard
   // [VT - Advanced Method] Insert a text area in an HTML file to contain the output of a command.
   html_command_output(command: string, lines: int, chars: int): list of string is empty;

   //    // @non_standard
   //    // [VT - Advanced Method] Create a report in tabular form.
   //    html_report(list_expression: exp, list_of_titles: list of string, expression: list of exp, ...): list of string is empty;
   //    // FIXME html_report() takes variable number of parameters.

   // @non_standard
   // [VT - Advanced Method] Embed an HTML file in a larger file.
   html_body(html_file: string): string is empty;

   // @non_standard
   // [VT - Advanced Method] Create a list of e modules as hyperlinks.
   html_modules(name_wildcard: string): list of string is empty;

   // @non_standard
   // [VT - Advanced Method] Create a file control.
   inp_file(file_name: string, value: string, length: int, extension: string, direction: string): string is empty;

   // @non_standard
   // [VT - Advanced Method] Display an image in an HTML file.
   html_image(image_file: string): string is empty;

   // @non_standard
   html_table(table: vt_table): list of string is empty;

   // ----------------------------------------------------
   // VT Manager API - Methods for Using External Browsers
   // ----------------------------------------------------


   // @non_standard
   // [VT - External Browsers Method] Open a URL in an external browser.
   show_url_in_browser(url: string) is empty;

   // @non_standard
   // [VT - External Browsers Method] Open a file in an external browser.
   show_file_in_browser(file_name: string) is empty;


   // --------------------------------
   // VT Manager API - Utility Methods
   // --------------------------------


   // @non_standard
   // [VT - Utility Method] Write the contents of a text file into a struct context.
   expand_file(file_name: string, instance: any_struct): list of string is empty;

   // @non_standard
   // [VT - Utility Method] Write the contents of a text file into a struct and save it into a new file.
   expand_file_to_file(orig_file_name: string, new_file_name: string, instance: any_struct) is empty;

   // @non_standard
   // [VT - Utility Method] Convert a package-relative file or directory name to an absolute name.
   get_absolute_name(file_name: string): string is empty;

   // @non_standard
   // [VT - Utility Method] Convert a Specman struct or unit instance to a string.
   instance_to_string(instance: base_struct): string is empty;

   // @non_standard
   // [VT - Utility Method] Get the code for a color.
   get_color_code(color: vt_color): string is empty;

   // @non_standard
   // [VT - Utility Method] Print colorized text.
   text_style(style: vt_style, text: string): string is empty;

   // @non_standard
   // [VT - Utility Method] Display VT styles.
   show_styles() is empty;

   // @non_standard
   // [VT - Utility Method] Display a list of all open VT windows.
   get_all_windows(): list of vt_window is empty;

   // @non_standard
   // [VT - Utility Method] Display a list of all open VT pages.
   get_all_pages(): list of vt_page is empty;

};

// @non_standard
// [VT struct] Structure used to keep the location of a window.
struct vt_location {
   // @non_standard
   // x coordinate
   x : int;
   // @non_standard
   // y coordinate
   y : int;
};

// @non_standard
// [VT struct] Structure used to keep the size of a window.
struct vt_size {
   // @non_standard
   // width of the window
   width : int;
   // @non_standard
   // height of the window
   height : int;
};

'>

<'

// @non_standard
struct vt_abs_table_row like sn_struct {

   p_table: vt_table;

   // @non_standard
   package add_cell_i(ind : index) : list of string is empty;

   // @non_standard
   package add_real_cell_at_i(ind: index) : list of string is empty;

   // @non_standard
   get_alignment(col: vt_table_col_wrapper): string is empty;

   // @non_standard
   get_bg_html(ind: index): string is empty;

};

// @non_standard
// [VT struct] VT Stripe struct.
struct vt_stripe like vt_struct{


   // ---------------------------------
   // VT Manager API - Advanced Methods
   // ---------------------------------

   // @non_standard
   // [VT - Advanced Method] Define a box for the current stripe.
   add_box(title: untyped, value: untyped, color: vt_color) is empty;

   // @non_standard
   internal_add_box(title: untyped, value: untyped, color: vt_color) is empty;

   // @non_standard
   // [VT - Advanced Method] Add a divider between boxes.
   add_divider() is empty;

   // @non_standard
   // [VT - Advanced Method] Create a row of boxes.
   add_field_boxes(struct_instance: any_struct, fields_wildcard: string, physical_only: bool, color: vt_color) is empty;

   // @non_standard
   // [VT - Advanced Method] Clear a vt_stripe.
   clear() is empty;

};

'>

<'


// ---------------------
// VT Window API Methods
// ---------------------


// @non_standard
// [VT struct] VT window struct.
struct vt_window like vt_struct{

   // @non_standard
   // [VT field] Defines the kind of the window.
   kind : vt_window_kind;


   // ------------------------------------
   // VT Window API - Configuration Method
   // ------------------------------------


   // @non_standard
   // [VT Window Method] VT Configuration Method.
   configure() is empty;


   // ------------------------------------------------
   // VT Window API - Methods to Set Window Attributes
   // ------------------------------------------------


   // @non_standard
   // [VT Window Attributes Method] Specify the location of a window.
   set_location(x: int, y: int) is empty;

   // @non_standard
   // [VT Window Attributes Method] Specify the size of a window.
   set_size(width: int, height: int) is empty;

   // @non_standard
   // [VT Window Attributes Method] Locks the window.
   set_locked(locked: bool) is empty;

   // @non_standard
   // [VT Window Attributes Method] Specify the window prefix for the title of a window.
   set_title_prefix(prefix: string) is empty;


   // ------------------------------------------------
   // VT Window API - Methods to Display Window Status
   // ------------------------------------------------


   // @non_standard
   // [VT Window Status Method] Check whether a window is visible.
   is_visible(): bool is empty;

   // @non_standard
   // [VT Window Status Method] Check whether a window is open.
   is_opened(): bool is empty;

   // @non_standard
   // [VT Window Status Method] Check whether a window is closed.
   is_closed(): bool is empty;

   // @non_standard
   // [VT Window Status Method] Check whether a window is locked.
   is_locked(): bool is empty;

   // @non_standard
   // [VT Window Status Method] Check whether a window is lockable.
   is_lockable(): bool is empty;


   // -----------------------------------------------------
   // VT Window API - Methods to Display Window Information
   // -----------------------------------------------------


   // @non_standard
   // [VT Window Information Method] Display the current VT window page.
   get_current_page(): vt_page is empty;

   // @non_standard
   // [VT Window Information Method] Display all VT window pages.
   get_all_pages(): list of vt_page is empty;

   // @non_standard
   // [VT Window Information Method] Display the window kind.
   get_kind(): vt_window_kind is empty;

   // @non_standard
   // [VT Window Information Method] Get the window’s size.
   set_get_size(): vt_size is empty;

   // @non_standard
   // [VT Window Information Method] Get the window’s location.
   get_location(): vt_location is empty;

   // @non_standard
   // [VT Window Information Method] Display the first part (prefix) of the window title.
   get_title_prefix(): string is empty;

   // @non_standard
   // [VT Window Information Method] Display the window ID.
   get_id(): int is empty;


   // --------------------------------------------
   // VT Window API - Interactive Calls to Windows
   // --------------------------------------------


   // @non_standard
   // [VT Window Interactive Call Method] Bring the window to the front.
   to_front() is empty;


   // --------------------------------------------------------
   // VT Window API - Menu Bar and Toolbar Preparation Methods
   // --------------------------------------------------------


   // @non_standard
   // [VT Window Menu Bar and Toolbar Method] Add a new menu.
   add_menu(menu_name: string) is empty;

   // @non_standard
   // [VT Window Menu Bar and Toolbar Method] Add a new action.
   add_menu_item(menu_name: string, title: string, tool_tip: string, specman_command: string, icon_file: string, toolbar_title: string) is empty;

   // @non_standard
   // [VT Window Menu Bar and Toolbar Method] Add a new menu separator.
   add_menu_separator(menu_name: string) is empty;

   // @non_standard
   add_toolbar_separator() is empty;

   // @non_standard
   // [VT Window Menu Bar and Toolbar Method] Enable or disable a VT window menu action.
   enable_action(action_title: string, enabled: bool) is empty;


   // --------------------------------------
   // VT Window API - Window Symbols Methods
   // --------------------------------------


   // @non_standard
   // [VT Window Symbols Method] Set a symbol value.
   set_symbol_value(name: string, value: string) is empty;

   // @non_standard
   // [VT Window Symbols Method] Set values for a list of symbols.
   set_symbol_values(names: list of string, values: list of string) is empty;

   // @non_standard
   // [VT Window Symbols Method] Get the value of a symbol.
   get_symbol_value(symbol: string): string is empty;

   // @non_standard
   // [VT Window Symbols Method] Get a list of symbol values.
   get_symbol_values(names: list of string): list of string is empty;


   // --------------------------------------
   // VT Window API - Window Closing Methods
   // --------------------------------------


   // @non_standard
   // [VT Window Closing Method] Sets a callback upon closing a VT window.
   set_pre_close_command(specman_command: string) is empty;

   // @non_standard
   // [VT Window Closing Method] Close the window.
   close() is empty;

};

'>

<'


// -----------
// VT Page API
// -----------


// @non_standard
// [VT struct] VT Page struct.
struct vt_page like vt_struct{


   // --------------------
   // VT Page API - Fields
   // --------------------


   // @non_standard
   // [VT field] Defines the kind of the page.
   kind : vt_page_kind;

   // @non_standard
   page_disabled_action_names: list of string;

   // -----------------------------------------
   // VT Page API - Window Configuration Method
   // -----------------------------------------


   // @non_standard
   // [VT Page Method] VT Configuration Method.
   configure() is empty;

   // @non_standard
   enable_action(action_title: string, enabled: bool) is empty;

   // --------------------------------------------
   // VT Page API - Methods to Set Page Attributes
   // --------------------------------------------


   // @non_standard
   // [VT Page Attributes Method] Set the window kind for the page.
   set_window_kind(window_kind: vt_window_kind) is empty;

   // @non_standard
   // [VT Page Attributes Method] Set the title of the page.
   set_title(title: string) is empty;


   // ------------------------------------------
   // VT Page API - Methods to Set Page Contents
   // ------------------------------------------


   // @non_standard
   // [VT Page Contents Method] Set the URL for the file for the page.
   set_url(url: string) is empty;

   // @non_standard
   // [VT Page Contents Method] Set the file for the page.
   set_file(file_name: string) is empty;

   // @non_standard
   // [VT Page Contents Method] Set the anchor for an HTML page.
   set_anchor(anchor: string) is empty;

   // @non_standard
   // [VT Page Contents Method] Set the body of the HTML.
   set_html_body(body: list of string) is empty;


   // --------------------------------------
   // VT Page API - Methods to Display Pages
   // --------------------------------------


   // @non_standard
   // [VT Page Display Method] Display the page.
   show() is empty;

   // @non_standard
   // [VT Page Display Method] Display the page in a new window.
   show_in_new_window() is empty;


   // --------------------------------------------
   // VT Page API - Methods to Display Page Status
   // --------------------------------------------


   // @non_standard
   // [VT Page Status Method] Show whether the page is created but not open.
   is_pre_opened():bool is empty;

   // @non_standard
   // [VT Page Status Method] Show whether the page is already open.
   is_opened(): bool is empty;

   // @non_standard
   // [VT Page Status Method] Show whether the page is open and is the current page.
   is_current():bool is empty;

   // @non_standard
   // [VT Page Status Method] Show whether the window is closed.
   is_closed(): bool is empty;


   // -------------------------------------------------
   // VT Page API - Methods to Display Page Information
   // -------------------------------------------------


   // @non_standard
   // [VT Page Information Method] Display the window kind.
   get_window_kind(): vt_window_kind is empty;

   // @non_standard
   // [VT Page Information Method] Display the page kind.
   get_kind(): vt_page_kind is empty;

   // @non_standard
   // [VT Page Information Method] Display the URL of the page.
   get_requested_url(): string is empty;

   // @non_standard
   // [VT Page Information Method] Display the file name for the page.
   get_requested_file(): string is empty;

   // @non_standard
   // [VT Page Information Method] Display the anchor name.
   get_requested_anchor(): string is empty;

   // @non_standard
   // [VT Page Information Method] Display the HTML body.
   get_requested_html_body(): list of string is empty;

   // @non_standard
   // [VT Page Information Method] Display the page title.
   get_title(): string is empty;

   // @non_standard
   // [VT Page Information Method] Display the window the page is bound to.
   get_window(): vt_window is empty;


   // --------------------------------------------------
   // VT Page API - Methods to Display the Page Contents
   // --------------------------------------------------


   // @non_standard
   // [VT Page Contents Method] Display the URL of the page.
   get_url(): string is empty;

   // @non_standard
   // [VT Page Contents Method] Display the file name for the page.
   get_file_name(): string is empty;

   // @non_standard
   // [VT Page Contents Method] Display the anchor location of the page.
   get_anchor(): string is empty;

   // @non_standard
   // [VT Page Contents Method] Display the HTML body of the Page.
   get_actual_html_body(): list of string is empty;


   // ----------------------------------------
   // VT Page API - Interactive Calls to Pages
   // ----------------------------------------


   // @non_standard
   // [VT Page Interactive Call Method] Find text in the page.
   find(text: string) is empty;

   // @non_standard
   // [VT Page Interactive Call Method] Find text in the page.
   find_by(text: string, first_only: bool, whole: bool, case_sensitive: bool) is empty;

   // @non_standard
   // [VT Page Interactive Call Method] Go to the anchor and search for text.
   go_to_anchor(anchor_name: string, mark: bool, text: string): string is empty;


   // ----------------------------------------------------
   // VT Page API - Methods to Set and Get Widget Contents
   // ----------------------------------------------------


   // @non_standard
   // [VT Page Widget Method] Set the value of a widget.
   set_widget_value(name: string, value: string) is empty;

   // @non_standard
   // [VT Page Widget Method] Display the value of a widget.
   get_widget_value(name: string): string is empty;

   // @non_standard
   // [VT Page Widget Method] Set the items of a widget.
   set_widget_items(name: string, items: list of string) is empty;

   // @non_standard
   // [VT Page Widget Method] Get the items of a widget.
   get_widget_items(name: string): list of string is empty;


   // --------------------------------------
   // VT Page API - Window Symbols Methods
   // --------------------------------------


   // @non_standard
   get_all_symbol_names(): list of string is empty;

   // @non_standard
   // [VT Window Symbols Method] Set a symbol value.
   set_symbol_value(name: string, value: string) is empty;

   // @non_standard
   // [VT Window Symbols Method] Set values for a list of symbols.
   set_symbol_values(names: list of string, values: list of string) is empty;

   // @non_standard
   // [VT Window Symbols Method] Get the value of a symbol.
   get_symbol_value(symbol: string): string is empty;

   // @non_standard
   // [VT Window Symbols Method] Get a list of symbol values.
   get_symbol_values(names: list of string): list of string is empty;

};

'>

<'


// -----------
// VT Table API
// -----------

// @non_standard
type vt_table_col_kind : [UNDEFINED, STRING, NUMBER, BOOLEAN, ICON];

// @non_standard
// [VT struct] VT table struct.
struct vt_table like vt_struct {

   // @non_standard
   p_table_width: int;

   // @non_standard
   add_row(cells: list of string): vt_table_row is empty;

   // @non_standard
   calc_col_max_text_width(col: vt_table_col_wrapper, col_num: int): int is empty;

   // @non_standard
   get_col(col : int): vt_table_col is empty;

   // @non_standard
   get_col0(col : int): vt_table_col_wrapper is empty;

   // @non_standard
   get_columns(): list of vt_table_col is empty;

   // @non_standard
   get_columns0(): list of vt_table_col_wrapper is empty;

   // @non_standard
   get_width(): int is empty;

   // @non_standard
   package normalize_cols_width() is empty;

   // @non_standard
   set_max_items(max: int) is empty;

   // @non_standard
   set_show_filters(show: bool) is empty;

   // @non_standard
   set_title_row_bg(color: vt_color) is empty;

   // @non_standard
   set_width(width: int, a_bool :bool) is empty;

};

// @non_standard
struct vt_table_row like vt_struct {

   // @non_standard
   set_cell_bg(cell_num: int, color: vt_color) is empty;

   // @non_standard
   set_cell_fg(cell_num: int, color: vt_color) is empty;

};

// @non_standard
// [VT struct] VT table column struct.
struct vt_table_col like vt_struct {

   // @non_standard
   get_col_width(): int is empty;

   // @non_standard
   set_col_kind(col_kind: vt_table_col_kind) is empty;

   // @non_standard
   set_col_width(width: uint) is empty;

   // @non_standard
   set_sortable(is_sortable: bool) is empty;

   // @non_standard
   set_title(title: string) is empty;

   // @non_standard
   set_tooltip(tooltip: string) is empty;

};

// @non_standard
struct vt_table_col_wrapper like sn_struct {

   // @non_standard
   get_col_num(): int is empty;

   // @non_standard
   get_user_col(): vt_table_col is empty;

};
'>


<'

//@non_standard
struct vt_element_factory {
   create_table(name: string, cols: list of vt_table_col): vt_table is empty;

   create_table_column(name: string, title: string): vt_table_col is empty;
};

'>

<'

//@non_standard
struct vt_util {
	
	show_html_file(file_name : string) is {};
	
	add_row(title : string, value : string) : list of string is {};
};

'>
