#ifndef __DVT_FL_API_PROTOCOL_H__
#define __DVT_FL_API_PROTOCOL_H__

#include "../global/global.h"
#include "../hash/utils.h"

#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <arpa/inet.h>
#include <sys/stat.h>
#include <errno.h>
#include <fcntl.h>

#define SERVER_FIFO_IN "/tmp/channel%d.in"
#define SERVER_FIFO_OUT "/tmp/channel%d.out"

typedef struct {
    uint32_t instance; // global state

    int32_t server_pipe_fd;
    int32_t client_pipe_fd;

    // there should be a structure named Communication or sth
    // which should hold pipe for read pipe for write
    // I would like to have the ability to simply request the current communication pipe

    // here we should have a field current_protocol

    cmp_ctx_t cmp_server, cmp_client; /*i dont like this names*/
    // cmp_server = cmp_read // i always have to search which one is who
    // cmp_client = cmp_write // please rename them 

    // functions
    int32_t (*create_pipe)(const char *filename, int permissions);
    cmp_reader pipe_reader;
    cmp_writer pipe_writer;

    void (*remove_fifo)(const char *fifo_name);

} Protocol; // this should be renamed as ProtocolCenter - this is a place which dictates on which pipe we should communicate
// think about export in the export functions. In the body of the export functions i have to request the communication pipe to send data

Protocol *getProtocolInstance();

#endif /* __DVT_FL_API_PROTOCOL_H__ */