#include "../global/global.h"

#ifndef __DVT_FL_API_COMMAND_H__
#define __DVT_FL_API_COMMAND_H__

#include "../protocol/caller.h"
#include "../protocol/protocol.h"

#define DVT_COMMAND_EXECUTE_IMPORT_FUNCTION "dvt_command_execute_import_function"
#define EXEC_IMPORT_FUNCTION_TYPE 0

#define DVT_COMMAND_RESULT_IMPORT_FUNCTION "dvt_command_result_import_function"
#define RESULT_IMPORT_FUNCTION_TYPE 4

#define DVT_COMMAND_EXECUTE_EXPORT_FUNCTION "dvt_command_execute_export_function"
#define EXEC_EXPORT_FUNCTION_TYPE 2

#define DVT_COMMAND_RESULT_EXPORT_FUNCTION "dvt_command_result_export_function"
#define RESULT_EXPORT_FUNCTION_TYPE 5

#define DVT_COMMAND_EXECUTE_IMPORT_TASK "dvt_command_execute_import_task"
#define EXEC_IMPORT_TASK_TYPE 1

#define DVT_COMMAND_RESULT_IMPORT_TASK "dvt_command_result_import_task"
#define RESULT_IMPORT_TASK_TYPE 7

#define DVT_COMMAND_EXECUTE_EXPORT_TASK "dvt_command_execute_export_task"
#define EXEC_EXPORT_TASK_TYPE 3

#define DVT_COMMAND_RESULT_EXPORT_TASK "dvt_command_result_export_task"
#define RESULT_EXPORT_TASK_TYPE 6

#define DVT_COMMAND_EXECUTE_USER_DEFINED_TASK "dvt_command_execute_user_defined_task"
#define EXEC_USER_DEFINED_TASK_TYPE 8

#define DVT_COMMAND_RESULT_USER_DEFINED_TASK "dvt_command_result_user_defined_task"
#define RESULT_USER_DEFINED_TASK_TYPE 9

#define DVT_COMMAND_EXECUTE_USER_DEFINED_FUNCTION "dvt_command_execute_user_defined_function"
#define EXEC_USER_DEFINED_FUNCTION_TYPE 10

#define DVT_COMMAND_RESULT_USER_DEFINED_FUNCTION "dvt_command_result_user_defined_function"
#define RESULT_USER_DEFINED_FUNCTION_TYPE 11

#define DVT_COMMAND_EXECUTE_CALLBACK_EVENT "dvt_command_execute_callback_event"
#define EXEC_CALLBACK_EVENT 12

#define DVT_COMMAND_RESULT_CALLBACK_EVENT "dvt_command_result_callback_event"
#define RESULT_CALLBACK_EVENT 13

#define DVT_ENABLE_NATIVE_TRACE "dvt_enable_native_trace"

typedef struct command_struct {
    int type;
    char *command;

    void(*execute)(const struct command_struct *self);
} Command;

Command *create_command(const char* command_type);

void execute_command(const Command *self);

void end_import_function();

void end_import_task();

int start_export(const char *identifier_name);

int start_export_function(const char *identifier_name);

int start_export_task(const char *identifier_name);

void wait_export(int export_packet_id);

#endif /* __DVT_FL_API_COMMAND_H__ */