/* SPDX-License-Identifier: GPL-3.0 */

#ifndef VECTOR_H
#define VECTOR_H

#include "svdpi.h"

#include <stdbool.h>
#include <stddef.h>

#include "utils.h"

/***** DEFINITIONS *****/

#define VECTOR_MINIMUM_CAPACITY 8
#define VECTOR_GROWTH_FACTOR 2
#define VECTOR_SHRINK_THRESHOLD (1 / 4)

#define VECTOR_ERROR -1
#define VECTOR_SUCCESS 0

#define VECTOR_UNINITIALIZED NULL
#define VECTOR_INITIALIZER \
	{ 0, 0, 0, VECTOR_UNINITIALIZED }

/***** STRUCTURES *****/

typedef struct Vector {
	size_t size;
	size_t capacity;
	size_t element_size;

	void *data;
} Vector;

/***** METHODS *****/

/* Constructor */
int32_t vector_init(Vector *vector, size_t capacity, size_t element_size);

/* Destructor */
int32_t vector_destroy(Vector *vector);

/* Insertion */
int32_t vector_push_back(Vector *vector, void *element);
int32_t vector_insert(Vector *vector, size_t index, void *element);

/* Lookup */
void *vector_get(Vector *vector, size_t index);

/* Information */
size_t vector_byte_size(const Vector *vector);

/***** PRIVATE *****/

bool _vector_should_grow(Vector *vector);

void *_vector_offset(Vector *vector, size_t index);

void _vector_assign(Vector *vector, size_t index, void *element);

int32_t _vector_move_right(Vector *vector, size_t index);

int32_t _vector_adjust_capacity(Vector *vector);
int32_t _vector_reallocate(Vector *vector, size_t new_capacity);

#endif /* VECTOR_H */
