#ifndef __DVT_NATIVE_FACTORY_H__
#define __DVT_NATIVE_FACTORY_H__

#include "vpi_user.h"

#include "../global/global.h"
#include "../hash/hashmap.h"
#include "../command/command.h"

#define SYSTEM_TASKS "system_tasks"
#define SYSTEM_FUNCTIONS "system_functions"
#define CALLBACK_EVENTS "callback_events"

typedef struct native_factory {
    int instance; // global state

    Hashmap system_tasks;
    Hashmap system_functions;
    Vector callback_events;
    Hashmap shared_object_handles;

    Hashmap user_data_db;

    int32_t (*create_new_systf)(struct native_factory *, p_vpi_systf_data);
    int32_t (*create_new_callback_event)(struct native_factory*, p_cb_data);
    void (*send_systf)(struct native_factory *);
    void (*send_callback_events)(struct native_factory *);
    p_vpi_systf_data (*get_systf)(struct native_factory *, int, char *);
    void (*register_handle)(struct native_factory *, char *, void *);
    void *(*get_handle)(struct native_factory *, char *);
    void (*set_data)(struct native_factory *, const svScope, void *, void *);
    void *(*get_data)(struct native_factory *, const svScope, void *);

    void *(*dvt_dlsym)(void *, const char *);

} NativeFactory;

NativeFactory *getNativeFactoryInstance();

#endif /* __DVT_NATIVE_FACTORY_H__ */