#include "../hash/utils.h"

#include <dlfcn.h>
#include <stdlib.h>

int main(int argc, char *argv[]) {
	// first argument of the main must be the shared library of dvt_native_bridge

    void *lib = dlopen(argv[1], RTLD_LAZY | RTLD_GLOBAL);
    if (!lib) {
    	ERROR_LOG_F(1, "Unable to find DVT shared library dvt_native_bridge.so at path %s", argv[1]);
    	exit(1);
    }
    
    void (*server_main)(int, char **);
    server_main = dlsym(lib, "server_main");

    if (!server_main) {
        ERROR_LOG_F(1, "Unable to find %s symbol method in dvt_native_bridge.so", "server_main");
        exit(1);
    }
    
    (*server_main)(argc, argv);

    dlclose(lib);
    return 0;
}
