#ifndef __DVT_FL_API_SERVER_H__
#define __DVT_FL_API_SERVER_H__

#include <unistd.h>
#include <dlfcn.h>
#include <string.h>

#include "../global/global.h"
#include "../protocol/protocol.h"
#include "../protocol/caller.h"
#include "../command/command_center.h"
#include "../native_factory/native_factory.h"

typedef struct server_struct {
    int instance; // global state

    Protocol* pc;
    Caller* caller;
    CommandCenter *command_center;

    void(*destroy)(struct server_struct* server);
    void(*parse_args)(int argc, char* argv[]);

} Server;

int get_export_packet_id();

void destroy(struct server_struct* server);

Server* getServerInstance();

void parse_args(int argc, char *argv[]);

enum library_state {
    EMPTY,
    LOADED
};

extern enum library_state __state;

#endif /* __DVT_FL_API_SERVER_H__ */
