const datePattern = /^\d+(-\d+){2}$/;
const versionPattern = /^\d+(\.\d+){1,3}$/;

Selectize.define('dvt-addons', function(options) {

    this.hideInput = (function() {
        return function() {
            var self = this;
            self.setTextboxValue('');
            self.$control_input.css({
                opacity : 0,
                position : 'relative',
                left : 0
            });
            self.isInputHidden = true;
        };
    })();

    this.showInput = (function() {
        return function() {
            this.$control_input.css({
                opacity : 1,
                position : 'relative',
                left : 0
            });
            this.isInputHidden = false;
        };
    })();

    this.getValue = (function() {
        return function() {
            return this.items;
        };
    })();

    this.addItems = (function() {
        return function(values) {
            var items = $.isArray(values) ? values : [values];
            for (var i = 0, n = items.length; i < n; i++) {
                this.isPending = (i < n - 1);
                if (this.options.hasOwnProperty(items[i]))
                    this.addItem(items[i]);
                else
                    this.addNewItem(items[i]);
            }
        };
    })();

    this.addNewItem = (function() {

        var hash_key = function(value) {
            if ( typeof value === 'undefined' || value === null)
                return '';
            if ( typeof value === 'boolean')
                return value ? '1' : '0';
            return value + '';
        };

        return function(input) {
            var self = this;
            var data = {};
            data[self.settings.labelField] = input;
            data[self.settings.valueField] = input;

            self.unlock();

            if (!data || typeof data !== 'object')
                return;
            var value = hash_key(data[self.settings.valueField]);
            if (!value)
                return;

            self.addOption(data);
            self.addItem(value);
            self.refreshOptions(false);
        };
    })();
    
    this.removeAllItems = (function() {
    	return function() {
    		var selectedItems = this.items;
    		while (selectedItems.length > 0)
    			this.removeItem(selectedItems[0]);
    	}
    })();

});

var categoriesFilterValues = initFilter("categoriesFilterInput", "categoriesRemoveAll", getCategoriesFilterData());
var labelsFilterValues = initFilter("labelsFilterInput", "labelsRemoveAll", getLabelsFilterData());

const scrollToTop = document.getElementById("scrollToTop");

function parseInput(input) {
    input = input.replace(/ +(?= )/g,'');
    input = input.replace(" :", ":");
    input = input.replace(": ",":");

    var arguments = [];
    var insideQuotes = false;
    var lastPos = 0;
    for (var i = 0; i < input.length; i++) {
        if (input[i] == '"') {
            insideQuotes = !insideQuotes;
        }

        if (!insideQuotes && input[i] == ' ') {
            arguments.push(input.substr(lastPos, i - lastPos));
            lastPos = i + 1;
        }
    }
    arguments.push(input.substr(lastPos));
	var result = new Map();
    var freeWords = [];
    
    var simpleAttributes = ["Name", "Title", "Description", "Parameter", "Parameter_description", "Since", "Autocorrect_parameter", "Autocorrect_parameter_description"];
    for (var i = 0; i < simpleAttributes.length; i++) {
        result[simpleAttributes[i]] = [];
        var simpleAttributeNotMatched = simpleAttributes[i] + " not Matched";
        result[simpleAttributeNotMatched] = [];
    }
    var complexAttributes = ["ID", "Label", "Severity", "Parameter_name", "Autocorrect_parameter_name"];
    for (var i = 0; i < complexAttributes.length; i++) {
        result[complexAttributes[i]] = [];
        var complexAttributeNotMatched = complexAttributes[i] + " not Matched";
        result[complexAttributeNotMatched] = [];
    }

    var simpleAttributesSet = new Set(simpleAttributes);
    var complexAttributesSet = new Set(complexAttributes);
    var differentArguments = new Set();
    
    for (var i = 0; i < arguments.length; i++) {
        var attributes = arguments[i].split(':');
        var key;

        if (attributes.length == 1) {
            freeWords.push(attributes[0]);
            differentArguments.add("free word");
            continue;
        }
        attributes[1] = attributes[1].trim();
        if (attributes[1][0] == '"' && attributes[1][attributes[1].length - 1] == '"') {
            attributes[1] = attributes[1].substr(1, attributes[1].length - 2);
        } else if (attributes[1][0] == '-' && attributes[1][1] == '"' && attributes[1][attributes[1].length - 1] == '"') {
            attributes[1] = "-" + attributes[1].substr(2, attributes[1].length - 3);
        }
        if (attributes[0] == "id") {
            attributes[0] = "ID";
        } else {
            attributes[0] = capitalizeFirstLetter(attributes[0]);
        }
        attributes[1] = attributes[1].trim();
        if (simpleAttributesSet.has(attributes[0])) {
            if (attributes[1][0] == '-') {
                attributes[1] = attributes[1].substr(1);
                key = attributes[0] + " not Matched";
                
            } else {
                key = attributes[0];
                differentArguments.add(key);
            }
            if (!(key in result)) {
                result[key] = [];
            }
            result[key].push(attributes[1]);

        } else if (complexAttributesSet.has(attributes[0])) {
            var listOfValues = attributes[1].split(',');
            for (var j = 0; j < listOfValues.length; j++) {
                var value = listOfValues[j].trim();

                if (value[0] == '-') {
                    value = value.substr(1);
                    key = attributes[0] + " not Matched";                    
                } else {
                    key = attributes[0];
                    differentArguments.add(key);
                }

                if (!(key in result)) {
                    result[key] = [];
                }

                result[key].push(value);
            }
        }
    }

    result["FreeWords"] = freeWords;
    result["Different arguments"] = differentArguments.size;

    return result;
}

function capitalizeFirstLetter(string) {
    return string.charAt(0).toUpperCase() + string.slice(1);
}

function filterSearch() {
    var title = document.getElementById("titleHeader").innerHTML;
    
    var input = document.getElementById("myInput");
    var filter = input.value.toLowerCase();
    var inputMap = parseInput(filter);

    var freeWords = inputMap["FreeWords"];

    var toPass = inputMap["Different arguments"];
    var freeWordsFound = new Set();
    var differentArgumentsPassed = new Set();
    var categoriesToShow = new Set();
    var categoryNamesToShow = new Set();
    var ruleNamesToShow = new Set();
    var ruleName;

    var tables = document.getElementsByTagName("table");

	var nOfChecks;
    var nOfChecksMatched;

    for (var i = 0; i < tables.length; i++) {
        freeWordsFound.clear();
        differentArgumentsPassed.clear();
        var table = tables[i];
        
        if (table.getAttribute('id') == "filterExamples") {
        	continue;
        }

        var tr = table.getElementsByTagName("tr");

        var foundNotMatched = false;
        var category = table.closest(".category");
        var heading = category.getElementsByClassName("categoryHead")[0].getElementsByTagName("h2")[0];
        var categoryName = heading.textContent || heading.innerText;

        if (!categoriesToShow.has(category)) {
            category.style.display = "none";
        }
        
        var filteredBySidebar = false;
        
        if (categoriesFilterValues != null && categoriesFilterValues.length > 0) {
        	const categoryName = heading.textContent;
        	if (!categoriesFilterValues.some(item => item.includes(categoryName)))
        		filteredBySidebar = true;
        }
        
        if (filteredBySidebar)
        	continue;

        for (var j = 0; j < tr.length; j++) {
            var th = tr[j].getElementsByTagName("th")[0];
            var td = tr[j].getElementsByTagName("td")[0];
            var filterParam;

            if (th && td) {
                td.innerHTML = unhighlight(td);

                var attribute = th.textContent || th.innerText;
                var value = td.textContent || td.innerText;
                var res;

                if (attribute == "Parameters") {
                    attribute = "Parameter";
                }
                
                if (attribute == "Autocorrect Parameters") {
                    attribute = "Autocorrect_parameter";
                }
                
                if (attribute == "Date" || attribute == "Version") {
                    attribute = "Since";
                }

                res = applyFilter(attribute, value, inputMap, differentArgumentsPassed, td);
                foundNotMatched = res[0];
                differentArgumentsPassed = res[1];
                td.innerHTML = res[2];
                if (foundNotMatched) {
                    break;
                }
                
                if (labelsFilterValues != null && labelsFilterValues.length > 0) {
					if (table.getAttribute('id') == "Manual" || table.getAttribute('id') == "ExportDesignHierarchy") {
						filteredBySidebar = true;
                		break;
					}
					
					if (attribute == "Label") {
	                	var foundLabel = false;
	                	var valueArr = value.split(",").map(v => v.trim());
	                	for (var crt = 0; crt < labelsFilterValues.length; crt++) {
	                		if (valueArr.includes(labelsFilterValues[crt])) {
	                			foundLabel = true;
	                			break;
	                		}
	                	}
	                	
	                	if (!foundLabel) {
	                		filteredBySidebar = true;
	                		break;
	            		}
					}
                }

                if (attribute == "Name") {
                    ruleName = value;
                }

                if (attribute == "Parameter") {
                    var splitText = value.split(" : ");
                    var index = 0;
                    var parameter_name = splitText[index];
                    while (true) {
                        var toSplit = splitText[index + 1];
                        var lastIndex = toSplit.lastIndexOf('.');
                        var parameter_description =  toSplit.substr(0, lastIndex + 1);

                        res = applyFilter("Parameter_name", parameter_name, inputMap, differentArgumentsPassed, td);
                        foundNotMatched = res[0];
                        differentArgumentsPassed = res[1];
                        td.innerHTML = res[2];
                        if (foundNotMatched) {
                            break;
                        }

                        res = applyFilter("Parameter_description", parameter_description, inputMap, differentArgumentsPassed, td);
                        foundNotMatched = res[0];
                        differentArgumentsPassed = res[1];
                        td.innerHTML = res[2];
                        if (foundNotMatched) {
                            break;
                        }

                        parameter_name = toSplit.substr(lastIndex + 1);
                        index++;

                        if (parameter_name == "") {
                            break;
                        }
                    }
                }
                
                if (attribute == "Autocorrect_parameter") {
                    var splitText = value.split(" : ");
                    var index = 0;
                    var autocorrect_parameter_name = splitText[index];
                    while (true) {
                        var toSplit = splitText[index + 1];
                        var lastIndex = toSplit.lastIndexOf('.');
                        var autocorrect_parameter_description =  toSplit.substr(0, lastIndex + 1);

                        res = applyFilter("Autocorrect_parameter_name", autocorrect_parameter_name, inputMap, differentArgumentsPassed, td);
                        foundNotMatched = res[0];
                        differentArgumentsPassed = res[1];
                        td.innerHTML = res[2];
                        if (foundNotMatched) {
                            break;
                        }

                        res = applyFilter("Autocorrect_parameter_description", autocorrect_parameter_description, inputMap, differentArgumentsPassed, td);
                        foundNotMatched = res[0];
                        differentArgumentsPassed = res[1];
                        td.innerHTML = res[2];
                        if (foundNotMatched) {
                            break;
                        }

                        autocorrect_parameter_name = toSplit.substr(lastIndex + 1);
                        index++;

                        if (autocorrect_parameter_name == "") {
                            break;
                        }
                    }
                }

                for (var k = 0; k < freeWords.length; k++) {
                    filterParam = freeWords[k];
                    if (value.toLowerCase().indexOf(filterParam) > -1) {
                        freeWordsFound.add(filterParam);
                        if (filterParam != "") {
                            td.innerHTML = highlight(filterParam, td);
                        }
                    }
                }
                if (freeWords.length > 0 && freeWordsFound.size == freeWords.length) {
                    differentArgumentsPassed.add("free word");
                }
            }
        }

        if (!filteredBySidebar && differentArgumentsPassed.size == toPass && !foundNotMatched) {
            table.style.display = "";
            category.style.display = "";
            categoriesToShow.add(category);
            ruleNamesToShow.add(ruleName);
            categoryNamesToShow.add(categoryName);
        } else {
            table.style.display = "none";
        }
    }
    
    nOfChecks = tables.length - 1;
    nOfChecksMatched = ruleNamesToShow.size;
    if (filter == "" && (categoriesFilterValues == null || categoriesFilterValues.length == 0) && (labelsFilterValues == null || labelsFilterValues.length == 0)) {
        document.getElementById("filterResults").textContent = nOfChecks + " checks";
    } else {
        document.getElementById("filterResults").textContent = nOfChecksMatched + "/" + nOfChecks + " checks matched";
    }        
    
    hideToc(categoryNamesToShow, ruleNamesToShow);
    scroll(0,0);
}

function applyFilter(attribute, value, inputMap, differentArgumentsPassed, td) {
    var toMatch = attribute;
    var toNotMatch = attribute + " not Matched";
    var arrToMatch = inputMap[toMatch];
    var arrToNotMatch = inputMap[toNotMatch];
    var filterParam;
	
    for (var k = 0; k < arrToMatch.length; k++) {
        filterParam = arrToMatch[k];
        if (filterCheck(attribute, value, filterParam)) {
            differentArgumentsPassed.add(attribute);
            td.innerHTML = highlight(filterParam, td);
        }
    }
    
    for (var k = 0; k < arrToNotMatch.length; k++) {
        filterParam = arrToNotMatch[k];
        if (filterCheck(attribute, value, filterParam)) {
            return [true, differentArgumentsPassed, td.innerHTML];
        }
    }
    return [false, differentArgumentsPassed, td.innerHTML];
}

function filterCheck(attribute, value, filter){
	if (attribute == 'Since') {
        if (datePattern.test(filter) && datePattern.test(value)) {
            const valueDate = new Date(value);
            const filterDate = new Date(filter);
            return valueDate >= filterDate;
        } else if (versionPattern.test(filter) && versionPattern.test(value)) {
            const valueVersion = value.split(".");
            const filterVersion = filter.split(".");
            return compareSinceVersion(valueVersion, filterVersion);
        } else
            return false;
	} else {
		return (value.toLowerCase().indexOf(filter) > -1);
	}
}

function compareSinceVersion(valueVersion, filterVersion) {
    const valueLen = valueVersion.length;
    const filterLen = filterVersion.length;

    if (valueLen < 2 || valueLen > 4 || filterLen < 2 || filterLen > 4) {
        return false;
    }

    const maxSize = Math.max(valueLen, filterLen);
    for (let i = 0; i < maxSize; i++) {
        if (valueLen <= i)
            return false;

        if (filterLen <= i)
            return true;

        const valueV = parseInt(valueVersion[i]);
        const filterV = parseInt(filterVersion[i]);

        if (valueV < filterV)
            return false;

        if (valueV > filterV)
            return true;
    }

    return true;
}

function hideToc(categoryNamesToShow, ruleNamesToShow) {
	const toc = document.getElementById("tocQuickNavigation");
    var lis = toc.getElementsByTagName("li");
    categoryNamesToShow = Array.from(categoryNamesToShow);
    ruleNamesToShow = Array.from(ruleNamesToShow);
    for (var i = 0; i < lis.length; i++) {
        var li = lis[i];
        li.style.display = "none";

        var liText = li.textContent;
        var lines = liText.split('\n');
        var categoryText = "";

        if (lines.length > 1) {
            categoryText = lines[0];
        }

        for (var j = 0; j < categoryNamesToShow.length; j++) {
            if (categoryText == categoryNamesToShow[j]) {
                li.style.display = "";
            }
        }
        for (var j = 0; j < ruleNamesToShow.length; j++) {
            if (liText == ruleNamesToShow[j]) {
                li.style.display = "";
            }
        }
    }
}

function initFilter(filterInputId, removeAllButtonId, filterData) {
	var filterComponent = $("#" + filterInputId).selectize({
        plugins : ['remove_button', 'restore_on_backspace', 'dvt-addons'],
        persist : false,
        create : false,
        hideSelected : true,
        addPrecedence : true,
        selectOnTab : false,
        valueField : 'text',
        searchField : 'text',
        onChange: filterSearch,
        options : filterData
    });
    
    var inputComponent = filterComponent[0].selectize;
    
    $("#" + removeAllButtonId).on("click", function() {
		inputComponent.removeAllItems();
    });
    
    return inputComponent.getValue();
}

function highlight(text, element) {
    var innerHTML = element.innerHTML;
    var reg = new RegExp('(' + text + ')' + '(?!(.(?!<span))*</span>)', 'gi');
    var innerHTML = innerHTML.replace(reg, function(str) {return "<span class='highlight'>"+str+"</span>"});

    return innerHTML;
}

function unhighlight(element) {
    var innerHTML = element.innerHTML;
    var innerHTML = innerHTML.replace(/<\/?span[^>]*>/g,"");

    return innerHTML;
}

function scrollFunction() {
	if (document.body.scrollTop > 800 || document.documentElement.scrollTop > 800) {
		scrollToTop.style.display = "block";
	} else {
		scrollToTop.style.display = "none";
	}
}

function scrollToTopFunction() {
	window.scrollTo(0, 0);
}

window.onload = function() {
	document.body.addEventListener('click', hideHelp);
	
	filterSearch(categoriesFilterValues, labelsFilterValues);
}

window.onscroll = function() {
	scrollFunction();
}

function toggleHelp() {
	var x = document.getElementById("helpDiv");
    if (x.style.display == "none") {
        x.style.display = "";
    } else {
        x.style.display = "none";
    }
}

function showHelp() {
	var x = document.getElementById("helpDiv");
	x.style.display = ""
}

function hideHelp(event) {
	var x = document.getElementById("helpDiv");
	if (!event.target.matches('.wrap *')) {
		x.style.display = "none"
	}
}
