let nOfAllChecks = null;
let nOfChecks;
let nOfChecksMatched;
let filterInputValue;
let inputMap;

const datePattern = /^\d+(-\d+){2}$/;
const versionPattern = /^\d+(\.\d+){1,3}$/;

function parseInput() {
    filterInputValue = filterInput.value.toLowerCase();
    filterInputValue = filterInputValue.replace(/ +(?= )/g, '');
    filterInputValue = filterInputValue.replace(' :', ':');
    filterInputValue = filterInputValue.replace(': ', ':');

    let argumentsInFilter = [];
    let insideQuotes = false;
    let lastPos = 0;
    for (let i = 0; i < filterInputValue.length; i++) {
        if (filterInputValue[i] === '"') {
            insideQuotes = !insideQuotes;
        }

        if (!insideQuotes && filterInputValue[i] === ' ') {
            argumentsInFilter.push(filterInputValue.substr(lastPos, i - lastPos));
            lastPos = i + 1;
        }
    }
    argumentsInFilter.push(filterInputValue.substr(lastPos));
    inputMap = new Map();
    let freeWords = [];

    const simpleAttributes = ["Name", "Title", "Description", "Parameter", "Parameter_description", "Since", "Autocorrect_parameter", "Autocorrect_parameter_description"];
    for (const simpleAttribute of simpleAttributes) {
        inputMap[simpleAttribute] = [];
        const simpleAttributeNotMatched = simpleAttribute + " not Matched";
        inputMap[simpleAttributeNotMatched] = [];
    }
    const complexAttributes = ["ID", "Label", "Severity", "Parameter_name", "Autocorrect_parameter_name"];
    for (const complexAttribute of complexAttributes) {
        inputMap[complexAttribute] = [];
        const complexAttributeNotMatched = complexAttribute + " not Matched";
        inputMap[complexAttributeNotMatched] = [];
    }

    const simpleAttributesSet = new Set(simpleAttributes);
    const complexAttributesSet = new Set(complexAttributes);
    const differentArguments = new Set();

    for (const argument of argumentsInFilter) {
        const attributes = argument.split(':');
        let key;

        if (attributes.length === 1) {
            freeWords.push(attributes[0]);
            differentArguments.add("free word");
            continue;
        }
        attributes[1] = attributes[1].trim();
        if (attributes[1][0] === '"' && attributes[1][attributes[1].length - 1] === '"') {
            attributes[1] = attributes[1].substr(1, attributes[1].length - 2);
        } else if (attributes[1][0] === '-' && attributes[1][1] === '"' && attributes[1][attributes[1].length - 1] === '"') {
            attributes[1] = "-" + attributes[1].substr(2, attributes[1].length - 3);
        }
        if (attributes[0] === "id") {
            attributes[0] = "ID";
        } else {
            attributes[0] = capitalizeFirstLetter(attributes[0]);
        }
        attributes[1] = attributes[1].trim();
        if (simpleAttributesSet.has(attributes[0])) {
            if (attributes[1][0] === '-') {
                attributes[1] = attributes[1].substr(1);
                key = attributes[0] + " not Matched";

            } else {
                key = attributes[0];
                differentArguments.add(key);
            }
            if (!(key in inputMap)) {
                inputMap[key] = [];
            }
            inputMap[key].push(attributes[1]);

        } else if (complexAttributesSet.has(attributes[0])) {
            const listOfValues = attributes[1].split(',');
            for (let value of listOfValues) {
                let trimmedValue = value.trim();

                if (trimmedValue[0] === '-') {
                    trimmedValue = trimmedValue.substr(1);
                    key = attributes[0] + " not Matched";
                } else {
                    key = attributes[0];
                    differentArguments.add(key);
                }

                if (!(key in inputMap)) {
                    inputMap[key] = [];
                }

                inputMap[key].push(trimmedValue);
            }
        }
    }

    inputMap["FreeWords"] = freeWords;
    inputMap["Different arguments"] = differentArguments.size;
}

function capitalizeFirstLetter(string) {
    return string.charAt(0).toUpperCase() + string.slice(1);
}

function filterSearch() {
    if (inputMap === undefined) {
        parseInput();
    }

    const freeWords = inputMap["FreeWords"];
    const toPass = inputMap["Different arguments"];
    const freeWordsFound = new Set();
    let differentArgumentsPassed = new Set();
    const categoriesToShow = new Set();
    const categoryIdsToShow = new Set();
    const ruleIdsToShow = new Set();
    const searchableLis = new Set();
    let ruleId;

    let searchableRules = allRulesInDefaultCategories;
    if (state === C.STATE.EDIT_RULESET) {
        searchableRules = new Set();
        categoriesToRulesInRuleset.forEach((rules, category) => {
            rules.forEach(rule => {
                searchableRules.add(rule);
            })
        })
    }

    nOfChecks = 0;
    nOfChecksMatched = 0;

    searchableRules.forEach(rule => {
        freeWordsFound.clear();
        differentArgumentsPassed.clear();
        const table = rule.querySelector('table');
        const tableRows = table.getElementsByTagName("tr");

        let foundNotMatched = false;
        rule.style.display = "none";

        const category = rule.closest(".category");
        if (!categoriesToShow.has(category)) {
            category.style.display = "none";
        }

        const categoryId = category.id;
        ruleId = rule.id;

        let li = document.querySelector(`li[data-id='${ruleId}']`);
        searchableLis.add(li);
        li = document.querySelector(`li[data-id='${categoryId}']`);
        searchableLis.add(li);
		
		let filteredBySidebar = false;
				        
        if (categoriesFilterValues !== null && categoriesFilterValues.length > 0) {
        	let categoryName;
			if (state === C.STATE.SELECT_RULES)
				categoryName = category.id;
			else if (state === C.STATE.EDIT_RULESET)
				categoryName = category.dataset.name;
			
			if (!categoriesFilterValues.some(item => item.includes(categoryName)))
        		filteredBySidebar = true;
		}
        
        if (filteredBySidebar) {
        	nOfChecks++;
			return;
		}

        if (state === C.STATE.SELECT_RULES) {
            if (shouldHideAddedRules) {
                if (rulesWithCopiesInRuleset.has(rule)) {
                    unhighlightRule(tableRows);
                    return;
                }
            }
        }

        for (const tr of tableRows) {
            const th = tr.getElementsByTagName("th")[0];
            const td = tr.getElementsByTagName("td")[0];

            if (th && td) {
                let attribute = th.textContent || th.innerText;
                if (attribute === 'Autocorrect' || attribute === 'Description Append' || attribute === 'Tags') {
                    continue;
                }

                td.innerHTML = unhighlight(td);

                if (filterInputValue !== '' || (categoriesFilterValues !== null && categoriesFilterValues.length > 0) || (labelsFilterValues !== null && labelsFilterValues.length > 0)) {
                    let value = td.innerText || td.textContent;
                    let res;

                    if (attribute === 'Parameters' || attribute === 'Parameters Description') {
                        attribute = 'Parameter';
                    }

                    if (attribute.startsWith('Description')) {
                        attribute = 'Description';
                    }

                    if (attribute === 'Autocorrect Parameters' || attribute === 'Autocorrect Parameters Description') {
                        attribute = 'Autocorrect_parameter';
                    }

                    if (attribute === 'Date' || attribute === 'Version') {
                        attribute = 'Since';
                    }

                    if (attribute === 'Parameters Values') {
                        attribute = 'Parameter_value';
                    }

                    if (attribute === 'Autocorrect Parameters Values') {
                        attribute = 'Autocorrect_parameter_value';
                    }
					
					if (labelsFilterValues !== null && labelsFilterValues.length > 0) {
						if (rule.getAttribute('id') === "MANUAL" || rule.getAttribute('id') === "ExportDesignHierarchy") {
							filteredBySidebar = true;
	                		break;
						}
						
						if (attribute === "Label") {
		                	let foundLabel = false;
		                	let valueArr = value.split(",").map(v => v.trim());
		                	for (let crt = 0; crt < labelsFilterValues.length; crt++) {
		                		if (valueArr.includes(labelsFilterValues[crt])) {
		                			foundLabel = true;
		                			break;
		                		}
		                	}
		                	
		                	if (!foundLabel) {
		                		filteredBySidebar = true;
		                		break;
		            		}
						}
	                }

                    let firstChild = td.firstElementChild;
                    let firstChildClassName;
                    if (firstChild !== null) {
                        firstChildClassName = firstChild.className;
                        if (firstChildClassName === 'inputText' || firstChild.tagName === 'SELECT') {
                            continue;
                        }
                    }

                    if (attribute !== 'Parameter_value' && attribute !== 'Autocorrect_parameter_value') {
                        res = applyFilter(attribute, value, differentArgumentsPassed, td);
                        foundNotMatched = res[0];
                        differentArgumentsPassed = res[1];
                        if (foundNotMatched) {
                            break;
                        }
                    }

                    if (attribute === 'Parameter_value' || attribute === 'Autocorrect_parameter_value') {
                        if (firstChildClassName === 'parameterValueEntry') {
                            const parameterKind = attribute.replace(/_value/g, '');

                            while (firstChild) {
                                let parameterLabel = firstChild.firstElementChild;
                                value = parameterLabel.innerText || parameterLabel.textContent;

                                res = applyFilter(parameterKind, value, differentArgumentsPassed, parameterLabel);
                                foundNotMatched = res[0];
                                differentArgumentsPassed = res[1];
                                if (foundNotMatched) {
                                    break;
                                }

                                value = value.replace(/\[new\]/g, '');
                                res = applyFilter(`${parameterKind}_name`, value, differentArgumentsPassed, parameterLabel);
                                foundNotMatched = res[0];
                                differentArgumentsPassed = res[1];
                                if (foundNotMatched) {
                                    break;
                                }

                                searchFreeWords(freeWords, parameterLabel, differentArgumentsPassed, freeWordsFound);
                                firstChild = firstChild.nextElementSibling;
                            }

                            continue;
                        }
                    }

                    if (attribute === 'Parameter' || attribute === 'Autocorrect_parameter') {
                        ({ differentArgumentsPassed, foundNotMatched } = searchParameter(attribute, value, differentArgumentsPassed, td));
                    }

                    searchFreeWords(freeWords, td, differentArgumentsPassed, freeWordsFound);
                }
            }
        }

        if (!filteredBySidebar && (filterInputValue === '' || (differentArgumentsPassed.size === toPass && !foundNotMatched))) {
            category.style.display = '';
            rule.style.display = '';
            categoriesToShow.add(category);
            ruleIdsToShow.add(ruleId);
            categoryIdsToShow.add(categoryId);
        }
        nOfChecks++;
    });

    nOfChecksMatched = ruleIdsToShow.size;
    if (filterInputValue === '' && (categoriesFilterValues === null || categoriesFilterValues.length === 0) && (labelsFilterValues === null || labelsFilterValues.length === 0)) {
        filterResults.textContent = nOfChecks + ' checks';
    } else {
        filterResults.textContent = nOfChecksMatched + '/' + nOfChecks + ' checks matched';
    }

    if (state === C.STATE.SELECT_RULES && nOfAllChecks === null) {
        nOfAllChecks = nOfChecks;
    }

    hideToc(searchableLis, categoryIdsToShow, ruleIdsToShow);
    scroll(0, 0);
}

function searchParameter(parameterKind, value, differentArgumentsPassed, td) {
    const splitText = value.split(' : ');
    let index = 0;
    let parameterName = splitText[index];
    let res;

    let foundNotMatched = false;
    while (true) {
        const toSplit = splitText[index + 1];
        const lastIndex = toSplit.lastIndexOf('.');
        const parameterDescription = toSplit.substr(0, lastIndex + 1);

        res = applyFilter(`${parameterKind}_name`, parameterName, differentArgumentsPassed, td);
        foundNotMatched = res[0];
        differentArgumentsPassed = res[1];
        if (foundNotMatched) {
            break;
        }

        res = applyFilter(`${parameterKind}_description`, parameterDescription, differentArgumentsPassed, td);
        foundNotMatched = res[0];
        differentArgumentsPassed = res[1];
        if (foundNotMatched) {
            break;
        }

        parameterName = toSplit.substr(lastIndex + 1);
        index++;

        if (parameterName === '') {
            break;
        }
    }

    return { differentArgumentsPassed, foundNotMatched };
}

function searchFreeWords(freeWords, data, differentArgumentsPassed, freeWordsFound) {
    let value = data.innerText || data.textContent;
    for (const freeWord of freeWords) {
        if (value.toLowerCase().indexOf(freeWord) > -1) {
            freeWordsFound.add(freeWord);
            if (freeWord !== '') {
                highlightTextInElement(freeWord, data);
            }
        }
    }

    if (freeWords.length > 0 && freeWordsFound.size === freeWords.length) {
        differentArgumentsPassed.add("free word");
    }
}

function unhighlightRule(tableRows) {
    for (const tr of tableRows) {
        const th = tr.getElementsByTagName("th")[0];
        const td = tr.getElementsByTagName("td")[0];

        if (th && td) {
            td.innerHTML = unhighlight(td);
        }
    }
}

function applyFilter(attribute, value, differentArgumentsPassed, element) {
    const arrToMatch = inputMap[attribute];
    const arrToNotMatch = inputMap[attribute + " not Matched"];

    for (const toMatch of arrToMatch) {
        if (filterCheck(attribute, value, toMatch)) {
            differentArgumentsPassed.add(attribute);
            highlightTextInElement(toMatch, element);
        }
    }

    for (const toNotMatch of arrToNotMatch) {
        if (filterCheck(attribute, value, toNotMatch)) {
            return [true, differentArgumentsPassed];
        }
    }
    return [false, differentArgumentsPassed];
}

function filterCheck(attribute, value, filter) {
    if (attribute === 'Since') {
        if (datePattern.test(filter) && datePattern.test(value)) {
            const valueDate = new Date(value);
            const filterDate = new Date(filter);
            return valueDate >= filterDate;
        } else if (versionPattern.test(filter) && versionPattern.test(value)) {
            const valueVersion = value.split(".");
            const filterVersion = filter.split(".");
            return compareSinceVersion(valueVersion, filterVersion);
        } else
            return false;
    } else {
        return (value.toLowerCase().indexOf(filter) > -1);
    }
}

function compareSinceVersion(valueVersion, filterVersion) {
    const valueLen = valueVersion.length;
    const filterLen = filterVersion.length;

    if (valueLen < 2 || valueLen > 4 || filterLen < 2 || filterLen > 4) {
        return false;
    }

    const maxSize = Math.max(valueLen, filterLen);
    for (let i = 0; i < maxSize; i++) {
        if (valueLen <= i)
            return false;

        if (filterLen <= i)
            return true;

        const valueV = parseInt(valueVersion[i]);
        const filterV = parseInt(filterVersion[i]);

        if (valueV < filterV)
            return false;

        if (valueV > filterV)
            return true;
    }

    return true;
}

function hideToc(searchableLis, categoryIdsToShow, ruleIdsToShow) {
    searchableLis.forEach(li => {
        li.style.display = "none";
        const liId = li.dataset.id;

        if (categoryIdsToShow.has(liId)) {
            li.style.display = '';
            return;
        }

        if (ruleIdsToShow.has(liId)) {
            li.style.display = '';
        }
    });
}

function initFilter(filterInputId, removeAllButtonId, filterData) {
	let filterComponent = $("#" + filterInputId).selectize({
        plugins : ['remove_button', 'restore_on_backspace', 'dvt-addons'],
        persist : true,
        create : false,
        hideSelected : true,
        addPrecedence : true,
        selectOnTab : false,
        valueField : 'text',
        searchField : 'text',
        onChange: filterSearch,
        options : filterData
    });
    
    let inputComponent = filterComponent[0].selectize;
    
    $("#" + removeAllButtonId).on("click", function() {
		inputComponent.removeAllItems();
    });
    
    return [ inputComponent, inputComponent.getValue() ];
}

function escapeRegExp(string) {
    return string.replace(/[.*+?^{}$()|[\]\\]/g, '\\$&');
}

function highlightTextInElement(text, element) {
    const regex = new RegExp(escapeRegExp(text), 'gi');
    const walker = document.createTreeWalker(element, NodeFilter.SHOW_TEXT, null, false);
    const toWrap = [];

    while (walker.nextNode()) {
        const node = walker.currentNode;
        if (!regex.test(node.nodeValue))
            continue;

        toWrap.push(node);
    }

    toWrap.forEach((node) => {
        const parent = node.parentNode;
        const frag = document.createDocumentFragment();
        let lastIndex = 0;
        const text = node.nodeValue;
        let match;

        regex.lastIndex = 0;

        while ((match = regex.exec(text)) !== null) {
            const before = text.slice(lastIndex, match.index);
            if (before)
                frag.appendChild(document.createTextNode(before));

            const span = document.createElement('span');
            span.className = 'highlight';
            span.textContent = match[0];
            frag.appendChild(span);

            lastIndex = match.index + match[0].length;
        }

        const after = text.slice(lastIndex);
        if (after)
            frag.appendChild(document.createTextNode(after));

        parent.replaceChild(frag, node);
    });
}

function unhighlight(element) {
    let innerHTML = element.innerHTML;
    innerHTML = innerHTML.replace(/<\/?span[^>]*>/g, "");
    return innerHTML;
}

function updateFilterResults(add, nofRules) {
	if (add) {
		nOfChecks += nofRules;
	} else {
		nOfChecks -= nofRules;
	}

	if (filterInputValue === '') {
		filterResults.textContent = nOfChecks + ' checks';
	} else {
		if (add) {
			nOfChecksMatched += nofRules;
		} else {
			nOfChecksMatched -= nofRules;
		}
		filterResults.textContent = nOfChecksMatched + '/' + nOfChecks + ' checks matched';
	}
}