`define A 1
`define BB 2

`define CCC 3
`define DDDD 4

module module1(
    input [7:0] a, // comment
    input signed [7:0] bb, // comment
    output signed [7:0] ccc,    // comment
    input clk, // clock
    input rst,  // reset
    input data_in // data
	);
	
// Single line comment starting at the first column
	reg signed [7:0] data_out; // c1
	   wire [1:0] byte_enable;    // c2
	reg			  nop; // Inline single line comment that should be wrapped

	always @(negedge	clk)
	begin
/*
   * This is a multi line comment 
* inside a module
*/
	end
	
	assign ccc = (bbb == 1'b7) ? a
	                           : data_in; 
    
	always @(posedge	clk) begin  
	`ifdef BIT
		data_out <= 1'b10; // c1
	`else
	       /* And this is a multi line comment that should be wrapped */
		nop <= 1'b1;    // c2
	`endif
	// @formatter:off
	if(nop) 
	data_out <= 1'b0;
	else
	data_out <= 1'b1;
	// @formatter:on
	end
	
	submod1 inst1(
	  .p1(c1), // comment 1
	  .p22(c22[2]) // comment 2
.p33(c33[3]) /* @formatter:skip */
	);
endmodule

class class1 #(
	FIRST_PARAM_MMMMMMMMM = param_1, 
	SECCOND_PARAM_MM = param_2,
	// If line wrapping is enabled
	//  second param will not align vertically 
	//  with first, only with second  
	THIRD_PARAM = exceeds_wrap_if_valign
);
    `uvm_object_utils_begin(ubus_transfer)
        `uvm_field_int (addr,UVM_DEFAULT)
        `uvm_field_string (tx, UVM_DEFAULT|UVM_NOCOMPARE)
    `uvm_object_utils_end

    virtual protected function class1 get(input string a = "me",
    int b = 1,
    output logic c);
    endfunction
endclass

module mod2(sig0, sig1, sig2, sig3, sig4, sig5, sig6, sig7, 
sig8, sig9, sig10, sig11, sig12, sig13, sig14, sig15);
endmodule
