<#include "doc_utils.ftl">
<#macro Toc children>
    <#list children as child>
        <#if child.type == "category">
            <li><a href="#${child.name?html}">${child.name?html}</a>
            <ul>
                    <@Toc child.children/>
            </ul>
            </li>
        <#elseif child.type == "rule">
            <li><a href="#${child.name?html}">${child.name?html}</a></li>
        </#if>
    </#list>
</#macro>
<#macro CategoriesFilter>
	<div class="tocHeader">
		<h2 class="tocEntry">Filter by Category</h2>
		<button title="Remove All" class="tocRemoveButton" id="categoriesRemoveAll">&times;</button>
	</div>
	<input type="text" id="categoriesFilterInput">
</#macro>
<#macro LabelsFilter>
	<div class="tocHeader">
		<h2 class="tocEntry">Filter by Labels</h2>
		<button title="Remove All" class="tocRemoveButton" id="labelsRemoveAll">&times;</button>
	</div>
	<input type="text" id="labelsFilterInput">
</#macro>
<#macro Content children>
	<#list children as child>
        <#if child.type == "category">
            <div class="category">
            <div class="categoryHead">
            <h2 id="${child.name?html}">${child.name?html}</h2>
            <#if child.description != "">
                <h3>Description: ${nl2br(child.description?html)}</h3>
            </#if>
            </div>
            <div class="categoryContent">
            <@Content child.children/>
            </div>
            </div>
        <#elseif child.type == "rule">
            <div class="rule">
            <table id="${child.name?html}" summary="${child.name?html}">
                <tr>
                    <th>ID</th>
                    <td class="bold">${child.id?html}</td>
                </tr>
                <tr>
                    <th>Name</th>
                    <td>${child.name?html}</td>
                </tr>
                <tr>
                    <th>Title</th>
                    <td>${child.title?html}</td>
                </tr>
                <#if child.label??>
	                <tr>
	                    <th>Label</th>
	                    <td>
	                    	<#list child.label as label>
	                    		${label?html}<#sep>,</#sep>
	                    	</#list>
	                    </td>
	                </tr>
            	</#if>
                <#if child.date??>
                <tr hidden>
                    <th>Date</th>
                    <td>${child.date?html}</td>
                </tr>
	            </#if>
                <#if child.version??>
                <tr hidden>
                    <th>Version</th>
                    <td>${child.version?html}</td>
                </tr>
	            </#if>
                <tr>
                    <th>Severity</th>
                    <td>${child.severity?html}</td>
                </tr>
                <tr>
                    <th>Description</th>
                    <td><pre>${nl2br(child.description?html)}</pre></td>
                </tr>
                <#if child.parameters != "">
	                 <tr>
	                    <th>Parameters</th>
	                    <td><pre>${nl3br(child.parameters?html)}</pre></td>
	                </tr>
               	</#if>
               	<#if child.autocorrectParameters != "">
	                 <tr>
	                    <th>Autocorrect Parameters</th>
	                    <td><pre>${nl3br(child.autocorrectParameters?html)}</pre></td>
	                </tr>
               	</#if>
            </table>
            </div>
        </#if>
	</#list>
</#macro>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
    <style type="text/css">
    	<#include "${resources_path}/doc_css.css">
    </style>
    <title>${ruleset}</title>
    <body oncontextmenu="return false;">
        <div id="container">
            <div id="header">
                <h1 id="titleHeader">${ruleset}</h1>
                <div class="wrap">
	                <div class="filter">
	                	<button type="submit" class="helpButton" onclick="toggleHelp()">
	                		?
	                	</button>
	                	<input type="text" id="myInput" class="filterTerm" name="search" onkeydown="if(event.keyCode==13) filterSearch()" placeholder="Filter checks...">
	                	<div class="textBlock">
                			<span id="filterResults"></span>
	                	</div>
	                </div>
	                <div id="helpDiv" style="display:none">
	                	You can filter the list of checks using the follwing filtering syntax:<br>
	                	<br>
						  ( name | title | description | parameter | parameter_description | since | autocorrect_parameter | autocorrect_parameter_description ): [-]( value | "value with whitespaces" )<br>
						  ( id | label | severity | parameter_name | autocorrect_parameter_name ): ( [-]value | "[-]value1, ... , [-]valueN" )<br>
						  free-from text<br>
						<br>
						Notes:<br>
						<br>
						  Placing "-" character before any value will filter-out matching checks.<br>
						  Filtering based on free-form text results in a list of checks that contain all the words from that free-form text anywhere in their content.<br>
						  Combining multiple attribute-based filters toghether or with free-form text results in a list of checks that match each attribute-based filter AND all the free-form text words.<br>
						  Free-from text must not contain ":" character.<br>
						  Filtering is case-insensitive.<br>
						<br>
						Examples:<br>
						<table class="filterExamples" id="filterExamples" style="width:100%">
						  <tr>
						    <td style="width:20%">id:UVM</td>
						    <td style="width:80%">show checks containing "UVM" in their ID</td>
						  </tr>
						  <tr>
						    <td style="width:20%">id:-SVTB</td>
						    <td style="width:80%">filter-out checks containing "SVTB" in their ID</td>
						  </tr>
						  <tr>
						    <td style="width:20%">description:"Check supports auto-correcting"</td>
						    <td style="width:80%">show checks containing "Check supports auto-correcting" in their description</td>
						  </tr>
						  <tr>
						    <td style="width:20%">title:deprecated parameter:comments</td>
						    <td style="width:80%">show checks containing "deprecated" in their title and "comments" in their parameter name or parameter description</td>
						  </tr>
						  <tr>
						    <td style="width:20%">id:"SVTB, -SVTB.1"</td>
						    <td style="width:80%">show checks containing "SVTB" in their ID but not "SVTB.1"</td>
						  </tr>
						  <tr>
						    <td style="width:20%">connect uvm_active_passive_enum title:-driver</td>
						    <td style="width:80%">show checks containing "connect" and "uvm_active_passive_enum" anywhere in their content and not containing "driver" in their title</td>
						  </tr>
						  <tr>
						    <td style="width:20%">since:2022-10-01</td>
						    <td style="width:80%">show checks that were created after 2022-10-01</td>
						  </tr>
						  <tr>
						    <td style="width:20%">since:-2022-10-01</td>
						    <td style="width:80%">show checks that were created before 2022-10-01</td>
						  </tr>
                          <tr>
						    <td style="width:20%">since:24.1.5</td>
						    <td style="width:80%">show checks that were added starting with version 24.1.5</td>
						  </tr>
						  <tr>
						    <td style="width:20%">since:-24.1.5</td>
						    <td style="width:80%">show checks that were added before version 24.1.5</td>
						  </tr>
						</table>
	              	</div>
	              	<button class="button" onclick="scrollToTopFunction()" id="scrollToTop" style="display: none;">Back to Top &uarr;</button>
                </div>
                <p>CONFIDENTIAL<#if !custom> - Copyright (C) 2005-2026 AMIQ EDA s.r.l.</#if></p>
            </div>
            <div id="toc">
            	<div class="tocFilterContainer" id="tocCategoriesFilter">
            		<@CategoriesFilter/>
            	</div>
            	<div class="tocFilterContainer" id="tocLabelsFilter">
            		<@LabelsFilter/>
            	</div>
	            <div id="tocQuickNavigation" style="margin-top: 10px;">
	            	<h2 class="tocEntry" style="font-weight: bold;">Quick Navigation</h2>
		            <ul>
		                <@Toc children/>
		            </ul>
	            </div>
                <@Logo/>
                <p>Copyright (C) 2005-2026 AMIQ EDA s.r.l.</p>
            </div>
            <div id="content">
                <@Content children/>
            </div>
            <div id="footer">
                <p>Generated by <b>${user}</b> on ${date} using <a href="http://eda.amiq.com/" target="_new">Verissimo Linter<sup>TM</sup></a> Version ${version}</p>
                <p>Copyright (C) 2005-2026 AMIQ EDA s.r.l.</p>
            </div>
        </div>
    <script>
		function getCategoriesFilterData() {
			var data = [];
			<#list children as child>
				<#if child.type == "category">
				    data.push({
				        text : "${child.name}"
				    });
			    </#if>
			</#list>
			return data;
		}
		
		function getLabelsFilterData() {
			var data = [];
			<#list labels as label>
			    data.push({
			        text : "${label}"
			    });
			</#list>
			return data;
		}

 		<#include "${resources_path}/searchFilter.js">
	</script>

	<script type="text/javascript">
		if (!window['vscodeOpen']) {
			document.addEventListener("DOMContentLoaded", function(event) { 
				var DARK_THEME_CSS = "body {background-color: #474645;} body, h1, h2, h3, h4, h5, h6, p, table, td, caption, th, ul, ol, dl, li, dd, dt {color: #e5e5e4;} th, td {border: 1px solid #3c3b40;} th {background-color: #3c3b40;} .categoryHead {border-top: 4px solid #474645; border-bottom: 1px solid #3c3b40;} .categoryHead a {color: #3c3b40;} #header {border-bottom: 1px dashed #3c3b40; background-color: #474645;} #toc {border-right: 1px dashed #3c3b40;} #footer {border-top: 1px dashed #3c3b40;} .filterTerm {border: 3px solid #3c3b40; background: #474645; color: #e5e5e4;} .helpButton {border: 1px solid #3c3b40; background: #3c3b40; color: #e5e5e4;} #helpDiv {border: 3px solid #3c3b40; color: #e5e5e4;} .textBlock {border: 3px solid #3c3b40; background-color: #474645; color: #e5e5e4;}"; 
	    		var CLASSIC_THEME_CSS = "body, h1, h2, h3, h4, h5, h6, p, table, td, caption, th, ul, ol, dl, li, dd, dt {color: #333;} h1, h2, h3 {color: #333;} th, td {border: 1px solid #ccc;} th {background-color: #eee;} .categoryHead {border-top: 4px solid #fff; border-bottom: 1px solid #ccc;} .categoryHead a {color: #333;} #header {border-bottom: 1px dashed #ccc; background-color: white;} #toc {border-right: 1px dashed #ccc;} #footer {border-top: 1px dashed #ccc;} .filterTerm {border: 3px solid #eee; color: #333;} .helpButton {border: 1px solid #eee; background: #eee; color: #333;} #helpDiv {border: 3px solid #eee; color: #333;} .textBlock {border: 3px solid #eee; background-color: white; color: #333;}";
				var styleSheet = document.createElement('style')
	
				var results = new RegExp('[\?&]' + "theme" + '=([^&#]*)').exec(window.location.search);
				if (results == null) {
					styleSheet.textContent = CLASSIC_THEME_CSS
					document.getElementsByTagName('head')[0].appendChild(styleSheet)
					return;
				}
	
				if (results[1] === "css/dark-theme.css")
	            	styleSheet.textContent = DARK_THEME_CSS
	           	else if (results[1] === "css/style.css")
	            	styleSheet.textContent = CLASSIC_THEME_CSS
	
	            document.getElementsByTagName('head')[0].appendChild(styleSheet)
			});
		}
    </script>

    </body>
</html>
