<#macro loop children>
    <#list children as child>
        <#if child.type == "category">

  <category name="${child.name}">
  <@loop child.children/>
  </category>

        <#elseif child.type == "rule">
    <#if attributes?seq_contains("complete_rule_info")>
    <!--
      ID: ${child.id?replace("--", "&#x2D;&#x2D;")}
      NAME: ${child.name?replace("--", "&#x2D;&#x2D;")}
      TITLE: ${child.title?replace("--", "&#x2D;&#x2D;")}
      <#if child.label??>
      LABEL: ${child.label?replace("--", "&#x2D;&#x2D;")?replace("[", "")?replace("]", "")}
      </#if>
      SEVERITY: ${child.severity?replace("--", "&#x2D;&#x2D;")}
      DESCRIPTION:
        ${child.description?replace("--", "&#x2D;&#x2D;")?replace("\n", "\n        ")?replace("\n\\s+\n", "\n\n", "r")}
      <#if child.parameters != "">
      PARAMETERS:
        <#list child.parameterMap as parameter>
        ${parameter.description?replace("--", "&#x2D;&#x2D;")?replace("\n", "\n        ")?replace("\n\\s+\n", "\n\n", "r")} Default: ${parameter.defaultValue?replace("--", "&#x2D;&#x2D;")}
        </#list>
      </#if>
      <#if child.autocorrectParameters != "">
      AUTOCORRECT PARAMETERS:
         <#list child.autocorrectParameterMap as parameter>
        ${parameter.description?replace("--", "&#x2D;&#x2D;")?replace("\n", "\n        ")?replace("\n\\s+\n", "\n\n", "r")} Default: ${parameter.defaultValue?replace("--", "&#x2D;&#x2D;")}
        </#list>
      </#if>
    -->
    </#if>
    <#outputformat "XML">
    <rule id="${child.id}"
      <#if attributes?seq_contains("name") || child.rulesetInfo.hasName.equals("true")>
      name="${child.name}"
      </#if>
      <#if attributes?seq_contains("title") || child.rulesetInfo.hasTitle.equals("true")>
      title="${child.title}"
      </#if>
      <#if (attributes?seq_contains("severity") || child.rulesetInfo.hasSeverity.equals("true")) && !child.rulesetInfo.hasSeverity.equals("null")>
      severity="${child.severity}"
      </#if>
      <#if attributes?seq_contains("disable") >
      disable="${child.disable?c}"
      </#if>
      <#if attributes?seq_contains("description") || child.rulesetInfo.hasDescription.equals("true")>
      description="${child.description?replace("&", "&amp;")?replace("\n", "&#xA;")?replace("<", "&lt;")?replace(">", "&gt;")?replace("'", "&apos;")?replace("\"", "&quot;")?no_esc}"
      </#if>
      <#if child.rulesetInfo.isAutoCorrectEnabled.equals("true")>
      autocorrect="on"
      </#if>
    >
    <#if child.parameters != "" && child.parameterMap?has_content>
    <#if child.rulesetInfo.properties?has_content || attributes?seq_contains("parameters") || attributes?seq_contains("commented_parameters")>
      <!-- Parameters: -->
      </#if>
      <#if child.rulesetInfo.properties?has_content>
      <#if attributes?seq_contains("parameters_info")>
      <#list child.rulesetInfo.properties as property>

      <!-- ${(property.description?replace("--", "&#x2D;&#x2D;"))?no_esc} -->
      <property key="${property.name}" value="${property.value}" />
      </#list>
      <#else>

      <#list child.rulesetInfo.properties as property>
      <property key="${property.name}" value="${property.value}" />
      </#list>
      </#if>
    </#if>
    <#if attributes?seq_contains("parameters")>
      <#if attributes?seq_contains("parameters_info")>
      <#list child.parameterMap as parameter>
      <#if parameter.rulesetOverriden == "false">

      <!-- ${parameter.description?replace("--", "&#x2D;&#x2D;")?no_esc} -->
      <property key="${parameter.name}" value="${parameter.defaultValue}" />
      </#if>
      </#list>
      <#else>

      <#list child.parameterMap as parameter>
      <#if parameter.rulesetOverriden == "false">
      <property key="${parameter.name}" value="${parameter.defaultValue}" />
      </#if>
      </#list>
      </#if>
    <#elseif attributes?seq_contains("commented_parameters")>
      <#if attributes?seq_contains("parameters_info")>
      <#list child.parameterMap as parameter>
      <#if parameter.rulesetOverriden == "false">

      <!-- ${parameter.description?replace("--", "&#x2D;&#x2D;")?no_esc} -->
      <!-- <property key="${parameter.name?replace("&", "&amp;")?replace("--", "&#x2D;&#x2D;")?replace("<", "&lt;")?replace(">", "&gt;")?replace("\"", "&#x22;")?no_esc}" value="${parameter.defaultValue?replace("&", "&amp;")?replace("--", "&#x2D;&#x2D;")?replace("<", "&lt;")?replace(">", "&gt;")?replace("\"", "&#x22;")?no_esc}" /> -->
      </#if>
      </#list>
      <#else>

      <#list child.parameterMap as parameter>
      <#if parameter.rulesetOverriden == "false">
      <!-- <property key="${parameter.name?replace("&", "&amp;")?replace("--", "&#x2D;&#x2D;")?replace("<", "&lt;")?replace(">", "&gt;")?replace("\"", "&#x22;")?no_esc}" value="${parameter.defaultValue?replace("&", "&amp;")?replace("--", "&#x2D;&#x2D;")?replace("<", "&lt;")?replace(">", "&gt;")?replace("\"", "&#x22;")?no_esc}" /> -->
      </#if>
      </#list>
      </#if>
    </#if>
    </#if>
    <#if child.autocorrectParameters != "" && child.autocorrectParameterMap?has_content>
    <#if child.rulesetInfo.autocorrectInputs?has_content || attributes?seq_contains("parameters") || attributes?seq_contains("commented_parameters")>

      <!-- Autocorrect Parameters: -->
      </#if>
      <#if child.rulesetInfo.autocorrectInputs?has_content>
      <#if attributes?seq_contains("parameters_info")>
      <#list child.rulesetInfo.autocorrectInputs as property>

      <!-- ${(property.description?replace("--", "&#x2D;&#x2D;"))?no_esc} -->
      <autocorrect-input key="${property.name}" value="${property.value}" />
      </#list>
      <#else>

      <#list child.rulesetInfo.autocorrectInputs as property>
      <autocorrect-input key="${property.name}" value="${property.value}" />
      </#list>
      </#if>
    </#if>
    <#if attributes?seq_contains("parameters")>
      <#if attributes?seq_contains("parameters_info")>
      <#list child.autocorrectParameterMap as parameter>
      <#if parameter.rulesetOverriden == "false">

      <!-- ${parameter.description?replace("--", "&#x2D;&#x2D;")?no_esc} -->
      <autocorrect-input key="${parameter.name}" value="${parameter.defaultValue}" />    
      </#if>
      </#list>
      <#else>

      <#list child.autocorrectParameterMap as parameter>
      <#if parameter.rulesetOverriden == "false">
      <autocorrect-input key="${parameter.name}" value="${parameter.defaultValue}" />
      </#if>
      </#list>
      </#if>
    <#elseif attributes?seq_contains("commented_parameters")>
      <#if attributes?seq_contains("parameters_info")>
      <#list child.autocorrectParameterMap as parameter>
      <#if parameter.rulesetOverriden == "false">

      <!-- ${parameter.description?replace("--", "&#x2D;&#x2D;")?no_esc} -->
      <!-- <autocorrect-input key="${parameter.name?replace("&", "&amp;")?replace("--", "&#x2D;&#x2D;")?replace("<", "&lt;")?replace(">", "&gt;")?replace("\"", "&#x22;")?no_esc}" value="${parameter.defaultValue?replace("&", "&amp;")?replace("--", "&#x2D;&#x2D;")?replace("<", "&lt;")?replace(">", "&gt;")?replace("\"", "&#x22;")?no_esc}" /> -->
      </#if>
      </#list>
      <#else>

      <#list child.autocorrectParameterMap as parameter>
      <#if parameter.rulesetOverriden == "false">
      <!-- <autocorrect-input key="${parameter.name?replace("&", "&amp;")?replace("--", "&#x2D;&#x2D;")?replace("<", "&lt;")?replace(">", "&gt;")?replace("\"", "&#x22;")?no_esc}" value="${parameter.defaultValue?replace("&", "&amp;")?replace("--", "&#x2D;&#x2D;")?replace("<", "&lt;")?replace(">", "&gt;")?replace("\"", "&#x22;")?no_esc}" /> -->
      </#if>
      </#list>
      </#if>
    </#if>
    </#if>
    </rule>

    </#outputformat>
    </#if>
    </#list>
</#macro>
<?xml version="1.0" encoding="UTF-8"?>
<ruleset version="${rulesetVersion}" name="${ruleset} - ${date}" library="${xvm}">
  <@loop children/>
</ruleset>