<#if getChildren()??>
    <#lt><@actionsTargetCode getChildren() 2/>
<#else>
    <#lt><@actionTargetCode this 2/>
</#if>

<#macro actionTargetCode action depth>
<#local indent>${""?left_pad(depth * 4)}</#local>
<#if action.getChildren()??>
    <#assign children = action.getChildren()> 
    <#if children.isEmpty()>
    <#elseif action.isSequenceActionInstance()>
        <#if children.size() == 1 && children.get(0).isSequenceActionInstance()>
            <#lt><@actionTargetCode children.get(0) depth/>
        <#else>
            <#assign content><@actionsTargetCode children depth + 1/></#assign>
            <#if content != "">
                <#lt>${indent}begin
                <#lt>${content}
                <#lt>${indent}end
            </#if>    
        </#if>    
    <#elseif action.isParallelActionInstance()>   
        <#if children.size() == 1 && children.get(0).isParallelActionInstance()>
        <#lt><@actionTargetCode children.get(0) depth/>
        <#else>
            <#assign content><@actionsTargetCode children depth + 1/></#assign>
            <#if content != "">
                <#lt>${indent}fork
                <#lt>${content}
                <#lt>${indent}join
            </#if>    
        </#if>
    <#else> 
<@actionsTargetCode children depth/> 
    </#if>
<#else>  
    <#assign targetCode = action.getBodyTargetCode(""?left_pad((depth + 1) * 4))>
    <#if !targetCode.isEmpty()>
        <#assign hierarchicalPath = action.getHierarchicalPath()>
        <#lt>${indent}begin // ${hierarchicalPath}
        <#lt>${targetCode}
        <#lt>${indent}end   // ${hierarchicalPath}
    </#if>
</#if>
</#macro>

<#macro actionsTargetCode actions depth>
    <#if !actions.isEmpty()>
        <#list actions as action>
        <#lt><@actionTargetCode action depth/><#t>
        </#list>
    </#if>
</#macro>
