package standard is

    -- basic boolean type - values: true, false
    type boolean is (FALSE, TRUE);

    -- The predefined operations for this type are as follows:
    function "and" (anonymous, anonymous1: BOOLEAN) return BOOLEAN;
    function "or" (anonymous, anonymous1: BOOLEAN) return BOOLEAN;
    function "nand" (anonymous, anonymous1: BOOLEAN) return BOOLEAN;
    function "nor" (anonymous, anonymous1: BOOLEAN) return BOOLEAN;
    function "xor" (anonymous, anonymous1: BOOLEAN) return BOOLEAN;
    function "xnor" (anonymous, anonymous1: BOOLEAN) return BOOLEAN;
    function "not" (anonymous: BOOLEAN) return BOOLEAN;
    function "=" (anonymous, anonymous1: BOOLEAN) return BOOLEAN;
    function "/=" (anonymous, anonymous1: BOOLEAN) return BOOLEAN;
    function "<" (anonymous, anonymous1: BOOLEAN) return BOOLEAN;
    function "<=" (anonymous, anonymous1: BOOLEAN) return BOOLEAN;
    function ">" (anonymous, anonymous1: BOOLEAN) return BOOLEAN;
    function ">=" (anonymous, anonymous1: BOOLEAN) return BOOLEAN;

    function "??" (anonymous: BOOLEAN) return BOOLEAN;

    function minimum (l, r: boolean) return boolean;
    function maximum (l, r: boolean) return boolean;
    function RISING_EDGE (signal S: BOOLEAN) return BOOLEAN;
    function FALLING_EDGE (signal S: BOOLEAN) return BOOLEAN;

    type file_open_kind is ( READ_MODE, WRITE_MODE, APPEND_MODE );
    -- The predefined operations for this type are as follows:
    function "=" (anonymous, anonymous1: FILE_OPEN_KIND) return BOOLEAN;
    function "/=" (anonymous, anonymous1: FILE_OPEN_KIND) return BOOLEAN;
    function "<" (anonymous, anonymous1: FILE_OPEN_KIND) return BOOLEAN;
    function "<=" (anonymous, anonymous1: FILE_OPEN_KIND) return BOOLEAN;
    function ">" (anonymous, anonymous1: FILE_OPEN_KIND) return BOOLEAN;
    function ">=" (anonymous, anonymous1: FILE_OPEN_KIND) return BOOLEAN;

    type file_open_status is ( OPEN_OK, STATUS_ERROR, NAME_ERROR, MODE_ERROR );
    -- The predefined operations for this type are as follows:
    function "=" (anonymous, anonymous1: FILE_OPEN_STATUS) return BOOLEAN;
    function "/=" (anonymous, anonymous1: FILE_OPEN_STATUS) return BOOLEAN;
    function "<" (anonymous, anonymous1: FILE_OPEN_STATUS) return BOOLEAN;
    function "<=" (anonymous, anonymous1: FILE_OPEN_STATUS) return BOOLEAN;
    function ">" (anonymous, anonymous1: FILE_OPEN_STATUS) return BOOLEAN;
    function ">=" (anonymous, anonymous1: FILE_OPEN_STATUS) return BOOLEAN;

    --basic bit type - values: 0, 1
    type bit is ('0', '1');

    -- The predefined operations for this type are as follows:
    function "and" (anonymous, anonymous1: BIT) return BIT;
    function "or" (anonymous, anonymous1: BIT) return BIT;
    function "nand" (anonymous, anonymous1: BIT) return BIT;
    function "nor" (anonymous, anonymous1: BIT) return BIT;
    function "xor" (anonymous, anonymous1: BIT) return BIT;
    function "xnor" (anonymous, anonymous1: BIT) return BIT;
    function "not" (anonymous: BIT) return BIT;
    function "=" (anonymous, anonymous1: BIT) return BOOLEAN;
    function "/=" (anonymous, anonymous1: BIT) return BOOLEAN;
    function "<" (anonymous, anonymous1: BIT) return BOOLEAN;
    function "<=" (anonymous, anonymous1: BIT) return BOOLEAN;
    function ">" (anonymous, anonymous1: BIT) return BOOLEAN;
    function ">=" (anonymous, anonymous1: BIT) return BOOLEAN;
    function "?=" (anonymous, anonymous1: BIT) return BIT;
    function "?/=" (anonymous, anonymous1: BIT) return BIT;
    function "?<" (anonymous, anonymous1: BIT) return BIT;
    function "?<=" (anonymous, anonymous1: BIT) return BIT;
    function "?>" (anonymous, anonymous1: BIT) return BIT;
    function "?>=" (anonymous, anonymous1: BIT) return BIT;

    function minimum (l, r: bit) return bit;
    function maximum (l, r: bit) return bit;

    function "??" (anonymous: BIT) return BOOLEAN;

    function rising_edge (signal s: bit) return boolean;
    function falling_edge (signal s: bit) return boolean;

    --basic character type
    type character is (
        NUL, SOH, STX,  ETX, EOT, ENQ, ACK, BEL,
        BS,  HT,  LF,   VT,  FF,  CR,  SO,  SI,
        DLE, DC1, DC2,  DC3, DC4, NAK, SYN, ETB,
        CAN, EM,  SUB,  ESC, FSP, GSP, RSP, USP,
        DEL,
        ' ', '!', '"',  '#', '$', '%', '&', ''',
        '(', ')', '*',  '+', ',', '-', '.', '/',
        '0', '1', '2',  '3', '4', '5', '6', '7',
        '8', '9', ':',  ';', '<', '=', '>', '?',

        '@',  'A', 'B', 'C', 'D', 'E', 'F', 'G',
        'H',  'I', 'J', 'K', 'L', 'M', 'N', 'O',
        'P',  'Q', 'R', 'S', 'T', 'U', 'V', 'W',
        'X',  'Y', 'Z', '[', '\', ']', '^', '_',

        '`', 'a', 'b',  'c', 'd', 'e', 'f', 'g',
        'h', 'i', 'j',  'k', 'l', 'm', 'n', 'o',
        'p', 'q', 'r',  's', 't', 'u', 'v', 'w',
        'x', 'y', 'z',  '{', '|', '}', '~',

        C128, C129, C130, C131, C132, C133, C134, C135,
        C136, C137, C138, C139, C140, C141, C142, C143,
        C144, C145, C146, C147, C148, C149, C150, C151,
        C152, C153, C154, C155, C156, C157, C158, C159,

        '¡', '¢', '£', '¤', '¥', '¦', '§', '¨',
        '©', 'ª', '«', '¬', '®', '¯', '°', '±',
        '²', '³', '´', 'µ', '¶', '·', '¸', '¹',
        'º', '»', '½', '¼', '¾', '¿', '÷', ' ',

        'À', 'Á', 'Â', 'Ã', 'Ä', 'Å', 'Æ', 'Ç',
        'È', 'É', 'Ê', 'Ë', 'Ì', 'Í', 'Î', 'Ï',
        'Ð', 'Ñ', 'Ò', 'Ó', 'Ô', 'Õ', 'Ö', '×',
        'Ø', 'Ù', 'Ú', 'Û', 'Ü', 'Ý', 'Þ', 'ß',

        'à', 'á', 'â', 'ã', 'ä', 'å', 'æ', 'ç',
        'è', 'é', 'ê', 'ë', 'ì', 'í', 'î', 'ï',
        'ð', 'ñ', 'ò', 'ó', 'ô', 'õ', 'ö', 'ÿ',
        'ø', 'ù', 'ú', 'û', 'ü', 'ý', 'þ'
    );

    -- The predefined operations for this type are as follows:
    function "=" (anonymous, anonymous1: CHARACTER) return BOOLEAN;
    function "/=" (anonymous, anonymous1: CHARACTER) return BOOLEAN;
    function "<" (anonymous, anonymous1: CHARACTER) return BOOLEAN;
    function "<=" (anonymous, anonymous1: CHARACTER) return BOOLEAN;
    function ">" (anonymous, anonymous1: CHARACTER) return BOOLEAN;
    function ">=" (anonymous, anonymous1: CHARACTER) return BOOLEAN;

    function minimum (l, r: character) return character;
    function maximum (l, r: character) return character;

    --severity level - values: NOTE, WARNING, ERROR, FAILURE
    type severity_level is (NOTE, WARNING, ERROR, FAILURE);

    -- The predefined operations for this type are as follows:
    function "=" (anonymous, anonymous1: SEVERITY_LEVEL) return BOOLEAN;
    function "/=" (anonymous, anonymous1: SEVERITY_LEVEL) return BOOLEAN;
    function "<" (anonymous, anonymous1: SEVERITY_LEVEL) return BOOLEAN;
    function "<=" (anonymous, anonymous1: SEVERITY_LEVEL) return BOOLEAN;
    function ">" (anonymous, anonymous1: SEVERITY_LEVEL) return BOOLEAN;
    function ">=" (anonymous, anonymous1: SEVERITY_LEVEL) return BOOLEAN;

    function minimum (l, r: severity_level) return severity_level;
    function maximum (l, r: severity_level) return severity_level;

    type integer is range -2147483647 to 2147483647;

    -- The predefined operations for this type are as follows:
    function "=" (anonymous, anonymous1: INTEGER) return BOOLEAN;
    function "/=" (anonymous, anonymous1: INTEGER) return BOOLEAN;
    function "<" (anonymous, anonymous1: INTEGER) return BOOLEAN;
    function "<=" (anonymous, anonymous1: INTEGER) return BOOLEAN;
    function ">" (anonymous, anonymous1: INTEGER) return BOOLEAN;
    function ">=" (anonymous, anonymous1: INTEGER) return BOOLEAN;
    function "+" (anonymous: INTEGER) return INTEGER;
    function "-" (anonymous: INTEGER) return INTEGER;
    function "abs" (anonymous: INTEGER) return INTEGER;
    function "+" (anonymous, anonymous1: INTEGER) return INTEGER;
    function "-" (anonymous, anonymous1: INTEGER) return INTEGER;
    function "*" (anonymous, anonymous1: INTEGER) return INTEGER;
    function "/" (anonymous, anonymous1: INTEGER) return INTEGER;
    function "mod" (anonymous, anonymous1: INTEGER) return INTEGER;
    function "rem" (anonymous, anonymous1: INTEGER) return INTEGER;
    function "**" (anonymous: INTEGER; anonymous1: INTEGER) return INTEGER;

    function minimum (l, r: integer) return integer;
    function maximum (l, r: integer) return integer;

    type real is range 0.0 to 0.0;

    -- The predefined operations for this type are as follows:
    function "=" (anonymous, anonymous1: REAL) return BOOLEAN;
    function "/=" (anonymous, anonymous1: REAL) return BOOLEAN;
    function "<" (anonymous, anonymous1: REAL) return BOOLEAN;
    function "<=" (anonymous, anonymous1: REAL) return BOOLEAN;
    function ">" (anonymous, anonymous1: REAL) return BOOLEAN;
    function ">=" (anonymous, anonymous1: REAL) return BOOLEAN;
    function "+" (anonymous: REAL) return REAL;
    function "-" (anonymous: REAL) return REAL;
    function "abs" (anonymous: REAL) return REAL;
    function "+" (anonymous, anonymous1: REAL) return REAL;
    function "-" (anonymous, anonymous1: REAL) return REAL;
    function "*" (anonymous, anonymous1: REAL) return REAL;
    function "/" (anonymous, anonymous1: REAL) return REAL;
    function "**" (anonymous: REAL; anonymous1: INTEGER) return REAL;

    function minimum (l, r: real) return real;
    function maximum (l, r: real) return real;

    --basic time type
    type time is range 0 to 0
    units
        fs; -- femtosecond
        ps = 1000 fs; -- picosecond
        ns = 1000 ps; -- nanosecond
        us = 1000 ns; -- microsecond
        ms = 1000 us; -- millisecond
        sec = 1000 ms; -- second
        min = 60 sec; -- minute
        hr = 60 min; -- hour
    end units;

    function minimum (l, r: time) return time;
    function maximum (l, r: time) return time;

    --delay length subtype of time
    subtype delay_length is time range 0 fs to time'HIGH;

    type domain_type is ( QUIESCENT_DOMAIN, TIME_DOMAIN, FREQUENCY_DOMAIN );

    signal domain: domain_type := QUIESCENT_DOMAIN;

    --function that returns the current simulation time:
    impure function now return time;

    impure function now return real;

    function frequency return real;

    --natural subtype values: 0 to high
    subtype natural is integer range 0 to integer'HIGH;

    --positive subtype values: 1 to high
    subtype positive is integer range 1 to integer'HIGH;

    --basic string type
    type string is array (positive range <>) of character;

    -- The predefined operations for these types are as follows:
    function "=" (anonymous, anonymous1: STRING) return BOOLEAN;
    function "/=" (anonymous, anonymous1: STRING) return BOOLEAN;
    function "<" (anonymous, anonymous1: STRING) return BOOLEAN;
    function "<=" (anonymous, anonymous1: STRING) return BOOLEAN;
    function ">" (anonymous, anonymous1: STRING) return BOOLEAN;
    function ">=" (anonymous, anonymous1: STRING) return BOOLEAN;
    function "&" (anonymous: STRING; anonymous1: STRING) return STRING;
    function "&" (anonymous: STRING; anonymous1: CHARACTER) return STRING;
    function "&" (anonymous: CHARACTER; anonymous1: STRING) return STRING;
    function "&" (anonymous: CHARACTER; anonymous1: CHARACTER) return STRING;

    function minimum (l, r: string) return string;
    function maximum (l, r: string) return string;
    function minimum (l: string) return character;
    function maximum (l: string) return character;

    type boolean_vector is array (natural range <>) of boolean;

    function "and" (anonymous: BOOLEAN_VECTOR; anonymous1: BOOLEAN) return BOOLEAN_VECTOR;
    function "and" (anonymous: BOOLEAN; anonymous1: BOOLEAN_VECTOR) return BOOLEAN_VECTOR;
    function "or" (anonymous: BOOLEAN_VECTOR; anonymous1: BOOLEAN) return BOOLEAN_VECTOR;
    function "or" (anonymous: BOOLEAN; anonymous1 : BOOLEAN_VECTOR) return BOOLEAN_VECTOR;
    function "nand" (anonymous: BOOLEAN_VECTOR; anonymous1: BOOLEAN) return BOOLEAN_VECTOR;
    function "nand" (anonymous: BOOLEAN; anonymous1: BOOLEAN_VECTOR) return BOOLEAN_VECTOR;
    function "nor" (anonymous: BOOLEAN_VECTOR; anonymous1: BOOLEAN) return BOOLEAN_VECTOR;
    function "nor" (anonymous: BOOLEAN; anonymous1: BOOLEAN_VECTOR) return BOOLEAN_VECTOR;
    function "xor" (anonymous: BOOLEAN_VECTOR; anonymous1: BOOLEAN) return BOOLEAN_VECTOR;
    function "xor" (anonymous: BOOLEAN; anonymous1: BOOLEAN_VECTOR) return BOOLEAN_VECTOR;
    function "xnor" (anonymous: BOOLEAN_VECTOR; anonymous1: BOOLEAN) return BOOLEAN_VECTOR;
    function "xnor" (anonymous: BOOLEAN; anonymous1: BOOLEAN_VECTOR) return BOOLEAN_VECTOR;
    function "and" (anonymous: BOOLEAN_VECTOR) return BOOLEAN;
    function "or" (anonymous: BOOLEAN_VECTOR) return BOOLEAN;
    function "nand" (anonymous: BOOLEAN_VECTOR) return BOOLEAN;
    function "nor" (anonymous: BOOLEAN_VECTOR) return BOOLEAN;
    function "xor" (anonymous: BOOLEAN_VECTOR) return BOOLEAN;
    function "xnor" (anonymous: BOOLEAN_VECTOR) return BOOLEAN;
    function "sll" (anonymous: BOOLEAN_VECTOR; anonymous1: INTEGER) return BOOLEAN_VECTOR;
    function "srl" (anonymous: BOOLEAN_VECTOR; anonymous1: INTEGER) return BOOLEAN_VECTOR;
    function "sla" (anonymous: BOOLEAN_VECTOR; anonymous1: INTEGER) return BOOLEAN_VECTOR;
    function "sra" (anonymous: BOOLEAN_VECTOR; anonymous1: INTEGER) return BOOLEAN_VECTOR;
    function "rol" (anonymous: BOOLEAN_VECTOR; anonymous1: INTEGER) return BOOLEAN_VECTOR;
    function "ror" (anonymous: BOOLEAN_VECTOR; anonymous1: INTEGER) return BOOLEAN_VECTOR;
    function "=" (anonymous, anonymous1: BOOLEAN_VECTOR) return BOOLEAN;
    function "/=" (anonymous, anonymous1: BOOLEAN_VECTOR) return BOOLEAN;
    function "<" (anonymous, anonymous1: BOOLEAN_VECTOR) return BOOLEAN;
    function "<=" (anonymous, anonymous1: BOOLEAN_VECTOR) return BOOLEAN;
    function ">" (anonymous, anonymous1: BOOLEAN_VECTOR) return BOOLEAN;
    function ">=" (anonymous, anonymous1: BOOLEAN_VECTOR) return BOOLEAN;
    function "?=" (anonymous, anonymous1: BOOLEAN_VECTOR) return BOOLEAN;
    function "?/=" (anonymous, anonymous1: BOOLEAN_VECTOR) return BOOLEAN;
    function "&" (anonymous: BOOLEAN_VECTOR; anonymous1: BOOLEAN_VECTOR) return BOOLEAN_VECTOR;
    function "&" (anonymous: BOOLEAN_VECTOR; anonymous1: BOOLEAN) return BOOLEAN_VECTOR;
    function "&" (anonymous: BOOLEAN; anonymous1: BOOLEAN_VECTOR) return BOOLEAN_VECTOR;
    function "&" (anonymous: BOOLEAN; anonymous1: BOOLEAN) return BOOLEAN_VECTOR;

    function minimum (l, r: boolean_vector) return boolean_vector;
    function maximum (l, r: boolean_vector) return boolean_vector;
    function minimum (l: boolean_vector) return boolean;
    function maximum (l: boolean_vector) return boolean;

    type bit_vector is array (natural range <>) of bit;
    function "and" (anonymous: BIT_VECTOR; anonymous1 : BIT) return BIT_VECTOR;
    function "and" (anonymous: BIT; anonymous1 : BIT_VECTOR) return BIT_VECTOR;
    function "or" (anonymous: BIT_VECTOR; anonymous1 : BIT) return BIT_VECTOR;
    function "or" (anonymous: BIT; anonymous1 : BIT_VECTOR) return BIT_VECTOR;
    function "nand" (anonymous: BIT_VECTOR; anonymous1 : BIT) return BIT_VECTOR;
    function "nand" (anonymous: BIT; anonymous1 : BIT_VECTOR) return BIT_VECTOR;
    function "nor" (anonymous: BIT_VECTOR; anonymous1 : BIT) return BIT_VECTOR;
    function "nor" (anonymous: BIT; anonymous1 : BIT_VECTOR) return BIT_VECTOR;
    function "xor" (anonymous: BIT_VECTOR; anonymous1 : BIT) return BIT_VECTOR;
    function "xor" (anonymous: BIT; anonymous1 : BIT_VECTOR) return BIT_VECTOR;
    function "xnor" (anonymous: BIT_VECTOR; anonymous1 : BIT) return BIT_VECTOR;
    function "xnor" (anonymous: BIT; anonymous1 : BIT_VECTOR) return BIT_VECTOR;
    function "and" (anonymous: BIT_VECTOR) return BIT;
    function "or" (anonymous: BIT_VECTOR) return BIT;
    function "nand" (anonymous: BIT_VECTOR) return BIT;
    function "nor" (anonymous: BIT_VECTOR) return BIT;
    function "xor" (anonymous: BIT_VECTOR) return BIT;
    function "xnor" (anonymous: BIT_VECTOR) return BIT;
    function "sll" (anonymous: BIT_VECTOR; anonymous1: INTEGER) return BIT_VECTOR;
    function "srl" (anonymous: BIT_VECTOR; anonymous1: INTEGER) return BIT_VECTOR;
    function "sla" (anonymous: BIT_VECTOR; anonymous1: INTEGER) return BIT_VECTOR;
    function "sra" (anonymous: BIT_VECTOR; anonymous1: INTEGER) return BIT_VECTOR;
    function "rol" (anonymous: BIT_VECTOR; anonymous1: INTEGER) return BIT_VECTOR;
    function "ror" (anonymous: BIT_VECTOR; anonymous1: INTEGER) return BIT_VECTOR;
    function "=" (anonymous, anonymous1: BIT_VECTOR) return BOOLEAN;
    function "/=" (anonymous, anonymous1: BIT_VECTOR) return BOOLEAN;
    function "<" (anonymous, anonymous1: BIT_VECTOR) return BOOLEAN;
    function "<=" (anonymous, anonymous1: BIT_VECTOR) return BOOLEAN;
    function ">" (anonymous, anonymous1: BIT_VECTOR) return BOOLEAN;
    function ">=" (anonymous, anonymous1: BIT_VECTOR) return BOOLEAN;
    function "?=" (anonymous, anonymous1: BIT_VECTOR) return BIT;
    function "?/=" (anonymous, anonymous1: BIT_VECTOR) return BIT;
    function "&" (anonymous: BIT_VECTOR; anonymous1: BIT_VECTOR) return BIT_VECTOR;
    function "&" (anonymous: BIT_VECTOR; anonymous1: BIT) return BIT_VECTOR;
    function "&" (anonymous: BIT; anonymous1: BIT_VECTOR) return BIT_VECTOR;
    function "&" (anonymous: BIT; anonymous1: BIT) return BIT_VECTOR;

    function minimum (l, r: bit_vector) return bit_vector;
    function maximum (l, r: bit_vector) return bit_vector;
    function minimum (l: bit_vector) return bit;
    function maximum (l: bit_vector) return bit;

    function to_string (value: bit_vector) return string;
    alias to_bstring is to_string [bit_vector return string];
    alias to_binary_string is to_string [bit_vector return string];

    function to_ostring (value: bit_vector) return string;
    alias to_octal_string is to_ostring [bit_vector return string];

    function to_hstring (value: bit_vector) return string;
    alias to_hex_string is to_hstring [bit_vector return string];

    type integer_vector is array (natural range <>) of integer;

    -- The predefined operations for this type are as follows:
    function "=" (anonymous, anonymous1: INTEGER_VECTOR) return BOOLEAN;
    function "/=" (anonymous, anonymous1: INTEGER_VECTOR) return BOOLEAN;
    function "<" (anonymous, anonymous1: INTEGER_VECTOR) return BOOLEAN;
    function "<=" (anonymous, anonymous1: INTEGER_VECTOR) return BOOLEAN;
    function ">" (anonymous, anonymous1: INTEGER_VECTOR) return BOOLEAN;
    function ">=" (anonymous, anonymous1: INTEGER_VECTOR) return BOOLEAN;
    function "&" (anonymous: INTEGER_VECTOR; anonymous1: INTEGER_VECTOR) return INTEGER_VECTOR;
    function "&" (anonymous: INTEGER_VECTOR; anonymous1: INTEGER) return INTEGER_VECTOR;
    function "&" (anonymous: INTEGER; anonymous1: INTEGER_VECTOR) return INTEGER_VECTOR;
    function "&" (anonymous: INTEGER; anonymous1: INTEGER) return INTEGER_VECTOR;

    function minimum (l, r: integer_vector) return integer_vector;
    function maximum (l, r: integer_vector) return integer_vector;
    function minimum (l: integer_vector) return integer;
    function maximum (l: integer_vector) return integer;

    type real_vector is array (natural range <>) of real;

    -- The predefined operations for this type are as follows:
    function "=" (anonymous, anonymous1: REAL_VECTOR) return BOOLEAN;
    function "/=" (anonymous, anonymous1: REAL_VECTOR) return BOOLEAN;
    function "&" (anonymous: REAL_VECTOR; anonymous1: REAL_VECTOR) return REAL_VECTOR;
    function "&" (anonymous: REAL_VECTOR; anonymous1: REAL) return REAL_VECTOR;
    function "&" (anonymous: REAL; anonymous1: REAL_VECTOR) return REAL_VECTOR;
    function "&" (anonymous: REAL; anonymous1: REAL) return REAL_VECTOR;

    function minimum (l: real_vector) return real;
    function maximum (l: real_vector) return real;

    type time_vector is array (natural range <>) of time;

    -- The predefined operations for this type are as follows:
    function "=" (anonymous, anonymous1: TIME_VECTOR) return BOOLEAN;
    function "/=" (anonymous, anonymous1: TIME_VECTOR) return BOOLEAN;
    function "&" (anonymous: TIME_VECTOR; anonymous1: TIME_VECTOR) return TIME_VECTOR;
    function "&" (anonymous: TIME_VECTOR; anonymous1: TIME) return TIME_VECTOR;
    function "&" (anonymous: TIME; anonymous1: TIME_VECTOR) return TIME_VECTOR;
    function "&" (anonymous: TIME; anonymous1: TIME) return TIME_VECTOR;

    function minimum (l: time_vector) return time;
    function maximum (l: time_vector) return time;

    function minimum (l, r: file_open_kind) return file_open_kind;
    function maximum (l, r: file_open_kind) return file_open_kind;

    function minimum (l, r: file_open_status) return file_open_status;
    function maximum (l, r: file_open_status) return file_open_status;

    attribute foreign: string;

    function to_string (value: boolean) return string;
    function to_string (value: bit) return string;
    function to_string (value: character) return string;
    function to_string (value: severity_level) return string;
    function to_string (value: integer) return string;
    function to_string (value: real) return string;
    function to_string (value: time) return string;
    function to_string (value: file_open_kind) return string;
    function to_string (value: file_open_status) return string;

    -- predefined overloaded to_string operations
    function to_string (value: real; digits: natural) return string;
    function to_string (value: real; format: string) return string;
    function to_string (value: time; unit: time) return string;



    type DVT81b441bd_UNIVERSAL_INTEGER is range 0 to 0;
    type DVT81b441bd_UNIVERSAL_REAL is range 0.0 to 0.0;
    type DVT81b441bd_ANY_TYPE is range 0 to 0;
    type DVT81b441bd_ANY_ACCESS is access DVT81b441bd_ANY_TYPE;
    type DVT81b441bd_ANY_CHARACTER_TYPE is range 0 to 0;
    type DVT81b441bd_ANY_SCALAR_OR_ARRAY is range 0 to 0;
    type DVT81b441bd_ANY_ARRAY is array(integer range <>) of DVT81b441bd_ANY_TYPE;
    type DVT81b441bd_ANY_BOOLEAN_ARRAY is array(integer range <>) of boolean;
    type DVT81b441bd_ANY_BIT_ARRAY is array(integer range <>) of bit;
    type DVT81b441bd_ANY_FILE is file of DVT81b441bd_ANY_TYPE;
    
    function to_string (value: DVT81b441bd_ANY_TYPE) return string;
    
    -- The predefined operations for this type are as follows:
    function "=" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_INTEGER) return BOOLEAN;
    function "/=" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_INTEGER) return BOOLEAN;
    function "<" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_INTEGER) return BOOLEAN;
    function "<=" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_INTEGER) return BOOLEAN;
    function ">" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_INTEGER) return BOOLEAN;
    function ">=" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_INTEGER) return BOOLEAN;
    function "+" (anonymous: DVT81b441bd_UNIVERSAL_INTEGER) return DVT81b441bd_UNIVERSAL_INTEGER;
    function "-" (anonymous: DVT81b441bd_UNIVERSAL_INTEGER) return DVT81b441bd_UNIVERSAL_INTEGER;
    function "abs" (anonymous: DVT81b441bd_UNIVERSAL_INTEGER) return DVT81b441bd_UNIVERSAL_INTEGER;
    function "+" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_INTEGER) return DVT81b441bd_UNIVERSAL_INTEGER;
    function "-" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_INTEGER) return DVT81b441bd_UNIVERSAL_INTEGER;
    function "*" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_INTEGER) return DVT81b441bd_UNIVERSAL_INTEGER;
    function "/" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_INTEGER) return DVT81b441bd_UNIVERSAL_INTEGER;
    function "mod" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_INTEGER) return DVT81b441bd_UNIVERSAL_INTEGER;
    function "rem" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_INTEGER) return DVT81b441bd_UNIVERSAL_INTEGER;


    -- The predefined operations for this type are as follows:
    function "=" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_REAL) return BOOLEAN;
    function "/=" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_REAL) return BOOLEAN;
    function "<" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_REAL) return BOOLEAN;
    function "<=" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_REAL) return BOOLEAN;
    function ">" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_REAL) return BOOLEAN;
    function ">=" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_REAL) return BOOLEAN;
    function "+" (anonymous: DVT81b441bd_UNIVERSAL_REAL) return DVT81b441bd_UNIVERSAL_REAL;
    function "-" (anonymous: DVT81b441bd_UNIVERSAL_REAL) return DVT81b441bd_UNIVERSAL_REAL;
    function "abs" (anonymous: DVT81b441bd_UNIVERSAL_REAL) return DVT81b441bd_UNIVERSAL_REAL;
    function "+" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_REAL) return DVT81b441bd_UNIVERSAL_REAL;
    function "-" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_REAL) return DVT81b441bd_UNIVERSAL_REAL;
    function "*" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_REAL) return DVT81b441bd_UNIVERSAL_REAL;
    function "/" (anonymous, anonymous1: DVT81b441bd_UNIVERSAL_REAL) return DVT81b441bd_UNIVERSAL_REAL;
    function "*" (anonymous: REAL; anonymous1: INTEGER) return REAL;
    function "*" (anonymous: INTEGER; anonymous1: REAL) return REAL;
    function "/" (anonymous: REAL; anonymous1: INTEGER) return REAL;

    function "**" (anonymous: DVT81b441bd_UNIVERSAL_INTEGER; anonymous1: INTEGER) return DVT81b441bd_UNIVERSAL_INTEGER;
    function "**" (anonymous: DVT81b441bd_UNIVERSAL_REAL; anonymous1: INTEGER) return DVT81b441bd_UNIVERSAL_REAL;

    type DVT81b441bd_ANY_PHYSICAL is range INTEGER'LOW to INTEGER'HIGH
    units
        DVT81b441bd_ANY_PHYSICAL_FS; --femtosecond
        DVT81b441bd_ANY_PHYSICAL_PS = 10 DVT81b441bd_ANY_PHYSICAL_FS; --picosecond
    end units;
    -- The predefined operations for this type are as follows:
    function "=" (anonymous, anonymous1: DVT81b441bd_ANY_PHYSICAL) return BOOLEAN;
    function "/=" (anonymous, anonymous1: DVT81b441bd_ANY_PHYSICAL) return BOOLEAN;
    function "<" (anonymous, anonymous1: DVT81b441bd_ANY_PHYSICAL) return BOOLEAN;
    function "<=" (anonymous, anonymous1: DVT81b441bd_ANY_PHYSICAL) return BOOLEAN;
    function ">" (anonymous, anonymous1: DVT81b441bd_ANY_PHYSICAL) return BOOLEAN;
    function ">=" (anonymous, anonymous1: DVT81b441bd_ANY_PHYSICAL) return BOOLEAN;
    function "+" (anonymous: DVT81b441bd_ANY_PHYSICAL) return DVT81b441bd_ANY_PHYSICAL;
    function "-" (anonymous: DVT81b441bd_ANY_PHYSICAL) return DVT81b441bd_ANY_PHYSICAL;
    function "abs" (anonymous: DVT81b441bd_ANY_PHYSICAL) return DVT81b441bd_ANY_PHYSICAL;
    function "+" (anonymous, anonymous1: DVT81b441bd_ANY_PHYSICAL) return DVT81b441bd_ANY_PHYSICAL;
    function "-" (anonymous, anonymous1: DVT81b441bd_ANY_PHYSICAL) return DVT81b441bd_ANY_PHYSICAL;
    function "*" (anonymous: DVT81b441bd_ANY_PHYSICAL; anonymous1: INTEGER) return DVT81b441bd_ANY_PHYSICAL;
    function "*" (anonymous: DVT81b441bd_ANY_PHYSICAL; anonymous1: REAL) return DVT81b441bd_ANY_PHYSICAL;
    function "*" (anonymous: INTEGER; anonymous1: DVT81b441bd_ANY_PHYSICAL) return DVT81b441bd_ANY_PHYSICAL;
    function "*" (anonymous: REAL; anonymous1: DVT81b441bd_ANY_PHYSICAL) return DVT81b441bd_ANY_PHYSICAL;
    function "/" (anonymous: DVT81b441bd_ANY_PHYSICAL; anonymous1: INTEGER) return DVT81b441bd_ANY_PHYSICAL;
    function "/" (anonymous: DVT81b441bd_ANY_PHYSICAL; anonymous1: REAL) return DVT81b441bd_ANY_PHYSICAL;
    function "/" (anonymous, anonymous1: DVT81b441bd_ANY_PHYSICAL) return DVT81b441bd_UNIVERSAL_INTEGER;
    function "mod" (anonymous, anonymous1: DVT81b441bd_ANY_PHYSICAL) return DVT81b441bd_ANY_PHYSICAL;
    function "rem" (anonymous, anonymous1: DVT81b441bd_ANY_PHYSICAL) return DVT81b441bd_ANY_PHYSICAL;

    -- 9.2.2 Functions defined for any one-dimensional array type whose element type is BOOLEAN.
    function "and" (anonymous, anonymous1: DVT81b441bd_ANY_BOOLEAN_ARRAY) return DVT81b441bd_ANY_BOOLEAN_ARRAY;
    function "or" (anonymous, anonymous1: DVT81b441bd_ANY_BOOLEAN_ARRAY) return DVT81b441bd_ANY_BOOLEAN_ARRAY;
    function "nand" (anonymous, anonymous1: DVT81b441bd_ANY_BOOLEAN_ARRAY) return DVT81b441bd_ANY_BOOLEAN_ARRAY;
    function "nor" (anonymous, anonymous1: DVT81b441bd_ANY_BOOLEAN_ARRAY) return DVT81b441bd_ANY_BOOLEAN_ARRAY;
    function "xor" (anonymous, anonymous1: DVT81b441bd_ANY_BOOLEAN_ARRAY) return DVT81b441bd_ANY_BOOLEAN_ARRAY;
    function "xnor" (anonymous, anonymous1: DVT81b441bd_ANY_BOOLEAN_ARRAY) return DVT81b441bd_ANY_BOOLEAN_ARRAY;
    function "not" (anonymous: DVT81b441bd_ANY_BOOLEAN_ARRAY) return DVT81b441bd_ANY_BOOLEAN_ARRAY;

    -- 9.2.2 Functions defined for any one-dimensional array type whose element type is BIT.
    function "and" (anonymous, anonymous1: DVT81b441bd_ANY_BIT_ARRAY) return DVT81b441bd_ANY_BIT_ARRAY;
    function "or" (anonymous, anonymous1: DVT81b441bd_ANY_BIT_ARRAY) return DVT81b441bd_ANY_BIT_ARRAY;
    function "nand" (anonymous, anonymous1: DVT81b441bd_ANY_BIT_ARRAY) return DVT81b441bd_ANY_BIT_ARRAY;
    function "nor" (anonymous, anonymous1: DVT81b441bd_ANY_BIT_ARRAY) return DVT81b441bd_ANY_BIT_ARRAY;
    function "xor" (anonymous, anonymous1: DVT81b441bd_ANY_BIT_ARRAY) return DVT81b441bd_ANY_BIT_ARRAY;
    function "xnor" (anonymous, anonymous1: DVT81b441bd_ANY_BIT_ARRAY) return DVT81b441bd_ANY_BIT_ARRAY;
    function "not" (anonymous: DVT81b441bd_ANY_BIT_ARRAY) return DVT81b441bd_ANY_BIT_ARRAY;


    /**
     *  File type operations(5.5.2)
     */
    procedure FILE_OPEN (file F: DVT81b441bd_ANY_FILE; External_Name: in STRING; Open_Kind: in FILE_OPEN_KIND := READ_MODE);
    procedure FILE_OPEN (Status: out FILE_OPEN_STATUS; file F: DVT81b441bd_ANY_FILE; External_Name: in STRING; Open_Kind: in FILE_OPEN_KIND := READ_MODE);
    procedure FILE_CLOSE (file F: DVT81b441bd_ANY_FILE);
    procedure READ (file F: DVT81b441bd_ANY_FILE; VALUE: out DVT81b441bd_ANY_TYPE);
    procedure WRITE (file F: DVT81b441bd_ANY_FILE; VALUE: in DVT81b441bd_ANY_TYPE);
    procedure FLUSH (file F: DVT81b441bd_ANY_FILE);
    function ENDFILE (file F: DVT81b441bd_ANY_FILE) return BOOLEAN;

    /**
     * Functions to provide universal operation
     */

    function "&" (anonymous, anonymous1 : DVT81b441bd_ANY_TYPE) return DVT81b441bd_ANY_TYPE;

    function "=" (anonymous, anonymous1 : DVT81b441bd_ANY_TYPE) return BOOLEAN;
    function "/=" (anonymous, anonymous1 : DVT81b441bd_ANY_TYPE) return BOOLEAN;

    function "<" (anonymous, anonymous1 : DVT81b441bd_ANY_SCALAR_OR_ARRAY) return BOOLEAN;
    function "<=" (anonymous, anonymous1 : DVT81b441bd_ANY_SCALAR_OR_ARRAY) return BOOLEAN;
    function ">" (anonymous, anonymous1 : DVT81b441bd_ANY_SCALAR_OR_ARRAY) return BOOLEAN;
    function ">=" (anonymous, anonymous1 : DVT81b441bd_ANY_SCALAR_OR_ARRAY) return BOOLEAN;

    procedure deallocate(P: inout DVT81b441bd_ANY_ACCESS);

end package standard;

use std.standard.all;
package textio is

-- a line is a pointer to a string value
    type line is access string;

-- The predefined operations for this type are as follows:
    function "=" (anonymous, anonymous1: LINE) return BOOLEAN;
    function "/=" (anonymous, anonymous1: LINE) return BOOLEAN;

-- a file of variable-length ASCII records
    type text is file of string;

    procedure READ (file F: TEXT; VALUE: out STRING);
    procedure WRITE (file F: TEXT; VALUE: in STRING);
    procedure FLUSH (file F: TEXT);
    function ENDFILE (file F: TEXT) return BOOLEAN;

-- for justifying output data within fields
    type side is (RIGHT, LEFT);

-- The predefined operations for this type are as follows:
    function "=" (anonymous, anonymous1: SIDE) return BOOLEAN;
    function "/=" (anonymous, anonymous1: SIDE) return BOOLEAN;
    function "<" (anonymous, anonymous1: SIDE) return BOOLEAN;
    function "<=" (anonymous, anonymous1: SIDE) return BOOLEAN;
    function ">" (anonymous, anonymous1: SIDE) return BOOLEAN;
    function ">=" (anonymous, anonymous1: SIDE) return BOOLEAN;
    function MINIMUM (L, R: SIDE) return SIDE;
    function MAXIMUM (L, R: SIDE) return SIDE;
    function TO_STRING (VALUE: SIDE) return STRING;

-- for specifying widths of output fields
    subtype width is natural;

--standard input file
    file input: text open READ_MODE is "STD_INPUT";

    --standard output file
    file output: text open WRITE_MODE is "STD_OUTPUT";

--read one line and return it
    procedure readline (file f: text; l: inout line);

-- Read procedure for string
    procedure sread(l: inout line; value: out string; strlen: out natural);

-- Read procedure for string (alias sread)
    procedure string_read(l: inout line; value: out string; strlen: out natural);

    procedure read (l: inout line; value: out bit; good: out boolean);
    procedure read (l: inout line; value: out bit);

    procedure read (l: inout line; value: out bit_vector; good: out boolean);
    procedure read (l: inout line; value: out bit_vector);

    procedure read (l: inout line; value: out boolean; good: out boolean);
    procedure read (l: inout line; value: out boolean);

    procedure read (l: inout line; value: out character; good: out boolean);
    procedure read (l: inout line; value: out character);

    procedure read (l: inout line; value: out integer; good: out boolean);
    procedure read (l: inout line; value: out integer);

    procedure read (l: inout line; value: out real; good: out boolean);
    procedure read (l: inout line; value: out real);

    procedure read (l: inout line; value: out string; good: out boolean);
    procedure read (l: inout line; value: out string);

    procedure read (l: inout line; value: out time; good: out boolean);
    procedure read (l: inout line; value: out time);

    alias bread is read [line, bit_vector, boolean];
    alias bread is read [line, bit_vector];
    alias binary_read is read [line, bit_vector, boolean];
    alias binary_read is read [line, bit_vector];

    procedure oread (l : inout line; value : out bit_vector; good : out boolean);
    procedure oread (l : inout line; value : out bit_vector);
    alias octal_read is oread [line, bit_vector, boolean];
    alias octal_read is oread [line, bit_vector];
    procedure hread (l : inout line; value : out bit_vector; good : out boolean);
    procedure hread (l : inout line; value : out bit_vector);
    alias hex_read is hread [line, bit_vector, boolean];
    alias hex_read is hread [line, bit_vector];

    procedure writeline (file f: text; l: inout line);

    procedure tee (file f :       text; l : inout line);

    procedure write (l: inout line; value: in bit; justified: in side := RIGHT; field: in width := 0);

    procedure write (l: inout line; value: in bit_vector; justified: in side := RIGHT; field: in width := 0);

    procedure write (l: inout line; value: in boolean; justified: in side := RIGHT; field: in width := 0);

    procedure write (l: inout line; value: in character; justified: in side := RIGHT; field: in width := 0);

    procedure write (l: inout line; value: in integer;justified: in side := RIGHT; field: in width := 0);

    procedure write (l: inout line; value: in real; justified: in side := RIGHT; field: in width := 0; digits: in natural := 0);

    procedure write (l: inout line; value: in string; justified: in side := RIGHT; field: in width := 0);

    procedure write (l: inout line; value: in time; justified: in side := RIGHT; field: in width := 0; unit: in time := ns);

    alias swrite is write [line, string, side, width];
    alias string_write is write [line, string, side, width];
    alias bwrite is write [line, bit_vector, side, width];
    alias binary_write is write [line, bit_vector, side, width];
    procedure owrite (l : inout line; value : in bit_vector; justified : in side := right; field : in width := 0);
    alias octal_write is owrite [line, bit_vector, side, width];
    procedure hwrite (l : inout line; value : in bit_vector; justified : in side := right; field : in width := 0);
    alias hex_write is hwrite [line, bit_vector, side, width];

    function endline (l: in line) return boolean;

    procedure file_open ( file f: text; external_name: in string; open_kind: in file_open_kind := read_mode);

    procedure file_open ( status: out file_open_status; file f: text; external_name: in string; open_kind: in file_open_kind := read_mode);

    procedure file_close (file f: text);

    procedure deallocate (p : inout line);

    function justify (value : string; justified : side := right; field: width := 0 ) return string;

end package textio;

use std.standard.all;
package env is
    procedure stop (status: integer);
    procedure stop;

    procedure finish (status: integer);
    procedure finish;

    function resolution_limit return delay_length;
end package env;
