#include "include/ucis.h"
#include <stdio.h>

char indentString[50];
char* computeIndent(int indent) {
    for (int i = 0; i < indent; i++) {
        indentString[i] = '\t';
    }
    indentString[indent] = '\0';

    return indentString;
}

ucisCBReturnT map_callback(void* userdata, ucisCBDataT* cbdata) {
    ucisCBReasonT reason = cbdata->reason;
    static int indent = 0;
    switch (reason) {
        case UCIS_REASON_DU:
            printf("%sDU: %s \n", computeIndent(indent), ucis_GetStringProperty(cbdata->db, cbdata->obj, -1, UCIS_STR_SCOPE_HIER_NAME));
            indent++;
            break;
        case UCIS_REASON_SCOPE:
            printf("%sSTART SCOPE: %s \n", computeIndent(indent), ucis_GetStringProperty(cbdata->db, cbdata->obj, -1, UCIS_STR_SCOPE_HIER_NAME));
            ucisScopeTypeT scopeType = ucis_GetScopeType(cbdata->db, cbdata->obj);
            if (scopeType == UCIS_CROSS) {
                printf("CROSS_\n");
                int nofcvps = ucis_GetIntProperty(cbdata->db, cbdata->obj, cbdata->coverindex, UCIS_INT_NUM_CROSSED_CVPS);
                printf("Number of CVPS: %d\n", nofcvps);

                for (int i = 0; i < nofcvps; i++) {
                    ucisScopeT coverpoint_scope;

                    if (ucis_GetIthCrossedCvp(cbdata->db, (ucisScopeT)cbdata->obj, i, &coverpoint_scope) == 0)
                    {
                        const char* cp_name = ucis_GetStringProperty(cbdata->db, (ucisObjT)coverpoint_scope, -1, UCIS_STR_SCOPE_NAME);
                        printf("\t\tCVP NAME: %s\n", cp_name);
                    }
                }
            }
            indent++;
            break;
        case UCIS_REASON_ENDSCOPE:
            indent--;
            printf("%sEND SCOPE: %s\n", computeIndent(indent), ucis_GetStringProperty(cbdata->db, cbdata->obj, -1, UCIS_STR_SCOPE_HIER_NAME));
            break;
        case UCIS_REASON_CVBIN:
            ucisScopeT scope = (ucisScopeT) (cbdata->obj);
            char* name;
            ucisCoverDataT coverdata;
            ucisSourceInfoT sourceinfo;

            // printf("%sSTART SCOPE: %s \n", computeIndent(indent), ucis_GetStringProperty(cbdata->db, cbdata->obj, -1, UCIS_STR_SCOPE_HIER_NAME));
            // ucis_GetCoverData(cbdata->db, scope, cbdata->coverindex, &name, &coverdata, &sourceinfo);
           
            // printf("%s==============BIN===============\n", computeIndent(indent));
            // indent++;
            // printf("%sname: %s\n", computeIndent(indent), name);
            // printf("%scoverdata->type: %d\n", computeIndent(indent), coverdata.type);
            // printf("%scoverdata->data: %d\n", computeIndent(indent), coverdata.data);
            // indent--;
            break;
        default:
    }
    // printf("\n\n REASON: %d \n", reason);
    // printf(" HSTRING: %s \n", ucis_GetStringProperty(cbdata->db, cbdata->obj, -1, UCIS_STR_SCOPE_HIER_NAME));
    return UCIS_SCAN_CONTINUE;
}

int main() {

    const char* dbName = "coverage.db";
    ucisT ucisDb = ucis_Open(dbName);

    void* data;
    ucis_CallBack(ucisDb, NULL, map_callback, data);
    return 0;
}