#include <dvt_ucis.h>
#include <iostream>

using namespace std;

ucisT ucis_Open(const char *name) {
    sqlite3 *db;

    int rc = sqlite3_open(name, &db);
    if (rc) {
        cout << "Can't open database: " <<  sqlite3_errmsg(db) << endl;
        return NULL;
    }

    return db;
}

int ucis_Close(ucisT db) {
    sqlite3 *sqliteDb = (sqlite3*) db;

    int rc = sqlite3_close(sqliteDb);
    if (rc) {
        cout << "Can't close database: " <<  sqlite3_errmsg(sqliteDb) << endl;
        return -1;
    }

    return 0;
}

void iterate_modules(sqlite3 *db, ucis_CBFuncT cbfunc, void *userdata) {
    ucisCBDataT *cbdata = new ucisCBDataT;
    cbdata->db = db;
    
    // iterate through modules
    vector<module*>* modules = module::get_all_modules(db);

    for (module* module_type : *modules) {
        cbdata->obj = static_cast<ucisObjT>(module_type);
        // start_scope
        cbdata->reason = UCIS_REASON_SCOPE;
        cbfunc(userdata, cbdata);

        // end_scope
        cbdata->reason = UCIS_REASON_ENDSCOPE;
        cbfunc(userdata, cbdata);
        delete module_type;
    }

    delete cbdata;
}

void iterate_bins(sqlite3 *db, ucis_CBFuncT cbfunc, void *userdata, coverpoint_instance* instance) {
    ucisCBDataT *cbdata = new ucisCBDataT;
    cbdata->db = db;
    cbdata->reason = UCIS_REASON_CVBIN;

    vector<bin_instance*>* bins = bin_instance::get_all_bins_from_cp_instance(db, instance);
    for (bin_instance* bin : *bins) {
        cbdata->obj = static_cast<ucisObjT>(bin);

        cbdata->coverindex = bin->id;
        cbfunc(userdata, cbdata);

        delete bin;
    }

    delete cbdata;
}

void iterate_coverpoint_instances(sqlite3 *db, ucis_CBFuncT cbfunc, void *userdata, covergroup_instance* instance) {
    ucisCBDataT *cbdata = new ucisCBDataT;
    cbdata->db = db;
    
    vector<coverpoint_instance*>* cp_instances = coverpoint_instance::get_all_cp_instances_from_cg_instance(db, instance);

    for (coverpoint_instance* cp_instance : *cp_instances) {
        cbdata->obj = static_cast<ucisObjT>(cp_instance);
        // start_scope
        cbdata->reason = UCIS_REASON_SCOPE;
        cbfunc(userdata, cbdata);

        iterate_bins(db, cbfunc, userdata, cp_instance);
        
        // end_scope
        cbdata->reason = UCIS_REASON_ENDSCOPE;
        cbfunc(userdata, cbdata);

        delete cp_instance;
    }

    delete cbdata;
}

void iterate_covergroup_instances(sqlite3 *db, ucis_CBFuncT cbfunc, void *userdata, module_instance* instance) {
    ucisCBDataT *cbdata = new ucisCBDataT;
    cbdata->db = db;
    
    vector<covergroup_instance*>* cg_instances = covergroup_instance::get_all_cg_instances_from_instance(db, instance);

    for (covergroup_instance* cg_instance : *cg_instances) {
        cbdata->obj = static_cast<ucisObjT>(cg_instance);
        // start_scope
        cbdata->reason = UCIS_REASON_SCOPE;
        cbfunc(userdata, cbdata);

        iterate_coverpoint_instances(db, cbfunc, userdata, cg_instance);
        
        // end_scope
        cbdata->reason = UCIS_REASON_ENDSCOPE;
        cbfunc(userdata, cbdata);
        delete cg_instance;
    }

    delete cbdata;
}

void iterate_module_instances(sqlite3 *db, ucis_CBFuncT cbfunc, void *userdata) {    
    vector<module_instance*>* instances = module_instance::get_all_instances(db);

    for (module_instance* instance : *instances) {
        iterate_covergroup_instances(db, cbfunc, userdata, instance);
        delete instance;
    }
}

int ucis_CallBack(ucisT db, ucisScopeT start, ucis_CBFuncT cbfunc, void *userdata)
{
    sqlite3 *sqliteDb = (sqlite3 *)db;
    if (start != NULL)
        return 0;

    // iterate_modules(sqliteDb, cbfunc, userdata);
    ucisCBDataT *cbdata = new ucisCBDataT;
    cbdata->reason = UCIS_REASON_INITDB;
    cbfunc(userdata, cbdata);

    iterate_module_instances(sqliteDb, cbfunc, userdata);

    cbdata->reason = UCIS_REASON_ENDDB;
    cbfunc(userdata, cbdata);
    return 0;
}

const char *ucis_GetStringProperty(ucisT db, ucisObjT obj, int coverindex, ucisStringPropertyEnumT property)
{
    sqlite3 *sqlDb = (sqlite3 *)db;
    entity *element = (entity *)obj;

    string* strProp = element->get_string_property(property);
    
    return strProp == NULL ? NULL : strProp->c_str();
}

ucisScopeTypeT ucis_GetScopeType(ucisT db, ucisScopeT scope) {
    entity *element = static_cast<entity*>(scope);
    return element->get_scope_type();
}

int ucis_GetIntProperty(ucisT db, ucisObjT obj, int coverindex, ucisIntPropertyEnumT property) {
    entity* element = static_cast<entity*>(obj);
    coverpoint_instance* cpInstance;
    switch (property)
    {
    case UCIS_INT_NUM_CROSSED_CVPS:

        if (element->type != CROSS_INSTANCE)    
            return -1;

        cpInstance = (coverpoint_instance*) element;
        if (!cpInstance->cp_type->isCross)
            return -1;

        if (cpInstance->cross_items == NULL)
            cpInstance->init_cross_items((sqlite3*) db);

        return cpInstance->cross_items->size();
    default:
        break;
    }

    return -1;
}

int ucis_GetIthCrossedCvp(ucisT db, ucisScopeT scope, int index, ucisScopeT* point_scope) {
    entity* element = static_cast<entity*>(scope);

    if (element->type != CROSS_INSTANCE)    
        return -1;

    coverpoint_instance* cpInstance = (coverpoint_instance*) element;
    if (!cpInstance->cp_type->isCross)
        return -1;

    if (cpInstance->cross_items == NULL)
        cpInstance->init_cross_items((sqlite3*) db);

    *point_scope = (ucisScopeT) (*(cpInstance->cross_items))[index];
    
    return 0;
}

int ucis_GetCoverData(ucisT db, ucisScopeT parent, int coverindex, char **name, ucisCoverDataT *data, ucisSourceInfoT *sourceinfo)
{
    // ignore sourceInfo for the moment
    entity *element = static_cast<entity*>(parent);

    bin_instance* bin = NULL;
    if (element->type == BIN_INSTANCE) {
        bin = (bin_instance*) element;
    } else if (element->type == COVERPOINT_INSTANCE) {
        coverpoint_instance *cp_inst = (coverpoint_instance*) element;
        bin = bin_instance::get_bin_from_id((sqlite3*) db, coverindex);
        bin->cp_instance = cp_inst;
    } else {
        return 0;
    }

    *name = new char[bin->name.length() + 1];
    strcpy(*name, bin->name.c_str());

    data->data.int32 = (uint32_t) bin->hitCount;
    data->type = bin->ucisBinType;

    return 0;
}

int ucis_GetScopeSourceInfo(ucisT db, ucisScopeT scope, ucisSourceInfoT* sourceinfo) { return -1; }
void ucis_RegisterErrorHandler(ucis_ErrorHandler errHandle, void *userdata) {}
const char *ucis_GetFileName(ucisT db, ucisFileHandleT filehandle) { return NULL; }