const path = require('path');

module.exports = {
  mode: 'development',
  entry: './main.js',
  devServer: {
    static: path.join(__dirname, './'),
    port: 8888,
    open: true,
  },
  output: {
    filename: 'lexical.js',
    path: __dirname
  },
  module: {
    rules: [
      {
        test: /\.js$/,
        exclude: /node_modules/,
        use: {
          loader: 'babel-loader',
          options: { presets: ['@babel/preset-env'] },
        },
      },
      {
        test: /\.css$/i,
        use: ['style-loader', 'css-loader'],
      },
    ],
  },
  resolve: {
    extensions: ['.js'],
  },
};