require("@babel/polyfill");

const marked = require("marked");
const admonition = require("marked-admonition-extension");

function parse(comment, hasAdmonitions) {
	marked.use({
      headerIds: false,
      mangle: false
    });
    
    if (hasAdmonitions)
        marked.use(admonition.default);
    
    if (typeof comment === 'string') {
		return marked.parse(comment);
	}
	
	return '';
}

module.exports = {parse}
