#!/bin/bash

export PATH=$PATH:~/store/releng/ro.amiq.dvt.releng.binary.v52/node/16.13.1/node/bin/

echo "[1] Installing dependencies ..."
echo -e "\t babel ..."      && npm install --save-dev @babel/core @babel/cli @babel/preset-env @babel/polyfill > /dev/null 2>&1
echo -e "\t marked ..."   && npm install --save-dev marked              > /dev/null 2>&1
echo -e "\t marked-admonition-extension ..." && npm install --save-dev marked-admonition-extension  > /dev/null 2>&1
echo -e "\t browserify ..." && npm install --save-dev browserify             > /dev/null 2>&1

echo "[2] Browserify DVT custom source code ..."
node_modules/.bin/browserify custom.js --standalone dvt --outfile browserify_custom.js

echo "[3] From ECMA6 to ECMA5 ..."
node_modules/@babel/cli/bin/babel.js browserify_custom.js --out-file marked.dvt.rhino.js --presets=@babel/preset-env --source-type script --config-file ./babel.config.json

# Rhino doesn't seem to have support for 'u' flag when creating a RegExp
# https://github.com/mozilla/rhino/issues/958
match="opt = opt || '';"
insert="opt = opt.replace('u','');"

sed -i "s/$match/$match $insert/" marked.dvt.rhino.js 
