document.addEventListener('DOMContentLoaded', function () {
	
	document.querySelectorAll('a.a_wrapper').forEach(a => {
	  const root = document.documentElement.dataset.content_root;
	  const href = a.getAttribute('href');

	  if (!root || !href) return;

	  a.href = `${root}/${href}`;
	});

    if (document.getElementsByClassName('diagram') !== null) {
        var diagrams = document.getElementsByClassName('diagram');

        for (var i = 0; i < diagrams.length; i++) {
            if (diagrams[i].classList.contains("fsm") || diagrams[i].classList.contains("custom")) {
                continue;
            }

            if (diagrams[i].getElementsByTagName('svg') == null || diagrams[i].getElementsByTagName('svg').length == 0) {
                continue;
            }

            svgPanZoom(diagrams[i].getElementsByTagName('svg')[0], {
                viewportSelector: 'svg > g',
                fit: true,
                center: true,
                dblClickZoomEnabled: false,
                mouseWheelZoomEnabled: false,
                zoomEnabled: false,
                panEnabled: false
            });
        }
    }

    if (document.getElementsByClassName('fsm') !== null) {
        var fsmContainers = document.getElementsByClassName('fsm')
        for (var i = 0; i < fsmContainers.length; i++) {
            let panZoom = svgPanZoom(fsmContainers[i].querySelector("svg"), {
                viewportSelector: 'svg > g',
                zoomEnabled: true,
                fit: true,
                center: true,
                dblClickZoomEnabled: false,
                mouseWheelZoomEnabled: false,
                panEnabled: true
            });
            panZoom.zoomOut();

            fsmContainers[i].querySelector('div > #zoom-in').addEventListener('click', function (ev) {
                ev.preventDefault()
                panZoom.zoomIn()
            });

            fsmContainers[i].querySelector('div > #zoom-out').addEventListener('click', function (ev) {
                ev.preventDefault()
                panZoom.zoomOut()
            });

            fsmContainers[i].querySelector('div > #zoom-reset').addEventListener('click', function (ev) {
                ev.preventDefault()
                panZoom.resetZoom()
                panZoom.center()
            });
        }
    }
    
	const commentDiv = document.querySelector('div.comment');
	if (commentDiv) {
		const tables = commentDiv.querySelectorAll('table');
		tables.forEach(table => {
			['docutils', 'align-default'].forEach(cls => {
				if (!table.classList.contains(cls)) {
					table.classList.add(cls);
				}
			});
		});
	}


}, false);



$(function () {
    $('svg rect[href]')
        .on("dblclick", function (e) {
            location.href = $(this).attr("href");
        })
        .on("mouseenter", function (e) {
            $(this).css("stroke", "red").css("stroke-width", "5").css("stroke-dasharray", "none");
        })
        .on("mouseleave", function (e) {
            $(this).css("stroke", "none").css("stroke-width", "0");
        });
    $('svg text').each(function () {
        const parentSVG = this.closest('svg');
        const prevRects = parentSVG.querySelectorAll('rect[href]');
        if (prevRects == null || prevRects.length == 0)
            return;

        let prevRect = null;
        for (const rect of prevRects) {
            const rectX = parseFloat(rect.getAttribute('x'));
            const textX = parseFloat(this.getAttribute('x'));
            const rectWidth = parseFloat(rect.getAttribute('width'));
            const rectY = parseFloat(rect.getAttribute('y'));
            const textY = parseFloat(this.getAttribute('y'));
            const rectHeight = parseFloat(rect.getAttribute('height'));
            if (textX >= rectX && textX <= (rectX + rectWidth) && textY >= rectY && textY <= (rectY + rectHeight)) {
                prevRect = rect;
            }
        }

        if (prevRect == null)
            return;

        $(this).on("dblclick", function (e) {
            location.href = $(prevRect).attr("href");
        })
        .on("mouseenter", function (e) {
            $(prevRect).css("stroke", "red").css("stroke-width", "5").css("stroke-dasharray", "none");
        })
        .on("mouseleave", function (e) {
            $(prevRect).css("stroke", "none").css("stroke-width", "0");
        });
    });
});

function isEmpty(str) {
    return (!str || 0 === str.length);
}

function textEquals(el, text) {
    var searchText = text.toUpperCase();
    var elementText = el.innerHTML.replace(/<\/?tspan>/gi, "").replace(/<rect[^>]*><\/rect>/gi, "");
    if (elementText.includes("<title>")) {
        elementText = elementText.substring(0, elementText.indexOf("<title>"));
    }
    var match = elementText.trim().toUpperCase().match("^" + searchText + "$");
    return match && match.length > 0;
}

$(window).on('load', function () {
    $('svg.WaveDrom > style').remove(); // this need removal as it breaks HTML styling of the page

    $('table[id*="fsm-table"] > tbody > tr').click(function () {
        $(this).parent().find('.selected').removeClass('selected');
        $(this).addClass("selected");

        $(this).parent().find('tr').each(function () {
            $(this).find('.current_state').removeClass('current_state');
            $(this).find('.future_state').removeClass('future_state');
        });

        var currentState = $(this).find("td:eq(1)").text();
        var nextState = $(this).find("td:eq(2)").text();

        var id = $(this).closest("table").attr('id');
        var index = id.substr(id.lastIndexOf('-') + 1)

        var svg = $(this).closest("section").find('svg')[index];
        svg.scrollIntoView();

        $(svg).find('text').each(function () {
            $(this).prev("rect").prev("rect").removeClass('next_state').removeClass('previous_state').removeClass('current_state');
            $(this).prev("rect").removeClass('next_state').removeClass('previous_state').removeClass('current_state');
        });

        var cells = [].slice.call(svg.getElementsByTagName('text'));

        if (!isEmpty(currentState)) {
            if ($(cells.find(el => textEquals(el, currentState))).prev("rect").hasClass("highlighted")) {
                $(cells.find(el => textEquals(el, currentState))).prev("rect").remove();
            }
            $(cells.find(el => textEquals(el, currentState))).prev("rect").addClass('current_state');
        }

        if (!isEmpty(nextState)) {
            if ($(cells.find(el => textEquals(el, nextState))).prev("rect").hasClass("highlighted")) {
                $(cells.find(el => textEquals(el, nextState))).prev("rect").remove();
            }
            $(cells.find(el => textEquals(el, nextState))).prev("rect").addClass('next_state');
        }

    })
});


jQuery.extend(jQuery.fn, {
    within: function (p) {
        return this.filter(function () {
            return $(p).find(this).length;
        });
    }
});


$(window).on('load', function () {

    $("text").within("svg").click(function () {
        svg = $(this).parent().parent().parent().get(0);
        section = $(svg).parent().parent().get(0);
        index = [].slice.call($(section).find('svg')).indexOf(svg);
        var nodeValue = this.innerHTML;
        if (nodeValue.includes("<title>")) {
            nodeValue = nodeValue.substring(0, nodeValue.indexOf("<title>"));
        }
        nodeValue = nodeValue.replace(/<rect[^>]*><\/rect>/gi, "").replace(/<\/?tspan>/gi, "").trim().toUpperCase();

        var cells = [].slice.call(svg.getElementsByTagName('text'));
        $(svg).find('text').each(function () {
            if ($(this).prev("rect").hasClass("highlighted"))
                $(this).prev("rect").prev("rect").removeClass('next_state').removeClass('previous_state').removeClass('current_state');
            else
                $(this).prev("rect").removeClass('next_state').removeClass('previous_state').removeClass('current_state');
        });

        if ($(this).prev("rect").hasClass("highlighted"))
            $(this).prev("rect").prev("rect").addClass('current_state');
        else
            $(this).prev("rect").addClass('current_state');

        $(svg).parent().parent().find('table[id*="fsm-table-' + index + '"] tr').each(function () {
            $(this).removeClass('selected');
            $(this).find('.current_state').removeClass('current_state');
            $(this).find('.future_state').removeClass('future_state');
            if ($(this).find('td:eq(0)').text().trim() == nodeValue) {
                $(this).trigger("click");
            }

            if ($(this).find('td:eq(1)').text().trim().toUpperCase() == nodeValue) {
                $(this).find('td:eq(1)').addClass("current_state");
                var nextState = $(this).find('td:eq(2)').text();
                if ($(cells.find(el => textEquals(el, nextState))).prev("rect").hasClass("highlighted")) {
                    $(cells.find(el => textEquals(el, nextState))).prev("rect").remove();
                }
                $(cells.find(el => textEquals(el, nextState))).prev("rect").addClass('next_state');
            }

            if ($(this).find('td:eq(2)').text().trim().toUpperCase() == nodeValue) {
                $(this).find('td:eq(2)').addClass("future_state");
                var prevState = $(this).find('td:eq(1)').text();
                if ($(cells.find(el => textEquals(el, prevState))).prev("rect").hasClass("highlighted")) {
                    $(cells.find(el => textEquals(el, prevState))).prev("rect").remove();
                }
                $(cells.find(el => textEquals(el, prevState))).prev("rect").addClass('previous_state');
            }
        });
    });

    $("svg").within("section#always-blocks").each(function () {
        $(this).css("cursor", "pointer");
    });
});

function expand(div, modal) {

    var modalImg = document.getElementById("img");
    if (div !== null) {
        var svg = div.getElementsByTagName("svg")[0];
        if (svg == null) {
            var imgElement = div.getElementsByTagName("img")[0];

            var svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");
            svg.setAttribute('width', imgElement.width);
            svg.setAttribute('height', imgElement.height);

            // Create an <image> element within the SVG
            var imageElement = document.createElementNS('http://www.w3.org/2000/svg', 'image');
            imageElement.setAttributeNS('http://www.w3.org/1999/xlink', 'href', imgElement.src);
            imageElement.setAttribute('width', imgElement.width);
            imageElement.setAttribute('height', imgElement.height);

            // Append <image> element to the SVG
            svg.appendChild(imageElement);
        }

        var button = div.getElementsByClassName("hover-button")[0];
        button.onclick = function () {
            modal.style.display = "block";
            modalImg.innerHTML = svg.outerHTML;

            if (document.getElementById('myModal') !== null) {
                var panZoomTiger = svgPanZoom('#myModal svg', {
                    viewportSelector: 'svg > g',
                    zoomEnabled: true,
                    controlIconsEnabled: true,
                    fit: true,
                    center: true,
                    dblClickZoomEnabled: false,
                    mouseWheelZoomEnabled: true
                });
                panZoomTiger.zoomOut()


            }

            $(function () {
                $('svg rect[href]')
                    .on("dblclick", function (e) {
                        location.href = $(this).attr("href");
                    })
                    .on("mouseenter", function (e) {
                        $(this).css("stroke", "red").css("stroke-width", "5").css("stroke-dasharray", "none");
                    })
                    .on("mouseleave", function (e) {
                        $(this).css("stroke", "none").css("stroke-width", "0");
                    });
                $('svg text').each(function () {
                    const parentSVG = this.closest('svg');
                    const prevRects = parentSVG.querySelectorAll('rect[href]');
                    if (prevRects == null || prevRects.length == 0)
                        return;

                    let prevRect = null;
                    for (const rect of prevRects) {
                        const rectX = parseFloat(rect.getAttribute('x'));
                        const textX = parseFloat(this.getAttribute('x'));
                        const rectWidth = parseFloat(rect.getAttribute('width'));
                        const rectY = parseFloat(rect.getAttribute('y'));
                        const textY = parseFloat(this.getAttribute('y'));
                        const rectHeight = parseFloat(rect.getAttribute('height'));
                        if (textX >= rectX && textX <= (rectX + rectWidth) && textY >= rectY && textY <= (rectY + rectHeight)) {
                            prevRect = rect;
                        }
                    }

                    if (prevRect == null)
                        return;

                    $(this).on("dblclick", function (e) {
                        location.href = $(prevRect).attr("href");
                    })
                    .on("mouseenter", function (e) {
                        $(prevRect).css("stroke", "red").css("stroke-width", "5").css("stroke-dasharray", "none");
                    })
                    .on("mouseleave", function (e) {
                        $(prevRect).css("stroke", "none").css("stroke-width", "0");
                    });
                });
            });
        }
    }
}

$(document).ready(function () {
    // Get the modal
    var modal = document.getElementById("myModal");

    // Get the image and insert it inside the modal - use its "alt" text as a caption

    var diagrams = document.getElementsByClassName("diagram");
    for (var i = 0; i < diagrams.length; i++) {
        if (!diagrams[i].classList.contains("block") && !diagrams[i].classList.contains("fsm") && !diagrams[i].classList.contains("entity"))
            expand(diagrams[i], modal);
    }

    // Get the <span> element that closes the modal
    var span = document.getElementsByClassName("close")[0];

    // When the user clicks on <span> (x), close the modal
    span.onclick = function () {
        modal.style.display = "none";
    }

    $(document).keyup(function (e) {
        if (e.key === "Escape") {
            modal.style.display = "none";
        }
    });

});

$(document).ready(function () {
    var codeLinks = document.getElementsByClassName("code-link");
    for (var i = 0; i < codeLinks.length; i++) {
        var link = codeLinks[i].innerHTML;
        var header = codeLinks[i].closest(".container").querySelector("dl > dt");
        header.innerHTML += link;
    }

    var qualifiers = document.getElementsByClassName("qualifiers");
    for (var i = 0; i < qualifiers.length; i++) {
        var qualifier = qualifiers[i].innerHTML;
        var header = qualifiers[i].closest(".container").querySelector("dl > dt");
        header.innerHTML = qualifier + header.innerHTML;
    }

});

$(document).ready(fixMarkdownAdmonitions);

function fixMarkdownAdmonitions() {
    // Get the modal
    const admonitions = document.querySelectorAll('[class^="admonition admonition-');

    admonitions.forEach(admonition => {
        const classes = Array.from(admonition.classList).filter(cls => cls.match(/^admonition-/));
        classes.forEach(cls => {
            admonition.classList.remove(cls);
            admonition.classList.add(cls.replace('admonition-', ''));
        })
    })
}

function switchLayout() {
    var button = document.getElementById("specador-layout-btn");
    var spanElement = button.querySelector("span");
    var divElement = document.querySelector(".wy-nav-content");

    if (button.title === "Maximum width") {
        button.title = "Original width";
        spanElement.classList.remove("fa-expand");
        spanElement.classList.add("fa-compress");
        divElement.style.width = "auto";
        window.name = "full-width";
    } else {
        button.title = "Maximum width";
        spanElement.classList.remove("fa-compress");
        spanElement.classList.add("fa-expand");
        divElement.style.width = "1000px";
        window.name = "";
    }
    var fsmContainers = document.getElementsByClassName('fsm')
    for (var i = 0; i < fsmContainers.length; i++) {
        let panZoom = svgPanZoom(fsmContainers[i].querySelector("svg"), {
            viewportSelector: 'svg > g',
            zoomEnabled: true,
            fit: true,
            center: true,
            dblClickZoomEnabled: false,
            mouseWheelZoomEnabled: false,
            panEnabled: true
        });
        panZoom.resize();
        panZoom.fit();
        panZoom.center();
        panzoom.zoomOut();
}
}

$(document).ready(function () {

    if (window.name === "full-width") {
        switchLayout();
    }

    const blockDiagram = document.querySelector(".block");
    if (blockDiagram !== null) {
        const copyButton = blockDiagram.querySelector(".hover-button") || null;
        if (copyButton) {
            copyButton.onclick = function () {
                var copyText = blockDiagram.getElementsByClassName("copyText")[0].innerHTML;
    
                // Copy the text inside the text field
                navigator.clipboard.writeText(copyText);
    
                var image = copyButton.getElementsByTagName("span")[0];
                image.classList.remove("fa-clone");
                image.classList.add("fa-check");
    
                setTimeout(function () {
                    image.classList.remove("fa-check");
                    image.classList.add("fa-clone");
                }, 1500);
            };
        }
    }
});

document.addEventListener('DOMContentLoaded',function () {
    const button = document.getElementById("scroll-top-btn");
    window.onscroll = function() {
        if (document.body.scrollTop > 50 || document.documentElement.scrollTop > 50) {
            button.style.display = 'block';
        } else {
            button.style.display = 'none';
        }
    };
});

var generated_date = ''

$(document).ready(function () {

	$('footer').html(function(index, currentHtml) {
		if (generated_date)
			return currentHtml + 'Last updated on ' + generated_date + '.';
		return currentHtml;
	});
});
