require("@babel/polyfill");

var json5 = require("json5");
var onml = require("onml");
var skins = _extends({}, require("wavedrom/skins/default.js"));
var renderAny = require("wavedrom/lib/render-any.js");
var cheerio = require("cheerio");

function _extends() {
  _extends =
    Object.assign ||
    function (target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i];
        for (var key in source) {
          if (Object.prototype.hasOwnProperty.call(source, key)) {
            target[key] = source[key];
          }
        }
      }
      return target;
    };
  return _extends.apply(this, arguments);
}

const DVT_DARK_STYLESHEET = '.dark-mode svg{background:#262626} .dark-mode .s6,.dark-mode g[id^=\"wavelane_draw\"]>text>tspan,.dark-mode text,.dark-mode tspan.h6{fill:#FFFFFF}.dark-mode .s5,.dark-mode g[id^=\"wavearcs\"] text{fill:#000000}.dark-mode .s1,.dark-mode line,.dark-mode path.s1,.dark-mode path.s2,.s2{stroke:#FFFFFF}.dark-mode .s3,.s4{stroke:#FFFFFF;color:#fff}.dark-mode .s7{fill:#000000;color:#fff}.dark-mode .s8{fill:#00004B;color:#fff}.dark-mode .s9{fill:#001F46;color:#fff}.dark-mode .s10{fill:#461F00;color:#fff}.dark-mode .s11{fill:#330201;color:#fff}.dark-mode .s12{fill:#32023A;color:#fff}.dark-mode .s13{fill:#0F3E04;color:#fff}.dark-mode .s14{fill:#0A3D3F;color:#fff}.dark-mode .s15,.dark-mode .s16{fill:#FFBE3B}.dark-mode tspan.error{fill:#F60000}.dark-mode tspan.warning{fill:#F6B900}.dark-mode .info{fill:#0099D0}.dark-mode tspan.success{fill:#00AB00} .dark-mode rect:not([field]){stroke: #fff !important;} .dark-mode g[id^=\"waves\"] rect:not([field]){fill:none !important; stroke: none !important; stroke-opacity:0 !important;}';
const VSCODE_DARK_STYLESHEET = '.s1,.s2,.s3,.s4,line,path.s1,path.s2{stroke:var(--vscode-editor-foreground,#FFFFFF)!important}.s3,.s4,.s7{color:var(--vscode-editor-foreground,#fff)!important}div[id^=\"diagram-div\"] svg{width:100%;height:100%;background:var(--vscode-editor-background,#000)!important}div.wavedrom,div.wavedrom-register{background-color:var(--vscode-editor-background,#000)}.s6,text,tspan.h6{fill:var(--vscode-editor-foreground,#FFFFFF)!important}.s5,.s7{fill:var(--vscode-editor-background,#000000)!important}.s10,.s11,.s12,.s13,.s14,.s8,.s9{color:var(--vscode-editor-foreground,#fff)}.s8{fill:#00004B}.s9{fill:#001F46}.s10{fill:#461F00}.s11{fill:#330201}.s12{fill:#32023A}.s13{fill:#0F3E04}.s14{fill:#0A3D3F}.s15,.s16{fill:#FFBE3B}tspan.error{fill:#F60000}tspan.warning{fill:#F6B900}.info{fill:#0099D0}tspan.success{fill:#00AB00}g[id^=\"wavelane_draw\"]>text>tspan{fill:var(--vscode-editor-foreground,#FFFFFF)} rect:not([field]){stroke: #fff !important;} g[id^=\"waves\"] rect:not([field]){fill:none !important; stroke: none !important; stroke-opacity:0 !important;}';
const VSCODE_LIGHT_STYLESHEET = '.s1,.s2,.s3,.s4,line,path.s1,path.s2{stroke:var(--vscode-editor-foreground,#000000)!important}div[id^=\"diagram-div\"] svg{width:100%;height:100%;background:var(--vscode-editor-background,#fff)!important}.s6,text,tspan.h6{fill:var(--vscode-editor-foreground,#000000)!important}.s5,.s7{fill:var(--vscode-editor-background,#FFFFFF)!important}.s3,.s4{color:var(--vscode-editor-background,#fff)!important}.s7{color:var(--vscode-editor-foreground,#000)!important}';
const BITFIELD_STYLESHEET = 'div,table{border-collapse:collapse;border:hidden;font-family:sans-serif}div{color:#000;text-anchor:middle;font-size:14px;font-weight:400}div.dark-mode{color:#FFF;} .dark-mode div{color:#FFF;}thead>tr{background-color: hsla(290, 89%, 7%, 0.1);text-align: left;}.dark-mode thead>tr{background-color:#1f1d1f}td,th{padding:1px;max-width: 0;overflow: hidden;text-overflow: ellipsis;white-space: nowrap;}tr{border-bottom:1px solid hsla(156,12%,59%,.1)}tr:nth-of-type(2n){background-color:hsla(156,12%,59%,.1)} tr:last-of-type{border-bottom:2px solid hsla(290,89%,7%,.1)}tbody>tr:hover{font-weight:bold}tbody>tr.select{color:#009879; font-weight:bold} rect.select{stroke:black; stroke-width:3;} .dark-mode rect.select{stroke:white; stroke-width:3;}';

const svgClickHandler = `
<script type="text/ecmascript">
  <![CDATA[
  function svgClickHandler(event) {
    var rects = document.getElementsByTagName("rect");
    for (i = 0; i < rects.length; i++) {
      rects[i].classList.remove("select");
    }

    var rectangle = event.target;
    var parent = rectangle.getAttribute("parent") ? rectangle.getAttribute("parent") + '.' : '';
    var lines = document.getElementsByTagName("tr");

    for (i = 1; i < lines.length; i++) {
      lines[i].classList.remove("select");
      var col = lines[i].getElementsByTagName("td")[0];

      if (col && (col.textContent === (parent + rectangle.getAttribute("field")) ||
          col.innerText === (parent + rectangle.getAttribute("field")))
      ) {
        lines[i].className += " select";
        col.scrollIntoView({behavior: "smooth", block: "center", inline: "nearest"});
      }
    }

  }
]]></script>`;

const tableClickHandler = `
<script type="text/ecmascript">
  <![CDATA[
  function tableClickHandler(event) {
    var line = event.target.parentNode;
    var col = line.getElementsByTagName("td")[0];
    var rects = document.getElementsByTagName("rect");

    for (i = 0; i < rects.length; i++) {
      var parent = rects[i].getAttribute("parent") ? rects[i].getAttribute("parent") + '.' : '';
      if (col && (col.textContent === (parent + rects[i].getAttribute("field")) ||
          col.innerText === (parent + rects[i].getAttribute("field")))
      ) {

        rects[i].classList.toggle("select");
        rects[i].scrollIntoView({behavior: "smooth", block: "center", inline: "nearest"});
      } else {
        rects[i].classList.remove("select");
      }
    }

    var lines = document.getElementsByTagName("tr");

    for (i = 0; i < lines.length; i++) {
      if (lines[i].isEqualNode(line)) {
        lines[i].classList.toggle("select");
      } else {
        lines[i].classList.remove("select");
      }
    }

  }
]]></script>`;

function generateSVG(json, table, vscode, dark, bitfieldSize) {
  var result = '';

  if (typeof json === 'string') {
    var parsedJson = json5.parse(json);
    var wavedromSVG = onml.s(renderAny(0, parsedJson, skins));

    var customCSS = getCustomCSS(vscode, dark, table);
    if (customCSS.trim().length > 0) {
      wavedromSVG = wavedromSVG.replace('</svg>', customCSS + '</svg>');
    }

    return wavedromSVG;
  }


  const padding = 25;
  var width = 0;
  var y = 0;
  for (var i = 0; i < json.length; i++) {
    var parsedJson = json5.parse(json[i]);
    var wavedromSVG = onml.s(renderAny(0, parsedJson, skins));

    var customCSS = getCustomCSS(vscode, dark, table);
    if (customCSS.trim().length > 0) {
      wavedromSVG = wavedromSVG.replace('</svg>', customCSS + '</svg>');
    }

    if (parsedJson.reg) {
      var $ = cheerio.load(wavedromSVG);
      
      if (table.trim().length > 0) {
          $('rect[field]').css('cursor', 'pointer');
          $('rect[field]').attr('onclick', 'svgClickHandler(event);');

          $('text[y]').css('cursor', 'pointer');
          $('text[y]').css('pointer-events', 'none');
          $('tspan').css('cursor', 'pointer');
          $('tspan').css('pointer-events', 'none');
      }

      if (i == 0)
        width = parseInt($('svg').attr('width'));

      if (i + 1 == json.length) {
        if (table.trim().length > 0) {
            $('svg').append(svgClickHandler);
            $('svg').append(tableClickHandler);
            $('svg').append(table);
            $('tr').css('cursor', 'pointer');
            $('td').attr('onclick', 'tableClickHandler(event)');
            adjustSVGHeight($);
        }
        wavedromSVG = updateBitfieldSVG($, bitfieldSize);
      }

      $('svg').attr('x', 0);
      $('svg').attr('y', i > 0 ? y + padding : y);
      y += parseInt($('svg').attr('height'));
      if (i > 0)
        y += padding;

      wavedromSVG = $.html("svg");
      wavedromSVG = vscode ? wavedromSVG.replace(/foreignobject/g, 'foreignObject') : wavedromSVG;
    }

    result += wavedromSVG;
  }

  if (json.length > 1) {
	  var header = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="'+width+'px" height="' + y + 'px" viewBox="0 0 '+width+' ' + y + '">';
	  return header.concat(result).concat('</svg>');
  }

  return result;
}

function updateBitfieldSVG($, bitfieldUpdates) {

  if (!bitfieldUpdates)
    return extractSVGFromHTML($.html());

  var bitfieldUpdatesJSON = json5.parse(bitfieldUpdates);
  if (!bitfieldUpdatesJSON)
    return extractSVGFromHTML($.html());

  var indices = $("svg").find("g > g > g > text");

  for (var i = 0; i < indices.length; i++) {
    var diagramOldIndex = $(indices[i]).text();
    if (isNaN(diagramOldIndex)) continue;
    var j = bitfieldUpdatesJSON.oldIndices.indexOf(parseInt(diagramOldIndex));
    if (j !== -1)
        $(indices[i]).html(bitfieldUpdatesJSON.newIndices[j]);
  }

  return extractSVGFromHTML($.html());
}

function adjustSVGHeight($) {
  const margin = 15;
  $('svg > foreignObject').attr('y', parseInt($('svg').attr('height')) + margin);

  var newHeight = parseInt($('svg').attr('height')) + parseInt($('svg > foreignObject').attr('height')) + margin;
  $('svg').attr('height', newHeight);
  $('svg').attr('viewBox', "0 0 " + $('svg').attr('width') + " " + newHeight);

}

function getCustomCSS(vscode, dark, table) {
  var customCSS = '';
  if (vscode) {
    customCSS = dark ? VSCODE_DARK_STYLESHEET : VSCODE_LIGHT_STYLESHEET;
  } else {
    customCSS = dark ? DVT_DARK_STYLESHEET : '';
  }

  if (table.trim().length > 0) {
    customCSS += BITFIELD_STYLESHEET;
  }

  if (customCSS.trim().length > 0) {
    return '<style xmlns="http://www.w3.org/2000/svg">' + customCSS + '</style>';
  }

  return '';
}

function extractSVGFromHTML(html) {
  var indexOfStartSVG = html.indexOf("<svg");
  var indexOfEndSVG = html.indexOf("</svg>") + "</svg>".length;
  return html.substring(indexOfStartSVG, indexOfEndSVG);
}

function getDVTHTMLBitfieldTitle(header, type, editorPath, editorOffset, length, dark) {
  return (
    "<div id='registerTitle' style='text-align: center; padding-bottom: 10px; color: " + (dark ? "#FFFFFF" : "#626262") +"; font-weight: bold; font-size: small;''>" +
    header + "<a onclick=\"window['DVTOpenLink']('" + editorPath + "'," + editorOffset + "," + length + ")\" href ='#'> " +
    type +
    "</a></div>"
  );
};

function getVSCodeHTMLBitfieldTitle(header, registerName) {
  return (
    '<h3 id="registerTitle" style="text-align: center;cursor: default;">' +
    header + ' <a onclick="clickOnRegisterName()" style="cursor: pointer;"> ' +
    registerName +
    "</a>" +
    "</h3>"
  );
};

module.exports = {generateSVG, getDVTHTMLBitfieldTitle, getVSCodeHTMLBitfieldTitle}
/*
const trimFieldName = (name, space, ratio) => {
  if (!(typeof name === 'string' || name instanceof String))
    return name;

  const width = name.length * 7.5;
  if (width <= space)
    return name;

  var charWidth = width / name.length;
  var end = name.length - ((width - space) / charWidth) - 3;
  if (end > 0)
    return name.substring(0, end) + '...';
  return name.substring(0, 1) + '...';
}

....


compact ? trimFieldName(e.name, step * e.bits, 7.5) : e.name

*/
