#!/bin/bash

set -euo pipefail

export PATH=$PATH:~/store/releng/ro.amiq.dvt.releng.binary.v92/node-build/20.15.1/linux_64/node/bin

echo "[1] Installing dependencies ..."
echo -e "\t babel ..."      && npm install --save-exact @babel/core @babel/cli @babel/preset-env @babel/polyfill > /dev/null 2>&1
echo -e "\t wavedrom ..."   && npm install --save-exact wavedrom              > /dev/null 2>&1
echo -e "\t cheerio ..."    && npm install --save-exact cheerio               > /dev/null 2>&1
echo -e "\t browserify ..." && npm install --save-exact  browserify             > /dev/null 2>&1
echo -e "\t json5 ..."      && npm install --save-exact json5                  > /dev/null 2>&1
echo -e "\t onml ..."       && npm install --save-exact onml                   > /dev/null 2>&1

echo "[2] Browserify DVT custom source code ..."
node_modules/.bin/browserify custom.js --standalone dvt --outfile browserify_custom.js

echo "[3] From ECMA6 to ECMA5 ..."
node_modules/@babel/cli/bin/babel.js browserify_custom.js --out-file wavedrom.dvt.rhino.js --presets=@babel/preset-env --source-type script
rm -f browserify_custom.js


