"use strict";

function acquireVsCodeApi() {
    let mockState;

    const currentUrl = window.location.href;
    const websocketUrl = currentUrl.replace("http", "ws").replace("static/", "ws");
    const webSocket = new WebSocket(websocketUrl);

	const pendingMessages = [];

	webSocket.onopen = () => {
	    while (pendingMessages.length) {
	        webSocket.send(pendingMessages.shift());
	    }
	};

    webSocket.onmessage = (ev) => {
        const rpcMessage = JSON.parse(ev.data);
        rpcMessage.receiver = {type: "webview"};
        if ('method' in rpcMessage) {
        	rpcMessage.method = window.requestPrefix + "-" + rpcMessage.method;
        }
        postMessage(rpcMessage);
    }

    return {
		postMessage: (message) => {
	        if ('method' in message) {
	            message.method = message.method.substring(message.method.indexOf('-') + 1);
	        }
	        const payload = JSON.stringify(message);
	        if (webSocket.readyState === WebSocket.CONNECTING) {
	            pendingMessages.push(payload);
	        } else {
	            webSocket.send(payload);
	        }
	    },
        getState: () => {
            return mockState;
        },
        setState: (state) => {
            mockState = state;
        }
    };
}
