#!/bin/sh

WORKSPACE=`pwd`

export UVM_ML_HOME="${DVT_PREDEFINED_PROJECTS}"/libs/UVM_ML-1.6/
export UVM_ML_CC="$(which g++)"
export UVM_ML_SVDPI_DIR="${UVM_ML_HOME}"/uvm_ml_dpi
export UVM_ML_DEBUG_MODE=true
export OSCI_VERSION=2.3.1
export UVM_ML_NO_ENV_DUMP=1

export OSCI_INSTALL="${DVT_PREDEFINED_PROJECTS}"/libs/systemc-2.3.1a
export OSCI_SRC="${DVT_PREDEFINED_PROJECTS}"/libs/systemc-2.3.1a

build_osci=1
clean_osci=0

build_uvm_ml=1
clean_uvm_ml=0

build_sc_top=1
clean_sc_top=0

for parameter in "$@"; do
    if [ "$parameter" = "--help" ] || [ "$parameter" = "-help" ] || [ "$parameter" = "-h" ]; then        
        echo "DVT help"
        echo "--clean-osci"
        echo "--clean-uvm-ml"
    elif [ "$parameter" = "--build-osci" ]; then
        build_osci=1
    elif [ "$parameter" = "--clean-osci" ]; then
        clean_osci=1
        build_osci=0
    elif [ "$parameter" = "--no-build-osci" ]; then
        build_osci=0
    elif [ "$parameter" = "--build-uvm-ml" ]; then
        build_uvm_ml=1
    elif [ "$parameter" = "--clean-uvm-ml" ]; then
        clean_uvm_ml=1
        build_uvm_ml=0
    elif [ "$parameter" = "--no-build-uvm-ml" ]; then
        build_uvm_ml=0
    elif [ "$parameter" = "--clean-sc-top" ]; then
    	clean_sc_top=1
    	build_sc_top=0
    elif [ "$parameter" = "--clean" ]; then
        clean_osci=1
        clean_uvm_ml=1
        clean_sc_top=1
        build_uvm_ml=0
        build_osci=0
        build_sc_top=0
    fi
done

if [ "$clean_uvm_ml" = 1 ]; then
	echo
	echo "======== Cleaning UVM_ML-1.6 ========"
	echo
	
	rm -rf "${UVM_ML_HOME}"/"${UVM_ML_SVDPI_DIR}"
    "${UVM_ML_HOME}"/ml/install.csh --clean --no-specman
fi

if [ "$clean_osci" = 1 ]; then
	echo
	echo "======== Cleaning OSCI ========"
	echo
	
    cd "${OSCI_SRC}" && make clean
fi

if [ "$clean_sc_top" = 1 ]; then
	echo
	echo "======== Cleaning C/C++ Project Sources ========"
	echo
	
	COMMAND="rm -f sc.o sc.so"
	echo "${COMMAND}"
	cd ${WORKSPACE} && ${COMMAND}
fi

if [ "$build_osci" = 1 ]; then
    echo
    echo "======== Configure OSCI ========"
	echo
	    
    cd "${OSCI_SRC}" && ./configure
    
    echo
    echo "======== Install OSCI Library ========"
    echo
    
    cd "${OSCI_SRC}" && make install
fi

if [ "$build_uvm_ml" = 1 ]; then
	echo
	echo "======== Install UVM_ML-1.6 Library ========"
	echo
	
	cd "${UVM_ML_HOME}"
		
	if [ ! -d "${UVM_ML_SVDPI_DIR}" ]; then
		
		echo
		echo "======== Creating UVM_ML_SVDPI_DIR Directory ========"
		echo
	
		mkdir "${UVM_ML_SVDPI_DIR}"
	fi

	cp "${DVT_PREDEFINED_PROJECTS}"/libs/IEEE_1364-2001/include/veriuser.h "${UVM_ML_SVDPI_DIR}"
	    
	cp "${DVT_PREDEFINED_PROJECTS}"/libs/IEEE_1364-2005/include/acc_user.h "${UVM_ML_SVDPI_DIR}"
	
	cp "${DVT_PREDEFINED_PROJECTS}"/libs/IEEE_1800-2012/include/svdpi.h "${UVM_ML_SVDPI_DIR}"
	cp "${DVT_PREDEFINED_PROJECTS}"/libs/IEEE_1800-2012/include/sv_vpi_user.h "${UVM_ML_SVDPI_DIR}"
	cp "${DVT_PREDEFINED_PROJECTS}"/libs/IEEE_1800-2012/include/vpi_compatibility.h "${UVM_ML_SVDPI_DIR}"
	cp "${DVT_PREDEFINED_PROJECTS}"/libs/IEEE_1800-2012/include/vpi_user.h "${UVM_ML_SVDPI_DIR}"

    "${UVM_ML_HOME}"/ml/test_env.csh
    echo
    "${UVM_ML_HOME}"/ml/install.csh --no-specman --build-osci --64bit
fi

if [ "$build_sc_top" = 1 ]; then
	echo
	echo "======== Compiling C/C++ Project Sources ========"
	echo 
	
	cd "${WORKSPACE}" 
	
	if [ -z "$SYSTEMC_HOME" ]; then
		SYSTEMC_HOME="${OSCI_SRC}"
	fi
	
	COMPILE_SOURCES="
	"\${UVM_ML_CC}"
		sc.cpp -c -fPIC -std=c++11 
		-I\${UVM_ML_HOME}/ml/frameworks/uvm/sv/1.1d-ml/uvm_lib/uvm_ml/sc 
		-I\${UVM_ML_HOME}/ml/frameworks/uvm/sc 
		-I\${UVM_ML_HOME}/ml/adapters/uvm_sc 
		-I\${UVM_ML_HOME}/ml/adapters/uvm_sc/osci 
		-I\${SYSTEMC_HOME}/include"
	LINK_SOURCES="
	"\${UVM_ML_CC}" 
		-shared -o sc.so sc.o -std=c++11"
	
	echo "${COMPILE_SOURCES}"
	echo "${LINK_SOURCES}"
	
	eval ${COMPILE_SOURCES}
	eval ${LINK_SOURCES}
fi

if [ "$build_osci" = 1 ] || [ "$build_uvm_ml" = 1 ] || [ "$build_sc_top" = 1 ]; then
    echo 
    echo "======== Shared libraries locations: ========"
    echo
    
    echo "======== UVM_ML-1.6 Shared Libraries: ========"
    find "${UVM_ML_HOME}" -type f -name "*.so"
    echo
    
    echo "======== OSCI Shared Libraries: ========"
    find "${OSCI_SRC}"/lib-linux64 -type f -name "*.so"
    echo
    
    echo "======== Project C/C++ Sources Shared Libraries: ========"
    find "${WORKSPACE}" -type f -name "sc.so"
    echo
fi
