<#include "utils.${format}.ftl">
<#if hasCode>
<@LinkToCode declaration declarationLine />
</#if>

.. _${id}:
	
Architecture ${name} of :ref:`${entityName}<${entityID}>`
${""?left_pad(("Architecture " + name + " of :ref:`${entityName}<${entityID}>`")?length, "*")}
<#if format == "pdf">
.. raw:: latex

	\label{${id}}
</#if>

<#if instances?has_content && !isDesignTop>

<@SectionTitle "Instances" /> 

.. raw:: html

	<div id="instances">

<#assign top=instances["top"][0]>
* ${top.getName()} <@LinkToInstance top />
<@Instances top.getID() 0 />

.. raw:: html

	</div>
</#if>

<#if submodules?has_content>
<@SectionTitle "Design Hierarchy" /> 

.. raw:: html

	<div id="design-hierarchy">

<@SubInstances submodules />

.. raw:: html

	</div>
</#if>

<#if hasFlowDiagram>
<@ExpandButton "${id}-flow" "flow" "Flow Diagram of ${unformatedname}">
<@Diagram "flow_of_${libraryName}-${unformatedname}.svg" "Flow Diagram of ${unformatedname}"/>
</@ExpandButton>  
</#if>

<#if hasSubInstancesDiagram>
<@ExpandButton "${id}-subinstances" "subinstances" "Sub-Instances Diagram of ${unformatedname}">
<@Diagram "subinstances_of_${unformatedname}.svg" "Sub-Instances Diagram of ${unformatedname}"/>
</@ExpandButton>  
</#if>

<#if hasSchematicDiagram>
<@ExpandButton "${id}-schematic" "schematic" "Schematic Diagram of ${unformatedname}">
<@Diagram "schematic_of_${libraryName}-${unformatedname}.svg" "Schematic Diagram of ${unformatedname}"/>
</@ExpandButton>  
</#if>

<#if comment?has_content>
<@Comment comment />
</#if>

<#list components>
Components
----------

<#if isPreview>
	<#items as component>
	* Component ${component.getName()}
	</#items>
<#else>
.. toctree:: 
   :maxdepth: 0

	<#items as component>
   ${unformatedname}/${component.getName()}
	</#items>
</#if>
</#list>

<#list types>
.. list-table:: Types
    :widths: 50 50
    :header-rows: 1
    :class: longtable
    
    * - Name
      - Description
    <#items as type>
    <#assign comment=type.getComment()>
    
        .. _${type.getID()}:
    * - <@TableCellName type />
      - <#if comment?has_content><@IndentComment comment 3/></#if>
    </#items>
</#list>

<#if functions?has_content>
	<@FunctionsList "Functions" functions />
</#if>

<#if procedures?has_content>
	<@FunctionsList "Procedures" procedures />
</#if>

<#list processes>

<@SectionTitle "Processes" /> 

.. raw:: html

	<section id="always-blocks">
<#assign count = 0>
	
<#items as process>
	<@AlwaysBlock process process?index false true />
<#if process.containsFSMDiagram() && process.getFSMDiagramName()?has_content>

.. container:: diagram fsm
    :name: ${id}-fsm-${process.getFSMDiagramVariableName()}

<@Diagram process.getFSMDiagramName()/>
<@ZoomButtons/>

<#assign commonExpressions = process.getCommonExpressions()!"">
<#if commonExpressions?has_content >
.. note::
	
	Common expressions filtered by preference: <#list commonExpressions as expression>${expression}<#sep> AND </#sep></#list> 
</#if>

<#assign rows = process.getRows()!"">
.. list-table:: FSM Transitions for ${process.getFSMDiagramVariableName()}
	:widths: 7 19 19 35 20
	:header-rows: 1
	:name: ${id}_fsm_table_${count}
	:class: longtable table-hover

	* - #
	  - Current State
	  - Next State
	  - Condition
	  - Comment
	<#list rows as row>
	* - ${row.getTransitionIndex()}
	  - ${row.getCurrentState()}
	  - ${row.getNextState()}
	  - ${row.getCondition()}
	  - <@IndentComment row.getTransitionComment() 3/>
	</#list>	
<#assign count++ >
</#if>
</#items>

.. raw:: html

	</section>
</#list>

<#if format == "pdf">
.. raw:: latex

	\clearpage
<#else>
.. raw:: html

	<div id="myModal" class="modal">
	  <span class="close">&times;</span>
	  <div id="img" class="modal-content"></div>
	</div>
</#if>