<#include "utils.${format}.ftl">
<#if hasCode>
<@LinkToCode declaration line />
</#if>

.. _${id}:

Class ${name}
${""?left_pad(("Class " + name)?length, "*")}
<#if format == "pdf">
.. raw:: latex

	\label{${id}}
</#if>
	
<#list classHierarchy>
.. raw:: html

   <div id="class-hierarchy">

<#assign indent = 0>	
<#items as class>
${"*"?left_pad(indent * 3 + 1, " ")} ${class}
<#assign indent++>
</#items>

.. raw:: html

   </div>
</#list>

<#if hasUMLDiagram>
<@ExpandButton "${id}-uml" "inheritance" "Inheritance Diagram of ${unformatedname}">
<@Diagram "uml_of_${unformatedname}.svg" "Inheritance Diagram of ${unformatedname}"/>
</@ExpandButton>  
</#if>

<#if hasUMLCollaborationDiagram>
<@ExpandButton "${id}-collaboration" "collaboration" "Collaboration Diagram of ${unformatedname}">
<@Diagram "collaboration_of_${unformatedname}.svg" "Collaboration Diagram of ${unformatedname}"/>
</@ExpandButton>  
</#if>

<#if hasBitfieldDiagram>
<@BitFieldDiagram "${id}-bitfield" unformatedname hasBitfieldDiagram "VLOG_UVM_REG" bitfields/>
</#if>

<#if hasComponentDiagram>
<@ExpandButton "${id}-components" "test" "UVM Components Diagram of ${unformatedname}">
<@Diagram "component_of_${unformatedname}.svg" "UVM Components Diagram of ${unformatedname}"/>
</@ExpandButton>  
</#if>

<#if comment?? && comment?has_content>
  <@Comment comment=comment />
<#elseif isPreview?? && isPreview>
	<#if isUVMTest?? && isUVMTest>
  <@AiComment "test" commentLine 0 true/>
	<#else>
  <@AiComment "class" commentLine 0 true/>
	</#if>  
</#if>

<#list parameters>
.. list-table:: Parameters
	:widths: 25 25 50
	:header-rows: 1
	:class: longtable

	* - Name
	  - Default value
	  - Description
	<#items as parameter>
	<#assign comment=parameter.getComment()>
	
	    .. _${parameter.getID()}:
	* - <@TableCellName parameter />		
	  - ${parameter.getValue()}
	  - <#if comment?has_content><@TableComment comment /><#elseif isPreview>
	  		
			<@AiComment "parameter ${parameter.getName()}=${parameter.getValue()}" "${parameter.getDeclarationLine()}" 3 />
	  	</#if>	
	</#items>
</#list>

<#list localparams>
.. list-table:: Local Parameters
	:widths: 25 25 50
	:header-rows: 1
	:class: longtable

	* - Name
	  - Default value
	  - Description
	<#items as parameter>
	<#assign comment=parameter.getComment()>
	
	    .. _${parameter.getID()}:
	* - <@TableCellName parameter />		
	  - ${parameter.getValue()}
	  - <#if comment?has_content><@TableComment comment /><#elseif isPreview>
			<@AiComment "parameter ${parameter.getName()}=${parameter.getValue()}" "${parameter.getDeclarationLine()}" 3 />
	  	</#if>	
	</#items>
</#list>

<#list variables>
.. list-table:: Variables
	:widths: 25 25 50
	:header-rows: 1
	:class: longtable

	* - Name
	  - Type
	  - Description
	<#items as variable>
	<#assign comment=variable.getComment()>
	
	    .. _${variable.getID()}:
	* - <@TableCellName variable />
	  - <@TypeWithLinks variable false />
	  - <#if comment?has_content><@IndentComment comment 3/><#elseif isPreview>
			<@AiComment "variable ${variable.getName()}" "${variable.getDeclarationLine()}" 3 />
	  </#if>
	</#items>
	<#if inheritedVariables??>
	<#list inheritedVariables>
	<#items as variable>
   
	<#assign link=variable.getLinkToRefType()>
	<#assign linkToParent=variable.getLinkToParent()>
	<#assign comment=variable.getComment()>
    
	* - <#if linkToParent?has_content > :ref:`${variable.getEnclosingClassName()}.${variable.getName()} <${linkToParent}>` <#else>	${variable.getEnclosingClassName()}.${variable.getName()} </#if>
	  - <#if link?has_content > :ref:`${variable.getAssociatedTypeName()} <${link}>` <#else> ${variable.getAssociatedTypeName()} </#if>
	  - <#if comment?has_content><@TableComment comment /><#elseif isPreview>
			<@AiComment "variable ${variable.getName()}" "${variable.getDeclarationLine()}" />
	  	</#if>
	</#items>
	</#list>
	</#if>
</#list>

<#list constraints>
.. list-table:: Constraints
	:widths: 25 75
	:header-rows: 1
	:class: longtable

	* - Name
	  - Description
	<#items as variable>
	<#assign comment=variable.getComment()>
	
	    .. _${variable.getID()}:
	* - <@TableCellName variable />
	  - <#if comment?has_content><@TableComment comment /><#elseif isPreview>
			<@AiComment "constraint ${variable.getName()}" "${variable.getDeclarationLine()}" 3 />
	  </#if>
	  
	</#items>
</#list>

<#if typedefs?has_content>
<#list typedefs>
.. list-table:: Typedefs
	:widths: 25 25 50
	:header-rows: 1
	:class: longtable

	* - Name
	  - Actual Type
	  - Description
	<#items as typedef>
	<#assign comment=typedef.getComment()>
	<#assign link=typedef.getLinkToRefType()>

	    .. _${typedef.getID()}:
	* - <@TableCellName typedef />
	  - <#if link?has_content > :ref:`${typedef.getAssociatedTypeSignature()} <${link}>` <#else> ${typedef.getAssociatedTypeSignature()} </#if>
	  - <#if comment?has_content><@TableComment comment /><#elseif isPreview>
			<@AiComment "typedef ${typedef.getName()}" "${typedef.getDeclarationLine()}" 3 />
	  </#if>
	  
	</#items>
</#list>
</#if>

<#if assertions?has_content>
	<@AssertionsTable "Assertions" assertions isPreview/>
</#if>

<#if constructors?has_content>
	<@FunctionsList "Constructors" constructors isPreview/>
</#if>

<#if enums?has_content>   
	<@EnumList "Enums" enums isPreview/>
</#if>

<#if structs?has_content>   
	<#if structsIndexes?has_content>
Structs
=======	
	
	<#list structs as struct>
* :ref:`${struct.getName()}<${struct.getID()}>`
	</#list>
	
	<#else>
	<@StructsList "Structs" structs/>
	</#if>
</#if>


<#if coverGroups?has_content>
	<@CovergroupList "Covergroups" coverGroups isPreview/>
</#if>

<#if events?has_content>   
	<@MemberList "Events" events isPreview />
</#if>

<#if functions?has_content>
	<@FunctionsList "Functions" functions isPreview/>
</#if>

<#if inheritedFunctions??>
	<@FunctionsList "Inherited Functions" inheritedFunctions isPreview true/>
</#if>

<#if tasks?has_content>
	<@FunctionsList "Tasks" tasks isPreview />
</#if>


<#if inheritedTasks??>
	<@FunctionsList "Inherited Tasks" inheritedTasks isPreview true/>
</#if>

<#list innerClasses>
Inner Classes
-------------
<#if isPreview>
	<#items as innerClass>
	* Class ${innerClass.getName()}
	</#items>
<#else>
.. toctree:: 
   :maxdepth: 5
	
	<#items as innerClass>
   Class ${innerClass.getName()} <${unformatedname}/${innerClass.getName()}>
	</#items>
</#if>
</#list>

<#if format == "pdf">
.. raw:: latex

	\clearpage
<#else>
.. raw:: html

	<div id="myModal" class="modal">
	  <span class="close">&times;</span>
	  <div id="img" class="modal-content"></div>
	</div>
</#if>