<#include "utils.${format}.ftl">
<#if hasCode>
<@LinkToCode declaration declarationLine />
</#if>

.. _${id}:
	
Component ${name}
${""?left_pad(("Component " + name)?length, "*")}
<#if format == "pdf">
.. raw:: latex

	\label{${id}}
</#if>

<#if hasBlockDiagram>

.. container:: diagram entity
    :name: ${id}-block
	
<@Diagram "block_of_${unformatedname}.svg" "Block Diagram of ${unformatedname}"/>

    .. raw:: html
	
		<figcaption>
			<p><span class="caption-text">Block Diagram of ${unformatedname}</span><a class="headerlink" href="#${id}-block" title="Link to this image"></a></p>
		</figcaption>

</#if>

<#if comment?has_content>
<@Comment comment />
</#if>

<#list generics>
.. list-table:: Generics
    :widths: 20 20 20 40
    :header-rows: 1
    :class: longtable
    
    * - Name
      - Type
      - Initial Value
      - Description
    <#items as generic>
    <#assign comment=generic.getComment()>
    
        .. _${generic.getID()}:
    * - <@TableCellName generic />
      - <@GenericType generic />
      - <@GenericInitialValue generic />
      - <#if comment?has_content><@IndentComment comment 3/></#if>
    </#items>
</#list>

<#list ports>
.. list-table:: Ports
    :widths: 20 20 20 40
    :header-rows: 1
    :class: longtable
    
    * - Name
      - Direction
      - Type
      - Description
    <#items as port>
    <#assign comment=port.getComment()>
    <#assign link=port.getLinkToRef()>
    
        .. _${port.getID()}:
    * - <@TableCellName port />
      - ${port.getDirection()}
      - <#if link?has_content >:ref:`${port.getPortType()} <${link}>`<#else>${port.getPortType()}</#if>
      - <#if comment?has_content><@IndentComment comment 3/></#if>
    </#items>
</#list>

<#if format == "html">
.. raw:: html

	<div id="myModal" class="modal">
	  <span class="close">&times;</span>
	  <div id="img" class="modal-content"></div>
	</div>
</#if>