import errno
import sphinx.util.osutil
sphinx.util.osutil.ENOENT = errno.ENOENT
sphinx.util.osutil.EPIPE = errno.EPIPE
sphinx.util.osutil.EINVAL = errno.EINVAL

project = '''${project}'''
copyright = '${copyright}'
author = '${author}'
release = '${version}'
root_doc = '${index}'


html_context = {'specador_version': '${specador_version}'}
html_favicon = 'specador.ico'
html_show_sphinx = False
smartquotes = False

html_extra_path = ["extern"]
extensions = [
    'myst_parser',
    'sphinx.ext.intersphinx',
]

templates_path = ['_templates']
exclude_patterns = []

html_theme = 'sphinx_rtd_theme'
html_theme_options = {
    'collapse_navigation': False,
    'sticky_navigation': True,
    'navigation_depth': 5,
}

<#if !copyright?has_content>
html_show_copyright = False
</#if>
html_show_sourcelink = False
html_scaled_image_link = False

html_title = '''${project}'''
html_static_path = ['_static']

html_css_files = [
    <#if isPreview>'preview.css',</#if>
    'specador.css',
    'custom.css',
    'markdown.css',
    'fonts.css'
]

html_js_files = [
	<#if isPreview>
	'preview.js',
	'lexical.js',
	</#if>
    'svg-pan-zoom.min.js',
    'specador.js',
    'custom.js',
    'code.js'
]
